<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCiscoCatalyst6000T1VoIPGatewayT1Req StructType
 * @subpackage Structs
 */
class UpdateCiscoCatalyst6000T1VoIPGatewayT1Req extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: Optional description of the device
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The networkLocation
     * Meta informations extracted from the WSDL
     * - default: Use System Default
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $networkLocation;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \CUCM\StructType\XFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The automatedAlternateRoutingCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The loadInformation
     * Meta informations extracted from the WSDL
     * - documentation: For devices with load information, if any special load information is specified the special attribute is set to TRUE.Otherwise,the load information is default for the product.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The vendorConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The traceFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $traceFlag;
    /**
     * The mlppDomainId
     * Meta informations extracted from the WSDL
     * - documentation: This setting only effects devices that support MLPP. Use -1 to set to null
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 128
     * @var string
     */
    public $mlppDomainId;
    /**
     * The mlppIndicationStatus
     * Meta informations extracted from the WSDL
     * - default: Off
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The retryVideoCallAsAudio
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The cgpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The sendGeoLocation
     * Meta informations extracted from the WSDL
     * - documentation: Not valid for CTI route points and VoiceMail ports
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendGeoLocation;
    /**
     * The ports
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Ports
     */
    public $ports;
    /**
     * The trunkSelectionOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $trunkSelectionOrder;
    /**
     * The clockReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $clockReference;
    /**
     * The csuParam
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $csuParam;
    /**
     * The digitSending
     * Meta informations extracted from the WSDL
     * - default: DTMF
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $digitSending;
    /**
     * The pcmType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pcmType;
    /**
     * The fdlChannel
     * Meta informations extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $fdlChannel;
    /**
     * The yellowAlarm
     * Meta informations extracted from the WSDL
     * - default: F-Bit
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $yellowAlarm;
    /**
     * The zeroSupression
     * Meta informations extracted from the WSDL
     * - default: B8ZS
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $zeroSupression;
    /**
     * The smdiBasePort
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $smdiBasePort;
    /**
     * The handleDtmfPrecedenceSignals
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $handleDtmfPrecedenceSignals;
    /**
     * The cdpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The useDevicePoolCdpnTransformCss
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCdpnTransformCss;
    /**
     * The geoLocationFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The pstnAccess
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pstnAccess;
    /**
     * The imeE164TransformationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $imeE164TransformationName;
    /**
     * Constructor method for UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setNewName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setDescription()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setCallingSearchSpaceName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setDevicePoolName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setCommonDeviceConfigName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setNetworkLocation()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setLocationName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setMediaResourceListName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setAutomatedAlternateRoutingCssName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setAarNeighborhoodName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setLoadInformation()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setVendorConfig()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setTraceFlag()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setMlppDomainId()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setMlppIndicationStatus()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setUseTrustedRelayPoint()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setRetryVideoCallAsAudio()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setCgpnTransformationCssName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setUseDevicePoolCgpnTransformCss()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setGeoLocationName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setSendGeoLocation()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setPorts()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setTrunkSelectionOrder()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setClockReference()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setCsuParam()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setDigitSending()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setPcmType()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setFdlChannel()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setYellowAlarm()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setZeroSupression()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setSmdiBasePort()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setHandleDtmfPrecedenceSignals()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setCdpnTransformationCssName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setUseDevicePoolCdpnTransformCss()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setGeoLocationFilterName()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setPstnAccess()
     * @uses UpdateCiscoCatalyst6000T1VoIPGatewayT1Req::setImeE164TransformationName()
     * @param string $newName
     * @param string $description
     * @param \CUCM\StructType\XFkType $callingSearchSpaceName
     * @param \CUCM\StructType\XFkType $devicePoolName
     * @param \CUCM\StructType\XFkType $commonDeviceConfigName
     * @param string $networkLocation
     * @param \CUCM\StructType\XFkType $locationName
     * @param \CUCM\StructType\XFkType $mediaResourceListName
     * @param \CUCM\StructType\XFkType $automatedAlternateRoutingCssName
     * @param \CUCM\StructType\XFkType $aarNeighborhoodName
     * @param \CUCM\StructType\XLoadInformation $loadInformation
     * @param \CUCM\StructType\XVendorConfig $vendorConfig
     * @param string $traceFlag
     * @param string $mlppDomainId
     * @param string $mlppIndicationStatus
     * @param string $useTrustedRelayPoint
     * @param string $retryVideoCallAsAudio
     * @param \CUCM\StructType\XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param \CUCM\StructType\XFkType $geoLocationName
     * @param string $sendGeoLocation
     * @param \CUCM\StructType\Ports $ports
     * @param string $trunkSelectionOrder
     * @param string $clockReference
     * @param string $csuParam
     * @param string $digitSending
     * @param string $pcmType
     * @param string $fdlChannel
     * @param string $yellowAlarm
     * @param string $zeroSupression
     * @param string $smdiBasePort
     * @param string $handleDtmfPrecedenceSignals
     * @param \CUCM\StructType\XFkType $cdpnTransformationCssName
     * @param string $useDevicePoolCdpnTransformCss
     * @param \CUCM\StructType\XFkType $geoLocationFilterName
     * @param string $pstnAccess
     * @param \CUCM\StructType\XFkType $imeE164TransformationName
     */
    public function __construct($newName = null, $description = null, \CUCM\StructType\XFkType $callingSearchSpaceName = null, \CUCM\StructType\XFkType $devicePoolName = null, \CUCM\StructType\XFkType $commonDeviceConfigName = null, $networkLocation = 'Use System Default', \CUCM\StructType\XFkType $locationName = null, \CUCM\StructType\XFkType $mediaResourceListName = null, \CUCM\StructType\XFkType $automatedAlternateRoutingCssName = null, \CUCM\StructType\XFkType $aarNeighborhoodName = null, \CUCM\StructType\XLoadInformation $loadInformation = null, \CUCM\StructType\XVendorConfig $vendorConfig = null, $traceFlag = null, $mlppDomainId = null, $mlppIndicationStatus = 'Off', $useTrustedRelayPoint = 'Default', $retryVideoCallAsAudio = true, \CUCM\StructType\XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = true, \CUCM\StructType\XFkType $geoLocationName = null, $sendGeoLocation = null, \CUCM\StructType\Ports $ports = null, $trunkSelectionOrder = null, $clockReference = null, $csuParam = null, $digitSending = 'DTMF', $pcmType = null, $fdlChannel = 'None', $yellowAlarm = 'F-Bit', $zeroSupression = 'B8ZS', $smdiBasePort = '0', $handleDtmfPrecedenceSignals = false, \CUCM\StructType\XFkType $cdpnTransformationCssName = null, $useDevicePoolCdpnTransformCss = true, \CUCM\StructType\XFkType $geoLocationFilterName = null, $pstnAccess = true, \CUCM\StructType\XFkType $imeE164TransformationName = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setNetworkLocation($networkLocation)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setLoadInformation($loadInformation)
            ->setVendorConfig($vendorConfig)
            ->setTraceFlag($traceFlag)
            ->setMlppDomainId($mlppDomainId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setSendGeoLocation($sendGeoLocation)
            ->setPorts($ports)
            ->setTrunkSelectionOrder($trunkSelectionOrder)
            ->setClockReference($clockReference)
            ->setCsuParam($csuParam)
            ->setDigitSending($digitSending)
            ->setPcmType($pcmType)
            ->setFdlChannel($fdlChannel)
            ->setYellowAlarm($yellowAlarm)
            ->setZeroSupression($zeroSupression)
            ->setSmdiBasePort($smdiBasePort)
            ->setHandleDtmfPrecedenceSignals($handleDtmfPrecedenceSignals)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setPstnAccess($pstnAccess)
            ->setImeE164TransformationName($imeE164TransformationName);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 128) || (is_array($newName) && count($newName) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return isset($this->callingSearchSpaceName) ? $this->callingSearchSpaceName : null;
    }
    /**
     * Set callingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $callingSearchSpaceName
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setCallingSearchSpaceName(\CUCM\StructType\XFkType $callingSearchSpaceName = null)
    {
        if (is_null($callingSearchSpaceName) || (is_array($callingSearchSpaceName) && empty($callingSearchSpaceName))) {
            unset($this->callingSearchSpaceName);
        } else {
            $this->callingSearchSpaceName = $callingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get devicePoolName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return isset($this->devicePoolName) ? $this->devicePoolName : null;
    }
    /**
     * Set devicePoolName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $devicePoolName
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setDevicePoolName(\CUCM\StructType\XFkType $devicePoolName = null)
    {
        if (is_null($devicePoolName) || (is_array($devicePoolName) && empty($devicePoolName))) {
            unset($this->devicePoolName);
        } else {
            $this->devicePoolName = $devicePoolName;
        }
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return isset($this->commonDeviceConfigName) ? $this->commonDeviceConfigName : null;
    }
    /**
     * Set commonDeviceConfigName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $commonDeviceConfigName
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setCommonDeviceConfigName(\CUCM\StructType\XFkType $commonDeviceConfigName = null)
    {
        if (is_null($commonDeviceConfigName) || (is_array($commonDeviceConfigName) && empty($commonDeviceConfigName))) {
            unset($this->commonDeviceConfigName);
        } else {
            $this->commonDeviceConfigName = $commonDeviceConfigName;
        }
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @uses \CUCM\EnumType\XNetworkLocation::valueIsValid()
     * @uses \CUCM\EnumType\XNetworkLocation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocation
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setNetworkLocation($networkLocation = 'Use System Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XNetworkLocation::valueIsValid($networkLocation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocation, implode(', ', \CUCM\EnumType\XNetworkLocation::getValidValues())), __LINE__);
        }
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get locationName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \CUCM\StructType\XFkType $locationName
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setLocationName(\CUCM\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return isset($this->mediaResourceListName) ? $this->mediaResourceListName : null;
    }
    /**
     * Set mediaResourceListName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $mediaResourceListName
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setMediaResourceListName(\CUCM\StructType\XFkType $mediaResourceListName = null)
    {
        if (is_null($mediaResourceListName) || (is_array($mediaResourceListName) && empty($mediaResourceListName))) {
            unset($this->mediaResourceListName);
        } else {
            $this->mediaResourceListName = $mediaResourceListName;
        }
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return isset($this->automatedAlternateRoutingCssName) ? $this->automatedAlternateRoutingCssName : null;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $automatedAlternateRoutingCssName
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setAutomatedAlternateRoutingCssName(\CUCM\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        if (is_null($automatedAlternateRoutingCssName) || (is_array($automatedAlternateRoutingCssName) && empty($automatedAlternateRoutingCssName))) {
            unset($this->automatedAlternateRoutingCssName);
        } else {
            $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        }
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return isset($this->aarNeighborhoodName) ? $this->aarNeighborhoodName : null;
    }
    /**
     * Set aarNeighborhoodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $aarNeighborhoodName
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setAarNeighborhoodName(\CUCM\StructType\XFkType $aarNeighborhoodName = null)
    {
        if (is_null($aarNeighborhoodName) || (is_array($aarNeighborhoodName) && empty($aarNeighborhoodName))) {
            unset($this->aarNeighborhoodName);
        } else {
            $this->aarNeighborhoodName = $aarNeighborhoodName;
        }
        return $this;
    }
    /**
     * Get loadInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return isset($this->loadInformation) ? $this->loadInformation : null;
    }
    /**
     * Set loadInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XLoadInformation $loadInformation
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setLoadInformation(\CUCM\StructType\XLoadInformation $loadInformation = null)
    {
        if (is_null($loadInformation) || (is_array($loadInformation) && empty($loadInformation))) {
            unset($this->loadInformation);
        } else {
            $this->loadInformation = $loadInformation;
        }
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \CUCM\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \CUCM\StructType\XVendorConfig $vendorConfig
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setVendorConfig(\CUCM\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get traceFlag value
     * @return string|null
     */
    public function getTraceFlag()
    {
        return $this->traceFlag;
    }
    /**
     * Set traceFlag value
     * @param string $traceFlag
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setTraceFlag($traceFlag = null)
    {
        // validation for constraint: pattern
        if (is_scalar($traceFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($traceFlag, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($traceFlag) && !is_string($traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($traceFlag)), __LINE__);
        }
        $this->traceFlag = $traceFlag;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return isset($this->mlppDomainId) ? $this->mlppDomainId : null;
    }
    /**
     * Set mlppDomainId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mlppDomainId
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mlppDomainId) && strlen($mlppDomainId) > 128) || (is_array($mlppDomainId) && count($mlppDomainId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($mlppDomainId) ? strlen($mlppDomainId) : count($mlppDomainId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mlppDomainId) && !is_string($mlppDomainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mlppDomainId)), __LINE__);
        }
        if (is_null($mlppDomainId) || (is_array($mlppDomainId) && empty($mlppDomainId))) {
            unset($this->mlppDomainId);
        } else {
            $this->mlppDomainId = $mlppDomainId;
        }
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndicationStatus
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = 'Off')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($mlppIndicationStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mlppIndicationStatus, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useTrustedRelayPoint, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = true)
    {
        // validation for constraint: pattern
        if (is_scalar($retryVideoCallAsAudio) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($retryVideoCallAsAudio, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($retryVideoCallAsAudio) && !is_string($retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retryVideoCallAsAudio)), __LINE__);
        }
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return isset($this->cgpnTransformationCssName) ? $this->cgpnTransformationCssName : null;
    }
    /**
     * Set cgpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $cgpnTransformationCssName
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setCgpnTransformationCssName(\CUCM\StructType\XFkType $cgpnTransformationCssName = null)
    {
        if (is_null($cgpnTransformationCssName) || (is_array($cgpnTransformationCssName) && empty($cgpnTransformationCssName))) {
            unset($this->cgpnTransformationCssName);
        } else {
            $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCss) && !is_string($useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return isset($this->geoLocationName) ? $this->geoLocationName : null;
    }
    /**
     * Set geoLocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $geoLocationName
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setGeoLocationName(\CUCM\StructType\XFkType $geoLocationName = null)
    {
        if (is_null($geoLocationName) || (is_array($geoLocationName) && empty($geoLocationName))) {
            unset($this->geoLocationName);
        } else {
            $this->geoLocationName = $geoLocationName;
        }
        return $this;
    }
    /**
     * Get sendGeoLocation value
     * @return string|null
     */
    public function getSendGeoLocation()
    {
        return $this->sendGeoLocation;
    }
    /**
     * Set sendGeoLocation value
     * @param string $sendGeoLocation
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setSendGeoLocation($sendGeoLocation = null)
    {
        // validation for constraint: pattern
        if (is_scalar($sendGeoLocation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $sendGeoLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($sendGeoLocation, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sendGeoLocation) && !is_string($sendGeoLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendGeoLocation)), __LINE__);
        }
        $this->sendGeoLocation = $sendGeoLocation;
        return $this;
    }
    /**
     * Get ports value
     * @return \CUCM\StructType\Ports|null
     */
    public function getPorts()
    {
        return $this->ports;
    }
    /**
     * Set ports value
     * @param \CUCM\StructType\Ports $ports
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setPorts(\CUCM\StructType\Ports $ports = null)
    {
        $this->ports = $ports;
        return $this;
    }
    /**
     * Get trunkSelectionOrder value
     * @return string|null
     */
    public function getTrunkSelectionOrder()
    {
        return $this->trunkSelectionOrder;
    }
    /**
     * Set trunkSelectionOrder value
     * @uses \CUCM\EnumType\XTrunkSelectionOrder::valueIsValid()
     * @uses \CUCM\EnumType\XTrunkSelectionOrder::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkSelectionOrder
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setTrunkSelectionOrder($trunkSelectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XTrunkSelectionOrder::valueIsValid($trunkSelectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trunkSelectionOrder, implode(', ', \CUCM\EnumType\XTrunkSelectionOrder::getValidValues())), __LINE__);
        }
        $this->trunkSelectionOrder = $trunkSelectionOrder;
        return $this;
    }
    /**
     * Get clockReference value
     * @return string|null
     */
    public function getClockReference()
    {
        return $this->clockReference;
    }
    /**
     * Set clockReference value
     * @uses \CUCM\EnumType\XClockReference::valueIsValid()
     * @uses \CUCM\EnumType\XClockReference::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clockReference
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setClockReference($clockReference = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XClockReference::valueIsValid($clockReference)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $clockReference, implode(', ', \CUCM\EnumType\XClockReference::getValidValues())), __LINE__);
        }
        $this->clockReference = $clockReference;
        return $this;
    }
    /**
     * Get csuParam value
     * @return string|null
     */
    public function getCsuParam()
    {
        return $this->csuParam;
    }
    /**
     * Set csuParam value
     * @uses \CUCM\EnumType\XCSUParam::valueIsValid()
     * @uses \CUCM\EnumType\XCSUParam::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $csuParam
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setCsuParam($csuParam = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XCSUParam::valueIsValid($csuParam)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $csuParam, implode(', ', \CUCM\EnumType\XCSUParam::getValidValues())), __LINE__);
        }
        $this->csuParam = $csuParam;
        return $this;
    }
    /**
     * Get digitSending value
     * @return string|null
     */
    public function getDigitSending()
    {
        return $this->digitSending;
    }
    /**
     * Set digitSending value
     * @uses \CUCM\EnumType\XDigitSending::valueIsValid()
     * @uses \CUCM\EnumType\XDigitSending::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $digitSending
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setDigitSending($digitSending = 'DTMF')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XDigitSending::valueIsValid($digitSending)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $digitSending, implode(', ', \CUCM\EnumType\XDigitSending::getValidValues())), __LINE__);
        }
        $this->digitSending = $digitSending;
        return $this;
    }
    /**
     * Get pcmType value
     * @return string|null
     */
    public function getPcmType()
    {
        return $this->pcmType;
    }
    /**
     * Set pcmType value
     * @uses \CUCM\EnumType\XEncode::valueIsValid()
     * @uses \CUCM\EnumType\XEncode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pcmType
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setPcmType($pcmType = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XEncode::valueIsValid($pcmType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pcmType, implode(', ', \CUCM\EnumType\XEncode::getValidValues())), __LINE__);
        }
        $this->pcmType = $pcmType;
        return $this;
    }
    /**
     * Get fdlChannel value
     * @return string|null
     */
    public function getFdlChannel()
    {
        return $this->fdlChannel;
    }
    /**
     * Set fdlChannel value
     * @uses \CUCM\EnumType\XFDLChannel::valueIsValid()
     * @uses \CUCM\EnumType\XFDLChannel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fdlChannel
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setFdlChannel($fdlChannel = 'None')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XFDLChannel::valueIsValid($fdlChannel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $fdlChannel, implode(', ', \CUCM\EnumType\XFDLChannel::getValidValues())), __LINE__);
        }
        $this->fdlChannel = $fdlChannel;
        return $this;
    }
    /**
     * Get yellowAlarm value
     * @return string|null
     */
    public function getYellowAlarm()
    {
        return $this->yellowAlarm;
    }
    /**
     * Set yellowAlarm value
     * @uses \CUCM\EnumType\XYellowAlarm::valueIsValid()
     * @uses \CUCM\EnumType\XYellowAlarm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $yellowAlarm
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setYellowAlarm($yellowAlarm = 'F-Bit')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XYellowAlarm::valueIsValid($yellowAlarm)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $yellowAlarm, implode(', ', \CUCM\EnumType\XYellowAlarm::getValidValues())), __LINE__);
        }
        $this->yellowAlarm = $yellowAlarm;
        return $this;
    }
    /**
     * Get zeroSupression value
     * @return string|null
     */
    public function getZeroSupression()
    {
        return $this->zeroSupression;
    }
    /**
     * Set zeroSupression value
     * @uses \CUCM\EnumType\XZeroSuppression::valueIsValid()
     * @uses \CUCM\EnumType\XZeroSuppression::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zeroSupression
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setZeroSupression($zeroSupression = 'B8ZS')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XZeroSuppression::valueIsValid($zeroSupression)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $zeroSupression, implode(', ', \CUCM\EnumType\XZeroSuppression::getValidValues())), __LINE__);
        }
        $this->zeroSupression = $zeroSupression;
        return $this;
    }
    /**
     * Get smdiBasePort value
     * @return string|null
     */
    public function getSmdiBasePort()
    {
        return $this->smdiBasePort;
    }
    /**
     * Set smdiBasePort value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $smdiBasePort
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setSmdiBasePort($smdiBasePort = '0')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($smdiBasePort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $smdiBasePort, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->smdiBasePort = $smdiBasePort;
        return $this;
    }
    /**
     * Get handleDtmfPrecedenceSignals value
     * @return string|null
     */
    public function getHandleDtmfPrecedenceSignals()
    {
        return $this->handleDtmfPrecedenceSignals;
    }
    /**
     * Set handleDtmfPrecedenceSignals value
     * @param string $handleDtmfPrecedenceSignals
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setHandleDtmfPrecedenceSignals($handleDtmfPrecedenceSignals = false)
    {
        // validation for constraint: pattern
        if (is_scalar($handleDtmfPrecedenceSignals) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $handleDtmfPrecedenceSignals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($handleDtmfPrecedenceSignals, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($handleDtmfPrecedenceSignals) && !is_string($handleDtmfPrecedenceSignals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($handleDtmfPrecedenceSignals)), __LINE__);
        }
        $this->handleDtmfPrecedenceSignals = $handleDtmfPrecedenceSignals;
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return isset($this->cdpnTransformationCssName) ? $this->cdpnTransformationCssName : null;
    }
    /**
     * Set cdpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $cdpnTransformationCssName
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setCdpnTransformationCssName(\CUCM\StructType\XFkType $cdpnTransformationCssName = null)
    {
        if (is_null($cdpnTransformationCssName) || (is_array($cdpnTransformationCssName) && empty($cdpnTransformationCssName))) {
            unset($this->cdpnTransformationCssName);
        } else {
            $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCdpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCdpnTransformCss()
    {
        return $this->useDevicePoolCdpnTransformCss;
    }
    /**
     * Set useDevicePoolCdpnTransformCss value
     * @param string $useDevicePoolCdpnTransformCss
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCdpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCdpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCdpnTransformCss) && !is_string($useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCdpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCdpnTransformCss = $useDevicePoolCdpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return isset($this->geoLocationFilterName) ? $this->geoLocationFilterName : null;
    }
    /**
     * Set geoLocationFilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $geoLocationFilterName
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setGeoLocationFilterName(\CUCM\StructType\XFkType $geoLocationFilterName = null)
    {
        if (is_null($geoLocationFilterName) || (is_array($geoLocationFilterName) && empty($geoLocationFilterName))) {
            unset($this->geoLocationFilterName);
        } else {
            $this->geoLocationFilterName = $geoLocationFilterName;
        }
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return string|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param string $pstnAccess
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setPstnAccess($pstnAccess = true)
    {
        // validation for constraint: pattern
        if (is_scalar($pstnAccess) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($pstnAccess, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pstnAccess) && !is_string($pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pstnAccess)), __LINE__);
        }
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get imeE164TransformationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getImeE164TransformationName()
    {
        return isset($this->imeE164TransformationName) ? $this->imeE164TransformationName : null;
    }
    /**
     * Set imeE164TransformationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $imeE164TransformationName
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public function setImeE164TransformationName(\CUCM\StructType\XFkType $imeE164TransformationName = null)
    {
        if (is_null($imeE164TransformationName) || (is_array($imeE164TransformationName) && empty($imeE164TransformationName))) {
            unset($this->imeE164TransformationName);
        } else {
            $this->imeE164TransformationName = $imeE164TransformationName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
