<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCallManagerGroupReq StructType
 * @subpackage Structs
 */
class UpdateCallManagerGroupReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The tftpDefault
     * Meta informations extracted from the WSDL
     * - documentation: Only use when setting TFTP Default to true. Setting to true will result in setting all other CallManager groups to false.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $tftpDefault;
    /**
     * The removeMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\RemoveMembers
     */
    public $removeMembers;
    /**
     * The addMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\AddMembers
     */
    public $addMembers;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Members
     */
    public $members;
    /**
     * Constructor method for UpdateCallManagerGroupReq
     * @uses UpdateCallManagerGroupReq::setNewName()
     * @uses UpdateCallManagerGroupReq::setTftpDefault()
     * @uses UpdateCallManagerGroupReq::setRemoveMembers()
     * @uses UpdateCallManagerGroupReq::setAddMembers()
     * @uses UpdateCallManagerGroupReq::setMembers()
     * @param string $newName
     * @param string $tftpDefault
     * @param \CUCM\StructType\RemoveMembers $removeMembers
     * @param \CUCM\StructType\AddMembers $addMembers
     * @param \CUCM\StructType\Members $members
     */
    public function __construct($newName = null, $tftpDefault = null, \CUCM\StructType\RemoveMembers $removeMembers = null, \CUCM\StructType\AddMembers $addMembers = null, \CUCM\StructType\Members $members = null)
    {
        $this
            ->setNewName($newName)
            ->setTftpDefault($tftpDefault)
            ->setRemoveMembers($removeMembers)
            ->setAddMembers($addMembers)
            ->setMembers($members);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \CUCM\StructType\UpdateCallManagerGroupReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get tftpDefault value
     * @return string|null
     */
    public function getTftpDefault()
    {
        return $this->tftpDefault;
    }
    /**
     * Set tftpDefault value
     * @param string $tftpDefault
     * @return \CUCM\StructType\UpdateCallManagerGroupReq
     */
    public function setTftpDefault($tftpDefault = null)
    {
        // validation for constraint: pattern
        if (is_scalar($tftpDefault) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $tftpDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($tftpDefault, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tftpDefault) && !is_string($tftpDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tftpDefault)), __LINE__);
        }
        $this->tftpDefault = $tftpDefault;
        return $this;
    }
    /**
     * Get removeMembers value
     * @return \CUCM\StructType\RemoveMembers|null
     */
    public function getRemoveMembers()
    {
        return $this->removeMembers;
    }
    /**
     * Set removeMembers value
     * @param \CUCM\StructType\RemoveMembers $removeMembers
     * @return \CUCM\StructType\UpdateCallManagerGroupReq
     */
    public function setRemoveMembers(\CUCM\StructType\RemoveMembers $removeMembers = null)
    {
        $this->removeMembers = $removeMembers;
        return $this;
    }
    /**
     * Get addMembers value
     * @return \CUCM\StructType\AddMembers|null
     */
    public function getAddMembers()
    {
        return $this->addMembers;
    }
    /**
     * Set addMembers value
     * @param \CUCM\StructType\AddMembers $addMembers
     * @return \CUCM\StructType\UpdateCallManagerGroupReq
     */
    public function setAddMembers(\CUCM\StructType\AddMembers $addMembers = null)
    {
        $this->addMembers = $addMembers;
        return $this;
    }
    /**
     * Get members value
     * @return \CUCM\StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \CUCM\StructType\Members $members
     * @return \CUCM\StructType\UpdateCallManagerGroupReq
     */
    public function setMembers(\CUCM\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateCallManagerGroupReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
