<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateApplicationServerReq StructType
 * @subpackage Structs
 */
class UpdateApplicationServerReq extends APIRequest
{
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The ipAddress
     * Meta informations extracted from the WSDL
     * - documentation: Applicable for Cisco Unity Voice Mail 4.x or later, Cisco Unity Connection and Cisco Web Dialer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipAddress;
    /**
     * The removeAppUsers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\RemoveAppUsers
     */
    public $removeAppUsers;
    /**
     * The addAppUsers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\AddAppUsers
     */
    public $addAppUsers;
    /**
     * The appUsers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\AppUsers
     */
    public $appUsers;
    /**
     * The url
     * Meta informations extracted from the WSDL
     * - documentation: Applicable only for Presence Server, CUMA Provisioning Server
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $url;
    /**
     * The endUserUrl
     * Meta informations extracted from the WSDL
     * - documentation: Applicable only for Presence Server, CUMA Provisioning Server, CER Location Management
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $endUserUrl;
    /**
     * The processNodeName
     * Meta informations extracted from the WSDL
     * - documentation: Applicable Only for Cisco Web dialer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $processNodeName;
    /**
     * The removeEndUsers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\RemoveEndUsers
     */
    public $removeEndUsers;
    /**
     * The addEndUsers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\AddEndUsers
     */
    public $addEndUsers;
    /**
     * The endUsers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\EndUsers
     */
    public $endUsers;
    /**
     * Constructor method for UpdateApplicationServerReq
     * @uses UpdateApplicationServerReq::setUuid()
     * @uses UpdateApplicationServerReq::setNewName()
     * @uses UpdateApplicationServerReq::setIpAddress()
     * @uses UpdateApplicationServerReq::setRemoveAppUsers()
     * @uses UpdateApplicationServerReq::setAddAppUsers()
     * @uses UpdateApplicationServerReq::setAppUsers()
     * @uses UpdateApplicationServerReq::setUrl()
     * @uses UpdateApplicationServerReq::setEndUserUrl()
     * @uses UpdateApplicationServerReq::setProcessNodeName()
     * @uses UpdateApplicationServerReq::setRemoveEndUsers()
     * @uses UpdateApplicationServerReq::setAddEndUsers()
     * @uses UpdateApplicationServerReq::setEndUsers()
     * @param string $uuid
     * @param string $newName
     * @param string $ipAddress
     * @param \CUCM\StructType\RemoveAppUsers $removeAppUsers
     * @param \CUCM\StructType\AddAppUsers $addAppUsers
     * @param \CUCM\StructType\AppUsers $appUsers
     * @param string $url
     * @param string $endUserUrl
     * @param \CUCM\StructType\XFkType $processNodeName
     * @param \CUCM\StructType\RemoveEndUsers $removeEndUsers
     * @param \CUCM\StructType\AddEndUsers $addEndUsers
     * @param \CUCM\StructType\EndUsers $endUsers
     */
    public function __construct($uuid = null, $newName = null, $ipAddress = null, \CUCM\StructType\RemoveAppUsers $removeAppUsers = null, \CUCM\StructType\AddAppUsers $addAppUsers = null, \CUCM\StructType\AppUsers $appUsers = null, $url = null, $endUserUrl = null, \CUCM\StructType\XFkType $processNodeName = null, \CUCM\StructType\RemoveEndUsers $removeEndUsers = null, \CUCM\StructType\AddEndUsers $addEndUsers = null, \CUCM\StructType\EndUsers $endUsers = null)
    {
        $this
            ->setUuid($uuid)
            ->setNewName($newName)
            ->setIpAddress($ipAddress)
            ->setRemoveAppUsers($removeAppUsers)
            ->setAddAppUsers($addAppUsers)
            ->setAppUsers($appUsers)
            ->setUrl($url)
            ->setEndUserUrl($endUserUrl)
            ->setProcessNodeName($processNodeName)
            ->setRemoveEndUsers($removeEndUsers)
            ->setAddEndUsers($addEndUsers)
            ->setEndUsers($endUsers);
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\UpdateApplicationServerReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \CUCM\StructType\UpdateApplicationServerReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \CUCM\StructType\UpdateApplicationServerReq
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get removeAppUsers value
     * @return \CUCM\StructType\RemoveAppUsers|null
     */
    public function getRemoveAppUsers()
    {
        return $this->removeAppUsers;
    }
    /**
     * Set removeAppUsers value
     * @param \CUCM\StructType\RemoveAppUsers $removeAppUsers
     * @return \CUCM\StructType\UpdateApplicationServerReq
     */
    public function setRemoveAppUsers(\CUCM\StructType\RemoveAppUsers $removeAppUsers = null)
    {
        $this->removeAppUsers = $removeAppUsers;
        return $this;
    }
    /**
     * Get addAppUsers value
     * @return \CUCM\StructType\AddAppUsers|null
     */
    public function getAddAppUsers()
    {
        return $this->addAppUsers;
    }
    /**
     * Set addAppUsers value
     * @param \CUCM\StructType\AddAppUsers $addAppUsers
     * @return \CUCM\StructType\UpdateApplicationServerReq
     */
    public function setAddAppUsers(\CUCM\StructType\AddAppUsers $addAppUsers = null)
    {
        $this->addAppUsers = $addAppUsers;
        return $this;
    }
    /**
     * Get appUsers value
     * @return \CUCM\StructType\AppUsers|null
     */
    public function getAppUsers()
    {
        return $this->appUsers;
    }
    /**
     * Set appUsers value
     * @param \CUCM\StructType\AppUsers $appUsers
     * @return \CUCM\StructType\UpdateApplicationServerReq
     */
    public function setAppUsers(\CUCM\StructType\AppUsers $appUsers = null)
    {
        $this->appUsers = $appUsers;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \CUCM\StructType\UpdateApplicationServerReq
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get endUserUrl value
     * @return string|null
     */
    public function getEndUserUrl()
    {
        return $this->endUserUrl;
    }
    /**
     * Set endUserUrl value
     * @param string $endUserUrl
     * @return \CUCM\StructType\UpdateApplicationServerReq
     */
    public function setEndUserUrl($endUserUrl = null)
    {
        // validation for constraint: string
        if (!is_null($endUserUrl) && !is_string($endUserUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endUserUrl)), __LINE__);
        }
        $this->endUserUrl = $endUserUrl;
        return $this;
    }
    /**
     * Get processNodeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getProcessNodeName()
    {
        return isset($this->processNodeName) ? $this->processNodeName : null;
    }
    /**
     * Set processNodeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $processNodeName
     * @return \CUCM\StructType\UpdateApplicationServerReq
     */
    public function setProcessNodeName(\CUCM\StructType\XFkType $processNodeName = null)
    {
        if (is_null($processNodeName) || (is_array($processNodeName) && empty($processNodeName))) {
            unset($this->processNodeName);
        } else {
            $this->processNodeName = $processNodeName;
        }
        return $this;
    }
    /**
     * Get removeEndUsers value
     * @return \CUCM\StructType\RemoveEndUsers|null
     */
    public function getRemoveEndUsers()
    {
        return $this->removeEndUsers;
    }
    /**
     * Set removeEndUsers value
     * @param \CUCM\StructType\RemoveEndUsers $removeEndUsers
     * @return \CUCM\StructType\UpdateApplicationServerReq
     */
    public function setRemoveEndUsers(\CUCM\StructType\RemoveEndUsers $removeEndUsers = null)
    {
        $this->removeEndUsers = $removeEndUsers;
        return $this;
    }
    /**
     * Get addEndUsers value
     * @return \CUCM\StructType\AddEndUsers|null
     */
    public function getAddEndUsers()
    {
        return $this->addEndUsers;
    }
    /**
     * Set addEndUsers value
     * @param \CUCM\StructType\AddEndUsers $addEndUsers
     * @return \CUCM\StructType\UpdateApplicationServerReq
     */
    public function setAddEndUsers(\CUCM\StructType\AddEndUsers $addEndUsers = null)
    {
        $this->addEndUsers = $addEndUsers;
        return $this;
    }
    /**
     * Get endUsers value
     * @return \CUCM\StructType\EndUsers|null
     */
    public function getEndUsers()
    {
        return $this->endUsers;
    }
    /**
     * Set endUsers value
     * @param \CUCM\StructType\EndUsers $endUsers
     * @return \CUCM\StructType\UpdateApplicationServerReq
     */
    public function setEndUsers(\CUCM\StructType\EndUsers $endUsers = null)
    {
        $this->endUsers = $endUsers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateApplicationServerReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
