<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for unit StructType
 * Meta informations extracted from the WSDL
 * - documentation: In the IOS model unit corresponds to a SLOT(Slot Module) | In the IOS model unit corresponds to a SLOT(Slot Module) | In the IOS model unit corresponds to a SLOT(Slot Module)
 * @subpackage Structs
 */
class Unit extends AbstractStructBase
{
    /**
     * The index
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $index;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $product;
    /**
     * The subunits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Subunits
     */
    public $subunits;
    /**
     * Constructor method for unit
     * @uses Unit::setIndex()
     * @uses Unit::setProduct()
     * @uses Unit::setSubunits()
     * @param string $index
     * @param string $product
     * @param \CUCM\StructType\Subunits $subunits
     */
    public function __construct($index = '0', $product = null, \CUCM\StructType\Subunits $subunits = null)
    {
        $this
            ->setIndex($index)
            ->setProduct($product)
            ->setSubunits($subunits);
    }
    /**
     * Get index value
     * @return string|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return \CUCM\StructType\Unit
     */
    public function setIndex($index = '0')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $index, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \CUCM\EnumType\XMGCPSlotModule::valueIsValid()
     * @uses \CUCM\EnumType\XMGCPSlotModule::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \CUCM\StructType\Unit
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XMGCPSlotModule::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', \CUCM\EnumType\XMGCPSlotModule::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get subunits value
     * @return \CUCM\StructType\Subunits|null
     */
    public function getSubunits()
    {
        return $this->subunits;
    }
    /**
     * Set subunits value
     * @param \CUCM\StructType\Subunits $subunits
     * @return \CUCM\StructType\Unit
     */
    public function setSubunits(\CUCM\StructType\Subunits $subunits = null)
    {
        $this->subunits = $subunits;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\Unit
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
