<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for subunits StructType
 * @subpackage Structs
 */
class Subunits extends AbstractStructBase
{
    /**
     * The subunit
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \CUCM\StructType\Subunit[]
     */
    public $subunit;
    /**
     * Constructor method for subunits
     * @uses Subunits::setSubunit()
     * @param \CUCM\StructType\Subunit[] $subunit
     */
    public function __construct(array $subunit = array())
    {
        $this
            ->setSubunit($subunit);
    }
    /**
     * Get subunit value
     * @return \CUCM\StructType\Subunit[]|null
     */
    public function getSubunit()
    {
        return $this->subunit;
    }
    /**
     * Set subunit value
     * @throws \InvalidArgumentException
     * @param \CUCM\StructType\Subunit[] $subunit
     * @return \CUCM\StructType\Subunits
     */
    public function setSubunit(array $subunit = array())
    {
        foreach ($subunit as $subunitsSubunitItem) {
            // validation for constraint: itemType
            if (!$subunitsSubunitItem instanceof \CUCM\StructType\Subunit) {
                throw new \InvalidArgumentException(sprintf('The subunit property can only contain items of \CUCM\StructType\Subunit, "%s" given', is_object($subunitsSubunitItem) ? get_class($subunitsSubunitItem) : gettype($subunitsSubunitItem)), __LINE__);
            }
        }
        $this->subunit = $subunit;
        return $this;
    }
    /**
     * Add item to subunit value
     * @throws \InvalidArgumentException
     * @param \CUCM\StructType\Subunit $item
     * @return \CUCM\StructType\Subunits
     */
    public function addToSubunit(\CUCM\StructType\Subunit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CUCM\StructType\Subunit) {
            throw new \InvalidArgumentException(sprintf('The subunit property can only contain items of \CUCM\StructType\Subunit, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->subunit[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\Subunits
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
