<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for servers StructType
 * @subpackage Structs
 */
class Servers extends AbstractStructBase
{
    /**
     * The server
     * Meta informations extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \CUCM\StructType\Server[]
     */
    public $server;
    /**
     * Constructor method for servers
     * @uses Servers::setServer()
     * @param \CUCM\StructType\Server[] $server
     */
    public function __construct(array $server = array())
    {
        $this
            ->setServer($server);
    }
    /**
     * Get server value
     * @return \CUCM\StructType\Server[]|null
     */
    public function getServer()
    {
        return $this->server;
    }
    /**
     * Set server value
     * @throws \InvalidArgumentException
     * @param \CUCM\StructType\Server[] $server
     * @return \CUCM\StructType\Servers
     */
    public function setServer(array $server = array())
    {
        foreach ($server as $serversServerItem) {
            // validation for constraint: itemType
            if (!$serversServerItem instanceof \CUCM\StructType\Server) {
                throw new \InvalidArgumentException(sprintf('The server property can only contain items of \CUCM\StructType\Server, "%s" given', is_object($serversServerItem) ? get_class($serversServerItem) : gettype($serversServerItem)), __LINE__);
            }
        }
        $this->server = $server;
        return $this;
    }
    /**
     * Add item to server value
     * @throws \InvalidArgumentException
     * @param \CUCM\StructType\Server $item
     * @return \CUCM\StructType\Servers
     */
    public function addToServer(\CUCM\StructType\Server $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CUCM\StructType\Server) {
            throw new \InvalidArgumentException(sprintf('The server property can only contain items of \CUCM\StructType\Server, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->server[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\Servers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
