<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveGatewaySubunitsReq StructType
 * @subpackage Structs
 */
class RemoveGatewaySubunitsReq extends AbstractStructBase
{
    /**
     * The gatewayUuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $gatewayUuid;
    /**
     * The domainName
     * Meta informations extracted from the WSDL
     * - documentation: For SCCP mention MAC Address
     * - nillable: false
     * @var string
     */
    public $domainName;
    /**
     * The unit
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var int
     */
    public $unit;
    /**
     * The subunits
     * @var \CUCM\StructType\Subunits
     */
    public $subunits;
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for RemoveGatewaySubunitsReq
     * @uses RemoveGatewaySubunitsReq::setGatewayUuid()
     * @uses RemoveGatewaySubunitsReq::setDomainName()
     * @uses RemoveGatewaySubunitsReq::setUnit()
     * @uses RemoveGatewaySubunitsReq::setSubunits()
     * @uses RemoveGatewaySubunitsReq::setSequence()
     * @param string $gatewayUuid
     * @param string $domainName
     * @param int $unit
     * @param \CUCM\StructType\Subunits $subunits
     * @param int $sequence
     */
    public function __construct($gatewayUuid = null, $domainName = null, $unit = null, \CUCM\StructType\Subunits $subunits = null, $sequence = null)
    {
        $this
            ->setGatewayUuid($gatewayUuid)
            ->setDomainName($domainName)
            ->setUnit($unit)
            ->setSubunits($subunits)
            ->setSequence($sequence);
    }
    /**
     * Get gatewayUuid value
     * @return string|null
     */
    public function getGatewayUuid()
    {
        return $this->gatewayUuid;
    }
    /**
     * Set gatewayUuid value
     * @param string $gatewayUuid
     * @return \CUCM\StructType\RemoveGatewaySubunitsReq
     */
    public function setGatewayUuid($gatewayUuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($gatewayUuid) && !preg_match('/\\{........-....-....-....-............\\}/', $gatewayUuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($gatewayUuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($gatewayUuid) && !is_string($gatewayUuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gatewayUuid)), __LINE__);
        }
        $this->gatewayUuid = $gatewayUuid;
        return $this;
    }
    /**
     * Get domainName value
     * @return string|null
     */
    public function getDomainName()
    {
        return $this->domainName;
    }
    /**
     * Set domainName value
     * @param string $domainName
     * @return \CUCM\StructType\RemoveGatewaySubunitsReq
     */
    public function setDomainName($domainName = null)
    {
        // validation for constraint: string
        if (!is_null($domainName) && !is_string($domainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainName)), __LINE__);
        }
        $this->domainName = $domainName;
        return $this;
    }
    /**
     * Get unit value
     * @return int|null
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @param int $unit
     * @return \CUCM\StructType\RemoveGatewaySubunitsReq
     */
    public function setUnit($unit = null)
    {
        // validation for constraint: int
        if (!is_null($unit) && !is_numeric($unit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unit)), __LINE__);
        }
        $this->unit = $unit;
        return $this;
    }
    /**
     * Get subunits value
     * @return \CUCM\StructType\Subunits|null
     */
    public function getSubunits()
    {
        return $this->subunits;
    }
    /**
     * Set subunits value
     * @param \CUCM\StructType\Subunits $subunits
     * @return \CUCM\StructType\RemoveGatewaySubunitsReq
     */
    public function setSubunits(\CUCM\StructType\Subunits $subunits = null)
    {
        $this->subunits = $subunits;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \CUCM\StructType\RemoveGatewaySubunitsReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RemoveGatewaySubunitsReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
