<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for removeEndUsers StructType
 * @subpackage Structs
 */
class RemoveEndUsers extends XCommonMembersExtension
{
    /**
     * The selectedEndUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \CUCM\StructType\SelectedEndUser[]
     */
    public $selectedEndUser;
    /**
     * Constructor method for removeEndUsers
     * @uses RemoveEndUsers::setSelectedEndUser()
     * @param \CUCM\StructType\SelectedEndUser[] $selectedEndUser
     */
    public function __construct(array $selectedEndUser = array())
    {
        $this
            ->setSelectedEndUser($selectedEndUser);
    }
    /**
     * Get selectedEndUser value
     * @return \CUCM\StructType\SelectedEndUser[]
     */
    public function getSelectedEndUser()
    {
        return $this->selectedEndUser;
    }
    /**
     * Set selectedEndUser value
     * @throws \InvalidArgumentException
     * @param \CUCM\StructType\SelectedEndUser[] $selectedEndUser
     * @return \CUCM\StructType\RemoveEndUsers
     */
    public function setSelectedEndUser(array $selectedEndUser = array())
    {
        foreach ($selectedEndUser as $removeEndUsersSelectedEndUserItem) {
            // validation for constraint: itemType
            if (!$removeEndUsersSelectedEndUserItem instanceof \CUCM\StructType\SelectedEndUser) {
                throw new \InvalidArgumentException(sprintf('The selectedEndUser property can only contain items of \CUCM\StructType\SelectedEndUser, "%s" given', is_object($removeEndUsersSelectedEndUserItem) ? get_class($removeEndUsersSelectedEndUserItem) : gettype($removeEndUsersSelectedEndUserItem)), __LINE__);
            }
        }
        $this->selectedEndUser = $selectedEndUser;
        return $this;
    }
    /**
     * Add item to selectedEndUser value
     * @throws \InvalidArgumentException
     * @param \CUCM\StructType\SelectedEndUser $item
     * @return \CUCM\StructType\RemoveEndUsers
     */
    public function addToSelectedEndUser(\CUCM\StructType\SelectedEndUser $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CUCM\StructType\SelectedEndUser) {
            throw new \InvalidArgumentException(sprintf('The selectedEndUser property can only contain items of \CUCM\StructType\SelectedEndUser, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->selectedEndUser[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RemoveEndUsers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
