<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for removeApplicationToSoftkeyTemplateReq StructType
 * @subpackage Structs
 */
class RemoveApplicationToSoftkeyTemplateReq extends AbstractStructBase
{
    /**
     * The softKeyTemplateName
     * Meta informations extracted from the WSDL
     * - documentation: This template should not be a standard template
     * - minOccurs: 1
     * - nillable: false
     * @var \CUCM\StructType\XFkType
     */
    public $softKeyTemplateName;
    /**
     * The applicationName
     * Meta informations extracted from the WSDL
     * - documentation: This application should not be Cisco CallManager.
     * - nillable: false
     * - maxLength: 100
     * @var string
     */
    public $applicationName;
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for removeApplicationToSoftkeyTemplateReq
     * @uses RemoveApplicationToSoftkeyTemplateReq::setSoftKeyTemplateName()
     * @uses RemoveApplicationToSoftkeyTemplateReq::setApplicationName()
     * @uses RemoveApplicationToSoftkeyTemplateReq::setSequence()
     * @param \CUCM\StructType\XFkType $softKeyTemplateName
     * @param string $applicationName
     * @param int $sequence
     */
    public function __construct(\CUCM\StructType\XFkType $softKeyTemplateName = null, $applicationName = null, $sequence = null)
    {
        $this
            ->setSoftKeyTemplateName($softKeyTemplateName)
            ->setApplicationName($applicationName)
            ->setSequence($sequence);
    }
    /**
     * Get softKeyTemplateName value
     * @return \CUCM\StructType\XFkType
     */
    public function getSoftKeyTemplateName()
    {
        return $this->softKeyTemplateName;
    }
    /**
     * Set softKeyTemplateName value
     * @param \CUCM\StructType\XFkType $softKeyTemplateName
     * @return \CUCM\StructType\RemoveApplicationToSoftkeyTemplateReq
     */
    public function setSoftKeyTemplateName(\CUCM\StructType\XFkType $softKeyTemplateName = null)
    {
        $this->softKeyTemplateName = $softKeyTemplateName;
        return $this;
    }
    /**
     * Get applicationName value
     * @return string|null
     */
    public function getApplicationName()
    {
        return $this->applicationName;
    }
    /**
     * Set applicationName value
     * @param string $applicationName
     * @return \CUCM\StructType\RemoveApplicationToSoftkeyTemplateReq
     */
    public function setApplicationName($applicationName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($applicationName) && strlen($applicationName) > 100) || (is_array($applicationName) && count($applicationName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($applicationName) ? strlen($applicationName) : count($applicationName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($applicationName) && !is_string($applicationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicationName)), __LINE__);
        }
        $this->applicationName = $applicationName;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \CUCM\StructType\RemoveApplicationToSoftkeyTemplateReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RemoveApplicationToSoftkeyTemplateReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
