<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RUser StructType
 * @subpackage Structs
 */
class RUser extends AbstractStructBase
{
    /**
     * The firstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The middleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $middleName;
    /**
     * The lastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lastName;
    /**
     * The userid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userid;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The pin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pin;
    /**
     * The telephoneNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $telephoneNumber;
    /**
     * The mailid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mailid;
    /**
     * The department
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $department;
    /**
     * The manager
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $manager;
    /**
     * The userLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userLocale;
    /**
     * The associatedDevices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\AssociatedDevices
     */
    public $associatedDevices;
    /**
     * The primaryExtension
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\PrimaryExtension
     */
    public $primaryExtension;
    /**
     * The associatedPc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $associatedPc;
    /**
     * The associatedGroups
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\AssociatedGroups
     */
    public $associatedGroups;
    /**
     * The enableCti
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableCti;
    /**
     * The digestCredentials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $digestCredentials;
    /**
     * The phoneProfiles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\PhoneProfiles
     */
    public $phoneProfiles;
    /**
     * The defaultProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $defaultProfile;
    /**
     * The presenceGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The enableMobility
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableMobility;
    /**
     * The enableMobileVoiceAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableMobileVoiceAccess;
    /**
     * The maxDeskPickupWaitTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxDeskPickupWaitTime;
    /**
     * The remoteDestinationLimit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $remoteDestinationLimit;
    /**
     * The associatedRemoteDestinationProfiles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\AssociatedRemoteDestinationProfiles
     */
    public $associatedRemoteDestinationProfiles;
    /**
     * The passwordCredentials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\PasswordCredentials
     */
    public $passwordCredentials;
    /**
     * The pinCredentials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\PinCredentials
     */
    public $pinCredentials;
    /**
     * The primaryDevice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $primaryDevice;
    /**
     * The associatedTodAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\AssociatedTodAccess
     */
    public $associatedTodAccess;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The enableEmcc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableEmcc;
    /**
     * The associatedCapfProfiles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\AssociatedCapfProfiles
     */
    public $associatedCapfProfiles;
    /**
     * The ctiControlledDeviceProfiles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\CtiControlledDeviceProfiles
     */
    public $ctiControlledDeviceProfiles;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RUser
     * @uses RUser::setFirstName()
     * @uses RUser::setMiddleName()
     * @uses RUser::setLastName()
     * @uses RUser::setUserid()
     * @uses RUser::setPassword()
     * @uses RUser::setPin()
     * @uses RUser::setTelephoneNumber()
     * @uses RUser::setMailid()
     * @uses RUser::setDepartment()
     * @uses RUser::setManager()
     * @uses RUser::setUserLocale()
     * @uses RUser::setAssociatedDevices()
     * @uses RUser::setPrimaryExtension()
     * @uses RUser::setAssociatedPc()
     * @uses RUser::setAssociatedGroups()
     * @uses RUser::setEnableCti()
     * @uses RUser::setDigestCredentials()
     * @uses RUser::setPhoneProfiles()
     * @uses RUser::setDefaultProfile()
     * @uses RUser::setPresenceGroupName()
     * @uses RUser::setSubscribeCallingSearchSpaceName()
     * @uses RUser::setEnableMobility()
     * @uses RUser::setEnableMobileVoiceAccess()
     * @uses RUser::setMaxDeskPickupWaitTime()
     * @uses RUser::setRemoteDestinationLimit()
     * @uses RUser::setAssociatedRemoteDestinationProfiles()
     * @uses RUser::setPasswordCredentials()
     * @uses RUser::setPinCredentials()
     * @uses RUser::setPrimaryDevice()
     * @uses RUser::setAssociatedTodAccess()
     * @uses RUser::setStatus()
     * @uses RUser::setEnableEmcc()
     * @uses RUser::setAssociatedCapfProfiles()
     * @uses RUser::setCtiControlledDeviceProfiles()
     * @uses RUser::setUuid()
     * @param string $firstName
     * @param string $middleName
     * @param string $lastName
     * @param string $userid
     * @param string $password
     * @param string $pin
     * @param string $telephoneNumber
     * @param string $mailid
     * @param string $department
     * @param string $manager
     * @param string $userLocale
     * @param \CUCM\StructType\AssociatedDevices $associatedDevices
     * @param \CUCM\StructType\PrimaryExtension $primaryExtension
     * @param string $associatedPc
     * @param \CUCM\StructType\AssociatedGroups $associatedGroups
     * @param string $enableCti
     * @param string $digestCredentials
     * @param \CUCM\StructType\PhoneProfiles $phoneProfiles
     * @param \CUCM\StructType\XFkType $defaultProfile
     * @param \CUCM\StructType\XFkType $presenceGroupName
     * @param \CUCM\StructType\XFkType $subscribeCallingSearchSpaceName
     * @param string $enableMobility
     * @param string $enableMobileVoiceAccess
     * @param string $maxDeskPickupWaitTime
     * @param string $remoteDestinationLimit
     * @param \CUCM\StructType\AssociatedRemoteDestinationProfiles $associatedRemoteDestinationProfiles
     * @param \CUCM\StructType\PasswordCredentials $passwordCredentials
     * @param \CUCM\StructType\PinCredentials $pinCredentials
     * @param \CUCM\StructType\XFkType $primaryDevice
     * @param \CUCM\StructType\AssociatedTodAccess $associatedTodAccess
     * @param string $status
     * @param string $enableEmcc
     * @param \CUCM\StructType\AssociatedCapfProfiles $associatedCapfProfiles
     * @param \CUCM\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles
     * @param string $uuid
     */
    public function __construct($firstName = null, $middleName = null, $lastName = null, $userid = null, $password = null, $pin = null, $telephoneNumber = null, $mailid = null, $department = null, $manager = null, $userLocale = null, \CUCM\StructType\AssociatedDevices $associatedDevices = null, \CUCM\StructType\PrimaryExtension $primaryExtension = null, $associatedPc = null, \CUCM\StructType\AssociatedGroups $associatedGroups = null, $enableCti = null, $digestCredentials = null, \CUCM\StructType\PhoneProfiles $phoneProfiles = null, \CUCM\StructType\XFkType $defaultProfile = null, \CUCM\StructType\XFkType $presenceGroupName = null, \CUCM\StructType\XFkType $subscribeCallingSearchSpaceName = null, $enableMobility = null, $enableMobileVoiceAccess = null, $maxDeskPickupWaitTime = null, $remoteDestinationLimit = null, \CUCM\StructType\AssociatedRemoteDestinationProfiles $associatedRemoteDestinationProfiles = null, \CUCM\StructType\PasswordCredentials $passwordCredentials = null, \CUCM\StructType\PinCredentials $pinCredentials = null, \CUCM\StructType\XFkType $primaryDevice = null, \CUCM\StructType\AssociatedTodAccess $associatedTodAccess = null, $status = null, $enableEmcc = null, \CUCM\StructType\AssociatedCapfProfiles $associatedCapfProfiles = null, \CUCM\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles = null, $uuid = null)
    {
        $this
            ->setFirstName($firstName)
            ->setMiddleName($middleName)
            ->setLastName($lastName)
            ->setUserid($userid)
            ->setPassword($password)
            ->setPin($pin)
            ->setTelephoneNumber($telephoneNumber)
            ->setMailid($mailid)
            ->setDepartment($department)
            ->setManager($manager)
            ->setUserLocale($userLocale)
            ->setAssociatedDevices($associatedDevices)
            ->setPrimaryExtension($primaryExtension)
            ->setAssociatedPc($associatedPc)
            ->setAssociatedGroups($associatedGroups)
            ->setEnableCti($enableCti)
            ->setDigestCredentials($digestCredentials)
            ->setPhoneProfiles($phoneProfiles)
            ->setDefaultProfile($defaultProfile)
            ->setPresenceGroupName($presenceGroupName)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setEnableMobility($enableMobility)
            ->setEnableMobileVoiceAccess($enableMobileVoiceAccess)
            ->setMaxDeskPickupWaitTime($maxDeskPickupWaitTime)
            ->setRemoteDestinationLimit($remoteDestinationLimit)
            ->setAssociatedRemoteDestinationProfiles($associatedRemoteDestinationProfiles)
            ->setPasswordCredentials($passwordCredentials)
            ->setPinCredentials($pinCredentials)
            ->setPrimaryDevice($primaryDevice)
            ->setAssociatedTodAccess($associatedTodAccess)
            ->setStatus($status)
            ->setEnableEmcc($enableEmcc)
            ->setAssociatedCapfProfiles($associatedCapfProfiles)
            ->setCtiControlledDeviceProfiles($ctiControlledDeviceProfiles)
            ->setUuid($uuid);
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \CUCM\StructType\RUser
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get middleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }
    /**
     * Set middleName value
     * @param string $middleName
     * @return \CUCM\StructType\RUser
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middleName)), __LINE__);
        }
        $this->middleName = $middleName;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \CUCM\StructType\RUser
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get userid value
     * @return string|null
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \CUCM\StructType\RUser
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \CUCM\StructType\RUser
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get pin value
     * @return string|null
     */
    public function getPin()
    {
        return $this->pin;
    }
    /**
     * Set pin value
     * @param string $pin
     * @return \CUCM\StructType\RUser
     */
    public function setPin($pin = null)
    {
        // validation for constraint: string
        if (!is_null($pin) && !is_string($pin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pin)), __LINE__);
        }
        $this->pin = $pin;
        return $this;
    }
    /**
     * Get telephoneNumber value
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return $this->telephoneNumber;
    }
    /**
     * Set telephoneNumber value
     * @param string $telephoneNumber
     * @return \CUCM\StructType\RUser
     */
    public function setTelephoneNumber($telephoneNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($telephoneNumber) && strlen($telephoneNumber) > 255) || (is_array($telephoneNumber) && count($telephoneNumber) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($telephoneNumber) ? strlen($telephoneNumber) : count($telephoneNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($telephoneNumber) && !is_string($telephoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephoneNumber)), __LINE__);
        }
        $this->telephoneNumber = $telephoneNumber;
        return $this;
    }
    /**
     * Get mailid value
     * @return string|null
     */
    public function getMailid()
    {
        return $this->mailid;
    }
    /**
     * Set mailid value
     * @param string $mailid
     * @return \CUCM\StructType\RUser
     */
    public function setMailid($mailid = null)
    {
        // validation for constraint: string
        if (!is_null($mailid) && !is_string($mailid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailid)), __LINE__);
        }
        $this->mailid = $mailid;
        return $this;
    }
    /**
     * Get department value
     * @return string|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param string $department
     * @return \CUCM\StructType\RUser
     */
    public function setDepartment($department = null)
    {
        // validation for constraint: string
        if (!is_null($department) && !is_string($department)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($department)), __LINE__);
        }
        $this->department = $department;
        return $this;
    }
    /**
     * Get manager value
     * @return string|null
     */
    public function getManager()
    {
        return $this->manager;
    }
    /**
     * Set manager value
     * @param string $manager
     * @return \CUCM\StructType\RUser
     */
    public function setManager($manager = null)
    {
        // validation for constraint: string
        if (!is_null($manager) && !is_string($manager)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manager)), __LINE__);
        }
        $this->manager = $manager;
        return $this;
    }
    /**
     * Get userLocale value
     * @return string|null
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @uses \CUCM\EnumType\XUserLocale::valueIsValid()
     * @uses \CUCM\EnumType\XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userLocale
     * @return \CUCM\StructType\RUser
     */
    public function setUserLocale($userLocale = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XUserLocale::valueIsValid($userLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userLocale, implode(', ', \CUCM\EnumType\XUserLocale::getValidValues())), __LINE__);
        }
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get associatedDevices value
     * @return \CUCM\StructType\AssociatedDevices|null
     */
    public function getAssociatedDevices()
    {
        return $this->associatedDevices;
    }
    /**
     * Set associatedDevices value
     * @param \CUCM\StructType\AssociatedDevices $associatedDevices
     * @return \CUCM\StructType\RUser
     */
    public function setAssociatedDevices(\CUCM\StructType\AssociatedDevices $associatedDevices = null)
    {
        $this->associatedDevices = $associatedDevices;
        return $this;
    }
    /**
     * Get primaryExtension value
     * @return \CUCM\StructType\PrimaryExtension|null
     */
    public function getPrimaryExtension()
    {
        return $this->primaryExtension;
    }
    /**
     * Set primaryExtension value
     * @param \CUCM\StructType\PrimaryExtension $primaryExtension
     * @return \CUCM\StructType\RUser
     */
    public function setPrimaryExtension(\CUCM\StructType\PrimaryExtension $primaryExtension = null)
    {
        $this->primaryExtension = $primaryExtension;
        return $this;
    }
    /**
     * Get associatedPc value
     * @return string|null
     */
    public function getAssociatedPc()
    {
        return $this->associatedPc;
    }
    /**
     * Set associatedPc value
     * @param string $associatedPc
     * @return \CUCM\StructType\RUser
     */
    public function setAssociatedPc($associatedPc = null)
    {
        // validation for constraint: string
        if (!is_null($associatedPc) && !is_string($associatedPc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($associatedPc)), __LINE__);
        }
        $this->associatedPc = $associatedPc;
        return $this;
    }
    /**
     * Get associatedGroups value
     * @return \CUCM\StructType\AssociatedGroups|null
     */
    public function getAssociatedGroups()
    {
        return $this->associatedGroups;
    }
    /**
     * Set associatedGroups value
     * @param \CUCM\StructType\AssociatedGroups $associatedGroups
     * @return \CUCM\StructType\RUser
     */
    public function setAssociatedGroups(\CUCM\StructType\AssociatedGroups $associatedGroups = null)
    {
        $this->associatedGroups = $associatedGroups;
        return $this;
    }
    /**
     * Get enableCti value
     * @return string|null
     */
    public function getEnableCti()
    {
        return $this->enableCti;
    }
    /**
     * Set enableCti value
     * @param string $enableCti
     * @return \CUCM\StructType\RUser
     */
    public function setEnableCti($enableCti = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableCti) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableCti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableCti, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableCti) && !is_string($enableCti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableCti)), __LINE__);
        }
        $this->enableCti = $enableCti;
        return $this;
    }
    /**
     * Get digestCredentials value
     * @return string|null
     */
    public function getDigestCredentials()
    {
        return $this->digestCredentials;
    }
    /**
     * Set digestCredentials value
     * @param string $digestCredentials
     * @return \CUCM\StructType\RUser
     */
    public function setDigestCredentials($digestCredentials = null)
    {
        // validation for constraint: string
        if (!is_null($digestCredentials) && !is_string($digestCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($digestCredentials)), __LINE__);
        }
        $this->digestCredentials = $digestCredentials;
        return $this;
    }
    /**
     * Get phoneProfiles value
     * @return \CUCM\StructType\PhoneProfiles|null
     */
    public function getPhoneProfiles()
    {
        return $this->phoneProfiles;
    }
    /**
     * Set phoneProfiles value
     * @param \CUCM\StructType\PhoneProfiles $phoneProfiles
     * @return \CUCM\StructType\RUser
     */
    public function setPhoneProfiles(\CUCM\StructType\PhoneProfiles $phoneProfiles = null)
    {
        $this->phoneProfiles = $phoneProfiles;
        return $this;
    }
    /**
     * Get defaultProfile value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getDefaultProfile()
    {
        return $this->defaultProfile;
    }
    /**
     * Set defaultProfile value
     * @param \CUCM\StructType\XFkType $defaultProfile
     * @return \CUCM\StructType\RUser
     */
    public function setDefaultProfile(\CUCM\StructType\XFkType $defaultProfile = null)
    {
        $this->defaultProfile = $defaultProfile;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \CUCM\StructType\XFkType $presenceGroupName
     * @return \CUCM\StructType\RUser
     */
    public function setPresenceGroupName(\CUCM\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return $this->subscribeCallingSearchSpaceName;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * @param \CUCM\StructType\XFkType $subscribeCallingSearchSpaceName
     * @return \CUCM\StructType\RUser
     */
    public function setSubscribeCallingSearchSpaceName(\CUCM\StructType\XFkType $subscribeCallingSearchSpaceName = null)
    {
        $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get enableMobility value
     * @return string|null
     */
    public function getEnableMobility()
    {
        return $this->enableMobility;
    }
    /**
     * Set enableMobility value
     * @param string $enableMobility
     * @return \CUCM\StructType\RUser
     */
    public function setEnableMobility($enableMobility = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableMobility) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableMobility, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableMobility) && !is_string($enableMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableMobility)), __LINE__);
        }
        $this->enableMobility = $enableMobility;
        return $this;
    }
    /**
     * Get enableMobileVoiceAccess value
     * @return string|null
     */
    public function getEnableMobileVoiceAccess()
    {
        return $this->enableMobileVoiceAccess;
    }
    /**
     * Set enableMobileVoiceAccess value
     * @param string $enableMobileVoiceAccess
     * @return \CUCM\StructType\RUser
     */
    public function setEnableMobileVoiceAccess($enableMobileVoiceAccess = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableMobileVoiceAccess) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableMobileVoiceAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableMobileVoiceAccess, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableMobileVoiceAccess) && !is_string($enableMobileVoiceAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableMobileVoiceAccess)), __LINE__);
        }
        $this->enableMobileVoiceAccess = $enableMobileVoiceAccess;
        return $this;
    }
    /**
     * Get maxDeskPickupWaitTime value
     * @return string|null
     */
    public function getMaxDeskPickupWaitTime()
    {
        return $this->maxDeskPickupWaitTime;
    }
    /**
     * Set maxDeskPickupWaitTime value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxDeskPickupWaitTime
     * @return \CUCM\StructType\RUser
     */
    public function setMaxDeskPickupWaitTime($maxDeskPickupWaitTime = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($maxDeskPickupWaitTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxDeskPickupWaitTime, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxDeskPickupWaitTime = $maxDeskPickupWaitTime;
        return $this;
    }
    /**
     * Get remoteDestinationLimit value
     * @return string|null
     */
    public function getRemoteDestinationLimit()
    {
        return $this->remoteDestinationLimit;
    }
    /**
     * Set remoteDestinationLimit value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $remoteDestinationLimit
     * @return \CUCM\StructType\RUser
     */
    public function setRemoteDestinationLimit($remoteDestinationLimit = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($remoteDestinationLimit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $remoteDestinationLimit, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->remoteDestinationLimit = $remoteDestinationLimit;
        return $this;
    }
    /**
     * Get associatedRemoteDestinationProfiles value
     * @return \CUCM\StructType\AssociatedRemoteDestinationProfiles|null
     */
    public function getAssociatedRemoteDestinationProfiles()
    {
        return $this->associatedRemoteDestinationProfiles;
    }
    /**
     * Set associatedRemoteDestinationProfiles value
     * @param \CUCM\StructType\AssociatedRemoteDestinationProfiles $associatedRemoteDestinationProfiles
     * @return \CUCM\StructType\RUser
     */
    public function setAssociatedRemoteDestinationProfiles(\CUCM\StructType\AssociatedRemoteDestinationProfiles $associatedRemoteDestinationProfiles = null)
    {
        $this->associatedRemoteDestinationProfiles = $associatedRemoteDestinationProfiles;
        return $this;
    }
    /**
     * Get passwordCredentials value
     * @return \CUCM\StructType\PasswordCredentials|null
     */
    public function getPasswordCredentials()
    {
        return $this->passwordCredentials;
    }
    /**
     * Set passwordCredentials value
     * @param \CUCM\StructType\PasswordCredentials $passwordCredentials
     * @return \CUCM\StructType\RUser
     */
    public function setPasswordCredentials(\CUCM\StructType\PasswordCredentials $passwordCredentials = null)
    {
        $this->passwordCredentials = $passwordCredentials;
        return $this;
    }
    /**
     * Get pinCredentials value
     * @return \CUCM\StructType\PinCredentials|null
     */
    public function getPinCredentials()
    {
        return $this->pinCredentials;
    }
    /**
     * Set pinCredentials value
     * @param \CUCM\StructType\PinCredentials $pinCredentials
     * @return \CUCM\StructType\RUser
     */
    public function setPinCredentials(\CUCM\StructType\PinCredentials $pinCredentials = null)
    {
        $this->pinCredentials = $pinCredentials;
        return $this;
    }
    /**
     * Get primaryDevice value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getPrimaryDevice()
    {
        return $this->primaryDevice;
    }
    /**
     * Set primaryDevice value
     * @param \CUCM\StructType\XFkType $primaryDevice
     * @return \CUCM\StructType\RUser
     */
    public function setPrimaryDevice(\CUCM\StructType\XFkType $primaryDevice = null)
    {
        $this->primaryDevice = $primaryDevice;
        return $this;
    }
    /**
     * Get associatedTodAccess value
     * @return \CUCM\StructType\AssociatedTodAccess|null
     */
    public function getAssociatedTodAccess()
    {
        return $this->associatedTodAccess;
    }
    /**
     * Set associatedTodAccess value
     * @param \CUCM\StructType\AssociatedTodAccess $associatedTodAccess
     * @return \CUCM\StructType\RUser
     */
    public function setAssociatedTodAccess(\CUCM\StructType\AssociatedTodAccess $associatedTodAccess = null)
    {
        $this->associatedTodAccess = $associatedTodAccess;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \CUCM\StructType\RUser
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get enableEmcc value
     * @return string|null
     */
    public function getEnableEmcc()
    {
        return $this->enableEmcc;
    }
    /**
     * Set enableEmcc value
     * @param string $enableEmcc
     * @return \CUCM\StructType\RUser
     */
    public function setEnableEmcc($enableEmcc = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableEmcc) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableEmcc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableEmcc, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableEmcc) && !is_string($enableEmcc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableEmcc)), __LINE__);
        }
        $this->enableEmcc = $enableEmcc;
        return $this;
    }
    /**
     * Get associatedCapfProfiles value
     * @return \CUCM\StructType\AssociatedCapfProfiles|null
     */
    public function getAssociatedCapfProfiles()
    {
        return $this->associatedCapfProfiles;
    }
    /**
     * Set associatedCapfProfiles value
     * @param \CUCM\StructType\AssociatedCapfProfiles $associatedCapfProfiles
     * @return \CUCM\StructType\RUser
     */
    public function setAssociatedCapfProfiles(\CUCM\StructType\AssociatedCapfProfiles $associatedCapfProfiles = null)
    {
        $this->associatedCapfProfiles = $associatedCapfProfiles;
        return $this;
    }
    /**
     * Get ctiControlledDeviceProfiles value
     * @return \CUCM\StructType\CtiControlledDeviceProfiles|null
     */
    public function getCtiControlledDeviceProfiles()
    {
        return $this->ctiControlledDeviceProfiles;
    }
    /**
     * Set ctiControlledDeviceProfiles value
     * @param \CUCM\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles
     * @return \CUCM\StructType\RUser
     */
    public function setCtiControlledDeviceProfiles(\CUCM\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles = null)
    {
        $this->ctiControlledDeviceProfiles = $ctiControlledDeviceProfiles;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RUser
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RUser
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
