<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RRoutePlan StructType
 * @subpackage Structs
 */
class RRoutePlan extends AbstractStructBase
{
    /**
     * The dnOrPattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $dnOrPattern;
    /**
     * The partition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $partition;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The routeDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $routeDetail;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RRoutePlan
     * @uses RRoutePlan::setDnOrPattern()
     * @uses RRoutePlan::setPartition()
     * @uses RRoutePlan::setType()
     * @uses RRoutePlan::setRouteDetail()
     * @uses RRoutePlan::setUuid()
     * @param string $dnOrPattern
     * @param \CUCM\StructType\XFkType $partition
     * @param string $type
     * @param string $routeDetail
     * @param string $uuid
     */
    public function __construct($dnOrPattern = null, \CUCM\StructType\XFkType $partition = null, $type = null, $routeDetail = null, $uuid = null)
    {
        $this
            ->setDnOrPattern($dnOrPattern)
            ->setPartition($partition)
            ->setType($type)
            ->setRouteDetail($routeDetail)
            ->setUuid($uuid);
    }
    /**
     * Get dnOrPattern value
     * @return string|null
     */
    public function getDnOrPattern()
    {
        return $this->dnOrPattern;
    }
    /**
     * Set dnOrPattern value
     * @param string $dnOrPattern
     * @return \CUCM\StructType\RRoutePlan
     */
    public function setDnOrPattern($dnOrPattern = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($dnOrPattern) && strlen($dnOrPattern) > 255) || (is_array($dnOrPattern) && count($dnOrPattern) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($dnOrPattern) ? strlen($dnOrPattern) : count($dnOrPattern)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dnOrPattern) && !is_string($dnOrPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dnOrPattern)), __LINE__);
        }
        $this->dnOrPattern = $dnOrPattern;
        return $this;
    }
    /**
     * Get partition value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getPartition()
    {
        return $this->partition;
    }
    /**
     * Set partition value
     * @param \CUCM\StructType\XFkType $partition
     * @return \CUCM\StructType\RRoutePlan
     */
    public function setPartition(\CUCM\StructType\XFkType $partition = null)
    {
        $this->partition = $partition;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \CUCM\EnumType\XPatternUsage::valueIsValid()
     * @uses \CUCM\EnumType\XPatternUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \CUCM\StructType\RRoutePlan
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPatternUsage::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \CUCM\EnumType\XPatternUsage::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get routeDetail value
     * @return string|null
     */
    public function getRouteDetail()
    {
        return $this->routeDetail;
    }
    /**
     * Set routeDetail value
     * @param string $routeDetail
     * @return \CUCM\StructType\RRoutePlan
     */
    public function setRouteDetail($routeDetail = null)
    {
        // validation for constraint: string
        if (!is_null($routeDetail) && !is_string($routeDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeDetail)), __LINE__);
        }
        $this->routeDetail = $routeDetail;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RRoutePlan
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RRoutePlan
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
