<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RRegionRelationship StructType
 * @subpackage Structs
 */
class RRegionRelationship extends AbstractStructBase
{
    /**
     * The regionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $regionName;
    /**
     * The bandwidth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bandwidth;
    /**
     * The videoBandwidth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $videoBandwidth;
    /**
     * The lossyNetwork
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lossyNetwork;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RRegionRelationship
     * @uses RRegionRelationship::setRegionName()
     * @uses RRegionRelationship::setBandwidth()
     * @uses RRegionRelationship::setVideoBandwidth()
     * @uses RRegionRelationship::setLossyNetwork()
     * @uses RRegionRelationship::setUuid()
     * @param \CUCM\StructType\XFkType $regionName
     * @param string $bandwidth
     * @param string $videoBandwidth
     * @param string $lossyNetwork
     * @param string $uuid
     */
    public function __construct(\CUCM\StructType\XFkType $regionName = null, $bandwidth = null, $videoBandwidth = null, $lossyNetwork = null, $uuid = null)
    {
        $this
            ->setRegionName($regionName)
            ->setBandwidth($bandwidth)
            ->setVideoBandwidth($videoBandwidth)
            ->setLossyNetwork($lossyNetwork)
            ->setUuid($uuid);
    }
    /**
     * Get regionName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getRegionName()
    {
        return $this->regionName;
    }
    /**
     * Set regionName value
     * @param \CUCM\StructType\XFkType $regionName
     * @return \CUCM\StructType\RRegionRelationship
     */
    public function setRegionName(\CUCM\StructType\XFkType $regionName = null)
    {
        $this->regionName = $regionName;
        return $this;
    }
    /**
     * Get bandwidth value
     * @return string|null
     */
    public function getBandwidth()
    {
        return $this->bandwidth;
    }
    /**
     * Set bandwidth value
     * @uses \CUCM\EnumType\XBandwidth::valueIsValid()
     * @uses \CUCM\EnumType\XBandwidth::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bandwidth
     * @return \CUCM\StructType\RRegionRelationship
     */
    public function setBandwidth($bandwidth = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XBandwidth::valueIsValid($bandwidth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $bandwidth, implode(', ', \CUCM\EnumType\XBandwidth::getValidValues())), __LINE__);
        }
        $this->bandwidth = $bandwidth;
        return $this;
    }
    /**
     * Get videoBandwidth value
     * @return string|null
     */
    public function getVideoBandwidth()
    {
        return $this->videoBandwidth;
    }
    /**
     * Set videoBandwidth value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $videoBandwidth
     * @return \CUCM\StructType\RRegionRelationship
     */
    public function setVideoBandwidth($videoBandwidth = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($videoBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $videoBandwidth, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->videoBandwidth = $videoBandwidth;
        return $this;
    }
    /**
     * Get lossyNetwork value
     * @return string|null
     */
    public function getLossyNetwork()
    {
        return $this->lossyNetwork;
    }
    /**
     * Set lossyNetwork value
     * @uses \CUCM\EnumType\XLossyNetwork::valueIsValid()
     * @uses \CUCM\EnumType\XLossyNetwork::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lossyNetwork
     * @return \CUCM\StructType\RRegionRelationship
     */
    public function setLossyNetwork($lossyNetwork = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XLossyNetwork::valueIsValid($lossyNetwork)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $lossyNetwork, implode(', ', \CUCM\EnumType\XLossyNetwork::getValidValues())), __LINE__);
        }
        $this->lossyNetwork = $lossyNetwork;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RRegionRelationship
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RRegionRelationship
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
