<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RPatternMember StructType
 * @subpackage Structs
 */
class RPatternMember extends AbstractStructBase
{
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The dialParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\DialParameters
     */
    public $dialParameters;
    /**
     * The selectionOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $selectionOrder;
    /**
     * Constructor method for RPatternMember
     * @uses RPatternMember::setDescription()
     * @uses RPatternMember::setDialParameters()
     * @uses RPatternMember::setSelectionOrder()
     * @param string $description
     * @param \CUCM\StructType\DialParameters $dialParameters
     * @param string $selectionOrder
     */
    public function __construct($description = null, \CUCM\StructType\DialParameters $dialParameters = null, $selectionOrder = null)
    {
        $this
            ->setDescription($description)
            ->setDialParameters($dialParameters)
            ->setSelectionOrder($selectionOrder);
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\RPatternMember
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get dialParameters value
     * @return \CUCM\StructType\DialParameters|null
     */
    public function getDialParameters()
    {
        return $this->dialParameters;
    }
    /**
     * Set dialParameters value
     * @param \CUCM\StructType\DialParameters $dialParameters
     * @return \CUCM\StructType\RPatternMember
     */
    public function setDialParameters(\CUCM\StructType\DialParameters $dialParameters = null)
    {
        $this->dialParameters = $dialParameters;
        return $this;
    }
    /**
     * Get selectionOrder value
     * @return string|null
     */
    public function getSelectionOrder()
    {
        return $this->selectionOrder;
    }
    /**
     * Set selectionOrder value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selectionOrder
     * @return \CUCM\StructType\RPatternMember
     */
    public function setSelectionOrder($selectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($selectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $selectionOrder, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->selectionOrder = $selectionOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RPatternMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
