<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RMohAudioSource StructType
 * @subpackage Structs
 */
class RMohAudioSource extends AbstractStructBase
{
    /**
     * The sourceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sourceId;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The sourceFile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $sourceFile;
    /**
     * The multicast
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $multicast;
    /**
     * The repeat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $repeat;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RMohAudioSource
     * @uses RMohAudioSource::setSourceId()
     * @uses RMohAudioSource::setName()
     * @uses RMohAudioSource::setSourceFile()
     * @uses RMohAudioSource::setMulticast()
     * @uses RMohAudioSource::setRepeat()
     * @uses RMohAudioSource::setUuid()
     * @param string $sourceId
     * @param string $name
     * @param string $sourceFile
     * @param string $multicast
     * @param string $repeat
     * @param string $uuid
     */
    public function __construct($sourceId = null, $name = null, $sourceFile = null, $multicast = null, $repeat = null, $uuid = null)
    {
        $this
            ->setSourceId($sourceId)
            ->setName($name)
            ->setSourceFile($sourceFile)
            ->setMulticast($multicast)
            ->setRepeat($repeat)
            ->setUuid($uuid);
    }
    /**
     * Get sourceId value
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->sourceId;
    }
    /**
     * Set sourceId value
     * @uses \CUCM\EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \CUCM\EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sourceId
     * @return \CUCM\StructType\RMohAudioSource
     */
    public function setSourceId($sourceId = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XMOHAudioSourceId::valueIsValid($sourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sourceId, implode(', ', \CUCM\EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        $this->sourceId = $sourceId;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\RMohAudioSource
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get sourceFile value
     * @return string|null
     */
    public function getSourceFile()
    {
        return $this->sourceFile;
    }
    /**
     * Set sourceFile value
     * @param string $sourceFile
     * @return \CUCM\StructType\RMohAudioSource
     */
    public function setSourceFile($sourceFile = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sourceFile) && strlen($sourceFile) > 255) || (is_array($sourceFile) && count($sourceFile) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($sourceFile) ? strlen($sourceFile) : count($sourceFile)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sourceFile) && !is_string($sourceFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sourceFile)), __LINE__);
        }
        $this->sourceFile = $sourceFile;
        return $this;
    }
    /**
     * Get multicast value
     * @return string|null
     */
    public function getMulticast()
    {
        return $this->multicast;
    }
    /**
     * Set multicast value
     * @param string $multicast
     * @return \CUCM\StructType\RMohAudioSource
     */
    public function setMulticast($multicast = null)
    {
        // validation for constraint: pattern
        if (is_scalar($multicast) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $multicast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($multicast, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($multicast) && !is_string($multicast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($multicast)), __LINE__);
        }
        $this->multicast = $multicast;
        return $this;
    }
    /**
     * Get repeat value
     * @return string|null
     */
    public function getRepeat()
    {
        return $this->repeat;
    }
    /**
     * Set repeat value
     * @param string $repeat
     * @return \CUCM\StructType\RMohAudioSource
     */
    public function setRepeat($repeat = null)
    {
        // validation for constraint: pattern
        if (is_scalar($repeat) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $repeat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($repeat, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($repeat) && !is_string($repeat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($repeat)), __LINE__);
        }
        $this->repeat = $repeat;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RMohAudioSource
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RMohAudioSource
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
