<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RLineGroup StructType
 * @subpackage Structs
 */
class RLineGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The distributionAlgorithm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $distributionAlgorithm;
    /**
     * The rnaReversionTimeOut
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rnaReversionTimeOut;
    /**
     * The huntAlgorithmNoAnswer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $huntAlgorithmNoAnswer;
    /**
     * The huntAlgorithmBusy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $huntAlgorithmBusy;
    /**
     * The huntAlgorithmNotAvailable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $huntAlgorithmNotAvailable;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Members
     */
    public $members;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RLineGroup
     * @uses RLineGroup::setName()
     * @uses RLineGroup::setDistributionAlgorithm()
     * @uses RLineGroup::setRnaReversionTimeOut()
     * @uses RLineGroup::setHuntAlgorithmNoAnswer()
     * @uses RLineGroup::setHuntAlgorithmBusy()
     * @uses RLineGroup::setHuntAlgorithmNotAvailable()
     * @uses RLineGroup::setMembers()
     * @uses RLineGroup::setUuid()
     * @param string $name
     * @param string $distributionAlgorithm
     * @param string $rnaReversionTimeOut
     * @param string $huntAlgorithmNoAnswer
     * @param string $huntAlgorithmBusy
     * @param string $huntAlgorithmNotAvailable
     * @param \CUCM\StructType\Members $members
     * @param string $uuid
     */
    public function __construct($name = null, $distributionAlgorithm = null, $rnaReversionTimeOut = null, $huntAlgorithmNoAnswer = null, $huntAlgorithmBusy = null, $huntAlgorithmNotAvailable = null, \CUCM\StructType\Members $members = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDistributionAlgorithm($distributionAlgorithm)
            ->setRnaReversionTimeOut($rnaReversionTimeOut)
            ->setHuntAlgorithmNoAnswer($huntAlgorithmNoAnswer)
            ->setHuntAlgorithmBusy($huntAlgorithmBusy)
            ->setHuntAlgorithmNotAvailable($huntAlgorithmNotAvailable)
            ->setMembers($members)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\RLineGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get distributionAlgorithm value
     * @return string|null
     */
    public function getDistributionAlgorithm()
    {
        return $this->distributionAlgorithm;
    }
    /**
     * Set distributionAlgorithm value
     * @uses \CUCM\EnumType\XDistributeAlgorithm::valueIsValid()
     * @uses \CUCM\EnumType\XDistributeAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $distributionAlgorithm
     * @return \CUCM\StructType\RLineGroup
     */
    public function setDistributionAlgorithm($distributionAlgorithm = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XDistributeAlgorithm::valueIsValid($distributionAlgorithm)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $distributionAlgorithm, implode(', ', \CUCM\EnumType\XDistributeAlgorithm::getValidValues())), __LINE__);
        }
        $this->distributionAlgorithm = $distributionAlgorithm;
        return $this;
    }
    /**
     * Get rnaReversionTimeOut value
     * @return string|null
     */
    public function getRnaReversionTimeOut()
    {
        return $this->rnaReversionTimeOut;
    }
    /**
     * Set rnaReversionTimeOut value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rnaReversionTimeOut
     * @return \CUCM\StructType\RLineGroup
     */
    public function setRnaReversionTimeOut($rnaReversionTimeOut = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($rnaReversionTimeOut)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rnaReversionTimeOut, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->rnaReversionTimeOut = $rnaReversionTimeOut;
        return $this;
    }
    /**
     * Get huntAlgorithmNoAnswer value
     * @return string|null
     */
    public function getHuntAlgorithmNoAnswer()
    {
        return $this->huntAlgorithmNoAnswer;
    }
    /**
     * Set huntAlgorithmNoAnswer value
     * @uses \CUCM\EnumType\XHuntAlgorithm::valueIsValid()
     * @uses \CUCM\EnumType\XHuntAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $huntAlgorithmNoAnswer
     * @return \CUCM\StructType\RLineGroup
     */
    public function setHuntAlgorithmNoAnswer($huntAlgorithmNoAnswer = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XHuntAlgorithm::valueIsValid($huntAlgorithmNoAnswer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $huntAlgorithmNoAnswer, implode(', ', \CUCM\EnumType\XHuntAlgorithm::getValidValues())), __LINE__);
        }
        $this->huntAlgorithmNoAnswer = $huntAlgorithmNoAnswer;
        return $this;
    }
    /**
     * Get huntAlgorithmBusy value
     * @return string|null
     */
    public function getHuntAlgorithmBusy()
    {
        return $this->huntAlgorithmBusy;
    }
    /**
     * Set huntAlgorithmBusy value
     * @uses \CUCM\EnumType\XHuntAlgorithm::valueIsValid()
     * @uses \CUCM\EnumType\XHuntAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $huntAlgorithmBusy
     * @return \CUCM\StructType\RLineGroup
     */
    public function setHuntAlgorithmBusy($huntAlgorithmBusy = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XHuntAlgorithm::valueIsValid($huntAlgorithmBusy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $huntAlgorithmBusy, implode(', ', \CUCM\EnumType\XHuntAlgorithm::getValidValues())), __LINE__);
        }
        $this->huntAlgorithmBusy = $huntAlgorithmBusy;
        return $this;
    }
    /**
     * Get huntAlgorithmNotAvailable value
     * @return string|null
     */
    public function getHuntAlgorithmNotAvailable()
    {
        return $this->huntAlgorithmNotAvailable;
    }
    /**
     * Set huntAlgorithmNotAvailable value
     * @uses \CUCM\EnumType\XHuntAlgorithm::valueIsValid()
     * @uses \CUCM\EnumType\XHuntAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $huntAlgorithmNotAvailable
     * @return \CUCM\StructType\RLineGroup
     */
    public function setHuntAlgorithmNotAvailable($huntAlgorithmNotAvailable = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XHuntAlgorithm::valueIsValid($huntAlgorithmNotAvailable)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $huntAlgorithmNotAvailable, implode(', ', \CUCM\EnumType\XHuntAlgorithm::getValidValues())), __LINE__);
        }
        $this->huntAlgorithmNotAvailable = $huntAlgorithmNotAvailable;
        return $this;
    }
    /**
     * Get members value
     * @return \CUCM\StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \CUCM\StructType\Members $members
     * @return \CUCM\StructType\RLineGroup
     */
    public function setMembers(\CUCM\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RLineGroup
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RLineGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
