<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RLdapDirectory StructType
 * @subpackage Structs
 */
class RLdapDirectory extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The ldapDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $ldapDn;
    /**
     * The ldapPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $ldapPassword;
    /**
     * The userSearchBase
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $userSearchBase;
    /**
     * The repeatable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $repeatable;
    /**
     * The intervalValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $intervalValue;
    /**
     * The scheduleUnit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $scheduleUnit;
    /**
     * The nextExecTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $nextExecTime;
    /**
     * The servers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Servers
     */
    public $servers;
    /**
     * The middleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $middleName;
    /**
     * The phoneNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $phoneNumber;
    /**
     * The mailId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $mailId;
    /**
     * The userId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $userId;
    /**
     * The managerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $managerId;
    /**
     * The firstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $firstName;
    /**
     * The lastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $lastName;
    /**
     * The department
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $department;
    /**
     * The ldapFilter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $ldapFilter;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RLdapDirectory
     * @uses RLdapDirectory::setName()
     * @uses RLdapDirectory::setLdapDn()
     * @uses RLdapDirectory::setLdapPassword()
     * @uses RLdapDirectory::setUserSearchBase()
     * @uses RLdapDirectory::setRepeatable()
     * @uses RLdapDirectory::setIntervalValue()
     * @uses RLdapDirectory::setScheduleUnit()
     * @uses RLdapDirectory::setNextExecTime()
     * @uses RLdapDirectory::setServers()
     * @uses RLdapDirectory::setMiddleName()
     * @uses RLdapDirectory::setPhoneNumber()
     * @uses RLdapDirectory::setMailId()
     * @uses RLdapDirectory::setUserId()
     * @uses RLdapDirectory::setManagerId()
     * @uses RLdapDirectory::setFirstName()
     * @uses RLdapDirectory::setLastName()
     * @uses RLdapDirectory::setDepartment()
     * @uses RLdapDirectory::setLdapFilter()
     * @uses RLdapDirectory::setUuid()
     * @param string $name
     * @param string $ldapDn
     * @param string $ldapPassword
     * @param string $userSearchBase
     * @param string $repeatable
     * @param string $intervalValue
     * @param string $scheduleUnit
     * @param string $nextExecTime
     * @param \CUCM\StructType\Servers $servers
     * @param string $middleName
     * @param string $phoneNumber
     * @param string $mailId
     * @param string $userId
     * @param string $managerId
     * @param string $firstName
     * @param string $lastName
     * @param string $department
     * @param \CUCM\StructType\XFkType $ldapFilter
     * @param string $uuid
     */
    public function __construct($name = null, $ldapDn = null, $ldapPassword = null, $userSearchBase = null, $repeatable = null, $intervalValue = null, $scheduleUnit = null, $nextExecTime = null, \CUCM\StructType\Servers $servers = null, $middleName = null, $phoneNumber = null, $mailId = null, $userId = null, $managerId = null, $firstName = null, $lastName = null, $department = null, \CUCM\StructType\XFkType $ldapFilter = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setLdapDn($ldapDn)
            ->setLdapPassword($ldapPassword)
            ->setUserSearchBase($userSearchBase)
            ->setRepeatable($repeatable)
            ->setIntervalValue($intervalValue)
            ->setScheduleUnit($scheduleUnit)
            ->setNextExecTime($nextExecTime)
            ->setServers($servers)
            ->setMiddleName($middleName)
            ->setPhoneNumber($phoneNumber)
            ->setMailId($mailId)
            ->setUserId($userId)
            ->setManagerId($managerId)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setDepartment($department)
            ->setLdapFilter($ldapFilter)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\RLdapDirectory
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get ldapDn value
     * @return string|null
     */
    public function getLdapDn()
    {
        return $this->ldapDn;
    }
    /**
     * Set ldapDn value
     * @param string $ldapDn
     * @return \CUCM\StructType\RLdapDirectory
     */
    public function setLdapDn($ldapDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ldapDn) && strlen($ldapDn) > 128) || (is_array($ldapDn) && count($ldapDn) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($ldapDn) ? strlen($ldapDn) : count($ldapDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ldapDn) && !is_string($ldapDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ldapDn)), __LINE__);
        }
        $this->ldapDn = $ldapDn;
        return $this;
    }
    /**
     * Get ldapPassword value
     * @return string|null
     */
    public function getLdapPassword()
    {
        return $this->ldapPassword;
    }
    /**
     * Set ldapPassword value
     * @param string $ldapPassword
     * @return \CUCM\StructType\RLdapDirectory
     */
    public function setLdapPassword($ldapPassword = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ldapPassword) && strlen($ldapPassword) > 128) || (is_array($ldapPassword) && count($ldapPassword) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($ldapPassword) ? strlen($ldapPassword) : count($ldapPassword)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ldapPassword) && !is_string($ldapPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ldapPassword)), __LINE__);
        }
        $this->ldapPassword = $ldapPassword;
        return $this;
    }
    /**
     * Get userSearchBase value
     * @return string|null
     */
    public function getUserSearchBase()
    {
        return $this->userSearchBase;
    }
    /**
     * Set userSearchBase value
     * @param string $userSearchBase
     * @return \CUCM\StructType\RLdapDirectory
     */
    public function setUserSearchBase($userSearchBase = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($userSearchBase) && strlen($userSearchBase) > 255) || (is_array($userSearchBase) && count($userSearchBase) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($userSearchBase) ? strlen($userSearchBase) : count($userSearchBase)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($userSearchBase) && !is_string($userSearchBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userSearchBase)), __LINE__);
        }
        $this->userSearchBase = $userSearchBase;
        return $this;
    }
    /**
     * Get repeatable value
     * @return string|null
     */
    public function getRepeatable()
    {
        return $this->repeatable;
    }
    /**
     * Set repeatable value
     * @param string $repeatable
     * @return \CUCM\StructType\RLdapDirectory
     */
    public function setRepeatable($repeatable = null)
    {
        // validation for constraint: pattern
        if (is_scalar($repeatable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $repeatable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($repeatable, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($repeatable) && !is_string($repeatable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($repeatable)), __LINE__);
        }
        $this->repeatable = $repeatable;
        return $this;
    }
    /**
     * Get intervalValue value
     * @return string|null
     */
    public function getIntervalValue()
    {
        return $this->intervalValue;
    }
    /**
     * Set intervalValue value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $intervalValue
     * @return \CUCM\StructType\RLdapDirectory
     */
    public function setIntervalValue($intervalValue = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($intervalValue)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $intervalValue, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->intervalValue = $intervalValue;
        return $this;
    }
    /**
     * Get scheduleUnit value
     * @return string|null
     */
    public function getScheduleUnit()
    {
        return $this->scheduleUnit;
    }
    /**
     * Set scheduleUnit value
     * @uses \CUCM\EnumType\XScheduleUnit::valueIsValid()
     * @uses \CUCM\EnumType\XScheduleUnit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scheduleUnit
     * @return \CUCM\StructType\RLdapDirectory
     */
    public function setScheduleUnit($scheduleUnit = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XScheduleUnit::valueIsValid($scheduleUnit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $scheduleUnit, implode(', ', \CUCM\EnumType\XScheduleUnit::getValidValues())), __LINE__);
        }
        $this->scheduleUnit = $scheduleUnit;
        return $this;
    }
    /**
     * Get nextExecTime value
     * @return string|null
     */
    public function getNextExecTime()
    {
        return $this->nextExecTime;
    }
    /**
     * Set nextExecTime value
     * @param string $nextExecTime
     * @return \CUCM\StructType\RLdapDirectory
     */
    public function setNextExecTime($nextExecTime = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nextExecTime) && strlen($nextExecTime) > 32) || (is_array($nextExecTime) && count($nextExecTime) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($nextExecTime) ? strlen($nextExecTime) : count($nextExecTime)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nextExecTime) && !is_string($nextExecTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nextExecTime)), __LINE__);
        }
        $this->nextExecTime = $nextExecTime;
        return $this;
    }
    /**
     * Get servers value
     * @return \CUCM\StructType\Servers|null
     */
    public function getServers()
    {
        return $this->servers;
    }
    /**
     * Set servers value
     * @param \CUCM\StructType\Servers $servers
     * @return \CUCM\StructType\RLdapDirectory
     */
    public function setServers(\CUCM\StructType\Servers $servers = null)
    {
        $this->servers = $servers;
        return $this;
    }
    /**
     * Get middleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }
    /**
     * Set middleName value
     * @param string $middleName
     * @return \CUCM\StructType\RLdapDirectory
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($middleName) && strlen($middleName) > 128) || (is_array($middleName) && count($middleName) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($middleName) ? strlen($middleName) : count($middleName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middleName)), __LINE__);
        }
        $this->middleName = $middleName;
        return $this;
    }
    /**
     * Get phoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->phoneNumber;
    }
    /**
     * Set phoneNumber value
     * @param string $phoneNumber
     * @return \CUCM\StructType\RLdapDirectory
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($phoneNumber) && strlen($phoneNumber) > 128) || (is_array($phoneNumber) && count($phoneNumber) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($phoneNumber) ? strlen($phoneNumber) : count($phoneNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumber)), __LINE__);
        }
        $this->phoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get mailId value
     * @return string|null
     */
    public function getMailId()
    {
        return $this->mailId;
    }
    /**
     * Set mailId value
     * @param string $mailId
     * @return \CUCM\StructType\RLdapDirectory
     */
    public function setMailId($mailId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mailId) && strlen($mailId) > 128) || (is_array($mailId) && count($mailId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($mailId) ? strlen($mailId) : count($mailId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mailId) && !is_string($mailId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailId)), __LINE__);
        }
        $this->mailId = $mailId;
        return $this;
    }
    /**
     * Get userId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \CUCM\StructType\RLdapDirectory
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($userId) && strlen($userId) > 128) || (is_array($userId) && count($userId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($userId) ? strlen($userId) : count($userId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userId)), __LINE__);
        }
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get managerId value
     * @return string|null
     */
    public function getManagerId()
    {
        return $this->managerId;
    }
    /**
     * Set managerId value
     * @param string $managerId
     * @return \CUCM\StructType\RLdapDirectory
     */
    public function setManagerId($managerId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($managerId) && strlen($managerId) > 128) || (is_array($managerId) && count($managerId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($managerId) ? strlen($managerId) : count($managerId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($managerId) && !is_string($managerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($managerId)), __LINE__);
        }
        $this->managerId = $managerId;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \CUCM\StructType\RLdapDirectory
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($firstName) && strlen($firstName) > 128) || (is_array($firstName) && count($firstName) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($firstName) ? strlen($firstName) : count($firstName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \CUCM\StructType\RLdapDirectory
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($lastName) && strlen($lastName) > 128) || (is_array($lastName) && count($lastName) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($lastName) ? strlen($lastName) : count($lastName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get department value
     * @return string|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param string $department
     * @return \CUCM\StructType\RLdapDirectory
     */
    public function setDepartment($department = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($department) && strlen($department) > 128) || (is_array($department) && count($department) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($department) ? strlen($department) : count($department)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($department) && !is_string($department)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($department)), __LINE__);
        }
        $this->department = $department;
        return $this;
    }
    /**
     * Get ldapFilter value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getLdapFilter()
    {
        return $this->ldapFilter;
    }
    /**
     * Set ldapFilter value
     * @param \CUCM\StructType\XFkType $ldapFilter
     * @return \CUCM\StructType\RLdapDirectory
     */
    public function setLdapFilter(\CUCM\StructType\XFkType $ldapFilter = null)
    {
        $this->ldapFilter = $ldapFilter;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RLdapDirectory
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RLdapDirectory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
