<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RImeE164Transformation StructType
 * @subpackage Structs
 */
class RImeE164Transformation extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The cgpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The isCgpnPreTransformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isCgpnPreTransformation;
    /**
     * The cdpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The isCdpnPreTransformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isCdpnPreTransformation;
    /**
     * The incomingCgpnTransformationProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $incomingCgpnTransformationProfileName;
    /**
     * The incomingCdpnTransformationProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $incomingCdpnTransformationProfileName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RImeE164Transformation
     * @uses RImeE164Transformation::setName()
     * @uses RImeE164Transformation::setDescription()
     * @uses RImeE164Transformation::setCgpnTransformationCssName()
     * @uses RImeE164Transformation::setIsCgpnPreTransformation()
     * @uses RImeE164Transformation::setCdpnTransformationCssName()
     * @uses RImeE164Transformation::setIsCdpnPreTransformation()
     * @uses RImeE164Transformation::setIncomingCgpnTransformationProfileName()
     * @uses RImeE164Transformation::setIncomingCdpnTransformationProfileName()
     * @uses RImeE164Transformation::setUuid()
     * @param string $name
     * @param string $description
     * @param \CUCM\StructType\XFkType $cgpnTransformationCssName
     * @param string $isCgpnPreTransformation
     * @param \CUCM\StructType\XFkType $cdpnTransformationCssName
     * @param string $isCdpnPreTransformation
     * @param \CUCM\StructType\XFkType $incomingCgpnTransformationProfileName
     * @param \CUCM\StructType\XFkType $incomingCdpnTransformationProfileName
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, \CUCM\StructType\XFkType $cgpnTransformationCssName = null, $isCgpnPreTransformation = null, \CUCM\StructType\XFkType $cdpnTransformationCssName = null, $isCdpnPreTransformation = null, \CUCM\StructType\XFkType $incomingCgpnTransformationProfileName = null, \CUCM\StructType\XFkType $incomingCdpnTransformationProfileName = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setIsCgpnPreTransformation($isCgpnPreTransformation)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setIsCdpnPreTransformation($isCdpnPreTransformation)
            ->setIncomingCgpnTransformationProfileName($incomingCgpnTransformationProfileName)
            ->setIncomingCdpnTransformationProfileName($incomingCdpnTransformationProfileName)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\RImeE164Transformation
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\RImeE164Transformation
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param \CUCM\StructType\XFkType $cgpnTransformationCssName
     * @return \CUCM\StructType\RImeE164Transformation
     */
    public function setCgpnTransformationCssName(\CUCM\StructType\XFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get isCgpnPreTransformation value
     * @return string|null
     */
    public function getIsCgpnPreTransformation()
    {
        return $this->isCgpnPreTransformation;
    }
    /**
     * Set isCgpnPreTransformation value
     * @param string $isCgpnPreTransformation
     * @return \CUCM\StructType\RImeE164Transformation
     */
    public function setIsCgpnPreTransformation($isCgpnPreTransformation = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isCgpnPreTransformation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isCgpnPreTransformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isCgpnPreTransformation, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isCgpnPreTransformation) && !is_string($isCgpnPreTransformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isCgpnPreTransformation)), __LINE__);
        }
        $this->isCgpnPreTransformation = $isCgpnPreTransformation;
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return $this->cdpnTransformationCssName;
    }
    /**
     * Set cdpnTransformationCssName value
     * @param \CUCM\StructType\XFkType $cdpnTransformationCssName
     * @return \CUCM\StructType\RImeE164Transformation
     */
    public function setCdpnTransformationCssName(\CUCM\StructType\XFkType $cdpnTransformationCssName = null)
    {
        $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        return $this;
    }
    /**
     * Get isCdpnPreTransformation value
     * @return string|null
     */
    public function getIsCdpnPreTransformation()
    {
        return $this->isCdpnPreTransformation;
    }
    /**
     * Set isCdpnPreTransformation value
     * @param string $isCdpnPreTransformation
     * @return \CUCM\StructType\RImeE164Transformation
     */
    public function setIsCdpnPreTransformation($isCdpnPreTransformation = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isCdpnPreTransformation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isCdpnPreTransformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isCdpnPreTransformation, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isCdpnPreTransformation) && !is_string($isCdpnPreTransformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isCdpnPreTransformation)), __LINE__);
        }
        $this->isCdpnPreTransformation = $isCdpnPreTransformation;
        return $this;
    }
    /**
     * Get incomingCgpnTransformationProfileName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getIncomingCgpnTransformationProfileName()
    {
        return $this->incomingCgpnTransformationProfileName;
    }
    /**
     * Set incomingCgpnTransformationProfileName value
     * @param \CUCM\StructType\XFkType $incomingCgpnTransformationProfileName
     * @return \CUCM\StructType\RImeE164Transformation
     */
    public function setIncomingCgpnTransformationProfileName(\CUCM\StructType\XFkType $incomingCgpnTransformationProfileName = null)
    {
        $this->incomingCgpnTransformationProfileName = $incomingCgpnTransformationProfileName;
        return $this;
    }
    /**
     * Get incomingCdpnTransformationProfileName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getIncomingCdpnTransformationProfileName()
    {
        return $this->incomingCdpnTransformationProfileName;
    }
    /**
     * Set incomingCdpnTransformationProfileName value
     * @param \CUCM\StructType\XFkType $incomingCdpnTransformationProfileName
     * @return \CUCM\StructType\RImeE164Transformation
     */
    public function setIncomingCdpnTransformationProfileName(\CUCM\StructType\XFkType $incomingCdpnTransformationProfileName = null)
    {
        $this->incomingCdpnTransformationProfileName = $incomingCdpnTransformationProfileName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RImeE164Transformation
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RImeE164Transformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
