<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFallbackFeatureConfig StructType
 * @subpackage Structs
 */
class RFallbackFeatureConfig extends AbstractStructBase
{
    /**
     * The enableFallbackForImeCalls
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableFallbackForImeCalls;
    /**
     * The qosSensistivityLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $qosSensistivityLevel;
    /**
     * The dtmfCorrelationDigits
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dtmfCorrelationDigits;
    /**
     * The dtmfCollectionTimer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dtmfCollectionTimer;
    /**
     * The callAnswerTimer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $callAnswerTimer;
    /**
     * The clearImeCallDelayTimer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $clearImeCallDelayTimer;
    /**
     * The dtmfInterDigitDelayTimer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dtmfInterDigitDelayTimer;
    /**
     * The postConnectFallbackDelayTimer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $postConnectFallbackDelayTimer;
    /**
     * The fallbackSplitDelayTimer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fallbackSplitDelayTimer;
    /**
     * The callCss
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $callCss;
    /**
     * Constructor method for RFallbackFeatureConfig
     * @uses RFallbackFeatureConfig::setEnableFallbackForImeCalls()
     * @uses RFallbackFeatureConfig::setQosSensistivityLevel()
     * @uses RFallbackFeatureConfig::setDtmfCorrelationDigits()
     * @uses RFallbackFeatureConfig::setDtmfCollectionTimer()
     * @uses RFallbackFeatureConfig::setCallAnswerTimer()
     * @uses RFallbackFeatureConfig::setClearImeCallDelayTimer()
     * @uses RFallbackFeatureConfig::setDtmfInterDigitDelayTimer()
     * @uses RFallbackFeatureConfig::setPostConnectFallbackDelayTimer()
     * @uses RFallbackFeatureConfig::setFallbackSplitDelayTimer()
     * @uses RFallbackFeatureConfig::setCallCss()
     * @param string $enableFallbackForImeCalls
     * @param string $qosSensistivityLevel
     * @param string $dtmfCorrelationDigits
     * @param string $dtmfCollectionTimer
     * @param string $callAnswerTimer
     * @param string $clearImeCallDelayTimer
     * @param string $dtmfInterDigitDelayTimer
     * @param string $postConnectFallbackDelayTimer
     * @param string $fallbackSplitDelayTimer
     * @param string $callCss
     */
    public function __construct($enableFallbackForImeCalls = null, $qosSensistivityLevel = null, $dtmfCorrelationDigits = null, $dtmfCollectionTimer = null, $callAnswerTimer = null, $clearImeCallDelayTimer = null, $dtmfInterDigitDelayTimer = null, $postConnectFallbackDelayTimer = null, $fallbackSplitDelayTimer = null, $callCss = null)
    {
        $this
            ->setEnableFallbackForImeCalls($enableFallbackForImeCalls)
            ->setQosSensistivityLevel($qosSensistivityLevel)
            ->setDtmfCorrelationDigits($dtmfCorrelationDigits)
            ->setDtmfCollectionTimer($dtmfCollectionTimer)
            ->setCallAnswerTimer($callAnswerTimer)
            ->setClearImeCallDelayTimer($clearImeCallDelayTimer)
            ->setDtmfInterDigitDelayTimer($dtmfInterDigitDelayTimer)
            ->setPostConnectFallbackDelayTimer($postConnectFallbackDelayTimer)
            ->setFallbackSplitDelayTimer($fallbackSplitDelayTimer)
            ->setCallCss($callCss);
    }
    /**
     * Get enableFallbackForImeCalls value
     * @return string|null
     */
    public function getEnableFallbackForImeCalls()
    {
        return $this->enableFallbackForImeCalls;
    }
    /**
     * Set enableFallbackForImeCalls value
     * @param string $enableFallbackForImeCalls
     * @return \CUCM\StructType\RFallbackFeatureConfig
     */
    public function setEnableFallbackForImeCalls($enableFallbackForImeCalls = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableFallbackForImeCalls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableFallbackForImeCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableFallbackForImeCalls, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableFallbackForImeCalls) && !is_string($enableFallbackForImeCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableFallbackForImeCalls)), __LINE__);
        }
        $this->enableFallbackForImeCalls = $enableFallbackForImeCalls;
        return $this;
    }
    /**
     * Get qosSensistivityLevel value
     * @return string|null
     */
    public function getQosSensistivityLevel()
    {
        return $this->qosSensistivityLevel;
    }
    /**
     * Set qosSensistivityLevel value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $qosSensistivityLevel
     * @return \CUCM\StructType\RFallbackFeatureConfig
     */
    public function setQosSensistivityLevel($qosSensistivityLevel = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($qosSensistivityLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $qosSensistivityLevel, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->qosSensistivityLevel = $qosSensistivityLevel;
        return $this;
    }
    /**
     * Get dtmfCorrelationDigits value
     * @return string|null
     */
    public function getDtmfCorrelationDigits()
    {
        return $this->dtmfCorrelationDigits;
    }
    /**
     * Set dtmfCorrelationDigits value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dtmfCorrelationDigits
     * @return \CUCM\StructType\RFallbackFeatureConfig
     */
    public function setDtmfCorrelationDigits($dtmfCorrelationDigits = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($dtmfCorrelationDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dtmfCorrelationDigits, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dtmfCorrelationDigits = $dtmfCorrelationDigits;
        return $this;
    }
    /**
     * Get dtmfCollectionTimer value
     * @return string|null
     */
    public function getDtmfCollectionTimer()
    {
        return $this->dtmfCollectionTimer;
    }
    /**
     * Set dtmfCollectionTimer value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dtmfCollectionTimer
     * @return \CUCM\StructType\RFallbackFeatureConfig
     */
    public function setDtmfCollectionTimer($dtmfCollectionTimer = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($dtmfCollectionTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dtmfCollectionTimer, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dtmfCollectionTimer = $dtmfCollectionTimer;
        return $this;
    }
    /**
     * Get callAnswerTimer value
     * @return string|null
     */
    public function getCallAnswerTimer()
    {
        return $this->callAnswerTimer;
    }
    /**
     * Set callAnswerTimer value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callAnswerTimer
     * @return \CUCM\StructType\RFallbackFeatureConfig
     */
    public function setCallAnswerTimer($callAnswerTimer = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($callAnswerTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callAnswerTimer, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->callAnswerTimer = $callAnswerTimer;
        return $this;
    }
    /**
     * Get clearImeCallDelayTimer value
     * @return string|null
     */
    public function getClearImeCallDelayTimer()
    {
        return $this->clearImeCallDelayTimer;
    }
    /**
     * Set clearImeCallDelayTimer value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clearImeCallDelayTimer
     * @return \CUCM\StructType\RFallbackFeatureConfig
     */
    public function setClearImeCallDelayTimer($clearImeCallDelayTimer = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($clearImeCallDelayTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $clearImeCallDelayTimer, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->clearImeCallDelayTimer = $clearImeCallDelayTimer;
        return $this;
    }
    /**
     * Get dtmfInterDigitDelayTimer value
     * @return string|null
     */
    public function getDtmfInterDigitDelayTimer()
    {
        return $this->dtmfInterDigitDelayTimer;
    }
    /**
     * Set dtmfInterDigitDelayTimer value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dtmfInterDigitDelayTimer
     * @return \CUCM\StructType\RFallbackFeatureConfig
     */
    public function setDtmfInterDigitDelayTimer($dtmfInterDigitDelayTimer = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($dtmfInterDigitDelayTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dtmfInterDigitDelayTimer, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dtmfInterDigitDelayTimer = $dtmfInterDigitDelayTimer;
        return $this;
    }
    /**
     * Get postConnectFallbackDelayTimer value
     * @return string|null
     */
    public function getPostConnectFallbackDelayTimer()
    {
        return $this->postConnectFallbackDelayTimer;
    }
    /**
     * Set postConnectFallbackDelayTimer value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $postConnectFallbackDelayTimer
     * @return \CUCM\StructType\RFallbackFeatureConfig
     */
    public function setPostConnectFallbackDelayTimer($postConnectFallbackDelayTimer = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($postConnectFallbackDelayTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $postConnectFallbackDelayTimer, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->postConnectFallbackDelayTimer = $postConnectFallbackDelayTimer;
        return $this;
    }
    /**
     * Get fallbackSplitDelayTimer value
     * @return string|null
     */
    public function getFallbackSplitDelayTimer()
    {
        return $this->fallbackSplitDelayTimer;
    }
    /**
     * Set fallbackSplitDelayTimer value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fallbackSplitDelayTimer
     * @return \CUCM\StructType\RFallbackFeatureConfig
     */
    public function setFallbackSplitDelayTimer($fallbackSplitDelayTimer = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($fallbackSplitDelayTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $fallbackSplitDelayTimer, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->fallbackSplitDelayTimer = $fallbackSplitDelayTimer;
        return $this;
    }
    /**
     * Get callCss value
     * @return string|null
     */
    public function getCallCss()
    {
        return $this->callCss;
    }
    /**
     * Set callCss value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callCss
     * @return \CUCM\StructType\RFallbackFeatureConfig
     */
    public function setCallCss($callCss = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($callCss)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callCss, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->callCss = $callCss;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RFallbackFeatureConfig
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
