<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RDigitDiscardInstructionMember StructType
 * @subpackage Structs
 */
class RDigitDiscardInstructionMember extends AbstractStructBase
{
    /**
     * The dialPlanTagName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $dialPlanTagName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RDigitDiscardInstructionMember
     * @uses RDigitDiscardInstructionMember::setDialPlanTagName()
     * @uses RDigitDiscardInstructionMember::setUuid()
     * @param \CUCM\StructType\XFkType $dialPlanTagName
     * @param string $uuid
     */
    public function __construct(\CUCM\StructType\XFkType $dialPlanTagName = null, $uuid = null)
    {
        $this
            ->setDialPlanTagName($dialPlanTagName)
            ->setUuid($uuid);
    }
    /**
     * Get dialPlanTagName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getDialPlanTagName()
    {
        return $this->dialPlanTagName;
    }
    /**
     * Set dialPlanTagName value
     * @param \CUCM\StructType\XFkType $dialPlanTagName
     * @return \CUCM\StructType\RDigitDiscardInstructionMember
     */
    public function setDialPlanTagName(\CUCM\StructType\XFkType $dialPlanTagName = null)
    {
        $this->dialPlanTagName = $dialPlanTagName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RDigitDiscardInstructionMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RDigitDiscardInstructionMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
