<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCallingPartyTransformationPattern StructType
 * @subpackage Structs
 */
class RCallingPartyTransformationPattern extends AbstractStructBase
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pattern;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The usage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The callingPartyTransformationMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyTransformationMask;
    /**
     * The useCallingPartyPhoneMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useCallingPartyPhoneMask;
    /**
     * The dialPlanName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $dialPlanName;
    /**
     * The digitDiscardInstructionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $digitDiscardInstructionName;
    /**
     * The patternUrgency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $patternUrgency;
    /**
     * The callingPartyPrefixDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $callingPartyPrefixDigits;
    /**
     * The routeFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $routeFilterName;
    /**
     * The callingLinePresentationBit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingLinePresentationBit;
    /**
     * The callingPartyNumberingPlan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNumberingPlan;
    /**
     * The callingPartyNumberType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNumberType;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RCallingPartyTransformationPattern
     * @uses RCallingPartyTransformationPattern::setPattern()
     * @uses RCallingPartyTransformationPattern::setDescription()
     * @uses RCallingPartyTransformationPattern::setUsage()
     * @uses RCallingPartyTransformationPattern::setRoutePartitionName()
     * @uses RCallingPartyTransformationPattern::setCallingPartyTransformationMask()
     * @uses RCallingPartyTransformationPattern::setUseCallingPartyPhoneMask()
     * @uses RCallingPartyTransformationPattern::setDialPlanName()
     * @uses RCallingPartyTransformationPattern::setDigitDiscardInstructionName()
     * @uses RCallingPartyTransformationPattern::setPatternUrgency()
     * @uses RCallingPartyTransformationPattern::setCallingPartyPrefixDigits()
     * @uses RCallingPartyTransformationPattern::setRouteFilterName()
     * @uses RCallingPartyTransformationPattern::setCallingLinePresentationBit()
     * @uses RCallingPartyTransformationPattern::setCallingPartyNumberingPlan()
     * @uses RCallingPartyTransformationPattern::setCallingPartyNumberType()
     * @uses RCallingPartyTransformationPattern::setUuid()
     * @param string $pattern
     * @param string $description
     * @param string $usage
     * @param \CUCM\StructType\XFkType $routePartitionName
     * @param string $callingPartyTransformationMask
     * @param string $useCallingPartyPhoneMask
     * @param \CUCM\StructType\XFkType $dialPlanName
     * @param \CUCM\StructType\XFkType $digitDiscardInstructionName
     * @param string $patternUrgency
     * @param string $callingPartyPrefixDigits
     * @param \CUCM\StructType\XFkType $routeFilterName
     * @param string $callingLinePresentationBit
     * @param string $callingPartyNumberingPlan
     * @param string $callingPartyNumberType
     * @param string $uuid
     */
    public function __construct($pattern = null, $description = null, $usage = null, \CUCM\StructType\XFkType $routePartitionName = null, $callingPartyTransformationMask = null, $useCallingPartyPhoneMask = null, \CUCM\StructType\XFkType $dialPlanName = null, \CUCM\StructType\XFkType $digitDiscardInstructionName = null, $patternUrgency = null, $callingPartyPrefixDigits = null, \CUCM\StructType\XFkType $routeFilterName = null, $callingLinePresentationBit = null, $callingPartyNumberingPlan = null, $callingPartyNumberType = null, $uuid = null)
    {
        $this
            ->setPattern($pattern)
            ->setDescription($description)
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setCallingPartyTransformationMask($callingPartyTransformationMask)
            ->setUseCallingPartyPhoneMask($useCallingPartyPhoneMask)
            ->setDialPlanName($dialPlanName)
            ->setDigitDiscardInstructionName($digitDiscardInstructionName)
            ->setPatternUrgency($patternUrgency)
            ->setCallingPartyPrefixDigits($callingPartyPrefixDigits)
            ->setRouteFilterName($routeFilterName)
            ->setCallingLinePresentationBit($callingLinePresentationBit)
            ->setCallingPartyNumberingPlan($callingPartyNumberingPlan)
            ->setCallingPartyNumberType($callingPartyNumberType)
            ->setUuid($uuid);
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \CUCM\StructType\RCallingPartyTransformationPattern
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\RCallingPartyTransformationPattern
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get usage value
     * @return string|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @uses \CUCM\EnumType\XPatternUsage::valueIsValid()
     * @uses \CUCM\EnumType\XPatternUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usage
     * @return \CUCM\StructType\RCallingPartyTransformationPattern
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPatternUsage::valueIsValid($usage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $usage, implode(', ', \CUCM\EnumType\XPatternUsage::getValidValues())), __LINE__);
        }
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \CUCM\StructType\XFkType $routePartitionName
     * @return \CUCM\StructType\RCallingPartyTransformationPattern
     */
    public function setRoutePartitionName(\CUCM\StructType\XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get callingPartyTransformationMask value
     * @return string|null
     */
    public function getCallingPartyTransformationMask()
    {
        return $this->callingPartyTransformationMask;
    }
    /**
     * Set callingPartyTransformationMask value
     * @param string $callingPartyTransformationMask
     * @return \CUCM\StructType\RCallingPartyTransformationPattern
     */
    public function setCallingPartyTransformationMask($callingPartyTransformationMask = null)
    {
        // validation for constraint: string
        if (!is_null($callingPartyTransformationMask) && !is_string($callingPartyTransformationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingPartyTransformationMask)), __LINE__);
        }
        $this->callingPartyTransformationMask = $callingPartyTransformationMask;
        return $this;
    }
    /**
     * Get useCallingPartyPhoneMask value
     * @return string|null
     */
    public function getUseCallingPartyPhoneMask()
    {
        return $this->useCallingPartyPhoneMask;
    }
    /**
     * Set useCallingPartyPhoneMask value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useCallingPartyPhoneMask
     * @return \CUCM\StructType\RCallingPartyTransformationPattern
     */
    public function setUseCallingPartyPhoneMask($useCallingPartyPhoneMask = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($useCallingPartyPhoneMask)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useCallingPartyPhoneMask, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useCallingPartyPhoneMask = $useCallingPartyPhoneMask;
        return $this;
    }
    /**
     * Get dialPlanName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getDialPlanName()
    {
        return $this->dialPlanName;
    }
    /**
     * Set dialPlanName value
     * @param \CUCM\StructType\XFkType $dialPlanName
     * @return \CUCM\StructType\RCallingPartyTransformationPattern
     */
    public function setDialPlanName(\CUCM\StructType\XFkType $dialPlanName = null)
    {
        $this->dialPlanName = $dialPlanName;
        return $this;
    }
    /**
     * Get digitDiscardInstructionName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getDigitDiscardInstructionName()
    {
        return $this->digitDiscardInstructionName;
    }
    /**
     * Set digitDiscardInstructionName value
     * @param \CUCM\StructType\XFkType $digitDiscardInstructionName
     * @return \CUCM\StructType\RCallingPartyTransformationPattern
     */
    public function setDigitDiscardInstructionName(\CUCM\StructType\XFkType $digitDiscardInstructionName = null)
    {
        $this->digitDiscardInstructionName = $digitDiscardInstructionName;
        return $this;
    }
    /**
     * Get patternUrgency value
     * @return string|null
     */
    public function getPatternUrgency()
    {
        return $this->patternUrgency;
    }
    /**
     * Set patternUrgency value
     * @param string $patternUrgency
     * @return \CUCM\StructType\RCallingPartyTransformationPattern
     */
    public function setPatternUrgency($patternUrgency = null)
    {
        // validation for constraint: pattern
        if (is_scalar($patternUrgency) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $patternUrgency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($patternUrgency, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($patternUrgency) && !is_string($patternUrgency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($patternUrgency)), __LINE__);
        }
        $this->patternUrgency = $patternUrgency;
        return $this;
    }
    /**
     * Get callingPartyPrefixDigits value
     * @return string|null
     */
    public function getCallingPartyPrefixDigits()
    {
        return $this->callingPartyPrefixDigits;
    }
    /**
     * Set callingPartyPrefixDigits value
     * @param string $callingPartyPrefixDigits
     * @return \CUCM\StructType\RCallingPartyTransformationPattern
     */
    public function setCallingPartyPrefixDigits($callingPartyPrefixDigits = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callingPartyPrefixDigits) && strlen($callingPartyPrefixDigits) > 50) || (is_array($callingPartyPrefixDigits) && count($callingPartyPrefixDigits) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($callingPartyPrefixDigits) ? strlen($callingPartyPrefixDigits) : count($callingPartyPrefixDigits)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callingPartyPrefixDigits) && !is_string($callingPartyPrefixDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingPartyPrefixDigits)), __LINE__);
        }
        $this->callingPartyPrefixDigits = $callingPartyPrefixDigits;
        return $this;
    }
    /**
     * Get routeFilterName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getRouteFilterName()
    {
        return $this->routeFilterName;
    }
    /**
     * Set routeFilterName value
     * @param \CUCM\StructType\XFkType $routeFilterName
     * @return \CUCM\StructType\RCallingPartyTransformationPattern
     */
    public function setRouteFilterName(\CUCM\StructType\XFkType $routeFilterName = null)
    {
        $this->routeFilterName = $routeFilterName;
        return $this;
    }
    /**
     * Get callingLinePresentationBit value
     * @return string|null
     */
    public function getCallingLinePresentationBit()
    {
        return $this->callingLinePresentationBit;
    }
    /**
     * Set callingLinePresentationBit value
     * @uses \CUCM\EnumType\XPresentationBit::valueIsValid()
     * @uses \CUCM\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingLinePresentationBit
     * @return \CUCM\StructType\RCallingPartyTransformationPattern
     */
    public function setCallingLinePresentationBit($callingLinePresentationBit = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPresentationBit::valueIsValid($callingLinePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingLinePresentationBit, implode(', ', \CUCM\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingLinePresentationBit = $callingLinePresentationBit;
        return $this;
    }
    /**
     * Get callingPartyNumberingPlan value
     * @return string|null
     */
    public function getCallingPartyNumberingPlan()
    {
        return $this->callingPartyNumberingPlan;
    }
    /**
     * Set callingPartyNumberingPlan value
     * @uses \CUCM\EnumType\XNumberingPlan::valueIsValid()
     * @uses \CUCM\EnumType\XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNumberingPlan
     * @return \CUCM\StructType\RCallingPartyTransformationPattern
     */
    public function setCallingPartyNumberingPlan($callingPartyNumberingPlan = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XNumberingPlan::valueIsValid($callingPartyNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartyNumberingPlan, implode(', ', \CUCM\EnumType\XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->callingPartyNumberingPlan = $callingPartyNumberingPlan;
        return $this;
    }
    /**
     * Get callingPartyNumberType value
     * @return string|null
     */
    public function getCallingPartyNumberType()
    {
        return $this->callingPartyNumberType;
    }
    /**
     * Set callingPartyNumberType value
     * @uses \CUCM\EnumType\XPriOfNumber::valueIsValid()
     * @uses \CUCM\EnumType\XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNumberType
     * @return \CUCM\StructType\RCallingPartyTransformationPattern
     */
    public function setCallingPartyNumberType($callingPartyNumberType = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPriOfNumber::valueIsValid($callingPartyNumberType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartyNumberType, implode(', ', \CUCM\EnumType\XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->callingPartyNumberType = $callingPartyNumberType;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RCallingPartyTransformationPattern
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RCallingPartyTransformationPattern
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
