<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCallerFilterList StructType
 * @subpackage Structs
 */
class RCallerFilterList extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The isAllowedType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isAllowedType;
    /**
     * The endUserIdName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $endUserIdName;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Members
     */
    public $members;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RCallerFilterList
     * @uses RCallerFilterList::setName()
     * @uses RCallerFilterList::setDescription()
     * @uses RCallerFilterList::setIsAllowedType()
     * @uses RCallerFilterList::setEndUserIdName()
     * @uses RCallerFilterList::setMembers()
     * @uses RCallerFilterList::setUuid()
     * @param string $name
     * @param string $description
     * @param string $isAllowedType
     * @param \CUCM\StructType\XFkType $endUserIdName
     * @param \CUCM\StructType\Members $members
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $isAllowedType = null, \CUCM\StructType\XFkType $endUserIdName = null, \CUCM\StructType\Members $members = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setIsAllowedType($isAllowedType)
            ->setEndUserIdName($endUserIdName)
            ->setMembers($members)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\RCallerFilterList
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\RCallerFilterList
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isAllowedType value
     * @return string|null
     */
    public function getIsAllowedType()
    {
        return $this->isAllowedType;
    }
    /**
     * Set isAllowedType value
     * @param string $isAllowedType
     * @return \CUCM\StructType\RCallerFilterList
     */
    public function setIsAllowedType($isAllowedType = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isAllowedType) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isAllowedType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isAllowedType, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isAllowedType) && !is_string($isAllowedType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isAllowedType)), __LINE__);
        }
        $this->isAllowedType = $isAllowedType;
        return $this;
    }
    /**
     * Get endUserIdName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getEndUserIdName()
    {
        return $this->endUserIdName;
    }
    /**
     * Set endUserIdName value
     * @param \CUCM\StructType\XFkType $endUserIdName
     * @return \CUCM\StructType\RCallerFilterList
     */
    public function setEndUserIdName(\CUCM\StructType\XFkType $endUserIdName = null)
    {
        $this->endUserIdName = $endUserIdName;
        return $this;
    }
    /**
     * Get members value
     * @return \CUCM\StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \CUCM\StructType\Members $members
     * @return \CUCM\StructType\RCallerFilterList
     */
    public function setMembers(\CUCM\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RCallerFilterList
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RCallerFilterList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
