<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCallManagerGroup StructType
 * @subpackage Structs
 */
class RCallManagerGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The tftpDefault
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $tftpDefault;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Members
     */
    public $members;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RCallManagerGroup
     * @uses RCallManagerGroup::setName()
     * @uses RCallManagerGroup::setTftpDefault()
     * @uses RCallManagerGroup::setMembers()
     * @uses RCallManagerGroup::setUuid()
     * @param string $name
     * @param string $tftpDefault
     * @param \CUCM\StructType\Members $members
     * @param string $uuid
     */
    public function __construct($name = null, $tftpDefault = null, \CUCM\StructType\Members $members = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setTftpDefault($tftpDefault)
            ->setMembers($members)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\RCallManagerGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get tftpDefault value
     * @return string|null
     */
    public function getTftpDefault()
    {
        return $this->tftpDefault;
    }
    /**
     * Set tftpDefault value
     * @param string $tftpDefault
     * @return \CUCM\StructType\RCallManagerGroup
     */
    public function setTftpDefault($tftpDefault = null)
    {
        // validation for constraint: pattern
        if (is_scalar($tftpDefault) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $tftpDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($tftpDefault, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tftpDefault) && !is_string($tftpDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tftpDefault)), __LINE__);
        }
        $this->tftpDefault = $tftpDefault;
        return $this;
    }
    /**
     * Get members value
     * @return \CUCM\StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \CUCM\StructType\Members $members
     * @return \CUCM\StructType\RCallManagerGroup
     */
    public function setMembers(\CUCM\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RCallManagerGroup
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RCallManagerGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
