<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCallManager StructType
 * @subpackage Structs
 */
class RCallManager extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $description;
    /**
     * The autoRegistration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\AutoRegistration
     */
    public $autoRegistration;
    /**
     * The ports
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Ports
     */
    public $ports;
    /**
     * The processNodeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $processNodeName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * Constructor method for RCallManager
     * @uses RCallManager::setName()
     * @uses RCallManager::setDescription()
     * @uses RCallManager::setAutoRegistration()
     * @uses RCallManager::setPorts()
     * @uses RCallManager::setProcessNodeName()
     * @uses RCallManager::setUuid()
     * @uses RCallManager::setCtiid()
     * @param string $name
     * @param string $description
     * @param \CUCM\StructType\AutoRegistration $autoRegistration
     * @param \CUCM\StructType\Ports $ports
     * @param \CUCM\StructType\XFkType $processNodeName
     * @param string $uuid
     * @param int $ctiid
     */
    public function __construct($name = null, $description = null, \CUCM\StructType\AutoRegistration $autoRegistration = null, \CUCM\StructType\Ports $ports = null, \CUCM\StructType\XFkType $processNodeName = null, $uuid = null, $ctiid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setAutoRegistration($autoRegistration)
            ->setPorts($ports)
            ->setProcessNodeName($processNodeName)
            ->setUuid($uuid)
            ->setCtiid($ctiid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\RCallManager
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\RCallManager
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 50) || (is_array($description) && count($description) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get autoRegistration value
     * @return \CUCM\StructType\AutoRegistration|null
     */
    public function getAutoRegistration()
    {
        return $this->autoRegistration;
    }
    /**
     * Set autoRegistration value
     * @param \CUCM\StructType\AutoRegistration $autoRegistration
     * @return \CUCM\StructType\RCallManager
     */
    public function setAutoRegistration(\CUCM\StructType\AutoRegistration $autoRegistration = null)
    {
        $this->autoRegistration = $autoRegistration;
        return $this;
    }
    /**
     * Get ports value
     * @return \CUCM\StructType\Ports|null
     */
    public function getPorts()
    {
        return $this->ports;
    }
    /**
     * Set ports value
     * @param \CUCM\StructType\Ports $ports
     * @return \CUCM\StructType\RCallManager
     */
    public function setPorts(\CUCM\StructType\Ports $ports = null)
    {
        $this->ports = $ports;
        return $this;
    }
    /**
     * Get processNodeName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getProcessNodeName()
    {
        return $this->processNodeName;
    }
    /**
     * Set processNodeName value
     * @param \CUCM\StructType\XFkType $processNodeName
     * @return \CUCM\StructType\RCallManager
     */
    public function setProcessNodeName(\CUCM\StructType\XFkType $processNodeName = null)
    {
        $this->processNodeName = $processNodeName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RCallManager
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \CUCM\StructType\RCallManager
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RCallManager
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
