<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RApplicationServer StructType
 * @subpackage Structs
 */
class RApplicationServer extends AbstractStructBase
{
    /**
     * The appServerType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $appServerType;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The ipAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ipAddress;
    /**
     * The appUsers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\AppUsers
     */
    public $appUsers;
    /**
     * The url
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $url;
    /**
     * The endUserUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $endUserUrl;
    /**
     * The processNodeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $processNodeName;
    /**
     * The endUsers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\EndUsers
     */
    public $endUsers;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RApplicationServer
     * @uses RApplicationServer::setAppServerType()
     * @uses RApplicationServer::setName()
     * @uses RApplicationServer::setIpAddress()
     * @uses RApplicationServer::setAppUsers()
     * @uses RApplicationServer::setUrl()
     * @uses RApplicationServer::setEndUserUrl()
     * @uses RApplicationServer::setProcessNodeName()
     * @uses RApplicationServer::setEndUsers()
     * @uses RApplicationServer::setUuid()
     * @param string $appServerType
     * @param string $name
     * @param string $ipAddress
     * @param \CUCM\StructType\AppUsers $appUsers
     * @param string $url
     * @param string $endUserUrl
     * @param \CUCM\StructType\XFkType $processNodeName
     * @param \CUCM\StructType\EndUsers $endUsers
     * @param string $uuid
     */
    public function __construct($appServerType = null, $name = null, $ipAddress = null, \CUCM\StructType\AppUsers $appUsers = null, $url = null, $endUserUrl = null, \CUCM\StructType\XFkType $processNodeName = null, \CUCM\StructType\EndUsers $endUsers = null, $uuid = null)
    {
        $this
            ->setAppServerType($appServerType)
            ->setName($name)
            ->setIpAddress($ipAddress)
            ->setAppUsers($appUsers)
            ->setUrl($url)
            ->setEndUserUrl($endUserUrl)
            ->setProcessNodeName($processNodeName)
            ->setEndUsers($endUsers)
            ->setUuid($uuid);
    }
    /**
     * Get appServerType value
     * @return string|null
     */
    public function getAppServerType()
    {
        return $this->appServerType;
    }
    /**
     * Set appServerType value
     * @uses \CUCM\EnumType\XAppServer::valueIsValid()
     * @uses \CUCM\EnumType\XAppServer::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $appServerType
     * @return \CUCM\StructType\RApplicationServer
     */
    public function setAppServerType($appServerType = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XAppServer::valueIsValid($appServerType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $appServerType, implode(', ', \CUCM\EnumType\XAppServer::getValidValues())), __LINE__);
        }
        $this->appServerType = $appServerType;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\RApplicationServer
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \CUCM\StructType\RApplicationServer
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get appUsers value
     * @return \CUCM\StructType\AppUsers|null
     */
    public function getAppUsers()
    {
        return $this->appUsers;
    }
    /**
     * Set appUsers value
     * @param \CUCM\StructType\AppUsers $appUsers
     * @return \CUCM\StructType\RApplicationServer
     */
    public function setAppUsers(\CUCM\StructType\AppUsers $appUsers = null)
    {
        $this->appUsers = $appUsers;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \CUCM\StructType\RApplicationServer
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get endUserUrl value
     * @return string|null
     */
    public function getEndUserUrl()
    {
        return $this->endUserUrl;
    }
    /**
     * Set endUserUrl value
     * @param string $endUserUrl
     * @return \CUCM\StructType\RApplicationServer
     */
    public function setEndUserUrl($endUserUrl = null)
    {
        // validation for constraint: string
        if (!is_null($endUserUrl) && !is_string($endUserUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endUserUrl)), __LINE__);
        }
        $this->endUserUrl = $endUserUrl;
        return $this;
    }
    /**
     * Get processNodeName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getProcessNodeName()
    {
        return $this->processNodeName;
    }
    /**
     * Set processNodeName value
     * @param \CUCM\StructType\XFkType $processNodeName
     * @return \CUCM\StructType\RApplicationServer
     */
    public function setProcessNodeName(\CUCM\StructType\XFkType $processNodeName = null)
    {
        $this->processNodeName = $processNodeName;
        return $this;
    }
    /**
     * Get endUsers value
     * @return \CUCM\StructType\EndUsers|null
     */
    public function getEndUsers()
    {
        return $this->endUsers;
    }
    /**
     * Set endUsers value
     * @param \CUCM\StructType\EndUsers $endUsers
     * @return \CUCM\StructType\RApplicationServer
     */
    public function setEndUsers(\CUCM\StructType\EndUsers $endUsers = null)
    {
        $this->endUsers = $endUsers;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RApplicationServer
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RApplicationServer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
