<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LVoiceMailPilot StructType
 * @subpackage Structs
 */
class LVoiceMailPilot extends AbstractStructBase
{
    /**
     * The dirn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $dirn;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $description;
    /**
     * The cssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $cssName;
    /**
     * The isDefault
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isDefault;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LVoiceMailPilot
     * @uses LVoiceMailPilot::setDirn()
     * @uses LVoiceMailPilot::setDescription()
     * @uses LVoiceMailPilot::setCssName()
     * @uses LVoiceMailPilot::setIsDefault()
     * @uses LVoiceMailPilot::setUuid()
     * @param string $dirn
     * @param string $description
     * @param \CUCM\StructType\XFkType $cssName
     * @param string $isDefault
     * @param string $uuid
     */
    public function __construct($dirn = null, $description = null, \CUCM\StructType\XFkType $cssName = null, $isDefault = null, $uuid = null)
    {
        $this
            ->setDirn($dirn)
            ->setDescription($description)
            ->setCssName($cssName)
            ->setIsDefault($isDefault)
            ->setUuid($uuid);
    }
    /**
     * Get dirn value
     * @return string|null
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param string $dirn
     * @return \CUCM\StructType\LVoiceMailPilot
     */
    public function setDirn($dirn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($dirn) && strlen($dirn) > 255) || (is_array($dirn) && count($dirn) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($dirn) ? strlen($dirn) : count($dirn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dirn) && !is_string($dirn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dirn)), __LINE__);
        }
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\LVoiceMailPilot
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 50) || (is_array($description) && count($description) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get cssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCssName()
    {
        return $this->cssName;
    }
    /**
     * Set cssName value
     * @param \CUCM\StructType\XFkType $cssName
     * @return \CUCM\StructType\LVoiceMailPilot
     */
    public function setCssName(\CUCM\StructType\XFkType $cssName = null)
    {
        $this->cssName = $cssName;
        return $this;
    }
    /**
     * Get isDefault value
     * @return string|null
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }
    /**
     * Set isDefault value
     * @param string $isDefault
     * @return \CUCM\StructType\LVoiceMailPilot
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isDefault) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isDefault, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isDefault) && !is_string($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isDefault)), __LINE__);
        }
        $this->isDefault = $isDefault;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\LVoiceMailPilot
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LVoiceMailPilot
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
