<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LVmPilot StructType
 * @subpackage Structs
 */
class LVmPilot extends AbstractStructBase
{
    /**
     * The dirn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $dirn;
    /**
     * The cssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $cssName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LVmPilot
     * @uses LVmPilot::setDirn()
     * @uses LVmPilot::setCssName()
     * @uses LVmPilot::setUuid()
     * @param string $dirn
     * @param \CUCM\StructType\XFkType $cssName
     * @param string $uuid
     */
    public function __construct($dirn = null, \CUCM\StructType\XFkType $cssName = null, $uuid = null)
    {
        $this
            ->setDirn($dirn)
            ->setCssName($cssName)
            ->setUuid($uuid);
    }
    /**
     * Get dirn value
     * @return string|null
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param string $dirn
     * @return \CUCM\StructType\LVmPilot
     */
    public function setDirn($dirn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($dirn) && strlen($dirn) > 50) || (is_array($dirn) && count($dirn) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($dirn) ? strlen($dirn) : count($dirn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dirn) && !is_string($dirn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dirn)), __LINE__);
        }
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get cssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCssName()
    {
        return $this->cssName;
    }
    /**
     * Set cssName value
     * @param \CUCM\StructType\XFkType $cssName
     * @return \CUCM\StructType\LVmPilot
     */
    public function setCssName(\CUCM\StructType\XFkType $cssName = null)
    {
        $this->cssName = $cssName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\LVmPilot
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LVmPilot
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
