<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LTransformationProfile StructType
 * @subpackage Structs
 */
class LTransformationProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The nationalStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nationalStripDigits;
    /**
     * The internationalStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $internationalStripDigits;
    /**
     * The unknownStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $unknownStripDigits;
    /**
     * The subscriberStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subscriberStripDigits;
    /**
     * The nationalPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $nationalPrefix;
    /**
     * The internationalPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $internationalPrefix;
    /**
     * The unknownPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $unknownPrefix;
    /**
     * The subscriberPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $subscriberPrefix;
    /**
     * The nationalCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $nationalCssName;
    /**
     * The internationalCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $internationalCssName;
    /**
     * The unknownCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $unknownCssName;
    /**
     * The subscriberCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $subscriberCssName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LTransformationProfile
     * @uses LTransformationProfile::setName()
     * @uses LTransformationProfile::setDescription()
     * @uses LTransformationProfile::setNationalStripDigits()
     * @uses LTransformationProfile::setInternationalStripDigits()
     * @uses LTransformationProfile::setUnknownStripDigits()
     * @uses LTransformationProfile::setSubscriberStripDigits()
     * @uses LTransformationProfile::setNationalPrefix()
     * @uses LTransformationProfile::setInternationalPrefix()
     * @uses LTransformationProfile::setUnknownPrefix()
     * @uses LTransformationProfile::setSubscriberPrefix()
     * @uses LTransformationProfile::setNationalCssName()
     * @uses LTransformationProfile::setInternationalCssName()
     * @uses LTransformationProfile::setUnknownCssName()
     * @uses LTransformationProfile::setSubscriberCssName()
     * @uses LTransformationProfile::setUuid()
     * @param string $name
     * @param string $description
     * @param string $nationalStripDigits
     * @param string $internationalStripDigits
     * @param string $unknownStripDigits
     * @param string $subscriberStripDigits
     * @param string $nationalPrefix
     * @param string $internationalPrefix
     * @param string $unknownPrefix
     * @param string $subscriberPrefix
     * @param \CUCM\StructType\XFkType $nationalCssName
     * @param \CUCM\StructType\XFkType $internationalCssName
     * @param \CUCM\StructType\XFkType $unknownCssName
     * @param \CUCM\StructType\XFkType $subscriberCssName
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $nationalStripDigits = null, $internationalStripDigits = null, $unknownStripDigits = null, $subscriberStripDigits = null, $nationalPrefix = null, $internationalPrefix = null, $unknownPrefix = null, $subscriberPrefix = null, \CUCM\StructType\XFkType $nationalCssName = null, \CUCM\StructType\XFkType $internationalCssName = null, \CUCM\StructType\XFkType $unknownCssName = null, \CUCM\StructType\XFkType $subscriberCssName = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setNationalStripDigits($nationalStripDigits)
            ->setInternationalStripDigits($internationalStripDigits)
            ->setUnknownStripDigits($unknownStripDigits)
            ->setSubscriberStripDigits($subscriberStripDigits)
            ->setNationalPrefix($nationalPrefix)
            ->setInternationalPrefix($internationalPrefix)
            ->setUnknownPrefix($unknownPrefix)
            ->setSubscriberPrefix($subscriberPrefix)
            ->setNationalCssName($nationalCssName)
            ->setInternationalCssName($internationalCssName)
            ->setUnknownCssName($unknownCssName)
            ->setSubscriberCssName($subscriberCssName)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\LTransformationProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\LTransformationProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get nationalStripDigits value
     * @return string|null
     */
    public function getNationalStripDigits()
    {
        return $this->nationalStripDigits;
    }
    /**
     * Set nationalStripDigits value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nationalStripDigits
     * @return \CUCM\StructType\LTransformationProfile
     */
    public function setNationalStripDigits($nationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($nationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $nationalStripDigits, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->nationalStripDigits = $nationalStripDigits;
        return $this;
    }
    /**
     * Get internationalStripDigits value
     * @return string|null
     */
    public function getInternationalStripDigits()
    {
        return $this->internationalStripDigits;
    }
    /**
     * Set internationalStripDigits value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $internationalStripDigits
     * @return \CUCM\StructType\LTransformationProfile
     */
    public function setInternationalStripDigits($internationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($internationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $internationalStripDigits, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->internationalStripDigits = $internationalStripDigits;
        return $this;
    }
    /**
     * Get unknownStripDigits value
     * @return string|null
     */
    public function getUnknownStripDigits()
    {
        return $this->unknownStripDigits;
    }
    /**
     * Set unknownStripDigits value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unknownStripDigits
     * @return \CUCM\StructType\LTransformationProfile
     */
    public function setUnknownStripDigits($unknownStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($unknownStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $unknownStripDigits, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->unknownStripDigits = $unknownStripDigits;
        return $this;
    }
    /**
     * Get subscriberStripDigits value
     * @return string|null
     */
    public function getSubscriberStripDigits()
    {
        return $this->subscriberStripDigits;
    }
    /**
     * Set subscriberStripDigits value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriberStripDigits
     * @return \CUCM\StructType\LTransformationProfile
     */
    public function setSubscriberStripDigits($subscriberStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($subscriberStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $subscriberStripDigits, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->subscriberStripDigits = $subscriberStripDigits;
        return $this;
    }
    /**
     * Get nationalPrefix value
     * @return string|null
     */
    public function getNationalPrefix()
    {
        return $this->nationalPrefix;
    }
    /**
     * Set nationalPrefix value
     * @param string $nationalPrefix
     * @return \CUCM\StructType\LTransformationProfile
     */
    public function setNationalPrefix($nationalPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nationalPrefix) && strlen($nationalPrefix) > 16) || (is_array($nationalPrefix) && count($nationalPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($nationalPrefix) ? strlen($nationalPrefix) : count($nationalPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nationalPrefix) && !is_string($nationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nationalPrefix)), __LINE__);
        }
        $this->nationalPrefix = $nationalPrefix;
        return $this;
    }
    /**
     * Get internationalPrefix value
     * @return string|null
     */
    public function getInternationalPrefix()
    {
        return $this->internationalPrefix;
    }
    /**
     * Set internationalPrefix value
     * @param string $internationalPrefix
     * @return \CUCM\StructType\LTransformationProfile
     */
    public function setInternationalPrefix($internationalPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($internationalPrefix) && strlen($internationalPrefix) > 16) || (is_array($internationalPrefix) && count($internationalPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($internationalPrefix) ? strlen($internationalPrefix) : count($internationalPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($internationalPrefix) && !is_string($internationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($internationalPrefix)), __LINE__);
        }
        $this->internationalPrefix = $internationalPrefix;
        return $this;
    }
    /**
     * Get unknownPrefix value
     * @return string|null
     */
    public function getUnknownPrefix()
    {
        return $this->unknownPrefix;
    }
    /**
     * Set unknownPrefix value
     * @param string $unknownPrefix
     * @return \CUCM\StructType\LTransformationProfile
     */
    public function setUnknownPrefix($unknownPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($unknownPrefix) && strlen($unknownPrefix) > 16) || (is_array($unknownPrefix) && count($unknownPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($unknownPrefix) ? strlen($unknownPrefix) : count($unknownPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unknownPrefix) && !is_string($unknownPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unknownPrefix)), __LINE__);
        }
        $this->unknownPrefix = $unknownPrefix;
        return $this;
    }
    /**
     * Get subscriberPrefix value
     * @return string|null
     */
    public function getSubscriberPrefix()
    {
        return $this->subscriberPrefix;
    }
    /**
     * Set subscriberPrefix value
     * @param string $subscriberPrefix
     * @return \CUCM\StructType\LTransformationProfile
     */
    public function setSubscriberPrefix($subscriberPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($subscriberPrefix) && strlen($subscriberPrefix) > 16) || (is_array($subscriberPrefix) && count($subscriberPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($subscriberPrefix) ? strlen($subscriberPrefix) : count($subscriberPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($subscriberPrefix) && !is_string($subscriberPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriberPrefix)), __LINE__);
        }
        $this->subscriberPrefix = $subscriberPrefix;
        return $this;
    }
    /**
     * Get nationalCssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getNationalCssName()
    {
        return $this->nationalCssName;
    }
    /**
     * Set nationalCssName value
     * @param \CUCM\StructType\XFkType $nationalCssName
     * @return \CUCM\StructType\LTransformationProfile
     */
    public function setNationalCssName(\CUCM\StructType\XFkType $nationalCssName = null)
    {
        $this->nationalCssName = $nationalCssName;
        return $this;
    }
    /**
     * Get internationalCssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getInternationalCssName()
    {
        return $this->internationalCssName;
    }
    /**
     * Set internationalCssName value
     * @param \CUCM\StructType\XFkType $internationalCssName
     * @return \CUCM\StructType\LTransformationProfile
     */
    public function setInternationalCssName(\CUCM\StructType\XFkType $internationalCssName = null)
    {
        $this->internationalCssName = $internationalCssName;
        return $this;
    }
    /**
     * Get unknownCssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getUnknownCssName()
    {
        return $this->unknownCssName;
    }
    /**
     * Set unknownCssName value
     * @param \CUCM\StructType\XFkType $unknownCssName
     * @return \CUCM\StructType\LTransformationProfile
     */
    public function setUnknownCssName(\CUCM\StructType\XFkType $unknownCssName = null)
    {
        $this->unknownCssName = $unknownCssName;
        return $this;
    }
    /**
     * Get subscriberCssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getSubscriberCssName()
    {
        return $this->subscriberCssName;
    }
    /**
     * Set subscriberCssName value
     * @param \CUCM\StructType\XFkType $subscriberCssName
     * @return \CUCM\StructType\LTransformationProfile
     */
    public function setSubscriberCssName(\CUCM\StructType\XFkType $subscriberCssName = null)
    {
        $this->subscriberCssName = $subscriberCssName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\LTransformationProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LTransformationProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
