<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LTimePeriod StructType
 * @subpackage Structs
 */
class LTimePeriod extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The startTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $startTime;
    /**
     * The endTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $endTime;
    /**
     * The startDay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $startDay;
    /**
     * The endDay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $endDay;
    /**
     * The monthOfYear
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $monthOfYear;
    /**
     * The dayOfMonth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dayOfMonth;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The isPublished
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isPublished;
    /**
     * The todOwnerIdName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $todOwnerIdName;
    /**
     * The dayOfMonthEnd
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dayOfMonthEnd;
    /**
     * The monthOfYearEnd
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $monthOfYearEnd;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LTimePeriod
     * @uses LTimePeriod::setName()
     * @uses LTimePeriod::setStartTime()
     * @uses LTimePeriod::setEndTime()
     * @uses LTimePeriod::setStartDay()
     * @uses LTimePeriod::setEndDay()
     * @uses LTimePeriod::setMonthOfYear()
     * @uses LTimePeriod::setDayOfMonth()
     * @uses LTimePeriod::setDescription()
     * @uses LTimePeriod::setIsPublished()
     * @uses LTimePeriod::setTodOwnerIdName()
     * @uses LTimePeriod::setDayOfMonthEnd()
     * @uses LTimePeriod::setMonthOfYearEnd()
     * @uses LTimePeriod::setUuid()
     * @param string $name
     * @param string $startTime
     * @param string $endTime
     * @param string $startDay
     * @param string $endDay
     * @param string $monthOfYear
     * @param string $dayOfMonth
     * @param string $description
     * @param string $isPublished
     * @param \CUCM\StructType\XFkType $todOwnerIdName
     * @param string $dayOfMonthEnd
     * @param string $monthOfYearEnd
     * @param string $uuid
     */
    public function __construct($name = null, $startTime = null, $endTime = null, $startDay = null, $endDay = null, $monthOfYear = null, $dayOfMonth = null, $description = null, $isPublished = null, \CUCM\StructType\XFkType $todOwnerIdName = null, $dayOfMonthEnd = null, $monthOfYearEnd = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setStartTime($startTime)
            ->setEndTime($endTime)
            ->setStartDay($startDay)
            ->setEndDay($endDay)
            ->setMonthOfYear($monthOfYear)
            ->setDayOfMonth($dayOfMonth)
            ->setDescription($description)
            ->setIsPublished($isPublished)
            ->setTodOwnerIdName($todOwnerIdName)
            ->setDayOfMonthEnd($dayOfMonthEnd)
            ->setMonthOfYearEnd($monthOfYearEnd)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\LTimePeriod
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get startTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->startTime;
    }
    /**
     * Set startTime value
     * @uses \CUCM\EnumType\XTimeOfDay::valueIsValid()
     * @uses \CUCM\EnumType\XTimeOfDay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startTime
     * @return \CUCM\StructType\LTimePeriod
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XTimeOfDay::valueIsValid($startTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $startTime, implode(', ', \CUCM\EnumType\XTimeOfDay::getValidValues())), __LINE__);
        }
        $this->startTime = $startTime;
        return $this;
    }
    /**
     * Get endTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->endTime;
    }
    /**
     * Set endTime value
     * @uses \CUCM\EnumType\XTimeOfDay::valueIsValid()
     * @uses \CUCM\EnumType\XTimeOfDay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $endTime
     * @return \CUCM\StructType\LTimePeriod
     */
    public function setEndTime($endTime = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XTimeOfDay::valueIsValid($endTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $endTime, implode(', ', \CUCM\EnumType\XTimeOfDay::getValidValues())), __LINE__);
        }
        $this->endTime = $endTime;
        return $this;
    }
    /**
     * Get startDay value
     * @return string|null
     */
    public function getStartDay()
    {
        return $this->startDay;
    }
    /**
     * Set startDay value
     * @uses \CUCM\EnumType\XDayOfWeek::valueIsValid()
     * @uses \CUCM\EnumType\XDayOfWeek::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startDay
     * @return \CUCM\StructType\LTimePeriod
     */
    public function setStartDay($startDay = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XDayOfWeek::valueIsValid($startDay)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $startDay, implode(', ', \CUCM\EnumType\XDayOfWeek::getValidValues())), __LINE__);
        }
        $this->startDay = $startDay;
        return $this;
    }
    /**
     * Get endDay value
     * @return string|null
     */
    public function getEndDay()
    {
        return $this->endDay;
    }
    /**
     * Set endDay value
     * @uses \CUCM\EnumType\XDayOfWeek::valueIsValid()
     * @uses \CUCM\EnumType\XDayOfWeek::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $endDay
     * @return \CUCM\StructType\LTimePeriod
     */
    public function setEndDay($endDay = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XDayOfWeek::valueIsValid($endDay)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $endDay, implode(', ', \CUCM\EnumType\XDayOfWeek::getValidValues())), __LINE__);
        }
        $this->endDay = $endDay;
        return $this;
    }
    /**
     * Get monthOfYear value
     * @return string|null
     */
    public function getMonthOfYear()
    {
        return $this->monthOfYear;
    }
    /**
     * Set monthOfYear value
     * @uses \CUCM\EnumType\XMonthOfYear::valueIsValid()
     * @uses \CUCM\EnumType\XMonthOfYear::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $monthOfYear
     * @return \CUCM\StructType\LTimePeriod
     */
    public function setMonthOfYear($monthOfYear = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XMonthOfYear::valueIsValid($monthOfYear)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $monthOfYear, implode(', ', \CUCM\EnumType\XMonthOfYear::getValidValues())), __LINE__);
        }
        $this->monthOfYear = $monthOfYear;
        return $this;
    }
    /**
     * Get dayOfMonth value
     * @return string|null
     */
    public function getDayOfMonth()
    {
        return $this->dayOfMonth;
    }
    /**
     * Set dayOfMonth value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dayOfMonth
     * @return \CUCM\StructType\LTimePeriod
     */
    public function setDayOfMonth($dayOfMonth = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($dayOfMonth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dayOfMonth, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dayOfMonth = $dayOfMonth;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\LTimePeriod
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isPublished value
     * @return string|null
     */
    public function getIsPublished()
    {
        return $this->isPublished;
    }
    /**
     * Set isPublished value
     * @param string $isPublished
     * @return \CUCM\StructType\LTimePeriod
     */
    public function setIsPublished($isPublished = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isPublished) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isPublished)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isPublished, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isPublished) && !is_string($isPublished)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isPublished)), __LINE__);
        }
        $this->isPublished = $isPublished;
        return $this;
    }
    /**
     * Get todOwnerIdName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getTodOwnerIdName()
    {
        return $this->todOwnerIdName;
    }
    /**
     * Set todOwnerIdName value
     * @param \CUCM\StructType\XFkType $todOwnerIdName
     * @return \CUCM\StructType\LTimePeriod
     */
    public function setTodOwnerIdName(\CUCM\StructType\XFkType $todOwnerIdName = null)
    {
        $this->todOwnerIdName = $todOwnerIdName;
        return $this;
    }
    /**
     * Get dayOfMonthEnd value
     * @return string|null
     */
    public function getDayOfMonthEnd()
    {
        return $this->dayOfMonthEnd;
    }
    /**
     * Set dayOfMonthEnd value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dayOfMonthEnd
     * @return \CUCM\StructType\LTimePeriod
     */
    public function setDayOfMonthEnd($dayOfMonthEnd = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($dayOfMonthEnd)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dayOfMonthEnd, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dayOfMonthEnd = $dayOfMonthEnd;
        return $this;
    }
    /**
     * Get monthOfYearEnd value
     * @return string|null
     */
    public function getMonthOfYearEnd()
    {
        return $this->monthOfYearEnd;
    }
    /**
     * Set monthOfYearEnd value
     * @uses \CUCM\EnumType\XMonthOfYear::valueIsValid()
     * @uses \CUCM\EnumType\XMonthOfYear::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $monthOfYearEnd
     * @return \CUCM\StructType\LTimePeriod
     */
    public function setMonthOfYearEnd($monthOfYearEnd = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XMonthOfYear::valueIsValid($monthOfYearEnd)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $monthOfYearEnd, implode(', ', \CUCM\EnumType\XMonthOfYear::getValidValues())), __LINE__);
        }
        $this->monthOfYearEnd = $monthOfYearEnd;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\LTimePeriod
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LTimePeriod
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
