<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LT1Port StructType
 * @subpackage Structs
 */
class LT1Port extends AbstractStructBase
{
    /**
     * The portNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $portNumber;
    /**
     * The attendantDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $attendantDn;
    /**
     * The unattendedPort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unattendedPort;
    /**
     * The callerIdDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $callerIdDn;
    /**
     * The callerIdEnable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $callerIdEnable;
    /**
     * The callingPartySelection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartySelection;
    /**
     * The digitSending
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $digitSending;
    /**
     * The expectedDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $expectedDigits;
    /**
     * The sigDigits
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \CUCM\StructType\SigDigits
     */
    public $sigDigits;
    /**
     * The prefixDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $prefixDn;
    /**
     * The presentationBit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $presentationBit;
    /**
     * The silenceSuppressionThreshold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $silenceSuppressionThreshold;
    /**
     * The startDialProtocol
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $startDialProtocol;
    /**
     * The trunk
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trunk;
    /**
     * The trunkDirection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trunkDirection;
    /**
     * The trunkLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trunkLevel;
    /**
     * The trunkPadRx
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trunkPadRx;
    /**
     * The trunkPadTx
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trunkPadTx;
    /**
     * The vendorConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The callerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callerId;
    /**
     * The endpointId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $endpointId;
    /**
     * The timer1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timer1;
    /**
     * The timer2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timer2;
    /**
     * The timer3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timer3;
    /**
     * The timer4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timer4;
    /**
     * The timer5
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timer5;
    /**
     * The timer6
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timer6;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LT1Port
     * @uses LT1Port::setPortNumber()
     * @uses LT1Port::setAttendantDn()
     * @uses LT1Port::setUnattendedPort()
     * @uses LT1Port::setCallerIdDn()
     * @uses LT1Port::setCallerIdEnable()
     * @uses LT1Port::setCallingPartySelection()
     * @uses LT1Port::setDigitSending()
     * @uses LT1Port::setExpectedDigits()
     * @uses LT1Port::setSigDigits()
     * @uses LT1Port::setPrefixDn()
     * @uses LT1Port::setPresentationBit()
     * @uses LT1Port::setSilenceSuppressionThreshold()
     * @uses LT1Port::setStartDialProtocol()
     * @uses LT1Port::setTrunk()
     * @uses LT1Port::setTrunkDirection()
     * @uses LT1Port::setTrunkLevel()
     * @uses LT1Port::setTrunkPadRx()
     * @uses LT1Port::setTrunkPadTx()
     * @uses LT1Port::setVendorConfig()
     * @uses LT1Port::setCallerId()
     * @uses LT1Port::setEndpointId()
     * @uses LT1Port::setTimer1()
     * @uses LT1Port::setTimer2()
     * @uses LT1Port::setTimer3()
     * @uses LT1Port::setTimer4()
     * @uses LT1Port::setTimer5()
     * @uses LT1Port::setTimer6()
     * @uses LT1Port::setUuid()
     * @param string $portNumber
     * @param string $attendantDn
     * @param string $unattendedPort
     * @param string $callerIdDn
     * @param string $callerIdEnable
     * @param string $callingPartySelection
     * @param string $digitSending
     * @param string $expectedDigits
     * @param \CUCM\StructType\SigDigits $sigDigits
     * @param string $prefixDn
     * @param string $presentationBit
     * @param string $silenceSuppressionThreshold
     * @param string $startDialProtocol
     * @param string $trunk
     * @param string $trunkDirection
     * @param string $trunkLevel
     * @param string $trunkPadRx
     * @param string $trunkPadTx
     * @param \CUCM\StructType\XVendorConfig $vendorConfig
     * @param string $callerId
     * @param string $endpointId
     * @param string $timer1
     * @param string $timer2
     * @param string $timer3
     * @param string $timer4
     * @param string $timer5
     * @param string $timer6
     * @param string $uuid
     */
    public function __construct($portNumber = null, $attendantDn = null, $unattendedPort = null, $callerIdDn = null, $callerIdEnable = null, $callingPartySelection = null, $digitSending = null, $expectedDigits = null, \CUCM\StructType\SigDigits $sigDigits = null, $prefixDn = null, $presentationBit = null, $silenceSuppressionThreshold = null, $startDialProtocol = null, $trunk = null, $trunkDirection = null, $trunkLevel = null, $trunkPadRx = null, $trunkPadTx = null, \CUCM\StructType\XVendorConfig $vendorConfig = null, $callerId = null, $endpointId = null, $timer1 = null, $timer2 = null, $timer3 = null, $timer4 = null, $timer5 = null, $timer6 = null, $uuid = null)
    {
        $this
            ->setPortNumber($portNumber)
            ->setAttendantDn($attendantDn)
            ->setUnattendedPort($unattendedPort)
            ->setCallerIdDn($callerIdDn)
            ->setCallerIdEnable($callerIdEnable)
            ->setCallingPartySelection($callingPartySelection)
            ->setDigitSending($digitSending)
            ->setExpectedDigits($expectedDigits)
            ->setSigDigits($sigDigits)
            ->setPrefixDn($prefixDn)
            ->setPresentationBit($presentationBit)
            ->setSilenceSuppressionThreshold($silenceSuppressionThreshold)
            ->setStartDialProtocol($startDialProtocol)
            ->setTrunk($trunk)
            ->setTrunkDirection($trunkDirection)
            ->setTrunkLevel($trunkLevel)
            ->setTrunkPadRx($trunkPadRx)
            ->setTrunkPadTx($trunkPadTx)
            ->setVendorConfig($vendorConfig)
            ->setCallerId($callerId)
            ->setEndpointId($endpointId)
            ->setTimer1($timer1)
            ->setTimer2($timer2)
            ->setTimer3($timer3)
            ->setTimer4($timer4)
            ->setTimer5($timer5)
            ->setTimer6($timer6)
            ->setUuid($uuid);
    }
    /**
     * Get portNumber value
     * @return string|null
     */
    public function getPortNumber()
    {
        return $this->portNumber;
    }
    /**
     * Set portNumber value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $portNumber
     * @return \CUCM\StructType\LT1Port
     */
    public function setPortNumber($portNumber = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($portNumber)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $portNumber, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->portNumber = $portNumber;
        return $this;
    }
    /**
     * Get attendantDn value
     * @return string|null
     */
    public function getAttendantDn()
    {
        return $this->attendantDn;
    }
    /**
     * Set attendantDn value
     * @param string $attendantDn
     * @return \CUCM\StructType\LT1Port
     */
    public function setAttendantDn($attendantDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($attendantDn) && strlen($attendantDn) > 255) || (is_array($attendantDn) && count($attendantDn) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($attendantDn) ? strlen($attendantDn) : count($attendantDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($attendantDn) && !is_string($attendantDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attendantDn)), __LINE__);
        }
        $this->attendantDn = $attendantDn;
        return $this;
    }
    /**
     * Get unattendedPort value
     * @return string|null
     */
    public function getUnattendedPort()
    {
        return $this->unattendedPort;
    }
    /**
     * Set unattendedPort value
     * @param string $unattendedPort
     * @return \CUCM\StructType\LT1Port
     */
    public function setUnattendedPort($unattendedPort = null)
    {
        // validation for constraint: pattern
        if (is_scalar($unattendedPort) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($unattendedPort, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unattendedPort) && !is_string($unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unattendedPort)), __LINE__);
        }
        $this->unattendedPort = $unattendedPort;
        return $this;
    }
    /**
     * Get callerIdDn value
     * @return string|null
     */
    public function getCallerIdDn()
    {
        return $this->callerIdDn;
    }
    /**
     * Set callerIdDn value
     * @param string $callerIdDn
     * @return \CUCM\StructType\LT1Port
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callerIdDn) && strlen($callerIdDn) > 255) || (is_array($callerIdDn) && count($callerIdDn) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($callerIdDn) ? strlen($callerIdDn) : count($callerIdDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callerIdDn) && !is_string($callerIdDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callerIdDn)), __LINE__);
        }
        $this->callerIdDn = $callerIdDn;
        return $this;
    }
    /**
     * Get callerIdEnable value
     * @return string|null
     */
    public function getCallerIdEnable()
    {
        return $this->callerIdEnable;
    }
    /**
     * Set callerIdEnable value
     * @param string $callerIdEnable
     * @return \CUCM\StructType\LT1Port
     */
    public function setCallerIdEnable($callerIdEnable = null)
    {
        // validation for constraint: pattern
        if (is_scalar($callerIdEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $callerIdEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($callerIdEnable, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callerIdEnable) && !is_string($callerIdEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callerIdEnable)), __LINE__);
        }
        $this->callerIdEnable = $callerIdEnable;
        return $this;
    }
    /**
     * Get callingPartySelection value
     * @return string|null
     */
    public function getCallingPartySelection()
    {
        return $this->callingPartySelection;
    }
    /**
     * Set callingPartySelection value
     * @uses \CUCM\EnumType\XCallingPartySelection::valueIsValid()
     * @uses \CUCM\EnumType\XCallingPartySelection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartySelection
     * @return \CUCM\StructType\LT1Port
     */
    public function setCallingPartySelection($callingPartySelection = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XCallingPartySelection::valueIsValid($callingPartySelection)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartySelection, implode(', ', \CUCM\EnumType\XCallingPartySelection::getValidValues())), __LINE__);
        }
        $this->callingPartySelection = $callingPartySelection;
        return $this;
    }
    /**
     * Get digitSending value
     * @return string|null
     */
    public function getDigitSending()
    {
        return $this->digitSending;
    }
    /**
     * Set digitSending value
     * @uses \CUCM\EnumType\XDigitSending::valueIsValid()
     * @uses \CUCM\EnumType\XDigitSending::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $digitSending
     * @return \CUCM\StructType\LT1Port
     */
    public function setDigitSending($digitSending = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XDigitSending::valueIsValid($digitSending)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $digitSending, implode(', ', \CUCM\EnumType\XDigitSending::getValidValues())), __LINE__);
        }
        $this->digitSending = $digitSending;
        return $this;
    }
    /**
     * Get expectedDigits value
     * @return string|null
     */
    public function getExpectedDigits()
    {
        return $this->expectedDigits;
    }
    /**
     * Set expectedDigits value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $expectedDigits
     * @return \CUCM\StructType\LT1Port
     */
    public function setExpectedDigits($expectedDigits = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($expectedDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $expectedDigits, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->expectedDigits = $expectedDigits;
        return $this;
    }
    /**
     * Get sigDigits value
     * @return \CUCM\StructType\SigDigits|null
     */
    public function getSigDigits()
    {
        return $this->sigDigits;
    }
    /**
     * Set sigDigits value
     * @param \CUCM\StructType\SigDigits $sigDigits
     * @return \CUCM\StructType\LT1Port
     */
    public function setSigDigits(\CUCM\StructType\SigDigits $sigDigits = null)
    {
        $this->sigDigits = $sigDigits;
        return $this;
    }
    /**
     * Get prefixDn value
     * @return string|null
     */
    public function getPrefixDn()
    {
        return $this->prefixDn;
    }
    /**
     * Set prefixDn value
     * @param string $prefixDn
     * @return \CUCM\StructType\LT1Port
     */
    public function setPrefixDn($prefixDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($prefixDn) && strlen($prefixDn) > 255) || (is_array($prefixDn) && count($prefixDn) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($prefixDn) ? strlen($prefixDn) : count($prefixDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($prefixDn) && !is_string($prefixDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefixDn)), __LINE__);
        }
        $this->prefixDn = $prefixDn;
        return $this;
    }
    /**
     * Get presentationBit value
     * @return string|null
     */
    public function getPresentationBit()
    {
        return $this->presentationBit;
    }
    /**
     * Set presentationBit value
     * @uses \CUCM\EnumType\XPresentationBit::valueIsValid()
     * @uses \CUCM\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $presentationBit
     * @return \CUCM\StructType\LT1Port
     */
    public function setPresentationBit($presentationBit = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPresentationBit::valueIsValid($presentationBit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $presentationBit, implode(', ', \CUCM\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->presentationBit = $presentationBit;
        return $this;
    }
    /**
     * Get silenceSuppressionThreshold value
     * @return string|null
     */
    public function getSilenceSuppressionThreshold()
    {
        return $this->silenceSuppressionThreshold;
    }
    /**
     * Set silenceSuppressionThreshold value
     * @uses \CUCM\EnumType\XSilenceSuppressionThreshold::valueIsValid()
     * @uses \CUCM\EnumType\XSilenceSuppressionThreshold::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $silenceSuppressionThreshold
     * @return \CUCM\StructType\LT1Port
     */
    public function setSilenceSuppressionThreshold($silenceSuppressionThreshold = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XSilenceSuppressionThreshold::valueIsValid($silenceSuppressionThreshold)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $silenceSuppressionThreshold, implode(', ', \CUCM\EnumType\XSilenceSuppressionThreshold::getValidValues())), __LINE__);
        }
        $this->silenceSuppressionThreshold = $silenceSuppressionThreshold;
        return $this;
    }
    /**
     * Get startDialProtocol value
     * @return string|null
     */
    public function getStartDialProtocol()
    {
        return $this->startDialProtocol;
    }
    /**
     * Set startDialProtocol value
     * @uses \CUCM\EnumType\XStartDialProtocol::valueIsValid()
     * @uses \CUCM\EnumType\XStartDialProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startDialProtocol
     * @return \CUCM\StructType\LT1Port
     */
    public function setStartDialProtocol($startDialProtocol = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStartDialProtocol::valueIsValid($startDialProtocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $startDialProtocol, implode(', ', \CUCM\EnumType\XStartDialProtocol::getValidValues())), __LINE__);
        }
        $this->startDialProtocol = $startDialProtocol;
        return $this;
    }
    /**
     * Get trunk value
     * @return string|null
     */
    public function getTrunk()
    {
        return $this->trunk;
    }
    /**
     * Set trunk value
     * @uses \CUCM\EnumType\XTrunk::valueIsValid()
     * @uses \CUCM\EnumType\XTrunk::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunk
     * @return \CUCM\StructType\LT1Port
     */
    public function setTrunk($trunk = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XTrunk::valueIsValid($trunk)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trunk, implode(', ', \CUCM\EnumType\XTrunk::getValidValues())), __LINE__);
        }
        $this->trunk = $trunk;
        return $this;
    }
    /**
     * Get trunkDirection value
     * @return string|null
     */
    public function getTrunkDirection()
    {
        return $this->trunkDirection;
    }
    /**
     * Set trunkDirection value
     * @uses \CUCM\EnumType\XTrunkDirection::valueIsValid()
     * @uses \CUCM\EnumType\XTrunkDirection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkDirection
     * @return \CUCM\StructType\LT1Port
     */
    public function setTrunkDirection($trunkDirection = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XTrunkDirection::valueIsValid($trunkDirection)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trunkDirection, implode(', ', \CUCM\EnumType\XTrunkDirection::getValidValues())), __LINE__);
        }
        $this->trunkDirection = $trunkDirection;
        return $this;
    }
    /**
     * Get trunkLevel value
     * @return string|null
     */
    public function getTrunkLevel()
    {
        return $this->trunkLevel;
    }
    /**
     * Set trunkLevel value
     * @uses \CUCM\EnumType\XTrunkLevel::valueIsValid()
     * @uses \CUCM\EnumType\XTrunkLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkLevel
     * @return \CUCM\StructType\LT1Port
     */
    public function setTrunkLevel($trunkLevel = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XTrunkLevel::valueIsValid($trunkLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trunkLevel, implode(', ', \CUCM\EnumType\XTrunkLevel::getValidValues())), __LINE__);
        }
        $this->trunkLevel = $trunkLevel;
        return $this;
    }
    /**
     * Get trunkPadRx value
     * @return string|null
     */
    public function getTrunkPadRx()
    {
        return $this->trunkPadRx;
    }
    /**
     * Set trunkPadRx value
     * @uses \CUCM\EnumType\XTrunkPad::valueIsValid()
     * @uses \CUCM\EnumType\XTrunkPad::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkPadRx
     * @return \CUCM\StructType\LT1Port
     */
    public function setTrunkPadRx($trunkPadRx = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XTrunkPad::valueIsValid($trunkPadRx)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trunkPadRx, implode(', ', \CUCM\EnumType\XTrunkPad::getValidValues())), __LINE__);
        }
        $this->trunkPadRx = $trunkPadRx;
        return $this;
    }
    /**
     * Get trunkPadTx value
     * @return string|null
     */
    public function getTrunkPadTx()
    {
        return $this->trunkPadTx;
    }
    /**
     * Set trunkPadTx value
     * @uses \CUCM\EnumType\XTrunkPad::valueIsValid()
     * @uses \CUCM\EnumType\XTrunkPad::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkPadTx
     * @return \CUCM\StructType\LT1Port
     */
    public function setTrunkPadTx($trunkPadTx = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XTrunkPad::valueIsValid($trunkPadTx)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trunkPadTx, implode(', ', \CUCM\EnumType\XTrunkPad::getValidValues())), __LINE__);
        }
        $this->trunkPadTx = $trunkPadTx;
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \CUCM\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \CUCM\StructType\XVendorConfig $vendorConfig
     * @return \CUCM\StructType\LT1Port
     */
    public function setVendorConfig(\CUCM\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get callerId value
     * @return string|null
     */
    public function getCallerId()
    {
        return $this->callerId;
    }
    /**
     * Set callerId value
     * @uses \CUCM\EnumType\XCallerID::valueIsValid()
     * @uses \CUCM\EnumType\XCallerID::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callerId
     * @return \CUCM\StructType\LT1Port
     */
    public function setCallerId($callerId = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XCallerID::valueIsValid($callerId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callerId, implode(', ', \CUCM\EnumType\XCallerID::getValidValues())), __LINE__);
        }
        $this->callerId = $callerId;
        return $this;
    }
    /**
     * Get endpointId value
     * @return string|null
     */
    public function getEndpointId()
    {
        return $this->endpointId;
    }
    /**
     * Set endpointId value
     * @param string $endpointId
     * @return \CUCM\StructType\LT1Port
     */
    public function setEndpointId($endpointId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($endpointId) && strlen($endpointId) > 128) || (is_array($endpointId) && count($endpointId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($endpointId) ? strlen($endpointId) : count($endpointId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($endpointId) && !is_string($endpointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endpointId)), __LINE__);
        }
        $this->endpointId = $endpointId;
        return $this;
    }
    /**
     * Get timer1 value
     * @return string|null
     */
    public function getTimer1()
    {
        return $this->timer1;
    }
    /**
     * Set timer1 value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timer1
     * @return \CUCM\StructType\LT1Port
     */
    public function setTimer1($timer1 = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($timer1)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timer1, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timer1 = $timer1;
        return $this;
    }
    /**
     * Get timer2 value
     * @return string|null
     */
    public function getTimer2()
    {
        return $this->timer2;
    }
    /**
     * Set timer2 value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timer2
     * @return \CUCM\StructType\LT1Port
     */
    public function setTimer2($timer2 = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($timer2)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timer2, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timer2 = $timer2;
        return $this;
    }
    /**
     * Get timer3 value
     * @return string|null
     */
    public function getTimer3()
    {
        return $this->timer3;
    }
    /**
     * Set timer3 value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timer3
     * @return \CUCM\StructType\LT1Port
     */
    public function setTimer3($timer3 = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($timer3)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timer3, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timer3 = $timer3;
        return $this;
    }
    /**
     * Get timer4 value
     * @return string|null
     */
    public function getTimer4()
    {
        return $this->timer4;
    }
    /**
     * Set timer4 value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timer4
     * @return \CUCM\StructType\LT1Port
     */
    public function setTimer4($timer4 = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($timer4)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timer4, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timer4 = $timer4;
        return $this;
    }
    /**
     * Get timer5 value
     * @return string|null
     */
    public function getTimer5()
    {
        return $this->timer5;
    }
    /**
     * Set timer5 value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timer5
     * @return \CUCM\StructType\LT1Port
     */
    public function setTimer5($timer5 = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($timer5)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timer5, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timer5 = $timer5;
        return $this;
    }
    /**
     * Get timer6 value
     * @return string|null
     */
    public function getTimer6()
    {
        return $this->timer6;
    }
    /**
     * Set timer6 value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timer6
     * @return \CUCM\StructType\LT1Port
     */
    public function setTimer6($timer6 = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($timer6)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timer6, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timer6 = $timer6;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\LT1Port
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LT1Port
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
