<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LSpeeddial StructType
 * @subpackage Structs
 */
class LSpeeddial extends AbstractStructBase
{
    /**
     * The dirn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $dirn;
    /**
     * The label
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $label;
    /**
     * The asciiLabel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $asciiLabel;
    /**
     * The index
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $index;
    /**
     * Constructor method for LSpeeddial
     * @uses LSpeeddial::setDirn()
     * @uses LSpeeddial::setLabel()
     * @uses LSpeeddial::setAsciiLabel()
     * @uses LSpeeddial::setIndex()
     * @param string $dirn
     * @param string $label
     * @param string $asciiLabel
     * @param string $index
     */
    public function __construct($dirn = null, $label = null, $asciiLabel = null, $index = null)
    {
        $this
            ->setDirn($dirn)
            ->setLabel($label)
            ->setAsciiLabel($asciiLabel)
            ->setIndex($index);
    }
    /**
     * Get dirn value
     * @return string|null
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param string $dirn
     * @return \CUCM\StructType\LSpeeddial
     */
    public function setDirn($dirn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($dirn) && strlen($dirn) > 255) || (is_array($dirn) && count($dirn) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($dirn) ? strlen($dirn) : count($dirn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dirn) && !is_string($dirn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dirn)), __LINE__);
        }
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \CUCM\StructType\LSpeeddial
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get asciiLabel value
     * @return string|null
     */
    public function getAsciiLabel()
    {
        return $this->asciiLabel;
    }
    /**
     * Set asciiLabel value
     * @param string $asciiLabel
     * @return \CUCM\StructType\LSpeeddial
     */
    public function setAsciiLabel($asciiLabel = null)
    {
        // validation for constraint: string
        if (!is_null($asciiLabel) && !is_string($asciiLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($asciiLabel)), __LINE__);
        }
        $this->asciiLabel = $asciiLabel;
        return $this;
    }
    /**
     * Get index value
     * @return string|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return \CUCM\StructType\LSpeeddial
     */
    public function setIndex($index = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $index, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LSpeeddial
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
