<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LSipProfile StructType
 * @subpackage Structs
 */
class LSipProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $description;
    /**
     * The defaultTelephonyEventPayloadType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $defaultTelephonyEventPayloadType;
    /**
     * The redirectByApplication
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectByApplication;
    /**
     * The ringing180
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ringing180;
    /**
     * The timerInvite
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerInvite;
    /**
     * The timerRegisterDelta
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerRegisterDelta;
    /**
     * The timerRegister
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerRegister;
    /**
     * The timerT1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerT1;
    /**
     * The timerT2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerT2;
    /**
     * The retryInvite
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $retryInvite;
    /**
     * The retryNotInvite
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $retryNotInvite;
    /**
     * The startMediaPort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $startMediaPort;
    /**
     * The stopMediaPort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $stopMediaPort;
    /**
     * The callpickupUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $callpickupUri;
    /**
     * The callpickupListUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $callpickupListUri;
    /**
     * The callpickupGroupUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $callpickupGroupUri;
    /**
     * The meetmeServiceUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $meetmeServiceUrl;
    /**
     * The userInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userInfo;
    /**
     * The dtmfDbLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dtmfDbLevel;
    /**
     * The callHoldRingback
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callHoldRingback;
    /**
     * The anonymousCallBlock
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $anonymousCallBlock;
    /**
     * The callerIdBlock
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callerIdBlock;
    /**
     * The dndControl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dndControl;
    /**
     * The telnetLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $telnetLevel;
    /**
     * The timerKeepAlive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerKeepAlive;
    /**
     * The timerSubscribe
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerSubscribe;
    /**
     * The timerSubscribeDelta
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerSubscribeDelta;
    /**
     * The maxRedirects
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxRedirects;
    /**
     * The timerOffHookToFirstDigit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerOffHookToFirstDigit;
    /**
     * The callForwardUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $callForwardUri;
    /**
     * The abbreviatedDialUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $abbreviatedDialUri;
    /**
     * The confJointEnable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $confJointEnable;
    /**
     * The rfc2543Hold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rfc2543Hold;
    /**
     * The semiAttendedTransfer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $semiAttendedTransfer;
    /**
     * The enableVad
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableVad;
    /**
     * The stutterMsgWaiting
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $stutterMsgWaiting;
    /**
     * The callStats
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $callStats;
    /**
     * The t38Invite
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $t38Invite;
    /**
     * The rerouteIncomingRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rerouteIncomingRequest;
    /**
     * The resourcePriorityNamespaceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $resourcePriorityNamespaceListName;
    /**
     * The enableAnatForEarlyOfferCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableAnatForEarlyOfferCalls;
    /**
     * The rsvpOverSip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rsvpOverSip;
    /**
     * The fallbackToLocalRsvp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $fallbackToLocalRsvp;
    /**
     * The sipRe11XxEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipRe11XxEnabled;
    /**
     * The gClear
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $gClear;
    /**
     * The earlyOfferSupportForVoiceCall
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $earlyOfferSupportForVoiceCall;
    /**
     * The sendRecvSDPInMidCallInvite
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendRecvSDPInMidCallInvite;
    /**
     * The enableOutboundOptionsPing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableOutboundOptionsPing;
    /**
     * The optionsPingIntervalWhenStatusOK
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $optionsPingIntervalWhenStatusOK;
    /**
     * The optionsPingIntervalWhenStatusNotOK
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $optionsPingIntervalWhenStatusNotOK;
    /**
     * The deliverConferenceBridgeIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $deliverConferenceBridgeIdentifier;
    /**
     * The sipOptionsRetryCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipOptionsRetryCount;
    /**
     * The sipOptionsRetryTimer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipOptionsRetryTimer;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LSipProfile
     * @uses LSipProfile::setName()
     * @uses LSipProfile::setDescription()
     * @uses LSipProfile::setDefaultTelephonyEventPayloadType()
     * @uses LSipProfile::setRedirectByApplication()
     * @uses LSipProfile::setRinging180()
     * @uses LSipProfile::setTimerInvite()
     * @uses LSipProfile::setTimerRegisterDelta()
     * @uses LSipProfile::setTimerRegister()
     * @uses LSipProfile::setTimerT1()
     * @uses LSipProfile::setTimerT2()
     * @uses LSipProfile::setRetryInvite()
     * @uses LSipProfile::setRetryNotInvite()
     * @uses LSipProfile::setStartMediaPort()
     * @uses LSipProfile::setStopMediaPort()
     * @uses LSipProfile::setCallpickupUri()
     * @uses LSipProfile::setCallpickupListUri()
     * @uses LSipProfile::setCallpickupGroupUri()
     * @uses LSipProfile::setMeetmeServiceUrl()
     * @uses LSipProfile::setUserInfo()
     * @uses LSipProfile::setDtmfDbLevel()
     * @uses LSipProfile::setCallHoldRingback()
     * @uses LSipProfile::setAnonymousCallBlock()
     * @uses LSipProfile::setCallerIdBlock()
     * @uses LSipProfile::setDndControl()
     * @uses LSipProfile::setTelnetLevel()
     * @uses LSipProfile::setTimerKeepAlive()
     * @uses LSipProfile::setTimerSubscribe()
     * @uses LSipProfile::setTimerSubscribeDelta()
     * @uses LSipProfile::setMaxRedirects()
     * @uses LSipProfile::setTimerOffHookToFirstDigit()
     * @uses LSipProfile::setCallForwardUri()
     * @uses LSipProfile::setAbbreviatedDialUri()
     * @uses LSipProfile::setConfJointEnable()
     * @uses LSipProfile::setRfc2543Hold()
     * @uses LSipProfile::setSemiAttendedTransfer()
     * @uses LSipProfile::setEnableVad()
     * @uses LSipProfile::setStutterMsgWaiting()
     * @uses LSipProfile::setCallStats()
     * @uses LSipProfile::setT38Invite()
     * @uses LSipProfile::setRerouteIncomingRequest()
     * @uses LSipProfile::setResourcePriorityNamespaceListName()
     * @uses LSipProfile::setEnableAnatForEarlyOfferCalls()
     * @uses LSipProfile::setRsvpOverSip()
     * @uses LSipProfile::setFallbackToLocalRsvp()
     * @uses LSipProfile::setSipRe11XxEnabled()
     * @uses LSipProfile::setGClear()
     * @uses LSipProfile::setEarlyOfferSupportForVoiceCall()
     * @uses LSipProfile::setSendRecvSDPInMidCallInvite()
     * @uses LSipProfile::setEnableOutboundOptionsPing()
     * @uses LSipProfile::setOptionsPingIntervalWhenStatusOK()
     * @uses LSipProfile::setOptionsPingIntervalWhenStatusNotOK()
     * @uses LSipProfile::setDeliverConferenceBridgeIdentifier()
     * @uses LSipProfile::setSipOptionsRetryCount()
     * @uses LSipProfile::setSipOptionsRetryTimer()
     * @uses LSipProfile::setUuid()
     * @param string $name
     * @param string $description
     * @param string $defaultTelephonyEventPayloadType
     * @param string $redirectByApplication
     * @param string $ringing180
     * @param string $timerInvite
     * @param string $timerRegisterDelta
     * @param string $timerRegister
     * @param string $timerT1
     * @param string $timerT2
     * @param string $retryInvite
     * @param string $retryNotInvite
     * @param string $startMediaPort
     * @param string $stopMediaPort
     * @param string $callpickupUri
     * @param string $callpickupListUri
     * @param string $callpickupGroupUri
     * @param string $meetmeServiceUrl
     * @param string $userInfo
     * @param string $dtmfDbLevel
     * @param string $callHoldRingback
     * @param string $anonymousCallBlock
     * @param string $callerIdBlock
     * @param string $dndControl
     * @param string $telnetLevel
     * @param string $timerKeepAlive
     * @param string $timerSubscribe
     * @param string $timerSubscribeDelta
     * @param string $maxRedirects
     * @param string $timerOffHookToFirstDigit
     * @param string $callForwardUri
     * @param string $abbreviatedDialUri
     * @param string $confJointEnable
     * @param string $rfc2543Hold
     * @param string $semiAttendedTransfer
     * @param string $enableVad
     * @param string $stutterMsgWaiting
     * @param string $callStats
     * @param string $t38Invite
     * @param string $rerouteIncomingRequest
     * @param \CUCM\StructType\XFkType $resourcePriorityNamespaceListName
     * @param string $enableAnatForEarlyOfferCalls
     * @param string $rsvpOverSip
     * @param string $fallbackToLocalRsvp
     * @param string $sipRe11XxEnabled
     * @param string $gClear
     * @param string $earlyOfferSupportForVoiceCall
     * @param string $sendRecvSDPInMidCallInvite
     * @param string $enableOutboundOptionsPing
     * @param string $optionsPingIntervalWhenStatusOK
     * @param string $optionsPingIntervalWhenStatusNotOK
     * @param string $deliverConferenceBridgeIdentifier
     * @param string $sipOptionsRetryCount
     * @param string $sipOptionsRetryTimer
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $defaultTelephonyEventPayloadType = null, $redirectByApplication = null, $ringing180 = null, $timerInvite = null, $timerRegisterDelta = null, $timerRegister = null, $timerT1 = null, $timerT2 = null, $retryInvite = null, $retryNotInvite = null, $startMediaPort = null, $stopMediaPort = null, $callpickupUri = null, $callpickupListUri = null, $callpickupGroupUri = null, $meetmeServiceUrl = null, $userInfo = null, $dtmfDbLevel = null, $callHoldRingback = null, $anonymousCallBlock = null, $callerIdBlock = null, $dndControl = null, $telnetLevel = null, $timerKeepAlive = null, $timerSubscribe = null, $timerSubscribeDelta = null, $maxRedirects = null, $timerOffHookToFirstDigit = null, $callForwardUri = null, $abbreviatedDialUri = null, $confJointEnable = null, $rfc2543Hold = null, $semiAttendedTransfer = null, $enableVad = null, $stutterMsgWaiting = null, $callStats = null, $t38Invite = null, $rerouteIncomingRequest = null, \CUCM\StructType\XFkType $resourcePriorityNamespaceListName = null, $enableAnatForEarlyOfferCalls = null, $rsvpOverSip = null, $fallbackToLocalRsvp = null, $sipRe11XxEnabled = null, $gClear = null, $earlyOfferSupportForVoiceCall = null, $sendRecvSDPInMidCallInvite = null, $enableOutboundOptionsPing = null, $optionsPingIntervalWhenStatusOK = null, $optionsPingIntervalWhenStatusNotOK = null, $deliverConferenceBridgeIdentifier = null, $sipOptionsRetryCount = null, $sipOptionsRetryTimer = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setDefaultTelephonyEventPayloadType($defaultTelephonyEventPayloadType)
            ->setRedirectByApplication($redirectByApplication)
            ->setRinging180($ringing180)
            ->setTimerInvite($timerInvite)
            ->setTimerRegisterDelta($timerRegisterDelta)
            ->setTimerRegister($timerRegister)
            ->setTimerT1($timerT1)
            ->setTimerT2($timerT2)
            ->setRetryInvite($retryInvite)
            ->setRetryNotInvite($retryNotInvite)
            ->setStartMediaPort($startMediaPort)
            ->setStopMediaPort($stopMediaPort)
            ->setCallpickupUri($callpickupUri)
            ->setCallpickupListUri($callpickupListUri)
            ->setCallpickupGroupUri($callpickupGroupUri)
            ->setMeetmeServiceUrl($meetmeServiceUrl)
            ->setUserInfo($userInfo)
            ->setDtmfDbLevel($dtmfDbLevel)
            ->setCallHoldRingback($callHoldRingback)
            ->setAnonymousCallBlock($anonymousCallBlock)
            ->setCallerIdBlock($callerIdBlock)
            ->setDndControl($dndControl)
            ->setTelnetLevel($telnetLevel)
            ->setTimerKeepAlive($timerKeepAlive)
            ->setTimerSubscribe($timerSubscribe)
            ->setTimerSubscribeDelta($timerSubscribeDelta)
            ->setMaxRedirects($maxRedirects)
            ->setTimerOffHookToFirstDigit($timerOffHookToFirstDigit)
            ->setCallForwardUri($callForwardUri)
            ->setAbbreviatedDialUri($abbreviatedDialUri)
            ->setConfJointEnable($confJointEnable)
            ->setRfc2543Hold($rfc2543Hold)
            ->setSemiAttendedTransfer($semiAttendedTransfer)
            ->setEnableVad($enableVad)
            ->setStutterMsgWaiting($stutterMsgWaiting)
            ->setCallStats($callStats)
            ->setT38Invite($t38Invite)
            ->setRerouteIncomingRequest($rerouteIncomingRequest)
            ->setResourcePriorityNamespaceListName($resourcePriorityNamespaceListName)
            ->setEnableAnatForEarlyOfferCalls($enableAnatForEarlyOfferCalls)
            ->setRsvpOverSip($rsvpOverSip)
            ->setFallbackToLocalRsvp($fallbackToLocalRsvp)
            ->setSipRe11XxEnabled($sipRe11XxEnabled)
            ->setGClear($gClear)
            ->setEarlyOfferSupportForVoiceCall($earlyOfferSupportForVoiceCall)
            ->setSendRecvSDPInMidCallInvite($sendRecvSDPInMidCallInvite)
            ->setEnableOutboundOptionsPing($enableOutboundOptionsPing)
            ->setOptionsPingIntervalWhenStatusOK($optionsPingIntervalWhenStatusOK)
            ->setOptionsPingIntervalWhenStatusNotOK($optionsPingIntervalWhenStatusNotOK)
            ->setDeliverConferenceBridgeIdentifier($deliverConferenceBridgeIdentifier)
            ->setSipOptionsRetryCount($sipOptionsRetryCount)
            ->setSipOptionsRetryTimer($sipOptionsRetryTimer)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\LSipProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\LSipProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 100) || (is_array($description) && count($description) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get defaultTelephonyEventPayloadType value
     * @return string|null
     */
    public function getDefaultTelephonyEventPayloadType()
    {
        return $this->defaultTelephonyEventPayloadType;
    }
    /**
     * Set defaultTelephonyEventPayloadType value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $defaultTelephonyEventPayloadType
     * @return \CUCM\StructType\LSipProfile
     */
    public function setDefaultTelephonyEventPayloadType($defaultTelephonyEventPayloadType = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($defaultTelephonyEventPayloadType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $defaultTelephonyEventPayloadType, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->defaultTelephonyEventPayloadType = $defaultTelephonyEventPayloadType;
        return $this;
    }
    /**
     * Get redirectByApplication value
     * @return string|null
     */
    public function getRedirectByApplication()
    {
        return $this->redirectByApplication;
    }
    /**
     * Set redirectByApplication value
     * @param string $redirectByApplication
     * @return \CUCM\StructType\LSipProfile
     */
    public function setRedirectByApplication($redirectByApplication = null)
    {
        // validation for constraint: pattern
        if (is_scalar($redirectByApplication) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $redirectByApplication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($redirectByApplication, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($redirectByApplication) && !is_string($redirectByApplication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($redirectByApplication)), __LINE__);
        }
        $this->redirectByApplication = $redirectByApplication;
        return $this;
    }
    /**
     * Get ringing180 value
     * @return string|null
     */
    public function getRinging180()
    {
        return $this->ringing180;
    }
    /**
     * Set ringing180 value
     * @param string $ringing180
     * @return \CUCM\StructType\LSipProfile
     */
    public function setRinging180($ringing180 = null)
    {
        // validation for constraint: pattern
        if (is_scalar($ringing180) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $ringing180)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($ringing180, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ringing180) && !is_string($ringing180)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ringing180)), __LINE__);
        }
        $this->ringing180 = $ringing180;
        return $this;
    }
    /**
     * Get timerInvite value
     * @return string|null
     */
    public function getTimerInvite()
    {
        return $this->timerInvite;
    }
    /**
     * Set timerInvite value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerInvite
     * @return \CUCM\StructType\LSipProfile
     */
    public function setTimerInvite($timerInvite = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($timerInvite)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerInvite, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerInvite = $timerInvite;
        return $this;
    }
    /**
     * Get timerRegisterDelta value
     * @return string|null
     */
    public function getTimerRegisterDelta()
    {
        return $this->timerRegisterDelta;
    }
    /**
     * Set timerRegisterDelta value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerRegisterDelta
     * @return \CUCM\StructType\LSipProfile
     */
    public function setTimerRegisterDelta($timerRegisterDelta = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($timerRegisterDelta)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerRegisterDelta, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerRegisterDelta = $timerRegisterDelta;
        return $this;
    }
    /**
     * Get timerRegister value
     * @return string|null
     */
    public function getTimerRegister()
    {
        return $this->timerRegister;
    }
    /**
     * Set timerRegister value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerRegister
     * @return \CUCM\StructType\LSipProfile
     */
    public function setTimerRegister($timerRegister = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($timerRegister)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerRegister, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerRegister = $timerRegister;
        return $this;
    }
    /**
     * Get timerT1 value
     * @return string|null
     */
    public function getTimerT1()
    {
        return $this->timerT1;
    }
    /**
     * Set timerT1 value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerT1
     * @return \CUCM\StructType\LSipProfile
     */
    public function setTimerT1($timerT1 = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($timerT1)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerT1, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerT1 = $timerT1;
        return $this;
    }
    /**
     * Get timerT2 value
     * @return string|null
     */
    public function getTimerT2()
    {
        return $this->timerT2;
    }
    /**
     * Set timerT2 value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerT2
     * @return \CUCM\StructType\LSipProfile
     */
    public function setTimerT2($timerT2 = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($timerT2)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerT2, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerT2 = $timerT2;
        return $this;
    }
    /**
     * Get retryInvite value
     * @return string|null
     */
    public function getRetryInvite()
    {
        return $this->retryInvite;
    }
    /**
     * Set retryInvite value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $retryInvite
     * @return \CUCM\StructType\LSipProfile
     */
    public function setRetryInvite($retryInvite = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($retryInvite)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $retryInvite, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->retryInvite = $retryInvite;
        return $this;
    }
    /**
     * Get retryNotInvite value
     * @return string|null
     */
    public function getRetryNotInvite()
    {
        return $this->retryNotInvite;
    }
    /**
     * Set retryNotInvite value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $retryNotInvite
     * @return \CUCM\StructType\LSipProfile
     */
    public function setRetryNotInvite($retryNotInvite = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($retryNotInvite)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $retryNotInvite, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->retryNotInvite = $retryNotInvite;
        return $this;
    }
    /**
     * Get startMediaPort value
     * @return string|null
     */
    public function getStartMediaPort()
    {
        return $this->startMediaPort;
    }
    /**
     * Set startMediaPort value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startMediaPort
     * @return \CUCM\StructType\LSipProfile
     */
    public function setStartMediaPort($startMediaPort = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($startMediaPort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $startMediaPort, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->startMediaPort = $startMediaPort;
        return $this;
    }
    /**
     * Get stopMediaPort value
     * @return string|null
     */
    public function getStopMediaPort()
    {
        return $this->stopMediaPort;
    }
    /**
     * Set stopMediaPort value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stopMediaPort
     * @return \CUCM\StructType\LSipProfile
     */
    public function setStopMediaPort($stopMediaPort = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($stopMediaPort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $stopMediaPort, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->stopMediaPort = $stopMediaPort;
        return $this;
    }
    /**
     * Get callpickupUri value
     * @return string|null
     */
    public function getCallpickupUri()
    {
        return $this->callpickupUri;
    }
    /**
     * Set callpickupUri value
     * @param string $callpickupUri
     * @return \CUCM\StructType\LSipProfile
     */
    public function setCallpickupUri($callpickupUri = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callpickupUri) && strlen($callpickupUri) > 128) || (is_array($callpickupUri) && count($callpickupUri) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($callpickupUri) ? strlen($callpickupUri) : count($callpickupUri)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callpickupUri) && !is_string($callpickupUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callpickupUri)), __LINE__);
        }
        $this->callpickupUri = $callpickupUri;
        return $this;
    }
    /**
     * Get callpickupListUri value
     * @return string|null
     */
    public function getCallpickupListUri()
    {
        return $this->callpickupListUri;
    }
    /**
     * Set callpickupListUri value
     * @param string $callpickupListUri
     * @return \CUCM\StructType\LSipProfile
     */
    public function setCallpickupListUri($callpickupListUri = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callpickupListUri) && strlen($callpickupListUri) > 128) || (is_array($callpickupListUri) && count($callpickupListUri) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($callpickupListUri) ? strlen($callpickupListUri) : count($callpickupListUri)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callpickupListUri) && !is_string($callpickupListUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callpickupListUri)), __LINE__);
        }
        $this->callpickupListUri = $callpickupListUri;
        return $this;
    }
    /**
     * Get callpickupGroupUri value
     * @return string|null
     */
    public function getCallpickupGroupUri()
    {
        return $this->callpickupGroupUri;
    }
    /**
     * Set callpickupGroupUri value
     * @param string $callpickupGroupUri
     * @return \CUCM\StructType\LSipProfile
     */
    public function setCallpickupGroupUri($callpickupGroupUri = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callpickupGroupUri) && strlen($callpickupGroupUri) > 128) || (is_array($callpickupGroupUri) && count($callpickupGroupUri) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($callpickupGroupUri) ? strlen($callpickupGroupUri) : count($callpickupGroupUri)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callpickupGroupUri) && !is_string($callpickupGroupUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callpickupGroupUri)), __LINE__);
        }
        $this->callpickupGroupUri = $callpickupGroupUri;
        return $this;
    }
    /**
     * Get meetmeServiceUrl value
     * @return string|null
     */
    public function getMeetmeServiceUrl()
    {
        return $this->meetmeServiceUrl;
    }
    /**
     * Set meetmeServiceUrl value
     * @param string $meetmeServiceUrl
     * @return \CUCM\StructType\LSipProfile
     */
    public function setMeetmeServiceUrl($meetmeServiceUrl = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($meetmeServiceUrl) && strlen($meetmeServiceUrl) > 128) || (is_array($meetmeServiceUrl) && count($meetmeServiceUrl) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($meetmeServiceUrl) ? strlen($meetmeServiceUrl) : count($meetmeServiceUrl)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($meetmeServiceUrl) && !is_string($meetmeServiceUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meetmeServiceUrl)), __LINE__);
        }
        $this->meetmeServiceUrl = $meetmeServiceUrl;
        return $this;
    }
    /**
     * Get userInfo value
     * @return string|null
     */
    public function getUserInfo()
    {
        return $this->userInfo;
    }
    /**
     * Set userInfo value
     * @uses \CUCM\EnumType\XZzuserInfo::valueIsValid()
     * @uses \CUCM\EnumType\XZzuserInfo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userInfo
     * @return \CUCM\StructType\LSipProfile
     */
    public function setUserInfo($userInfo = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XZzuserInfo::valueIsValid($userInfo)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userInfo, implode(', ', \CUCM\EnumType\XZzuserInfo::getValidValues())), __LINE__);
        }
        $this->userInfo = $userInfo;
        return $this;
    }
    /**
     * Get dtmfDbLevel value
     * @return string|null
     */
    public function getDtmfDbLevel()
    {
        return $this->dtmfDbLevel;
    }
    /**
     * Set dtmfDbLevel value
     * @uses \CUCM\EnumType\XZzdtmfDbLevel::valueIsValid()
     * @uses \CUCM\EnumType\XZzdtmfDbLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dtmfDbLevel
     * @return \CUCM\StructType\LSipProfile
     */
    public function setDtmfDbLevel($dtmfDbLevel = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XZzdtmfDbLevel::valueIsValid($dtmfDbLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dtmfDbLevel, implode(', ', \CUCM\EnumType\XZzdtmfDbLevel::getValidValues())), __LINE__);
        }
        $this->dtmfDbLevel = $dtmfDbLevel;
        return $this;
    }
    /**
     * Get callHoldRingback value
     * @return string|null
     */
    public function getCallHoldRingback()
    {
        return $this->callHoldRingback;
    }
    /**
     * Set callHoldRingback value
     * @uses \CUCM\EnumType\XZzpreff::valueIsValid()
     * @uses \CUCM\EnumType\XZzpreff::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callHoldRingback
     * @return \CUCM\StructType\LSipProfile
     */
    public function setCallHoldRingback($callHoldRingback = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XZzpreff::valueIsValid($callHoldRingback)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callHoldRingback, implode(', ', \CUCM\EnumType\XZzpreff::getValidValues())), __LINE__);
        }
        $this->callHoldRingback = $callHoldRingback;
        return $this;
    }
    /**
     * Get anonymousCallBlock value
     * @return string|null
     */
    public function getAnonymousCallBlock()
    {
        return $this->anonymousCallBlock;
    }
    /**
     * Set anonymousCallBlock value
     * @uses \CUCM\EnumType\XZzpreff::valueIsValid()
     * @uses \CUCM\EnumType\XZzpreff::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $anonymousCallBlock
     * @return \CUCM\StructType\LSipProfile
     */
    public function setAnonymousCallBlock($anonymousCallBlock = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XZzpreff::valueIsValid($anonymousCallBlock)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $anonymousCallBlock, implode(', ', \CUCM\EnumType\XZzpreff::getValidValues())), __LINE__);
        }
        $this->anonymousCallBlock = $anonymousCallBlock;
        return $this;
    }
    /**
     * Get callerIdBlock value
     * @return string|null
     */
    public function getCallerIdBlock()
    {
        return $this->callerIdBlock;
    }
    /**
     * Set callerIdBlock value
     * @uses \CUCM\EnumType\XZzpreff::valueIsValid()
     * @uses \CUCM\EnumType\XZzpreff::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callerIdBlock
     * @return \CUCM\StructType\LSipProfile
     */
    public function setCallerIdBlock($callerIdBlock = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XZzpreff::valueIsValid($callerIdBlock)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callerIdBlock, implode(', ', \CUCM\EnumType\XZzpreff::getValidValues())), __LINE__);
        }
        $this->callerIdBlock = $callerIdBlock;
        return $this;
    }
    /**
     * Get dndControl value
     * @return string|null
     */
    public function getDndControl()
    {
        return $this->dndControl;
    }
    /**
     * Set dndControl value
     * @uses \CUCM\EnumType\XZzdndcontrol::valueIsValid()
     * @uses \CUCM\EnumType\XZzdndcontrol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndControl
     * @return \CUCM\StructType\LSipProfile
     */
    public function setDndControl($dndControl = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XZzdndcontrol::valueIsValid($dndControl)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndControl, implode(', ', \CUCM\EnumType\XZzdndcontrol::getValidValues())), __LINE__);
        }
        $this->dndControl = $dndControl;
        return $this;
    }
    /**
     * Get telnetLevel value
     * @return string|null
     */
    public function getTelnetLevel()
    {
        return $this->telnetLevel;
    }
    /**
     * Set telnetLevel value
     * @uses \CUCM\EnumType\XTelnetLevel::valueIsValid()
     * @uses \CUCM\EnumType\XTelnetLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $telnetLevel
     * @return \CUCM\StructType\LSipProfile
     */
    public function setTelnetLevel($telnetLevel = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XTelnetLevel::valueIsValid($telnetLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $telnetLevel, implode(', ', \CUCM\EnumType\XTelnetLevel::getValidValues())), __LINE__);
        }
        $this->telnetLevel = $telnetLevel;
        return $this;
    }
    /**
     * Get timerKeepAlive value
     * @return string|null
     */
    public function getTimerKeepAlive()
    {
        return $this->timerKeepAlive;
    }
    /**
     * Set timerKeepAlive value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerKeepAlive
     * @return \CUCM\StructType\LSipProfile
     */
    public function setTimerKeepAlive($timerKeepAlive = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($timerKeepAlive)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerKeepAlive, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerKeepAlive = $timerKeepAlive;
        return $this;
    }
    /**
     * Get timerSubscribe value
     * @return string|null
     */
    public function getTimerSubscribe()
    {
        return $this->timerSubscribe;
    }
    /**
     * Set timerSubscribe value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerSubscribe
     * @return \CUCM\StructType\LSipProfile
     */
    public function setTimerSubscribe($timerSubscribe = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($timerSubscribe)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerSubscribe, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerSubscribe = $timerSubscribe;
        return $this;
    }
    /**
     * Get timerSubscribeDelta value
     * @return string|null
     */
    public function getTimerSubscribeDelta()
    {
        return $this->timerSubscribeDelta;
    }
    /**
     * Set timerSubscribeDelta value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerSubscribeDelta
     * @return \CUCM\StructType\LSipProfile
     */
    public function setTimerSubscribeDelta($timerSubscribeDelta = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($timerSubscribeDelta)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerSubscribeDelta, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerSubscribeDelta = $timerSubscribeDelta;
        return $this;
    }
    /**
     * Get maxRedirects value
     * @return string|null
     */
    public function getMaxRedirects()
    {
        return $this->maxRedirects;
    }
    /**
     * Set maxRedirects value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxRedirects
     * @return \CUCM\StructType\LSipProfile
     */
    public function setMaxRedirects($maxRedirects = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($maxRedirects)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxRedirects, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxRedirects = $maxRedirects;
        return $this;
    }
    /**
     * Get timerOffHookToFirstDigit value
     * @return string|null
     */
    public function getTimerOffHookToFirstDigit()
    {
        return $this->timerOffHookToFirstDigit;
    }
    /**
     * Set timerOffHookToFirstDigit value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerOffHookToFirstDigit
     * @return \CUCM\StructType\LSipProfile
     */
    public function setTimerOffHookToFirstDigit($timerOffHookToFirstDigit = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($timerOffHookToFirstDigit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerOffHookToFirstDigit, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerOffHookToFirstDigit = $timerOffHookToFirstDigit;
        return $this;
    }
    /**
     * Get callForwardUri value
     * @return string|null
     */
    public function getCallForwardUri()
    {
        return $this->callForwardUri;
    }
    /**
     * Set callForwardUri value
     * @param string $callForwardUri
     * @return \CUCM\StructType\LSipProfile
     */
    public function setCallForwardUri($callForwardUri = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callForwardUri) && strlen($callForwardUri) > 128) || (is_array($callForwardUri) && count($callForwardUri) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($callForwardUri) ? strlen($callForwardUri) : count($callForwardUri)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callForwardUri) && !is_string($callForwardUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callForwardUri)), __LINE__);
        }
        $this->callForwardUri = $callForwardUri;
        return $this;
    }
    /**
     * Get abbreviatedDialUri value
     * @return string|null
     */
    public function getAbbreviatedDialUri()
    {
        return $this->abbreviatedDialUri;
    }
    /**
     * Set abbreviatedDialUri value
     * @param string $abbreviatedDialUri
     * @return \CUCM\StructType\LSipProfile
     */
    public function setAbbreviatedDialUri($abbreviatedDialUri = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abbreviatedDialUri) && strlen($abbreviatedDialUri) > 128) || (is_array($abbreviatedDialUri) && count($abbreviatedDialUri) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($abbreviatedDialUri) ? strlen($abbreviatedDialUri) : count($abbreviatedDialUri)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abbreviatedDialUri) && !is_string($abbreviatedDialUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abbreviatedDialUri)), __LINE__);
        }
        $this->abbreviatedDialUri = $abbreviatedDialUri;
        return $this;
    }
    /**
     * Get confJointEnable value
     * @return string|null
     */
    public function getConfJointEnable()
    {
        return $this->confJointEnable;
    }
    /**
     * Set confJointEnable value
     * @param string $confJointEnable
     * @return \CUCM\StructType\LSipProfile
     */
    public function setConfJointEnable($confJointEnable = null)
    {
        // validation for constraint: pattern
        if (is_scalar($confJointEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $confJointEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($confJointEnable, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($confJointEnable) && !is_string($confJointEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($confJointEnable)), __LINE__);
        }
        $this->confJointEnable = $confJointEnable;
        return $this;
    }
    /**
     * Get rfc2543Hold value
     * @return string|null
     */
    public function getRfc2543Hold()
    {
        return $this->rfc2543Hold;
    }
    /**
     * Set rfc2543Hold value
     * @param string $rfc2543Hold
     * @return \CUCM\StructType\LSipProfile
     */
    public function setRfc2543Hold($rfc2543Hold = null)
    {
        // validation for constraint: pattern
        if (is_scalar($rfc2543Hold) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $rfc2543Hold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($rfc2543Hold, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rfc2543Hold) && !is_string($rfc2543Hold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rfc2543Hold)), __LINE__);
        }
        $this->rfc2543Hold = $rfc2543Hold;
        return $this;
    }
    /**
     * Get semiAttendedTransfer value
     * @return string|null
     */
    public function getSemiAttendedTransfer()
    {
        return $this->semiAttendedTransfer;
    }
    /**
     * Set semiAttendedTransfer value
     * @param string $semiAttendedTransfer
     * @return \CUCM\StructType\LSipProfile
     */
    public function setSemiAttendedTransfer($semiAttendedTransfer = null)
    {
        // validation for constraint: pattern
        if (is_scalar($semiAttendedTransfer) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $semiAttendedTransfer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($semiAttendedTransfer, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($semiAttendedTransfer) && !is_string($semiAttendedTransfer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($semiAttendedTransfer)), __LINE__);
        }
        $this->semiAttendedTransfer = $semiAttendedTransfer;
        return $this;
    }
    /**
     * Get enableVad value
     * @return string|null
     */
    public function getEnableVad()
    {
        return $this->enableVad;
    }
    /**
     * Set enableVad value
     * @param string $enableVad
     * @return \CUCM\StructType\LSipProfile
     */
    public function setEnableVad($enableVad = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableVad) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableVad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableVad, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableVad) && !is_string($enableVad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableVad)), __LINE__);
        }
        $this->enableVad = $enableVad;
        return $this;
    }
    /**
     * Get stutterMsgWaiting value
     * @return string|null
     */
    public function getStutterMsgWaiting()
    {
        return $this->stutterMsgWaiting;
    }
    /**
     * Set stutterMsgWaiting value
     * @param string $stutterMsgWaiting
     * @return \CUCM\StructType\LSipProfile
     */
    public function setStutterMsgWaiting($stutterMsgWaiting = null)
    {
        // validation for constraint: pattern
        if (is_scalar($stutterMsgWaiting) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $stutterMsgWaiting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($stutterMsgWaiting, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($stutterMsgWaiting) && !is_string($stutterMsgWaiting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stutterMsgWaiting)), __LINE__);
        }
        $this->stutterMsgWaiting = $stutterMsgWaiting;
        return $this;
    }
    /**
     * Get callStats value
     * @return string|null
     */
    public function getCallStats()
    {
        return $this->callStats;
    }
    /**
     * Set callStats value
     * @param string $callStats
     * @return \CUCM\StructType\LSipProfile
     */
    public function setCallStats($callStats = null)
    {
        // validation for constraint: pattern
        if (is_scalar($callStats) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $callStats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($callStats, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callStats) && !is_string($callStats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callStats)), __LINE__);
        }
        $this->callStats = $callStats;
        return $this;
    }
    /**
     * Get t38Invite value
     * @return string|null
     */
    public function getT38Invite()
    {
        return $this->t38Invite;
    }
    /**
     * Set t38Invite value
     * @param string $t38Invite
     * @return \CUCM\StructType\LSipProfile
     */
    public function setT38Invite($t38Invite = null)
    {
        // validation for constraint: pattern
        if (is_scalar($t38Invite) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $t38Invite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($t38Invite, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($t38Invite) && !is_string($t38Invite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($t38Invite)), __LINE__);
        }
        $this->t38Invite = $t38Invite;
        return $this;
    }
    /**
     * Get rerouteIncomingRequest value
     * @return string|null
     */
    public function getRerouteIncomingRequest()
    {
        return $this->rerouteIncomingRequest;
    }
    /**
     * Set rerouteIncomingRequest value
     * @uses \CUCM\EnumType\XSIPReroute::valueIsValid()
     * @uses \CUCM\EnumType\XSIPReroute::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rerouteIncomingRequest
     * @return \CUCM\StructType\LSipProfile
     */
    public function setRerouteIncomingRequest($rerouteIncomingRequest = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XSIPReroute::valueIsValid($rerouteIncomingRequest)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rerouteIncomingRequest, implode(', ', \CUCM\EnumType\XSIPReroute::getValidValues())), __LINE__);
        }
        $this->rerouteIncomingRequest = $rerouteIncomingRequest;
        return $this;
    }
    /**
     * Get resourcePriorityNamespaceListName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getResourcePriorityNamespaceListName()
    {
        return $this->resourcePriorityNamespaceListName;
    }
    /**
     * Set resourcePriorityNamespaceListName value
     * @param \CUCM\StructType\XFkType $resourcePriorityNamespaceListName
     * @return \CUCM\StructType\LSipProfile
     */
    public function setResourcePriorityNamespaceListName(\CUCM\StructType\XFkType $resourcePriorityNamespaceListName = null)
    {
        $this->resourcePriorityNamespaceListName = $resourcePriorityNamespaceListName;
        return $this;
    }
    /**
     * Get enableAnatForEarlyOfferCalls value
     * @return string|null
     */
    public function getEnableAnatForEarlyOfferCalls()
    {
        return $this->enableAnatForEarlyOfferCalls;
    }
    /**
     * Set enableAnatForEarlyOfferCalls value
     * @param string $enableAnatForEarlyOfferCalls
     * @return \CUCM\StructType\LSipProfile
     */
    public function setEnableAnatForEarlyOfferCalls($enableAnatForEarlyOfferCalls = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableAnatForEarlyOfferCalls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableAnatForEarlyOfferCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableAnatForEarlyOfferCalls, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableAnatForEarlyOfferCalls) && !is_string($enableAnatForEarlyOfferCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableAnatForEarlyOfferCalls)), __LINE__);
        }
        $this->enableAnatForEarlyOfferCalls = $enableAnatForEarlyOfferCalls;
        return $this;
    }
    /**
     * Get rsvpOverSip value
     * @return string|null
     */
    public function getRsvpOverSip()
    {
        return $this->rsvpOverSip;
    }
    /**
     * Set rsvpOverSip value
     * @uses \CUCM\EnumType\XRSVPOverSIP::valueIsValid()
     * @uses \CUCM\EnumType\XRSVPOverSIP::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rsvpOverSip
     * @return \CUCM\StructType\LSipProfile
     */
    public function setRsvpOverSip($rsvpOverSip = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XRSVPOverSIP::valueIsValid($rsvpOverSip)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rsvpOverSip, implode(', ', \CUCM\EnumType\XRSVPOverSIP::getValidValues())), __LINE__);
        }
        $this->rsvpOverSip = $rsvpOverSip;
        return $this;
    }
    /**
     * Get fallbackToLocalRsvp value
     * @return string|null
     */
    public function getFallbackToLocalRsvp()
    {
        return $this->fallbackToLocalRsvp;
    }
    /**
     * Set fallbackToLocalRsvp value
     * @param string $fallbackToLocalRsvp
     * @return \CUCM\StructType\LSipProfile
     */
    public function setFallbackToLocalRsvp($fallbackToLocalRsvp = null)
    {
        // validation for constraint: pattern
        if (is_scalar($fallbackToLocalRsvp) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $fallbackToLocalRsvp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($fallbackToLocalRsvp, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fallbackToLocalRsvp) && !is_string($fallbackToLocalRsvp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fallbackToLocalRsvp)), __LINE__);
        }
        $this->fallbackToLocalRsvp = $fallbackToLocalRsvp;
        return $this;
    }
    /**
     * Get sipRe11XxEnabled value
     * @return string|null
     */
    public function getSipRe11XxEnabled()
    {
        return $this->sipRe11XxEnabled;
    }
    /**
     * Set sipRe11XxEnabled value
     * @uses \CUCM\EnumType\XSIPRel1XXOptions::valueIsValid()
     * @uses \CUCM\EnumType\XSIPRel1XXOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipRe11XxEnabled
     * @return \CUCM\StructType\LSipProfile
     */
    public function setSipRe11XxEnabled($sipRe11XxEnabled = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XSIPRel1XXOptions::valueIsValid($sipRe11XxEnabled)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sipRe11XxEnabled, implode(', ', \CUCM\EnumType\XSIPRel1XXOptions::getValidValues())), __LINE__);
        }
        $this->sipRe11XxEnabled = $sipRe11XxEnabled;
        return $this;
    }
    /**
     * Get gClear value
     * @return string|null
     */
    public function getGClear()
    {
        return $this->gClear;
    }
    /**
     * Set gClear value
     * @uses \CUCM\EnumType\XGClear::valueIsValid()
     * @uses \CUCM\EnumType\XGClear::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gClear
     * @return \CUCM\StructType\LSipProfile
     */
    public function setGClear($gClear = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XGClear::valueIsValid($gClear)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $gClear, implode(', ', \CUCM\EnumType\XGClear::getValidValues())), __LINE__);
        }
        $this->gClear = $gClear;
        return $this;
    }
    /**
     * Get earlyOfferSupportForVoiceCall value
     * @return string|null
     */
    public function getEarlyOfferSupportForVoiceCall()
    {
        return $this->earlyOfferSupportForVoiceCall;
    }
    /**
     * Set earlyOfferSupportForVoiceCall value
     * @param string $earlyOfferSupportForVoiceCall
     * @return \CUCM\StructType\LSipProfile
     */
    public function setEarlyOfferSupportForVoiceCall($earlyOfferSupportForVoiceCall = null)
    {
        // validation for constraint: pattern
        if (is_scalar($earlyOfferSupportForVoiceCall) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $earlyOfferSupportForVoiceCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($earlyOfferSupportForVoiceCall, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($earlyOfferSupportForVoiceCall) && !is_string($earlyOfferSupportForVoiceCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($earlyOfferSupportForVoiceCall)), __LINE__);
        }
        $this->earlyOfferSupportForVoiceCall = $earlyOfferSupportForVoiceCall;
        return $this;
    }
    /**
     * Get sendRecvSDPInMidCallInvite value
     * @return string|null
     */
    public function getSendRecvSDPInMidCallInvite()
    {
        return $this->sendRecvSDPInMidCallInvite;
    }
    /**
     * Set sendRecvSDPInMidCallInvite value
     * @param string $sendRecvSDPInMidCallInvite
     * @return \CUCM\StructType\LSipProfile
     */
    public function setSendRecvSDPInMidCallInvite($sendRecvSDPInMidCallInvite = null)
    {
        // validation for constraint: pattern
        if (is_scalar($sendRecvSDPInMidCallInvite) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $sendRecvSDPInMidCallInvite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($sendRecvSDPInMidCallInvite, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sendRecvSDPInMidCallInvite) && !is_string($sendRecvSDPInMidCallInvite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendRecvSDPInMidCallInvite)), __LINE__);
        }
        $this->sendRecvSDPInMidCallInvite = $sendRecvSDPInMidCallInvite;
        return $this;
    }
    /**
     * Get enableOutboundOptionsPing value
     * @return string|null
     */
    public function getEnableOutboundOptionsPing()
    {
        return $this->enableOutboundOptionsPing;
    }
    /**
     * Set enableOutboundOptionsPing value
     * @param string $enableOutboundOptionsPing
     * @return \CUCM\StructType\LSipProfile
     */
    public function setEnableOutboundOptionsPing($enableOutboundOptionsPing = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableOutboundOptionsPing) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableOutboundOptionsPing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableOutboundOptionsPing, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableOutboundOptionsPing) && !is_string($enableOutboundOptionsPing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableOutboundOptionsPing)), __LINE__);
        }
        $this->enableOutboundOptionsPing = $enableOutboundOptionsPing;
        return $this;
    }
    /**
     * Get optionsPingIntervalWhenStatusOK value
     * @return string|null
     */
    public function getOptionsPingIntervalWhenStatusOK()
    {
        return $this->optionsPingIntervalWhenStatusOK;
    }
    /**
     * Set optionsPingIntervalWhenStatusOK value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $optionsPingIntervalWhenStatusOK
     * @return \CUCM\StructType\LSipProfile
     */
    public function setOptionsPingIntervalWhenStatusOK($optionsPingIntervalWhenStatusOK = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($optionsPingIntervalWhenStatusOK)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $optionsPingIntervalWhenStatusOK, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->optionsPingIntervalWhenStatusOK = $optionsPingIntervalWhenStatusOK;
        return $this;
    }
    /**
     * Get optionsPingIntervalWhenStatusNotOK value
     * @return string|null
     */
    public function getOptionsPingIntervalWhenStatusNotOK()
    {
        return $this->optionsPingIntervalWhenStatusNotOK;
    }
    /**
     * Set optionsPingIntervalWhenStatusNotOK value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $optionsPingIntervalWhenStatusNotOK
     * @return \CUCM\StructType\LSipProfile
     */
    public function setOptionsPingIntervalWhenStatusNotOK($optionsPingIntervalWhenStatusNotOK = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($optionsPingIntervalWhenStatusNotOK)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $optionsPingIntervalWhenStatusNotOK, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->optionsPingIntervalWhenStatusNotOK = $optionsPingIntervalWhenStatusNotOK;
        return $this;
    }
    /**
     * Get deliverConferenceBridgeIdentifier value
     * @return string|null
     */
    public function getDeliverConferenceBridgeIdentifier()
    {
        return $this->deliverConferenceBridgeIdentifier;
    }
    /**
     * Set deliverConferenceBridgeIdentifier value
     * @param string $deliverConferenceBridgeIdentifier
     * @return \CUCM\StructType\LSipProfile
     */
    public function setDeliverConferenceBridgeIdentifier($deliverConferenceBridgeIdentifier = null)
    {
        // validation for constraint: pattern
        if (is_scalar($deliverConferenceBridgeIdentifier) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $deliverConferenceBridgeIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($deliverConferenceBridgeIdentifier, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($deliverConferenceBridgeIdentifier) && !is_string($deliverConferenceBridgeIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliverConferenceBridgeIdentifier)), __LINE__);
        }
        $this->deliverConferenceBridgeIdentifier = $deliverConferenceBridgeIdentifier;
        return $this;
    }
    /**
     * Get sipOptionsRetryCount value
     * @return string|null
     */
    public function getSipOptionsRetryCount()
    {
        return $this->sipOptionsRetryCount;
    }
    /**
     * Set sipOptionsRetryCount value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipOptionsRetryCount
     * @return \CUCM\StructType\LSipProfile
     */
    public function setSipOptionsRetryCount($sipOptionsRetryCount = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($sipOptionsRetryCount)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sipOptionsRetryCount, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->sipOptionsRetryCount = $sipOptionsRetryCount;
        return $this;
    }
    /**
     * Get sipOptionsRetryTimer value
     * @return string|null
     */
    public function getSipOptionsRetryTimer()
    {
        return $this->sipOptionsRetryTimer;
    }
    /**
     * Set sipOptionsRetryTimer value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipOptionsRetryTimer
     * @return \CUCM\StructType\LSipProfile
     */
    public function setSipOptionsRetryTimer($sipOptionsRetryTimer = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($sipOptionsRetryTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sipOptionsRetryTimer, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->sipOptionsRetryTimer = $sipOptionsRetryTimer;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\LSipProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LSipProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
