<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LLine StructType
 * @subpackage Structs
 */
class LLine extends AbstractStructBase
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pattern;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The usage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The aarDestinationMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $aarDestinationMask;
    /**
     * The aarKeepCallHistory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $aarKeepCallHistory;
    /**
     * The aarVoiceMailEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $aarVoiceMailEnabled;
    /**
     * The callPickupGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $callPickupGroupName;
    /**
     * The autoAnswer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $autoAnswer;
    /**
     * The networkHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The alertingName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $alertingName;
    /**
     * The asciiAlertingName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $asciiAlertingName;
    /**
     * The presenceGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The shareLineAppearanceCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $shareLineAppearanceCssName;
    /**
     * The voiceMailProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $voiceMailProfileName;
    /**
     * The patternPrecedence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $patternPrecedence;
    /**
     * The releaseClause
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $releaseClause;
    /**
     * The hrDuration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hrDuration;
    /**
     * The hrInterval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hrInterval;
    /**
     * The cfaCssPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cfaCssPolicy;
    /**
     * The defaultActivatedDeviceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $defaultActivatedDeviceName;
    /**
     * The parkMonForwardNoRetrieveDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $parkMonForwardNoRetrieveDn;
    /**
     * The parkMonForwardNoRetrieveIntDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $parkMonForwardNoRetrieveIntDn;
    /**
     * The parkMonForwardNoRetrieveVmEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $parkMonForwardNoRetrieveVmEnabled;
    /**
     * The parkMonForwardNoRetrieveIntVmEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $parkMonForwardNoRetrieveIntVmEnabled;
    /**
     * The parkMonForwardNoRetrieveCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $parkMonForwardNoRetrieveCssName;
    /**
     * The parkMonForwardNoRetrieveIntCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $parkMonForwardNoRetrieveIntCssName;
    /**
     * The parkMonReversionTimer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parkMonReversionTimer;
    /**
     * The partyEntranceTone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $partyEntranceTone;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LLine
     * @uses LLine::setPattern()
     * @uses LLine::setDescription()
     * @uses LLine::setUsage()
     * @uses LLine::setRoutePartitionName()
     * @uses LLine::setAarNeighborhoodName()
     * @uses LLine::setAarDestinationMask()
     * @uses LLine::setAarKeepCallHistory()
     * @uses LLine::setAarVoiceMailEnabled()
     * @uses LLine::setCallPickupGroupName()
     * @uses LLine::setAutoAnswer()
     * @uses LLine::setNetworkHoldMohAudioSourceId()
     * @uses LLine::setUserHoldMohAudioSourceId()
     * @uses LLine::setAlertingName()
     * @uses LLine::setAsciiAlertingName()
     * @uses LLine::setPresenceGroupName()
     * @uses LLine::setShareLineAppearanceCssName()
     * @uses LLine::setVoiceMailProfileName()
     * @uses LLine::setPatternPrecedence()
     * @uses LLine::setReleaseClause()
     * @uses LLine::setHrDuration()
     * @uses LLine::setHrInterval()
     * @uses LLine::setCfaCssPolicy()
     * @uses LLine::setDefaultActivatedDeviceName()
     * @uses LLine::setParkMonForwardNoRetrieveDn()
     * @uses LLine::setParkMonForwardNoRetrieveIntDn()
     * @uses LLine::setParkMonForwardNoRetrieveVmEnabled()
     * @uses LLine::setParkMonForwardNoRetrieveIntVmEnabled()
     * @uses LLine::setParkMonForwardNoRetrieveCssName()
     * @uses LLine::setParkMonForwardNoRetrieveIntCssName()
     * @uses LLine::setParkMonReversionTimer()
     * @uses LLine::setPartyEntranceTone()
     * @uses LLine::setUuid()
     * @param string $pattern
     * @param string $description
     * @param string $usage
     * @param \CUCM\StructType\XFkType $routePartitionName
     * @param \CUCM\StructType\XFkType $aarNeighborhoodName
     * @param string $aarDestinationMask
     * @param string $aarKeepCallHistory
     * @param string $aarVoiceMailEnabled
     * @param \CUCM\StructType\XFkType $callPickupGroupName
     * @param string $autoAnswer
     * @param string $networkHoldMohAudioSourceId
     * @param string $userHoldMohAudioSourceId
     * @param string $alertingName
     * @param string $asciiAlertingName
     * @param \CUCM\StructType\XFkType $presenceGroupName
     * @param \CUCM\StructType\XFkType $shareLineAppearanceCssName
     * @param \CUCM\StructType\XFkType $voiceMailProfileName
     * @param string $patternPrecedence
     * @param string $releaseClause
     * @param string $hrDuration
     * @param string $hrInterval
     * @param string $cfaCssPolicy
     * @param \CUCM\StructType\XFkType $defaultActivatedDeviceName
     * @param string $parkMonForwardNoRetrieveDn
     * @param string $parkMonForwardNoRetrieveIntDn
     * @param string $parkMonForwardNoRetrieveVmEnabled
     * @param string $parkMonForwardNoRetrieveIntVmEnabled
     * @param \CUCM\StructType\XFkType $parkMonForwardNoRetrieveCssName
     * @param \CUCM\StructType\XFkType $parkMonForwardNoRetrieveIntCssName
     * @param string $parkMonReversionTimer
     * @param string $partyEntranceTone
     * @param string $uuid
     */
    public function __construct($pattern = null, $description = null, $usage = null, \CUCM\StructType\XFkType $routePartitionName = null, \CUCM\StructType\XFkType $aarNeighborhoodName = null, $aarDestinationMask = null, $aarKeepCallHistory = null, $aarVoiceMailEnabled = null, \CUCM\StructType\XFkType $callPickupGroupName = null, $autoAnswer = null, $networkHoldMohAudioSourceId = null, $userHoldMohAudioSourceId = null, $alertingName = null, $asciiAlertingName = null, \CUCM\StructType\XFkType $presenceGroupName = null, \CUCM\StructType\XFkType $shareLineAppearanceCssName = null, \CUCM\StructType\XFkType $voiceMailProfileName = null, $patternPrecedence = null, $releaseClause = null, $hrDuration = null, $hrInterval = null, $cfaCssPolicy = null, \CUCM\StructType\XFkType $defaultActivatedDeviceName = null, $parkMonForwardNoRetrieveDn = null, $parkMonForwardNoRetrieveIntDn = null, $parkMonForwardNoRetrieveVmEnabled = null, $parkMonForwardNoRetrieveIntVmEnabled = null, \CUCM\StructType\XFkType $parkMonForwardNoRetrieveCssName = null, \CUCM\StructType\XFkType $parkMonForwardNoRetrieveIntCssName = null, $parkMonReversionTimer = null, $partyEntranceTone = null, $uuid = null)
    {
        $this
            ->setPattern($pattern)
            ->setDescription($description)
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setAarDestinationMask($aarDestinationMask)
            ->setAarKeepCallHistory($aarKeepCallHistory)
            ->setAarVoiceMailEnabled($aarVoiceMailEnabled)
            ->setCallPickupGroupName($callPickupGroupName)
            ->setAutoAnswer($autoAnswer)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setAlertingName($alertingName)
            ->setAsciiAlertingName($asciiAlertingName)
            ->setPresenceGroupName($presenceGroupName)
            ->setShareLineAppearanceCssName($shareLineAppearanceCssName)
            ->setVoiceMailProfileName($voiceMailProfileName)
            ->setPatternPrecedence($patternPrecedence)
            ->setReleaseClause($releaseClause)
            ->setHrDuration($hrDuration)
            ->setHrInterval($hrInterval)
            ->setCfaCssPolicy($cfaCssPolicy)
            ->setDefaultActivatedDeviceName($defaultActivatedDeviceName)
            ->setParkMonForwardNoRetrieveDn($parkMonForwardNoRetrieveDn)
            ->setParkMonForwardNoRetrieveIntDn($parkMonForwardNoRetrieveIntDn)
            ->setParkMonForwardNoRetrieveVmEnabled($parkMonForwardNoRetrieveVmEnabled)
            ->setParkMonForwardNoRetrieveIntVmEnabled($parkMonForwardNoRetrieveIntVmEnabled)
            ->setParkMonForwardNoRetrieveCssName($parkMonForwardNoRetrieveCssName)
            ->setParkMonForwardNoRetrieveIntCssName($parkMonForwardNoRetrieveIntCssName)
            ->setParkMonReversionTimer($parkMonReversionTimer)
            ->setPartyEntranceTone($partyEntranceTone)
            ->setUuid($uuid);
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \CUCM\StructType\LLine
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\LLine
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get usage value
     * @return string|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @uses \CUCM\EnumType\XPatternUsage::valueIsValid()
     * @uses \CUCM\EnumType\XPatternUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usage
     * @return \CUCM\StructType\LLine
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPatternUsage::valueIsValid($usage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $usage, implode(', ', \CUCM\EnumType\XPatternUsage::getValidValues())), __LINE__);
        }
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \CUCM\StructType\XFkType $routePartitionName
     * @return \CUCM\StructType\LLine
     */
    public function setRoutePartitionName(\CUCM\StructType\XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \CUCM\StructType\XFkType $aarNeighborhoodName
     * @return \CUCM\StructType\LLine
     */
    public function setAarNeighborhoodName(\CUCM\StructType\XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get aarDestinationMask value
     * @return string|null
     */
    public function getAarDestinationMask()
    {
        return $this->aarDestinationMask;
    }
    /**
     * Set aarDestinationMask value
     * @param string $aarDestinationMask
     * @return \CUCM\StructType\LLine
     */
    public function setAarDestinationMask($aarDestinationMask = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aarDestinationMask) && strlen($aarDestinationMask) > 128) || (is_array($aarDestinationMask) && count($aarDestinationMask) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($aarDestinationMask) ? strlen($aarDestinationMask) : count($aarDestinationMask)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aarDestinationMask) && !is_string($aarDestinationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aarDestinationMask)), __LINE__);
        }
        $this->aarDestinationMask = $aarDestinationMask;
        return $this;
    }
    /**
     * Get aarKeepCallHistory value
     * @return string|null
     */
    public function getAarKeepCallHistory()
    {
        return $this->aarKeepCallHistory;
    }
    /**
     * Set aarKeepCallHistory value
     * @param string $aarKeepCallHistory
     * @return \CUCM\StructType\LLine
     */
    public function setAarKeepCallHistory($aarKeepCallHistory = null)
    {
        // validation for constraint: pattern
        if (is_scalar($aarKeepCallHistory) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $aarKeepCallHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($aarKeepCallHistory, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aarKeepCallHistory) && !is_string($aarKeepCallHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aarKeepCallHistory)), __LINE__);
        }
        $this->aarKeepCallHistory = $aarKeepCallHistory;
        return $this;
    }
    /**
     * Get aarVoiceMailEnabled value
     * @return string|null
     */
    public function getAarVoiceMailEnabled()
    {
        return $this->aarVoiceMailEnabled;
    }
    /**
     * Set aarVoiceMailEnabled value
     * @param string $aarVoiceMailEnabled
     * @return \CUCM\StructType\LLine
     */
    public function setAarVoiceMailEnabled($aarVoiceMailEnabled = null)
    {
        // validation for constraint: pattern
        if (is_scalar($aarVoiceMailEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $aarVoiceMailEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($aarVoiceMailEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aarVoiceMailEnabled) && !is_string($aarVoiceMailEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aarVoiceMailEnabled)), __LINE__);
        }
        $this->aarVoiceMailEnabled = $aarVoiceMailEnabled;
        return $this;
    }
    /**
     * Get callPickupGroupName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCallPickupGroupName()
    {
        return $this->callPickupGroupName;
    }
    /**
     * Set callPickupGroupName value
     * @param \CUCM\StructType\XFkType $callPickupGroupName
     * @return \CUCM\StructType\LLine
     */
    public function setCallPickupGroupName(\CUCM\StructType\XFkType $callPickupGroupName = null)
    {
        $this->callPickupGroupName = $callPickupGroupName;
        return $this;
    }
    /**
     * Get autoAnswer value
     * @return string|null
     */
    public function getAutoAnswer()
    {
        return $this->autoAnswer;
    }
    /**
     * Set autoAnswer value
     * @uses \CUCM\EnumType\XAutoAnswer::valueIsValid()
     * @uses \CUCM\EnumType\XAutoAnswer::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $autoAnswer
     * @return \CUCM\StructType\LLine
     */
    public function setAutoAnswer($autoAnswer = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XAutoAnswer::valueIsValid($autoAnswer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $autoAnswer, implode(', ', \CUCM\EnumType\XAutoAnswer::getValidValues())), __LINE__);
        }
        $this->autoAnswer = $autoAnswer;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * @return string|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return $this->networkHoldMohAudioSourceId;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * @uses \CUCM\EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \CUCM\EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkHoldMohAudioSourceId
     * @return \CUCM\StructType\LLine
     */
    public function setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XMOHAudioSourceId::valueIsValid($networkHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkHoldMohAudioSourceId, implode(', ', \CUCM\EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @uses \CUCM\EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \CUCM\EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userHoldMohAudioSourceId
     * @return \CUCM\StructType\LLine
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XMOHAudioSourceId::valueIsValid($userHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userHoldMohAudioSourceId, implode(', ', \CUCM\EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get alertingName value
     * @return string|null
     */
    public function getAlertingName()
    {
        return $this->alertingName;
    }
    /**
     * Set alertingName value
     * @param string $alertingName
     * @return \CUCM\StructType\LLine
     */
    public function setAlertingName($alertingName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($alertingName) && strlen($alertingName) > 50) || (is_array($alertingName) && count($alertingName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($alertingName) ? strlen($alertingName) : count($alertingName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($alertingName) && !is_string($alertingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alertingName)), __LINE__);
        }
        $this->alertingName = $alertingName;
        return $this;
    }
    /**
     * Get asciiAlertingName value
     * @return string|null
     */
    public function getAsciiAlertingName()
    {
        return $this->asciiAlertingName;
    }
    /**
     * Set asciiAlertingName value
     * @param string $asciiAlertingName
     * @return \CUCM\StructType\LLine
     */
    public function setAsciiAlertingName($asciiAlertingName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($asciiAlertingName) && strlen($asciiAlertingName) > 32) || (is_array($asciiAlertingName) && count($asciiAlertingName) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($asciiAlertingName) ? strlen($asciiAlertingName) : count($asciiAlertingName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($asciiAlertingName) && !is_string($asciiAlertingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($asciiAlertingName)), __LINE__);
        }
        $this->asciiAlertingName = $asciiAlertingName;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \CUCM\StructType\XFkType $presenceGroupName
     * @return \CUCM\StructType\LLine
     */
    public function setPresenceGroupName(\CUCM\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get shareLineAppearanceCssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getShareLineAppearanceCssName()
    {
        return $this->shareLineAppearanceCssName;
    }
    /**
     * Set shareLineAppearanceCssName value
     * @param \CUCM\StructType\XFkType $shareLineAppearanceCssName
     * @return \CUCM\StructType\LLine
     */
    public function setShareLineAppearanceCssName(\CUCM\StructType\XFkType $shareLineAppearanceCssName = null)
    {
        $this->shareLineAppearanceCssName = $shareLineAppearanceCssName;
        return $this;
    }
    /**
     * Get voiceMailProfileName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getVoiceMailProfileName()
    {
        return $this->voiceMailProfileName;
    }
    /**
     * Set voiceMailProfileName value
     * @param \CUCM\StructType\XFkType $voiceMailProfileName
     * @return \CUCM\StructType\LLine
     */
    public function setVoiceMailProfileName(\CUCM\StructType\XFkType $voiceMailProfileName = null)
    {
        $this->voiceMailProfileName = $voiceMailProfileName;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return string|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @uses \CUCM\EnumType\XPatternPrecedence::valueIsValid()
     * @uses \CUCM\EnumType\XPatternPrecedence::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $patternPrecedence
     * @return \CUCM\StructType\LLine
     */
    public function setPatternPrecedence($patternPrecedence = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPatternPrecedence::valueIsValid($patternPrecedence)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $patternPrecedence, implode(', ', \CUCM\EnumType\XPatternPrecedence::getValidValues())), __LINE__);
        }
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get releaseClause value
     * @return string|null
     */
    public function getReleaseClause()
    {
        return $this->releaseClause;
    }
    /**
     * Set releaseClause value
     * @uses \CUCM\EnumType\XReleaseCauseValue::valueIsValid()
     * @uses \CUCM\EnumType\XReleaseCauseValue::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $releaseClause
     * @return \CUCM\StructType\LLine
     */
    public function setReleaseClause($releaseClause = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XReleaseCauseValue::valueIsValid($releaseClause)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $releaseClause, implode(', ', \CUCM\EnumType\XReleaseCauseValue::getValidValues())), __LINE__);
        }
        $this->releaseClause = $releaseClause;
        return $this;
    }
    /**
     * Get hrDuration value
     * @return string|null
     */
    public function getHrDuration()
    {
        return $this->hrDuration;
    }
    /**
     * Set hrDuration value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hrDuration
     * @return \CUCM\StructType\LLine
     */
    public function setHrDuration($hrDuration = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($hrDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $hrDuration, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->hrDuration = $hrDuration;
        return $this;
    }
    /**
     * Get hrInterval value
     * @return string|null
     */
    public function getHrInterval()
    {
        return $this->hrInterval;
    }
    /**
     * Set hrInterval value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hrInterval
     * @return \CUCM\StructType\LLine
     */
    public function setHrInterval($hrInterval = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($hrInterval)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $hrInterval, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->hrInterval = $hrInterval;
        return $this;
    }
    /**
     * Get cfaCssPolicy value
     * @return string|null
     */
    public function getCfaCssPolicy()
    {
        return $this->cfaCssPolicy;
    }
    /**
     * Set cfaCssPolicy value
     * @uses \CUCM\EnumType\XCFACSSActivationPolicy::valueIsValid()
     * @uses \CUCM\EnumType\XCFACSSActivationPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cfaCssPolicy
     * @return \CUCM\StructType\LLine
     */
    public function setCfaCssPolicy($cfaCssPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XCFACSSActivationPolicy::valueIsValid($cfaCssPolicy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cfaCssPolicy, implode(', ', \CUCM\EnumType\XCFACSSActivationPolicy::getValidValues())), __LINE__);
        }
        $this->cfaCssPolicy = $cfaCssPolicy;
        return $this;
    }
    /**
     * Get defaultActivatedDeviceName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getDefaultActivatedDeviceName()
    {
        return $this->defaultActivatedDeviceName;
    }
    /**
     * Set defaultActivatedDeviceName value
     * @param \CUCM\StructType\XFkType $defaultActivatedDeviceName
     * @return \CUCM\StructType\LLine
     */
    public function setDefaultActivatedDeviceName(\CUCM\StructType\XFkType $defaultActivatedDeviceName = null)
    {
        $this->defaultActivatedDeviceName = $defaultActivatedDeviceName;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveDn value
     * @return string|null
     */
    public function getParkMonForwardNoRetrieveDn()
    {
        return $this->parkMonForwardNoRetrieveDn;
    }
    /**
     * Set parkMonForwardNoRetrieveDn value
     * @param string $parkMonForwardNoRetrieveDn
     * @return \CUCM\StructType\LLine
     */
    public function setParkMonForwardNoRetrieveDn($parkMonForwardNoRetrieveDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($parkMonForwardNoRetrieveDn) && strlen($parkMonForwardNoRetrieveDn) > 50) || (is_array($parkMonForwardNoRetrieveDn) && count($parkMonForwardNoRetrieveDn) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($parkMonForwardNoRetrieveDn) ? strlen($parkMonForwardNoRetrieveDn) : count($parkMonForwardNoRetrieveDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($parkMonForwardNoRetrieveDn) && !is_string($parkMonForwardNoRetrieveDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parkMonForwardNoRetrieveDn)), __LINE__);
        }
        $this->parkMonForwardNoRetrieveDn = $parkMonForwardNoRetrieveDn;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveIntDn value
     * @return string|null
     */
    public function getParkMonForwardNoRetrieveIntDn()
    {
        return $this->parkMonForwardNoRetrieveIntDn;
    }
    /**
     * Set parkMonForwardNoRetrieveIntDn value
     * @param string $parkMonForwardNoRetrieveIntDn
     * @return \CUCM\StructType\LLine
     */
    public function setParkMonForwardNoRetrieveIntDn($parkMonForwardNoRetrieveIntDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($parkMonForwardNoRetrieveIntDn) && strlen($parkMonForwardNoRetrieveIntDn) > 50) || (is_array($parkMonForwardNoRetrieveIntDn) && count($parkMonForwardNoRetrieveIntDn) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($parkMonForwardNoRetrieveIntDn) ? strlen($parkMonForwardNoRetrieveIntDn) : count($parkMonForwardNoRetrieveIntDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($parkMonForwardNoRetrieveIntDn) && !is_string($parkMonForwardNoRetrieveIntDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parkMonForwardNoRetrieveIntDn)), __LINE__);
        }
        $this->parkMonForwardNoRetrieveIntDn = $parkMonForwardNoRetrieveIntDn;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveVmEnabled value
     * @return string|null
     */
    public function getParkMonForwardNoRetrieveVmEnabled()
    {
        return $this->parkMonForwardNoRetrieveVmEnabled;
    }
    /**
     * Set parkMonForwardNoRetrieveVmEnabled value
     * @param string $parkMonForwardNoRetrieveVmEnabled
     * @return \CUCM\StructType\LLine
     */
    public function setParkMonForwardNoRetrieveVmEnabled($parkMonForwardNoRetrieveVmEnabled = null)
    {
        // validation for constraint: pattern
        if (is_scalar($parkMonForwardNoRetrieveVmEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $parkMonForwardNoRetrieveVmEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($parkMonForwardNoRetrieveVmEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($parkMonForwardNoRetrieveVmEnabled) && !is_string($parkMonForwardNoRetrieveVmEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parkMonForwardNoRetrieveVmEnabled)), __LINE__);
        }
        $this->parkMonForwardNoRetrieveVmEnabled = $parkMonForwardNoRetrieveVmEnabled;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveIntVmEnabled value
     * @return string|null
     */
    public function getParkMonForwardNoRetrieveIntVmEnabled()
    {
        return $this->parkMonForwardNoRetrieveIntVmEnabled;
    }
    /**
     * Set parkMonForwardNoRetrieveIntVmEnabled value
     * @param string $parkMonForwardNoRetrieveIntVmEnabled
     * @return \CUCM\StructType\LLine
     */
    public function setParkMonForwardNoRetrieveIntVmEnabled($parkMonForwardNoRetrieveIntVmEnabled = null)
    {
        // validation for constraint: pattern
        if (is_scalar($parkMonForwardNoRetrieveIntVmEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $parkMonForwardNoRetrieveIntVmEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($parkMonForwardNoRetrieveIntVmEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($parkMonForwardNoRetrieveIntVmEnabled) && !is_string($parkMonForwardNoRetrieveIntVmEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parkMonForwardNoRetrieveIntVmEnabled)), __LINE__);
        }
        $this->parkMonForwardNoRetrieveIntVmEnabled = $parkMonForwardNoRetrieveIntVmEnabled;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveCssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getParkMonForwardNoRetrieveCssName()
    {
        return $this->parkMonForwardNoRetrieveCssName;
    }
    /**
     * Set parkMonForwardNoRetrieveCssName value
     * @param \CUCM\StructType\XFkType $parkMonForwardNoRetrieveCssName
     * @return \CUCM\StructType\LLine
     */
    public function setParkMonForwardNoRetrieveCssName(\CUCM\StructType\XFkType $parkMonForwardNoRetrieveCssName = null)
    {
        $this->parkMonForwardNoRetrieveCssName = $parkMonForwardNoRetrieveCssName;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveIntCssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getParkMonForwardNoRetrieveIntCssName()
    {
        return $this->parkMonForwardNoRetrieveIntCssName;
    }
    /**
     * Set parkMonForwardNoRetrieveIntCssName value
     * @param \CUCM\StructType\XFkType $parkMonForwardNoRetrieveIntCssName
     * @return \CUCM\StructType\LLine
     */
    public function setParkMonForwardNoRetrieveIntCssName(\CUCM\StructType\XFkType $parkMonForwardNoRetrieveIntCssName = null)
    {
        $this->parkMonForwardNoRetrieveIntCssName = $parkMonForwardNoRetrieveIntCssName;
        return $this;
    }
    /**
     * Get parkMonReversionTimer value
     * @return string|null
     */
    public function getParkMonReversionTimer()
    {
        return $this->parkMonReversionTimer;
    }
    /**
     * Set parkMonReversionTimer value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $parkMonReversionTimer
     * @return \CUCM\StructType\LLine
     */
    public function setParkMonReversionTimer($parkMonReversionTimer = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($parkMonReversionTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $parkMonReversionTimer, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->parkMonReversionTimer = $parkMonReversionTimer;
        return $this;
    }
    /**
     * Get partyEntranceTone value
     * @return string|null
     */
    public function getPartyEntranceTone()
    {
        return $this->partyEntranceTone;
    }
    /**
     * Set partyEntranceTone value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $partyEntranceTone
     * @return \CUCM\StructType\LLine
     */
    public function setPartyEntranceTone($partyEntranceTone = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($partyEntranceTone)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $partyEntranceTone, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->partyEntranceTone = $partyEntranceTone;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\LLine
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
