<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LLicenseCapabilities StructType
 * @subpackage Structs
 */
class LLicenseCapabilities extends AbstractStructBase
{
    /**
     * The userid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userid;
    /**
     * The enableUps
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableUps;
    /**
     * The enableUpc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableUpc;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LLicenseCapabilities
     * @uses LLicenseCapabilities::setUserid()
     * @uses LLicenseCapabilities::setEnableUps()
     * @uses LLicenseCapabilities::setEnableUpc()
     * @uses LLicenseCapabilities::setUuid()
     * @param string $userid
     * @param string $enableUps
     * @param string $enableUpc
     * @param string $uuid
     */
    public function __construct($userid = null, $enableUps = null, $enableUpc = null, $uuid = null)
    {
        $this
            ->setUserid($userid)
            ->setEnableUps($enableUps)
            ->setEnableUpc($enableUpc)
            ->setUuid($uuid);
    }
    /**
     * Get userid value
     * @return string|null
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \CUCM\StructType\LLicenseCapabilities
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get enableUps value
     * @return string|null
     */
    public function getEnableUps()
    {
        return $this->enableUps;
    }
    /**
     * Set enableUps value
     * @param string $enableUps
     * @return \CUCM\StructType\LLicenseCapabilities
     */
    public function setEnableUps($enableUps = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableUps) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableUps, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableUps) && !is_string($enableUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableUps)), __LINE__);
        }
        $this->enableUps = $enableUps;
        return $this;
    }
    /**
     * Get enableUpc value
     * @return string|null
     */
    public function getEnableUpc()
    {
        return $this->enableUpc;
    }
    /**
     * Set enableUpc value
     * @param string $enableUpc
     * @return \CUCM\StructType\LLicenseCapabilities
     */
    public function setEnableUpc($enableUpc = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableUpc) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableUpc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableUpc, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableUpc) && !is_string($enableUpc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableUpc)), __LINE__);
        }
        $this->enableUpc = $enableUpc;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\LLicenseCapabilities
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LLicenseCapabilities
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
