<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LIpPhoneServicesParameter StructType
 * @subpackage Structs
 */
class LIpPhoneServicesParameter extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The displayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $displayName;
    /**
     * The default
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $default;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The paramRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $paramRequired;
    /**
     * The paramPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $paramPassword;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LIpPhoneServicesParameter
     * @uses LIpPhoneServicesParameter::setName()
     * @uses LIpPhoneServicesParameter::setDisplayName()
     * @uses LIpPhoneServicesParameter::setDefault()
     * @uses LIpPhoneServicesParameter::setDescription()
     * @uses LIpPhoneServicesParameter::setParamRequired()
     * @uses LIpPhoneServicesParameter::setParamPassword()
     * @uses LIpPhoneServicesParameter::setUuid()
     * @param string $name
     * @param string $displayName
     * @param string $default
     * @param string $description
     * @param string $paramRequired
     * @param string $paramPassword
     * @param string $uuid
     */
    public function __construct($name = null, $displayName = null, $default = null, $description = null, $paramRequired = null, $paramPassword = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDisplayName($displayName)
            ->setDefault($default)
            ->setDescription($description)
            ->setParamRequired($paramRequired)
            ->setParamPassword($paramPassword)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\LIpPhoneServicesParameter
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get displayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }
    /**
     * Set displayName value
     * @param string $displayName
     * @return \CUCM\StructType\LIpPhoneServicesParameter
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($displayName) && strlen($displayName) > 128) || (is_array($displayName) && count($displayName) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($displayName) ? strlen($displayName) : count($displayName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->displayName = $displayName;
        return $this;
    }
    /**
     * Get default value
     * @return string|null
     */
    public function getDefault()
    {
        return $this->default;
    }
    /**
     * Set default value
     * @param string $default
     * @return \CUCM\StructType\LIpPhoneServicesParameter
     */
    public function setDefault($default = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($default) && strlen($default) > 255) || (is_array($default) && count($default) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($default) ? strlen($default) : count($default)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($default) && !is_string($default)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($default)), __LINE__);
        }
        $this->default = $default;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\LIpPhoneServicesParameter
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get paramRequired value
     * @return string|null
     */
    public function getParamRequired()
    {
        return $this->paramRequired;
    }
    /**
     * Set paramRequired value
     * @param string $paramRequired
     * @return \CUCM\StructType\LIpPhoneServicesParameter
     */
    public function setParamRequired($paramRequired = null)
    {
        // validation for constraint: pattern
        if (is_scalar($paramRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $paramRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($paramRequired, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($paramRequired) && !is_string($paramRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paramRequired)), __LINE__);
        }
        $this->paramRequired = $paramRequired;
        return $this;
    }
    /**
     * Get paramPassword value
     * @return string|null
     */
    public function getParamPassword()
    {
        return $this->paramPassword;
    }
    /**
     * Set paramPassword value
     * @param string $paramPassword
     * @return \CUCM\StructType\LIpPhoneServicesParameter
     */
    public function setParamPassword($paramPassword = null)
    {
        // validation for constraint: pattern
        if (is_scalar($paramPassword) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $paramPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($paramPassword, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($paramPassword) && !is_string($paramPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paramPassword)), __LINE__);
        }
        $this->paramPassword = $paramPassword;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\LIpPhoneServicesParameter
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LIpPhoneServicesParameter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
