<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LButton StructType
 * @subpackage Structs
 */
class LButton extends AbstractStructBase
{
    /**
     * The feature
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $feature;
    /**
     * The label
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $label;
    /**
     * The buttonNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $buttonNumber;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LButton
     * @uses LButton::setFeature()
     * @uses LButton::setLabel()
     * @uses LButton::setButtonNumber()
     * @uses LButton::setUuid()
     * @param string $feature
     * @param string $label
     * @param string $buttonNumber
     * @param string $uuid
     */
    public function __construct($feature = null, $label = null, $buttonNumber = null, $uuid = null)
    {
        $this
            ->setFeature($feature)
            ->setLabel($label)
            ->setButtonNumber($buttonNumber)
            ->setUuid($uuid);
    }
    /**
     * Get feature value
     * @return string|null
     */
    public function getFeature()
    {
        return $this->feature;
    }
    /**
     * Set feature value
     * @uses \CUCM\EnumType\XFeature::valueIsValid()
     * @uses \CUCM\EnumType\XFeature::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $feature
     * @return \CUCM\StructType\LButton
     */
    public function setFeature($feature = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XFeature::valueIsValid($feature)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $feature, implode(', ', \CUCM\EnumType\XFeature::getValidValues())), __LINE__);
        }
        $this->feature = $feature;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \CUCM\StructType\LButton
     */
    public function setLabel($label = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($label) && strlen($label) > 50) || (is_array($label) && count($label) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($label) ? strlen($label) : count($label)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get buttonNumber value
     * @return string|null
     */
    public function getButtonNumber()
    {
        return $this->buttonNumber;
    }
    /**
     * Set buttonNumber value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $buttonNumber
     * @return \CUCM\StructType\LButton
     */
    public function setButtonNumber($buttonNumber = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($buttonNumber)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $buttonNumber, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->buttonNumber = $buttonNumber;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\LButton
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LButton
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
