<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LAarGroupRelationship StructType
 * @subpackage Structs
 */
class LAarGroupRelationship extends AbstractStructBase
{
    /**
     * The aarGroupFromName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $aarGroupFromName;
    /**
     * The aarGroupToName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $aarGroupToName;
    /**
     * The prefixDigit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $prefixDigit;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LAarGroupRelationship
     * @uses LAarGroupRelationship::setAarGroupFromName()
     * @uses LAarGroupRelationship::setAarGroupToName()
     * @uses LAarGroupRelationship::setPrefixDigit()
     * @uses LAarGroupRelationship::setUuid()
     * @param \CUCM\StructType\XFkType $aarGroupFromName
     * @param \CUCM\StructType\XFkType $aarGroupToName
     * @param string $prefixDigit
     * @param string $uuid
     */
    public function __construct(\CUCM\StructType\XFkType $aarGroupFromName = null, \CUCM\StructType\XFkType $aarGroupToName = null, $prefixDigit = null, $uuid = null)
    {
        $this
            ->setAarGroupFromName($aarGroupFromName)
            ->setAarGroupToName($aarGroupToName)
            ->setPrefixDigit($prefixDigit)
            ->setUuid($uuid);
    }
    /**
     * Get aarGroupFromName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getAarGroupFromName()
    {
        return $this->aarGroupFromName;
    }
    /**
     * Set aarGroupFromName value
     * @param \CUCM\StructType\XFkType $aarGroupFromName
     * @return \CUCM\StructType\LAarGroupRelationship
     */
    public function setAarGroupFromName(\CUCM\StructType\XFkType $aarGroupFromName = null)
    {
        $this->aarGroupFromName = $aarGroupFromName;
        return $this;
    }
    /**
     * Get aarGroupToName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getAarGroupToName()
    {
        return $this->aarGroupToName;
    }
    /**
     * Set aarGroupToName value
     * @param \CUCM\StructType\XFkType $aarGroupToName
     * @return \CUCM\StructType\LAarGroupRelationship
     */
    public function setAarGroupToName(\CUCM\StructType\XFkType $aarGroupToName = null)
    {
        $this->aarGroupToName = $aarGroupToName;
        return $this;
    }
    /**
     * Get prefixDigit value
     * @return string|null
     */
    public function getPrefixDigit()
    {
        return $this->prefixDigit;
    }
    /**
     * Set prefixDigit value
     * @param string $prefixDigit
     * @return \CUCM\StructType\LAarGroupRelationship
     */
    public function setPrefixDigit($prefixDigit = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($prefixDigit) && strlen($prefixDigit) > 32) || (is_array($prefixDigit) && count($prefixDigit) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($prefixDigit) ? strlen($prefixDigit) : count($prefixDigit)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($prefixDigit) && !is_string($prefixDigit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefixDigit)), __LINE__);
        }
        $this->prefixDigit = $prefixDigit;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\LAarGroupRelationship
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LAarGroupRelationship
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
