<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LAarGroupMatrix StructType
 * @subpackage Structs
 */
class LAarGroupMatrix extends AbstractStructBase
{
    /**
     * The prefixDigit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $prefixDigit;
    /**
     * The aarGroupFromName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $aarGroupFromName;
    /**
     * The aarGroupToName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $aarGroupToName;
    /**
     * Constructor method for LAarGroupMatrix
     * @uses LAarGroupMatrix::setPrefixDigit()
     * @uses LAarGroupMatrix::setAarGroupFromName()
     * @uses LAarGroupMatrix::setAarGroupToName()
     * @param string $prefixDigit
     * @param \CUCM\StructType\XFkType $aarGroupFromName
     * @param \CUCM\StructType\XFkType $aarGroupToName
     */
    public function __construct($prefixDigit = null, \CUCM\StructType\XFkType $aarGroupFromName = null, \CUCM\StructType\XFkType $aarGroupToName = null)
    {
        $this
            ->setPrefixDigit($prefixDigit)
            ->setAarGroupFromName($aarGroupFromName)
            ->setAarGroupToName($aarGroupToName);
    }
    /**
     * Get prefixDigit value
     * @return string|null
     */
    public function getPrefixDigit()
    {
        return $this->prefixDigit;
    }
    /**
     * Set prefixDigit value
     * @param string $prefixDigit
     * @return \CUCM\StructType\LAarGroupMatrix
     */
    public function setPrefixDigit($prefixDigit = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($prefixDigit) && strlen($prefixDigit) > 255) || (is_array($prefixDigit) && count($prefixDigit) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($prefixDigit) ? strlen($prefixDigit) : count($prefixDigit)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($prefixDigit) && !is_string($prefixDigit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefixDigit)), __LINE__);
        }
        $this->prefixDigit = $prefixDigit;
        return $this;
    }
    /**
     * Get aarGroupFromName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getAarGroupFromName()
    {
        return $this->aarGroupFromName;
    }
    /**
     * Set aarGroupFromName value
     * @param \CUCM\StructType\XFkType $aarGroupFromName
     * @return \CUCM\StructType\LAarGroupMatrix
     */
    public function setAarGroupFromName(\CUCM\StructType\XFkType $aarGroupFromName = null)
    {
        $this->aarGroupFromName = $aarGroupFromName;
        return $this;
    }
    /**
     * Get aarGroupToName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getAarGroupToName()
    {
        return $this->aarGroupToName;
    }
    /**
     * Set aarGroupToName value
     * @param \CUCM\StructType\XFkType $aarGroupToName
     * @return \CUCM\StructType\LAarGroupMatrix
     */
    public function setAarGroupToName(\CUCM\StructType\XFkType $aarGroupToName = null)
    {
        $this->aarGroupToName = $aarGroupToName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LAarGroupMatrix
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
