<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetNumDevicesReq StructType
 * Meta informations extracted from the WSDL
 * - documentation: This method returns the number of devices found. The caller specifies what class of device they want counted.
 * @subpackage Structs
 */
class GetNumDevicesReq extends APIRequest
{
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - documentation: The class of device that is to be counted. Cannot be null.
     * - nillable: false
     * @var string
     */
    public $class;
    /**
     * Constructor method for GetNumDevicesReq
     * @uses GetNumDevicesReq::setClass()
     * @param string $class
     */
    public function __construct($class = null)
    {
        $this
            ->setClass($class);
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses \CUCM\EnumType\XClass::valueIsValid()
     * @uses \CUCM\EnumType\XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return \CUCM\StructType\GetNumDevicesReq
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $class, implode(', ', \CUCM\EnumType\XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\GetNumDevicesReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
