<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetInterClusterServiceProfileReq StructType
 * @subpackage Structs
 */
class GetInterClusterServiceProfileReq extends AbstractStructBase
{
    /**
     * The interClusterService
     * Meta informations extracted from the WSDL
     * - default: EMCC
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $interClusterService;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The returnedTags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \CUCM\StructType\RInterClusterServiceProfile
     */
    public $returnedTags;
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for GetInterClusterServiceProfileReq
     * @uses GetInterClusterServiceProfileReq::setInterClusterService()
     * @uses GetInterClusterServiceProfileReq::setUuid()
     * @uses GetInterClusterServiceProfileReq::setReturnedTags()
     * @uses GetInterClusterServiceProfileReq::setSequence()
     * @param string $interClusterService
     * @param string $uuid
     * @param \CUCM\StructType\RInterClusterServiceProfile $returnedTags
     * @param int $sequence
     */
    public function __construct($interClusterService = 'EMCC', $uuid = null, \CUCM\StructType\RInterClusterServiceProfile $returnedTags = null, $sequence = null)
    {
        $this
            ->setInterClusterService($interClusterService)
            ->setUuid($uuid)
            ->setReturnedTags($returnedTags)
            ->setSequence($sequence);
    }
    /**
     * Get interClusterService value
     * @return string
     */
    public function getInterClusterService()
    {
        return $this->interClusterService;
    }
    /**
     * Set interClusterService value
     * @uses \CUCM\EnumType\XInterClusterService::valueIsValid()
     * @uses \CUCM\EnumType\XInterClusterService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $interClusterService
     * @return \CUCM\StructType\GetInterClusterServiceProfileReq
     */
    public function setInterClusterService($interClusterService = 'EMCC')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInterClusterService::valueIsValid($interClusterService)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $interClusterService, implode(', ', \CUCM\EnumType\XInterClusterService::getValidValues())), __LINE__);
        }
        $this->interClusterService = $interClusterService;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\GetInterClusterServiceProfileReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get returnedTags value
     * @return \CUCM\StructType\RInterClusterServiceProfile|null
     */
    public function getReturnedTags()
    {
        return $this->returnedTags;
    }
    /**
     * Set returnedTags value
     * @param \CUCM\StructType\RInterClusterServiceProfile $returnedTags
     * @return \CUCM\StructType\GetInterClusterServiceProfileReq
     */
    public function setReturnedTags(\CUCM\StructType\RInterClusterServiceProfile $returnedTags = null)
    {
        $this->returnedTags = $returnedTags;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \CUCM\StructType\GetInterClusterServiceProfileReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\GetInterClusterServiceProfileReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
