<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEmccFeatureConfigReq StructType
 * @subpackage Structs
 */
class GetEmccFeatureConfigReq extends AbstractStructBase
{
    /**
     * The parameterName
     * Meta informations extracted from the WSDL
     * - documentation: Name of the Emcc Parameter
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $parameterName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The returnedTags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \CUCM\StructType\REmccFeatureConfig
     */
    public $returnedTags;
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for GetEmccFeatureConfigReq
     * @uses GetEmccFeatureConfigReq::setParameterName()
     * @uses GetEmccFeatureConfigReq::setUuid()
     * @uses GetEmccFeatureConfigReq::setReturnedTags()
     * @uses GetEmccFeatureConfigReq::setSequence()
     * @param string $parameterName
     * @param string $uuid
     * @param \CUCM\StructType\REmccFeatureConfig $returnedTags
     * @param int $sequence
     */
    public function __construct($parameterName = null, $uuid = null, \CUCM\StructType\REmccFeatureConfig $returnedTags = null, $sequence = null)
    {
        $this
            ->setParameterName($parameterName)
            ->setUuid($uuid)
            ->setReturnedTags($returnedTags)
            ->setSequence($sequence);
    }
    /**
     * Get parameterName value
     * @return string
     */
    public function getParameterName()
    {
        return $this->parameterName;
    }
    /**
     * Set parameterName value
     * @param string $parameterName
     * @return \CUCM\StructType\GetEmccFeatureConfigReq
     */
    public function setParameterName($parameterName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($parameterName) && strlen($parameterName) > 50) || (is_array($parameterName) && count($parameterName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($parameterName) ? strlen($parameterName) : count($parameterName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($parameterName) && !is_string($parameterName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parameterName)), __LINE__);
        }
        $this->parameterName = $parameterName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\GetEmccFeatureConfigReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get returnedTags value
     * @return \CUCM\StructType\REmccFeatureConfig|null
     */
    public function getReturnedTags()
    {
        return $this->returnedTags;
    }
    /**
     * Set returnedTags value
     * @param \CUCM\StructType\REmccFeatureConfig $returnedTags
     * @return \CUCM\StructType\GetEmccFeatureConfigReq
     */
    public function setReturnedTags(\CUCM\StructType\REmccFeatureConfig $returnedTags = null)
    {
        $this->returnedTags = $returnedTags;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \CUCM\StructType\GetEmccFeatureConfigReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\GetEmccFeatureConfigReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
