<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for gateKeeperInfo StructType
 * @subpackage Structs
 */
class GateKeeperInfo extends AbstractStructBase
{
    /**
     * The gateKeeperName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $gateKeeperName;
    /**
     * The e164
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $e164;
    /**
     * The technologyPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $technologyPrefix;
    /**
     * The zone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $zone;
    /**
     * The gateKeeper
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $gateKeeper;
    /**
     * The terminalType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $terminalType;
    /**
     * Constructor method for gateKeeperInfo
     * @uses GateKeeperInfo::setGateKeeperName()
     * @uses GateKeeperInfo::setE164()
     * @uses GateKeeperInfo::setTechnologyPrefix()
     * @uses GateKeeperInfo::setZone()
     * @uses GateKeeperInfo::setGateKeeper()
     * @uses GateKeeperInfo::setTerminalType()
     * @param \CUCM\StructType\XFkType $gateKeeperName
     * @param string $e164
     * @param string $technologyPrefix
     * @param string $zone
     * @param \CUCM\StructType\XFkType $gateKeeper
     * @param string $terminalType
     */
    public function __construct(\CUCM\StructType\XFkType $gateKeeperName = null, $e164 = null, $technologyPrefix = null, $zone = null, \CUCM\StructType\XFkType $gateKeeper = null, $terminalType = null)
    {
        $this
            ->setGateKeeperName($gateKeeperName)
            ->setE164($e164)
            ->setTechnologyPrefix($technologyPrefix)
            ->setZone($zone)
            ->setGateKeeper($gateKeeper)
            ->setTerminalType($terminalType);
    }
    /**
     * Get gateKeeperName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getGateKeeperName()
    {
        return $this->gateKeeperName;
    }
    /**
     * Set gateKeeperName value
     * @param \CUCM\StructType\XFkType $gateKeeperName
     * @return \CUCM\StructType\GateKeeperInfo
     */
    public function setGateKeeperName(\CUCM\StructType\XFkType $gateKeeperName = null)
    {
        $this->gateKeeperName = $gateKeeperName;
        return $this;
    }
    /**
     * Get e164 value
     * @return string|null
     */
    public function getE164()
    {
        return $this->e164;
    }
    /**
     * Set e164 value
     * @param string $e164
     * @return \CUCM\StructType\GateKeeperInfo
     */
    public function setE164($e164 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($e164) && strlen($e164) > 50) || (is_array($e164) && count($e164) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($e164) ? strlen($e164) : count($e164)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($e164) && !is_string($e164)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($e164)), __LINE__);
        }
        $this->e164 = $e164;
        return $this;
    }
    /**
     * Get technologyPrefix value
     * @return string|null
     */
    public function getTechnologyPrefix()
    {
        return $this->technologyPrefix;
    }
    /**
     * Set technologyPrefix value
     * @param string $technologyPrefix
     * @return \CUCM\StructType\GateKeeperInfo
     */
    public function setTechnologyPrefix($technologyPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($technologyPrefix) && strlen($technologyPrefix) > 50) || (is_array($technologyPrefix) && count($technologyPrefix) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($technologyPrefix) ? strlen($technologyPrefix) : count($technologyPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($technologyPrefix) && !is_string($technologyPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($technologyPrefix)), __LINE__);
        }
        $this->technologyPrefix = $technologyPrefix;
        return $this;
    }
    /**
     * Get zone value
     * @return string|null
     */
    public function getZone()
    {
        return $this->zone;
    }
    /**
     * Set zone value
     * @param string $zone
     * @return \CUCM\StructType\GateKeeperInfo
     */
    public function setZone($zone = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($zone) && strlen($zone) > 50) || (is_array($zone) && count($zone) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($zone) ? strlen($zone) : count($zone)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($zone) && !is_string($zone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zone)), __LINE__);
        }
        $this->zone = $zone;
        return $this;
    }
    /**
     * Get gateKeeper value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getGateKeeper()
    {
        return $this->gateKeeper;
    }
    /**
     * Set gateKeeper value
     * @param \CUCM\StructType\XFkType $gateKeeper
     * @return \CUCM\StructType\GateKeeperInfo
     */
    public function setGateKeeper(\CUCM\StructType\XFkType $gateKeeper = null)
    {
        $this->gateKeeper = $gateKeeper;
        return $this;
    }
    /**
     * Get terminalType value
     * @return string|null
     */
    public function getTerminalType()
    {
        return $this->terminalType;
    }
    /**
     * Set terminalType value
     * @uses \CUCM\EnumType\XTerminal::valueIsValid()
     * @uses \CUCM\EnumType\XTerminal::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $terminalType
     * @return \CUCM\StructType\GateKeeperInfo
     */
    public function setTerminalType($terminalType = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XTerminal::valueIsValid($terminalType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $terminalType, implode(', ', \CUCM\EnumType\XTerminal::getValidValues())), __LINE__);
        }
        $this->terminalType = $terminalType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\GateKeeperInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
