<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for features StructType
 * @subpackage Structs
 */
class Features extends AbstractStructBase
{
    /**
     * The feature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \CUCM\StructType\XFeatureControlConfig[]
     */
    public $feature;
    /**
     * Constructor method for features
     * @uses Features::setFeature()
     * @param \CUCM\StructType\XFeatureControlConfig[] $feature
     */
    public function __construct(array $feature = array())
    {
        $this
            ->setFeature($feature);
    }
    /**
     * Get feature value
     * @return \CUCM\StructType\XFeatureControlConfig[]|null
     */
    public function getFeature()
    {
        return $this->feature;
    }
    /**
     * Set feature value
     * @throws \InvalidArgumentException
     * @param \CUCM\StructType\XFeatureControlConfig[] $feature
     * @return \CUCM\StructType\Features
     */
    public function setFeature(array $feature = array())
    {
        foreach ($feature as $featuresFeatureItem) {
            // validation for constraint: itemType
            if (!$featuresFeatureItem instanceof \CUCM\StructType\XFeatureControlConfig) {
                throw new \InvalidArgumentException(sprintf('The feature property can only contain items of \CUCM\StructType\XFeatureControlConfig, "%s" given', is_object($featuresFeatureItem) ? get_class($featuresFeatureItem) : gettype($featuresFeatureItem)), __LINE__);
            }
        }
        $this->feature = $feature;
        return $this;
    }
    /**
     * Add item to feature value
     * @throws \InvalidArgumentException
     * @param \CUCM\StructType\XFeatureControlConfig $item
     * @return \CUCM\StructType\Features
     */
    public function addToFeature(\CUCM\StructType\XFeatureControlConfig $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CUCM\StructType\XFeatureControlConfig) {
            throw new \InvalidArgumentException(sprintf('The feature property can only contain items of \CUCM\StructType\XFeatureControlConfig, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->feature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\Features
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
