<?php

namespace CUCM\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for List ServiceType
 * @subpackage Services
 */
class _List extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named listSipProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListSipProfileReq $axlParams
     * @return \CUCM\StructType\ListSipProfileRes|bool
     */
    public function listSipProfile(\CUCM\StructType\ListSipProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listSipProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listSipTrunkSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListSipTrunkSecurityProfileReq $axlParams
     * @return \CUCM\StructType\ListSipTrunkSecurityProfileRes|bool
     */
    public function listSipTrunkSecurityProfile(\CUCM\StructType\ListSipTrunkSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listSipTrunkSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listTimePeriod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListTimePeriodReq $axlParams
     * @return \CUCM\StructType\ListTimePeriodRes|bool
     */
    public function listTimePeriod(\CUCM\StructType\ListTimePeriodReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listTimePeriod($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listTimeSchedule
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListTimeScheduleReq $axlParams
     * @return \CUCM\StructType\ListTimeScheduleRes|bool
     */
    public function listTimeSchedule(\CUCM\StructType\ListTimeScheduleReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listTimeSchedule($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listTodAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListTodAccessReq $axlParams
     * @return \CUCM\StructType\ListTodAccessRes|bool
     */
    public function listTodAccess(\CUCM\StructType\ListTodAccessReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listTodAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listVoiceMailPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListVoiceMailPilotReq $axlParams
     * @return \CUCM\StructType\ListVoiceMailPilotRes|bool
     */
    public function listVoiceMailPilot(\CUCM\StructType\ListVoiceMailPilotReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listVoiceMailPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listProcessNode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListProcessNodeReq $axlParams
     * @return \CUCM\StructType\ListProcessNodeRes|bool
     */
    public function listProcessNode(\CUCM\StructType\ListProcessNodeReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listProcessNode($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCallerFilterList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListCallerFilterListReq $axlParams
     * @return \CUCM\StructType\ListCallerFilterListRes|bool
     */
    public function listCallerFilterList(\CUCM\StructType\ListCallerFilterListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCallerFilterList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listRoutePartition
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListRoutePartitionReq $axlParams
     * @return \CUCM\StructType\ListRoutePartitionRes|bool
     */
    public function listRoutePartition(\CUCM\StructType\ListRoutePartitionReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listRoutePartition($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListCssReq $axlParams
     * @return \CUCM\StructType\ListCssRes|bool
     */
    public function listCss(\CUCM\StructType\ListCssReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCss($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCallManager
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListCallManagerReq $axlParams
     * @return \CUCM\StructType\ListCallManagerRes|bool
     */
    public function listCallManager(\CUCM\StructType\ListCallManagerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCallManager($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listMediaResourceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListMediaResourceGroupReq $axlParams
     * @return \CUCM\StructType\ListMediaResourceGroupRes|bool
     */
    public function listMediaResourceGroup(\CUCM\StructType\ListMediaResourceGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listMediaResourceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listMediaResourceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListMediaResourceListReq $axlParams
     * @return \CUCM\StructType\ListMediaResourceListRes|bool
     */
    public function listMediaResourceList(\CUCM\StructType\ListMediaResourceListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listMediaResourceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listRegion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListRegionReq $axlParams
     * @return \CUCM\StructType\ListRegionRes|bool
     */
    public function listRegion(\CUCM\StructType\ListRegionReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listRegion($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listAarGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListAarGroupReq $axlParams
     * @return \CUCM\StructType\ListAarGroupRes|bool
     */
    public function listAarGroup(\CUCM\StructType\ListAarGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listAarGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listPhysicalLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListPhysicalLocationReq $axlParams
     * @return \CUCM\StructType\ListPhysicalLocationRes|bool
     */
    public function listPhysicalLocation(\CUCM\StructType\ListPhysicalLocationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listPhysicalLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listRouteGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListRouteGroupReq $axlParams
     * @return \CUCM\StructType\ListRouteGroupRes|bool
     */
    public function listRouteGroup(\CUCM\StructType\ListRouteGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listRouteGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDevicePool
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListDevicePoolReq $axlParams
     * @return \CUCM\StructType\ListDevicePoolRes|bool
     */
    public function listDevicePool(\CUCM\StructType\ListDevicePoolReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDevicePool($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDeviceMobilityGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListDeviceMobilityGroupReq $axlParams
     * @return \CUCM\StructType\ListDeviceMobilityGroupRes|bool
     */
    public function listDeviceMobilityGroup(\CUCM\StructType\ListDeviceMobilityGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDeviceMobilityGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListLocationReq $axlParams
     * @return \CUCM\StructType\ListLocationRes|bool
     */
    public function listLocation(\CUCM\StructType\ListLocationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listSoftKeyTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListSoftKeyTemplateReq $axlParams
     * @return \CUCM\StructType\ListSoftKeyTemplateRes|bool
     */
    public function listSoftKeyTemplate(\CUCM\StructType\ListSoftKeyTemplateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listSoftKeyTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listTranscoder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListTranscoderReq $axlParams
     * @return \CUCM\StructType\ListTranscoderRes|bool
     */
    public function listTranscoder(\CUCM\StructType\ListTranscoderReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listTranscoder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCommonDeviceConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListCommonDeviceConfigReq $axlParams
     * @return \CUCM\StructType\ListCommonDeviceConfigRes|bool
     */
    public function listCommonDeviceConfig(\CUCM\StructType\ListCommonDeviceConfigReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCommonDeviceConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listResourcePriorityNamespace
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListResourcePriorityNamespaceReq $axlParams
     * @return \CUCM\StructType\ListResourcePriorityNamespaceRes|bool
     */
    public function listResourcePriorityNamespace(\CUCM\StructType\ListResourcePriorityNamespaceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listResourcePriorityNamespace($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listResourcePriorityNamespaceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListResourcePriorityNamespaceListReq $axlParams
     * @return \CUCM\StructType\ListResourcePriorityNamespaceListRes|bool
     */
    public function listResourcePriorityNamespaceList(\CUCM\StructType\ListResourcePriorityNamespaceListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listResourcePriorityNamespaceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDeviceMobility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListDeviceMobilityReq $axlParams
     * @return \CUCM\StructType\ListDeviceMobilityRes|bool
     */
    public function listDeviceMobility(\CUCM\StructType\ListDeviceMobilityReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDeviceMobility($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCmcInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListCmcInfoReq $axlParams
     * @return \CUCM\StructType\ListCmcInfoRes|bool
     */
    public function listCmcInfo(\CUCM\StructType\ListCmcInfoReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCmcInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCredentialPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListCredentialPolicyReq $axlParams
     * @return \CUCM\StructType\ListCredentialPolicyRes|bool
     */
    public function listCredentialPolicy(\CUCM\StructType\ListCredentialPolicyReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCredentialPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listFacInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListFacInfoReq $axlParams
     * @return \CUCM\StructType\ListFacInfoRes|bool
     */
    public function listFacInfo(\CUCM\StructType\ListFacInfoReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listFacInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listHuntList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListHuntListReq $axlParams
     * @return \CUCM\StructType\ListHuntListRes|bool
     */
    public function listHuntList(\CUCM\StructType\ListHuntListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listHuntList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listIvrUserLocale
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListIvrUserLocaleReq $axlParams
     * @return \CUCM\StructType\ListIvrUserLocaleRes|bool
     */
    public function listIvrUserLocale(\CUCM\StructType\ListIvrUserLocaleReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listIvrUserLocale($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listLineGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListLineGroupReq $axlParams
     * @return \CUCM\StructType\ListLineGroupRes|bool
     */
    public function listLineGroup(\CUCM\StructType\ListLineGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listLineGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listRecordingProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListRecordingProfileReq $axlParams
     * @return \CUCM\StructType\ListRecordingProfileRes|bool
     */
    public function listRecordingProfile(\CUCM\StructType\ListRecordingProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listRecordingProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listRouteFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListRouteFilterReq $axlParams
     * @return \CUCM\StructType\ListRouteFilterRes|bool
     */
    public function listRouteFilter(\CUCM\StructType\ListRouteFilterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listRouteFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCallManagerGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListCallManagerGroupReq $axlParams
     * @return \CUCM\StructType\ListCallManagerGroupRes|bool
     */
    public function listCallManagerGroup(\CUCM\StructType\ListCallManagerGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCallManagerGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listUserGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListUserGroupReq $axlParams
     * @return \CUCM\StructType\ListUserGroupRes|bool
     */
    public function listUserGroup(\CUCM\StructType\ListUserGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listUserGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDialPlan
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListDialPlanReq $axlParams
     * @return \CUCM\StructType\ListDialPlanRes|bool
     */
    public function listDialPlan(\CUCM\StructType\ListDialPlanReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDialPlan($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDialPlanTag
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListDialPlanTagReq $axlParams
     * @return \CUCM\StructType\ListDialPlanTagRes|bool
     */
    public function listDialPlanTag(\CUCM\StructType\ListDialPlanTagReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDialPlanTag($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDdi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListDdiReq $axlParams
     * @return \CUCM\StructType\ListDdiRes|bool
     */
    public function listDdi(\CUCM\StructType\ListDdiReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDdi($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listMobileSmartClientProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListMobileSmartClientProfileReq $axlParams
     * @return \CUCM\StructType\ListMobileSmartClientProfileRes|bool
     */
    public function listMobileSmartClientProfile(\CUCM\StructType\ListMobileSmartClientProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listMobileSmartClientProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listProcessNodeService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListProcessNodeServiceReq $axlParams
     * @return \CUCM\StructType\ListProcessNodeServiceRes|bool
     */
    public function listProcessNodeService(\CUCM\StructType\ListProcessNodeServiceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listProcessNodeService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listMohAudioSource
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListMohAudioSourceReq $axlParams
     * @return \CUCM\StructType\ListMohAudioSourceRes|bool
     */
    public function listMohAudioSource(\CUCM\StructType\ListMohAudioSourceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listMohAudioSource($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDhcpServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListDhcpServerReq $axlParams
     * @return \CUCM\StructType\ListDhcpServerRes|bool
     */
    public function listDhcpServer(\CUCM\StructType\ListDhcpServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDhcpServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDhcpSubnet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListDhcpSubnetReq $axlParams
     * @return \CUCM\StructType\ListDhcpSubnetRes|bool
     */
    public function listDhcpSubnet(\CUCM\StructType\ListDhcpSubnetReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDhcpSubnet($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListCallParkReq $axlParams
     * @return \CUCM\StructType\ListCallParkRes|bool
     */
    public function listCallPark(\CUCM\StructType\ListCallParkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDirectedCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListDirectedCallParkReq $axlParams
     * @return \CUCM\StructType\ListDirectedCallParkRes|bool
     */
    public function listDirectedCallPark(\CUCM\StructType\ListDirectedCallParkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDirectedCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listMeetMe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListMeetMeReq $axlParams
     * @return \CUCM\StructType\ListMeetMeRes|bool
     */
    public function listMeetMe(\CUCM\StructType\ListMeetMeReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listMeetMe($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listRouteList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListRouteListReq $axlParams
     * @return \CUCM\StructType\ListRouteListRes|bool
     */
    public function listRouteList(\CUCM\StructType\ListRouteListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listRouteList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListUserReq $axlParams
     * @return \CUCM\StructType\ListUserRes|bool
     */
    public function listUser(\CUCM\StructType\ListUserReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listLicenseCapabilities
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListLicenseCapabilitiesReq $axlParams
     * @return \CUCM\StructType\ListLicenseCapabilitiesRes|bool
     */
    public function listLicenseCapabilities(\CUCM\StructType\ListLicenseCapabilitiesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listLicenseCapabilities($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listAppUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListAppUserReq $axlParams
     * @return \CUCM\StructType\ListAppUserRes|bool
     */
    public function listAppUser(\CUCM\StructType\ListAppUserReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listAppUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listSipRealm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListSipRealmReq $axlParams
     * @return \CUCM\StructType\ListSipRealmRes|bool
     */
    public function listSipRealm(\CUCM\StructType\ListSipRealmReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listSipRealm($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listPhoneNtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListPhoneNtpReq $axlParams
     * @return \CUCM\StructType\ListPhoneNtpRes|bool
     */
    public function listPhoneNtp(\CUCM\StructType\ListPhoneNtpReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listPhoneNtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDateTimeGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListDateTimeGroupReq $axlParams
     * @return \CUCM\StructType\ListDateTimeGroupRes|bool
     */
    public function listDateTimeGroup(\CUCM\StructType\ListDateTimeGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDateTimeGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listPresenceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListPresenceGroupReq $axlParams
     * @return \CUCM\StructType\ListPresenceGroupRes|bool
     */
    public function listPresenceGroup(\CUCM\StructType\ListPresenceGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listPresenceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listGeoLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListGeoLocationReq $axlParams
     * @return \CUCM\StructType\ListGeoLocationRes|bool
     */
    public function listGeoLocation(\CUCM\StructType\ListGeoLocationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listGeoLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listSrst
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListSrstReq $axlParams
     * @return \CUCM\StructType\ListSrstRes|bool
     */
    public function listSrst(\CUCM\StructType\ListSrstReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listSrst($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listMlppDomain
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListMlppDomainReq $axlParams
     * @return \CUCM\StructType\ListMlppDomainRes|bool
     */
    public function listMlppDomain(\CUCM\StructType\ListMlppDomainReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listMlppDomain($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCumaServerSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListCumaServerSecurityProfileReq $axlParams
     * @return \CUCM\StructType\ListCumaServerSecurityProfileRes|bool
     */
    public function listCumaServerSecurityProfile(\CUCM\StructType\ListCumaServerSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCumaServerSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listApplicationServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListApplicationServerReq $axlParams
     * @return \CUCM\StructType\ListApplicationServerRes|bool
     */
    public function listApplicationServer(\CUCM\StructType\ListApplicationServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listApplicationServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listApplicationUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListApplicationUserCapfProfileReq $axlParams
     * @return \CUCM\StructType\ListApplicationUserCapfProfileRes|bool
     */
    public function listApplicationUserCapfProfile(\CUCM\StructType\ListApplicationUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listApplicationUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listEndUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListEndUserCapfProfileReq $axlParams
     * @return \CUCM\StructType\ListEndUserCapfProfileRes|bool
     */
    public function listEndUserCapfProfile(\CUCM\StructType\ListEndUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listEndUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listGeoLocationFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListGeoLocationFilterReq $axlParams
     * @return \CUCM\StructType\ListGeoLocationFilterRes|bool
     */
    public function listGeoLocationFilter(\CUCM\StructType\ListGeoLocationFilterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listGeoLocationFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listVoiceMailProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListVoiceMailProfileReq $axlParams
     * @return \CUCM\StructType\ListVoiceMailProfileRes|bool
     */
    public function listVoiceMailProfile(\CUCM\StructType\ListVoiceMailProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listVoiceMailProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listVoiceMailPort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListVoiceMailPortReq $axlParams
     * @return \CUCM\StructType\ListVoiceMailPortRes|bool
     */
    public function listVoiceMailPort(\CUCM\StructType\ListVoiceMailPortReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listVoiceMailPort($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listGatekeeper
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListGatekeeperReq $axlParams
     * @return \CUCM\StructType\ListGatekeeperRes|bool
     */
    public function listGatekeeper(\CUCM\StructType\ListGatekeeperReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listGatekeeper($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listPhoneButtonTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListPhoneButtonTemplateReq $axlParams
     * @return \CUCM\StructType\ListPhoneButtonTemplateRes|bool
     */
    public function listPhoneButtonTemplate(\CUCM\StructType\ListPhoneButtonTemplateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listPhoneButtonTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCommonPhoneConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListCommonPhoneConfigReq $axlParams
     * @return \CUCM\StructType\ListCommonPhoneConfigRes|bool
     */
    public function listCommonPhoneConfig(\CUCM\StructType\ListCommonPhoneConfigReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCommonPhoneConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listMessageWaiting
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListMessageWaitingReq $axlParams
     * @return \CUCM\StructType\ListMessageWaitingRes|bool
     */
    public function listMessageWaiting(\CUCM\StructType\ListMessageWaitingReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listMessageWaiting($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listIpPhoneServices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListIpPhoneServicesReq $axlParams
     * @return \CUCM\StructType\ListIpPhoneServicesRes|bool
     */
    public function listIpPhoneServices(\CUCM\StructType\ListIpPhoneServicesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listIpPhoneServices($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCtiRoutePoint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListCtiRoutePointReq $axlParams
     * @return \CUCM\StructType\ListCtiRoutePointRes|bool
     */
    public function listCtiRoutePoint(\CUCM\StructType\ListCtiRoutePointReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCtiRoutePoint($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listTransPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListTransPatternReq $axlParams
     * @return \CUCM\StructType\ListTransPatternRes|bool
     */
    public function listTransPattern(\CUCM\StructType\ListTransPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listTransPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * listCallingPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListCallingPartyTransformationPatternReq $axlParams
     * @return \CUCM\StructType\ListCallingPartyTransformationPatternRes|bool
     */
    public function listCallingPartyTransformationPattern(\CUCM\StructType\ListCallingPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCallingPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listSipRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListSipRoutePatternReq $axlParams
     * @return \CUCM\StructType\ListSipRoutePatternRes|bool
     */
    public function listSipRoutePattern(\CUCM\StructType\ListSipRoutePatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listSipRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listHuntPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListHuntPilotReq $axlParams
     * @return \CUCM\StructType\ListHuntPilotRes|bool
     */
    public function listHuntPilot(\CUCM\StructType\ListHuntPilotReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listHuntPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListRoutePatternReq $axlParams
     * @return \CUCM\StructType\ListRoutePatternRes|bool
     */
    public function listRoutePattern(\CUCM\StructType\ListRoutePatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listApplicationDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListApplicationDialRulesReq $axlParams
     * @return \CUCM\StructType\ListApplicationDialRulesRes|bool
     */
    public function listApplicationDialRules(\CUCM\StructType\ListApplicationDialRulesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listApplicationDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDirectoryLookupDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListDirectoryLookupDialRulesReq $axlParams
     * @return \CUCM\StructType\ListDirectoryLookupDialRulesRes|bool
     */
    public function listDirectoryLookupDialRules(\CUCM\StructType\ListDirectoryLookupDialRulesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDirectoryLookupDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listPhoneSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListPhoneSecurityProfileReq $axlParams
     * @return \CUCM\StructType\ListPhoneSecurityProfileRes|bool
     */
    public function listPhoneSecurityProfile(\CUCM\StructType\ListPhoneSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listPhoneSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listSipDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListSipDialRulesReq $axlParams
     * @return \CUCM\StructType\ListSipDialRulesRes|bool
     */
    public function listSipDialRules(\CUCM\StructType\ListSipDialRulesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listSipDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listConferenceBridge
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListConferenceBridgeReq $axlParams
     * @return \CUCM\StructType\ListConferenceBridgeRes|bool
     */
    public function listConferenceBridge(\CUCM\StructType\ListConferenceBridgeReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listConferenceBridge($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listAnnunciator
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListAnnunciatorReq $axlParams
     * @return \CUCM\StructType\ListAnnunciatorRes|bool
     */
    public function listAnnunciator(\CUCM\StructType\ListAnnunciatorReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listAnnunciator($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listMtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListMtpReq $axlParams
     * @return \CUCM\StructType\ListMtpRes|bool
     */
    public function listMtp(\CUCM\StructType\ListMtpReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listMtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listRemoteDestinationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListRemoteDestinationProfileReq $axlParams
     * @return \CUCM\StructType\ListRemoteDestinationProfileRes|bool
     */
    public function listRemoteDestinationProfile(\CUCM\StructType\ListRemoteDestinationProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listRemoteDestinationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListLineReq $axlParams
     * @return \CUCM\StructType\ListLineRes|bool
     */
    public function listLine(\CUCM\StructType\ListLineReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listLine($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDefaultDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListDefaultDeviceProfileReq $axlParams
     * @return \CUCM\StructType\ListDefaultDeviceProfileRes|bool
     */
    public function listDefaultDeviceProfile(\CUCM\StructType\ListDefaultDeviceProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDefaultDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listH323Phone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListH323PhoneReq $axlParams
     * @return \CUCM\StructType\ListH323PhoneRes|bool
     */
    public function listH323Phone(\CUCM\StructType\ListH323PhoneReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listH323Phone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listMohServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListMohServerReq $axlParams
     * @return \CUCM\StructType\ListMohServerRes|bool
     */
    public function listMohServer(\CUCM\StructType\ListMohServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listMohServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listH323Trunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListH323TrunkReq $axlParams
     * @return \CUCM\StructType\ListH323TrunkRes|bool
     */
    public function listH323Trunk(\CUCM\StructType\ListH323TrunkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listH323Trunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listPhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListPhoneReq $axlParams
     * @return \CUCM\StructType\ListPhoneRes|bool
     */
    public function listPhone(\CUCM\StructType\ListPhoneReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listPhone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listH323Gateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListH323GatewayReq $axlParams
     * @return \CUCM\StructType\ListH323GatewayRes|bool
     */
    public function listH323Gateway(\CUCM\StructType\ListH323GatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listH323Gateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListDeviceProfileReq $axlParams
     * @return \CUCM\StructType\ListDeviceProfileRes|bool
     */
    public function listDeviceProfile(\CUCM\StructType\ListDeviceProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listRemoteDestination
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListRemoteDestinationReq $axlParams
     * @return \CUCM\StructType\ListRemoteDestinationRes|bool
     */
    public function listRemoteDestination(\CUCM\StructType\ListRemoteDestinationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listRemoteDestination($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListGatewayReq $axlParams
     * @return \CUCM\StructType\ListGatewayRes|bool
     */
    public function listGateway(\CUCM\StructType\ListGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * listCiscoCatalyst600024PortFXSGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListCiscoCatalyst600024PortFXSGatewayReq $axlParams
     * @return \CUCM\StructType\ListCiscoCatalyst600024PortFXSGatewayRes|bool
     */
    public function listCiscoCatalyst600024PortFXSGateway(\CUCM\StructType\ListCiscoCatalyst600024PortFXSGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCiscoCatalyst600024PortFXSGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCiscoCatalyst6000E1VoIPGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListCiscoCatalyst6000E1VoIPGatewayReq $axlParams
     * @return \CUCM\StructType\ListCiscoCatalyst6000E1VoIPGatewayRes|bool
     */
    public function listCiscoCatalyst6000E1VoIPGateway(\CUCM\StructType\ListCiscoCatalyst6000E1VoIPGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCiscoCatalyst6000E1VoIPGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * listCiscoCatalyst6000T1VoIPGatewayPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListCiscoCatalyst6000T1VoIPGatewayPriReq $axlParams
     * @return \CUCM\StructType\ListCiscoCatalyst6000T1VoIPGatewayPriRes|bool
     */
    public function listCiscoCatalyst6000T1VoIPGatewayPri(\CUCM\StructType\ListCiscoCatalyst6000T1VoIPGatewayPriReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCiscoCatalyst6000T1VoIPGatewayPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * listCiscoCatalyst6000T1VoIPGatewayT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListCiscoCatalyst6000T1VoIPGatewayT1Req $axlParams
     * @return \CUCM\StructType\ListCiscoCatalyst6000T1VoIPGatewayT1Res|bool
     */
    public function listCiscoCatalyst6000T1VoIPGatewayT1(\CUCM\StructType\ListCiscoCatalyst6000T1VoIPGatewayT1Req $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCiscoCatalyst6000T1VoIPGatewayT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCallPickupGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListCallPickupGroupReq $axlParams
     * @return \CUCM\StructType\ListCallPickupGroupRes|bool
     */
    public function listCallPickupGroup(\CUCM\StructType\ListCallPickupGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCallPickupGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listRoutePlan
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListRoutePlanReq $axlParams
     * @return \CUCM\StructType\ListRoutePlanRes|bool
     */
    public function listRoutePlan(\CUCM\StructType\ListRoutePlanReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listRoutePlan($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listGeoLocationPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListGeoLocationPolicyReq $axlParams
     * @return \CUCM\StructType\ListGeoLocationPolicyRes|bool
     */
    public function listGeoLocationPolicy(\CUCM\StructType\ListGeoLocationPolicyReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listGeoLocationPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listSipTrunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListSipTrunkReq $axlParams
     * @return \CUCM\StructType\ListSipTrunkRes|bool
     */
    public function listSipTrunk(\CUCM\StructType\ListSipTrunkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listSipTrunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * listCalledPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListCalledPartyTransformationPatternReq $axlParams
     * @return \CUCM\StructType\ListCalledPartyTransformationPatternRes|bool
     */
    public function listCalledPartyTransformationPattern(\CUCM\StructType\ListCalledPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCalledPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listExternalCallControlProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListExternalCallControlProfileReq $axlParams
     * @return \CUCM\StructType\ListExternalCallControlProfileRes|bool
     */
    public function listExternalCallControlProfile(\CUCM\StructType\ListExternalCallControlProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listExternalCallControlProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listSafSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListSafSecurityProfileReq $axlParams
     * @return \CUCM\StructType\ListSafSecurityProfileRes|bool
     */
    public function listSafSecurityProfile(\CUCM\StructType\ListSafSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listSafSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listSafForwarder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListSafForwarderReq $axlParams
     * @return \CUCM\StructType\ListSafForwarderRes|bool
     */
    public function listSafForwarder(\CUCM\StructType\ListSafForwarderReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listSafForwarder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCcdHostedDN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListCcdHostedDNReq $axlParams
     * @return \CUCM\StructType\ListCcdHostedDNRes|bool
     */
    public function listCcdHostedDN(\CUCM\StructType\ListCcdHostedDNReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCcdHostedDN($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCcdHostedDNGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListCcdHostedDNGroupReq $axlParams
     * @return \CUCM\StructType\ListCcdHostedDNGroupRes|bool
     */
    public function listCcdHostedDNGroup(\CUCM\StructType\ListCcdHostedDNGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCcdHostedDNGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listRemoteCluster
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListRemoteClusterReq $axlParams
     * @return \CUCM\StructType\ListRemoteClusterRes|bool
     */
    public function listRemoteCluster(\CUCM\StructType\ListRemoteClusterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listRemoteCluster($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCcdAdvertisingService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListCcdAdvertisingServiceReq $axlParams
     * @return \CUCM\StructType\ListCcdAdvertisingServiceRes|bool
     */
    public function listCcdAdvertisingService(\CUCM\StructType\ListCcdAdvertisingServiceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCcdAdvertisingService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listLdapDirectory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListLdapDirectoryReq $axlParams
     * @return \CUCM\StructType\ListLdapDirectoryRes|bool
     */
    public function listLdapDirectory(\CUCM\StructType\ListLdapDirectoryReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listLdapDirectory($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listSafCcdPurgeBlockLearnedRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListSafCcdPurgeBlockLearnedRoutesReq $axlParams
     * @return \CUCM\StructType\ListSafCcdPurgeBlockLearnedRoutesRes|bool
     */
    public function listSafCcdPurgeBlockLearnedRoutes(\CUCM\StructType\ListSafCcdPurgeBlockLearnedRoutesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listSafCcdPurgeBlockLearnedRoutes($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listVpnGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListVpnGatewayReq $axlParams
     * @return \CUCM\StructType\ListVpnGatewayRes|bool
     */
    public function listVpnGateway(\CUCM\StructType\ListVpnGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listVpnGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listVpnGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListVpnGroupReq $axlParams
     * @return \CUCM\StructType\ListVpnGroupRes|bool
     */
    public function listVpnGroup(\CUCM\StructType\ListVpnGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listVpnGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listVpnProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListVpnProfileReq $axlParams
     * @return \CUCM\StructType\ListVpnProfileRes|bool
     */
    public function listVpnProfile(\CUCM\StructType\ListVpnProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listVpnProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listImeServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListImeServerReq $axlParams
     * @return \CUCM\StructType\ListImeServerRes|bool
     */
    public function listImeServer(\CUCM\StructType\ListImeServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listImeServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listImeRouteFilterGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListImeRouteFilterGroupReq $axlParams
     * @return \CUCM\StructType\ListImeRouteFilterGroupRes|bool
     */
    public function listImeRouteFilterGroup(\CUCM\StructType\ListImeRouteFilterGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listImeRouteFilterGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listImeRouteFilterElement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListImeRouteFilterElementReq $axlParams
     * @return \CUCM\StructType\ListImeRouteFilterElementRes|bool
     */
    public function listImeRouteFilterElement(\CUCM\StructType\ListImeRouteFilterElementReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listImeRouteFilterElement($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listImeClient
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListImeClientReq $axlParams
     * @return \CUCM\StructType\ListImeClientRes|bool
     */
    public function listImeClient(\CUCM\StructType\ListImeClientReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listImeClient($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listImeEnrolledPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListImeEnrolledPatternReq $axlParams
     * @return \CUCM\StructType\ListImeEnrolledPatternRes|bool
     */
    public function listImeEnrolledPattern(\CUCM\StructType\ListImeEnrolledPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listImeEnrolledPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listImeEnrolledPatternGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListImeEnrolledPatternGroupReq $axlParams
     * @return \CUCM\StructType\ListImeEnrolledPatternGroupRes|bool
     */
    public function listImeEnrolledPatternGroup(\CUCM\StructType\ListImeEnrolledPatternGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listImeEnrolledPatternGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listImeExclusionNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListImeExclusionNumberReq $axlParams
     * @return \CUCM\StructType\ListImeExclusionNumberRes|bool
     */
    public function listImeExclusionNumber(\CUCM\StructType\ListImeExclusionNumberReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listImeExclusionNumber($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listImeExclusionNumberGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListImeExclusionNumberGroupReq $axlParams
     * @return \CUCM\StructType\ListImeExclusionNumberGroupRes|bool
     */
    public function listImeExclusionNumberGroup(\CUCM\StructType\ListImeExclusionNumberGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listImeExclusionNumberGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listImeFirewall
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListImeFirewallReq $axlParams
     * @return \CUCM\StructType\ListImeFirewallRes|bool
     */
    public function listImeFirewall(\CUCM\StructType\ListImeFirewallReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listImeFirewall($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listImeE164Transformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListImeE164TransformationReq $axlParams
     * @return \CUCM\StructType\ListImeE164TransformationRes|bool
     */
    public function listImeE164Transformation(\CUCM\StructType\ListImeE164TransformationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listImeE164Transformation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listTransformationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListTransformationProfileReq $axlParams
     * @return \CUCM\StructType\ListTransformationProfileRes|bool
     */
    public function listTransformationProfile(\CUCM\StructType\ListTransformationProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listTransformationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listFallbackProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListFallbackProfileReq $axlParams
     * @return \CUCM\StructType\ListFallbackProfileRes|bool
     */
    public function listFallbackProfile(\CUCM\StructType\ListFallbackProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listFallbackProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listLdapFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListLdapFilterReq $axlParams
     * @return \CUCM\StructType\ListLdapFilterRes|bool
     */
    public function listLdapFilter(\CUCM\StructType\ListLdapFilterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listLdapFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listTvsCertificate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListTvsCertificateReq $axlParams
     * @return \CUCM\StructType\ListTvsCertificateRes|bool
     */
    public function listTvsCertificate(\CUCM\StructType\ListTvsCertificateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listTvsCertificate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listFeatureControlPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListFeatureControlPolicyReq $axlParams
     * @return \CUCM\StructType\ListFeatureControlPolicyRes|bool
     */
    public function listFeatureControlPolicy(\CUCM\StructType\ListFeatureControlPolicyReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listFeatureControlPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listMobilityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListMobilityProfileReq $axlParams
     * @return \CUCM\StructType\ListMobilityProfileRes|bool
     */
    public function listMobilityProfile(\CUCM\StructType\ListMobilityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listMobilityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * listEnterpriseFeatureAccessConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ListEnterpriseFeatureAccessConfigurationReq $axlParams
     * @return \CUCM\StructType\ListEnterpriseFeatureAccessConfigurationRes|bool
     */
    public function listEnterpriseFeatureAccessConfiguration(\CUCM\StructType\ListEnterpriseFeatureAccessConfigurationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listEnterpriseFeatureAccessConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CUCM\StructType\ListAarGroupRes|\CUCM\StructType\ListAnnunciatorRes|\CUCM\StructType\ListApplicationDialRulesRes|\CUCM\StructType\ListApplicationServerRes|\CUCM\StructType\ListApplicationUserCapfProfileRes|\CUCM\StructType\ListAppUserRes|\CUCM\StructType\ListCalledPartyTransformationPatternRes|\CUCM\StructType\ListCallerFilterListRes|\CUCM\StructType\ListCallingPartyTransformationPatternRes|\CUCM\StructType\ListCallManagerGroupRes|\CUCM\StructType\ListCallManagerRes|\CUCM\StructType\ListCallParkRes|\CUCM\StructType\ListCallPickupGroupRes|\CUCM\StructType\ListCcdAdvertisingServiceRes|\CUCM\StructType\ListCcdHostedDNGroupRes|\CUCM\StructType\ListCcdHostedDNRes|\CUCM\StructType\ListCiscoCatalyst6000E1VoIPGatewayRes|\CUCM\StructType\ListCiscoCatalyst6000T1VoIPGatewayPriRes|\CUCM\StructType\ListCiscoCatalyst6000T1VoIPGatewayT1Res|\CUCM\StructType\ListCiscoCatalyst600024PortFXSGatewayRes|\CUCM\StructType\ListCmcInfoRes|\CUCM\StructType\ListCommonDeviceConfigRes|\CUCM\StructType\ListCommonPhoneConfigRes|\CUCM\StructType\ListConferenceBridgeRes|\CUCM\StructType\ListCredentialPolicyRes|\CUCM\StructType\ListCssRes|\CUCM\StructType\ListCtiRoutePointRes|\CUCM\StructType\ListCumaServerSecurityProfileRes|\CUCM\StructType\ListDateTimeGroupRes|\CUCM\StructType\ListDdiRes|\CUCM\StructType\ListDefaultDeviceProfileRes|\CUCM\StructType\ListDeviceMobilityGroupRes|\CUCM\StructType\ListDeviceMobilityRes|\CUCM\StructType\ListDevicePoolRes|\CUCM\StructType\ListDeviceProfileRes|\CUCM\StructType\ListDhcpServerRes|\CUCM\StructType\ListDhcpSubnetRes|\CUCM\StructType\ListDialPlanRes|\CUCM\StructType\ListDialPlanTagRes|\CUCM\StructType\ListDirectedCallParkRes|\CUCM\StructType\ListDirectoryLookupDialRulesRes|\CUCM\StructType\ListEndUserCapfProfileRes|\CUCM\StructType\ListEnterpriseFeatureAccessConfigurationRes|\CUCM\StructType\ListExternalCallControlProfileRes|\CUCM\StructType\ListFacInfoRes|\CUCM\StructType\ListFallbackProfileRes|\CUCM\StructType\ListFeatureControlPolicyRes|\CUCM\StructType\ListGatekeeperRes|\CUCM\StructType\ListGatewayRes|\CUCM\StructType\ListGeoLocationFilterRes|\CUCM\StructType\ListGeoLocationPolicyRes|\CUCM\StructType\ListGeoLocationRes|\CUCM\StructType\ListH323GatewayRes|\CUCM\StructType\ListH323PhoneRes|\CUCM\StructType\ListH323TrunkRes|\CUCM\StructType\ListHuntListRes|\CUCM\StructType\ListHuntPilotRes|\CUCM\StructType\ListImeClientRes|\CUCM\StructType\ListImeE164TransformationRes|\CUCM\StructType\ListImeEnrolledPatternGroupRes|\CUCM\StructType\ListImeEnrolledPatternRes|\CUCM\StructType\ListImeExclusionNumberGroupRes|\CUCM\StructType\ListImeExclusionNumberRes|\CUCM\StructType\ListImeFirewallRes|\CUCM\StructType\ListImeRouteFilterElementRes|\CUCM\StructType\ListImeRouteFilterGroupRes|\CUCM\StructType\ListImeServerRes|\CUCM\StructType\ListIpPhoneServicesRes|\CUCM\StructType\ListIvrUserLocaleRes|\CUCM\StructType\ListLdapDirectoryRes|\CUCM\StructType\ListLdapFilterRes|\CUCM\StructType\ListLicenseCapabilitiesRes|\CUCM\StructType\ListLineGroupRes|\CUCM\StructType\ListLineRes|\CUCM\StructType\ListLocationRes|\CUCM\StructType\ListMediaResourceGroupRes|\CUCM\StructType\ListMediaResourceListRes|\CUCM\StructType\ListMeetMeRes|\CUCM\StructType\ListMessageWaitingRes|\CUCM\StructType\ListMlppDomainRes|\CUCM\StructType\ListMobileSmartClientProfileRes|\CUCM\StructType\ListMobilityProfileRes|\CUCM\StructType\ListMohAudioSourceRes|\CUCM\StructType\ListMohServerRes|\CUCM\StructType\ListMtpRes|\CUCM\StructType\ListPhoneButtonTemplateRes|\CUCM\StructType\ListPhoneNtpRes|\CUCM\StructType\ListPhoneRes|\CUCM\StructType\ListPhoneSecurityProfileRes|\CUCM\StructType\ListPhysicalLocationRes|\CUCM\StructType\ListPresenceGroupRes|\CUCM\StructType\ListProcessNodeRes|\CUCM\StructType\ListProcessNodeServiceRes|\CUCM\StructType\ListRecordingProfileRes|\CUCM\StructType\ListRegionRes|\CUCM\StructType\ListRemoteClusterRes|\CUCM\StructType\ListRemoteDestinationProfileRes|\CUCM\StructType\ListRemoteDestinationRes|\CUCM\StructType\ListResourcePriorityNamespaceListRes|\CUCM\StructType\ListResourcePriorityNamespaceRes|\CUCM\StructType\ListRouteFilterRes|\CUCM\StructType\ListRouteGroupRes|\CUCM\StructType\ListRouteListRes|\CUCM\StructType\ListRoutePartitionRes|\CUCM\StructType\ListRoutePatternRes|\CUCM\StructType\ListRoutePlanRes|\CUCM\StructType\ListSafCcdPurgeBlockLearnedRoutesRes|\CUCM\StructType\ListSafForwarderRes|\CUCM\StructType\ListSafSecurityProfileRes|\CUCM\StructType\ListSipDialRulesRes|\CUCM\StructType\ListSipProfileRes|\CUCM\StructType\ListSipRealmRes|\CUCM\StructType\ListSipRoutePatternRes|\CUCM\StructType\ListSipTrunkRes|\CUCM\StructType\ListSipTrunkSecurityProfileRes|\CUCM\StructType\ListSoftKeyTemplateRes|\CUCM\StructType\ListSrstRes|\CUCM\StructType\ListTimePeriodRes|\CUCM\StructType\ListTimeScheduleRes|\CUCM\StructType\ListTodAccessRes|\CUCM\StructType\ListTranscoderRes|\CUCM\StructType\ListTransformationProfileRes|\CUCM\StructType\ListTransPatternRes|\CUCM\StructType\ListTvsCertificateRes|\CUCM\StructType\ListUserGroupRes|\CUCM\StructType\ListUserRes|\CUCM\StructType\ListVoiceMailPilotRes|\CUCM\StructType\ListVoiceMailPortRes|\CUCM\StructType\ListVoiceMailProfileRes|\CUCM\StructType\ListVpnGatewayRes|\CUCM\StructType\ListVpnGroupRes|\CUCM\StructType\ListVpnProfileRes
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
