<?php

namespace CUCM\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Do ServiceType
 * @subpackage Services
 */
class _Do extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named doAuthenticateUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\DoAuthenticateUserReq $axlParams
     * @return \CUCM\StructType\DoAuthenticateUserRes|bool
     */
    public function doAuthenticateUser(\CUCM\StructType\DoAuthenticateUserReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->doAuthenticateUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named doDeviceLogin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\DoDeviceLoginReq $axlParams
     * @return \CUCM\StructType\DoDeviceLoginRes|bool
     */
    public function doDeviceLogin(\CUCM\StructType\DoDeviceLoginReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->doDeviceLogin($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named doDeviceLogout
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\DoDeviceLogoutReq $axlParams
     * @return \CUCM\StructType\DoDeviceLogoutRes|bool
     */
    public function doDeviceLogout(\CUCM\StructType\DoDeviceLogoutReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->doDeviceLogout($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named doDeviceReset
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\DoDeviceResetReq $axlParams
     * @return \CUCM\StructType\DoDeviceResetRes|bool
     */
    public function doDeviceReset(\CUCM\StructType\DoDeviceResetReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->doDeviceReset($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named doLdapSync
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\DoLdapSyncReq $axlParams
     * @return \CUCM\StructType\DoLdapSyncRes|bool
     */
    public function doLdapSync(\CUCM\StructType\DoLdapSyncReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->doLdapSync($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named doUpdateRemoteCluster
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\DoUpdateRemoteClusterReq $axlParams
     * @return \CUCM\StructType\DoUpdateRemoteClusterRes|bool
     */
    public function doUpdateRemoteCluster(\CUCM\StructType\DoUpdateRemoteClusterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->doUpdateRemoteCluster($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CUCM\StructType\DoAuthenticateUserRes|\CUCM\StructType\DoDeviceLoginRes|\CUCM\StructType\DoDeviceLogoutRes|\CUCM\StructType\DoDeviceResetRes|\CUCM\StructType\DoLdapSyncRes|\CUCM\StructType\DoUpdateRemoteClusterRes
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
