<?php

namespace CUCM\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named updateSipProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateSipProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateSipProfile(\CUCM\StructType\UpdateSipProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateSipProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSipTrunkSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateSipTrunkSecurityProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateSipTrunkSecurityProfile(\CUCM\StructType\UpdateSipTrunkSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateSipTrunkSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateTimePeriod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateTimePeriodReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateTimePeriod(\CUCM\StructType\UpdateTimePeriodReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateTimePeriod($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateTimeSchedule
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateTimeScheduleReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateTimeSchedule(\CUCM\StructType\UpdateTimeScheduleReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateTimeSchedule($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateTodAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateTodAccessReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateTodAccess(\CUCM\StructType\UpdateTodAccessReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateTodAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateVoiceMailPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateVoiceMailPilotReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateVoiceMailPilot(\CUCM\StructType\UpdateVoiceMailPilotReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateVoiceMailPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateProcessNode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateProcessNodeReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateProcessNode(\CUCM\StructType\UpdateProcessNodeReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateProcessNode($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCallerFilterList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateCallerFilterListReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateCallerFilterList(\CUCM\StructType\UpdateCallerFilterListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateCallerFilterList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRoutePartition
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateRoutePartitionReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateRoutePartition(\CUCM\StructType\UpdateRoutePartitionReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateRoutePartition($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateCssReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateCss(\CUCM\StructType\UpdateCssReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateCss($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCallManager
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateCallManagerReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateCallManager(\CUCM\StructType\UpdateCallManagerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateCallManager($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMediaResourceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateMediaResourceGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateMediaResourceGroup(\CUCM\StructType\UpdateMediaResourceGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateMediaResourceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMediaResourceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateMediaResourceListReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateMediaResourceList(\CUCM\StructType\UpdateMediaResourceListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateMediaResourceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRegion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateRegionReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateRegion(\CUCM\StructType\UpdateRegionReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateRegion($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAarGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateAarGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateAarGroup(\CUCM\StructType\UpdateAarGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateAarGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePhysicalLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdatePhysicalLocationReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updatePhysicalLocation(\CUCM\StructType\UpdatePhysicalLocationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updatePhysicalLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRouteGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateRouteGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateRouteGroup(\CUCM\StructType\UpdateRouteGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateRouteGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDevicePool
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateDevicePoolReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateDevicePool(\CUCM\StructType\UpdateDevicePoolReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateDevicePool($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDeviceMobilityGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateDeviceMobilityGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateDeviceMobilityGroup(\CUCM\StructType\UpdateDeviceMobilityGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateDeviceMobilityGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateLocationReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateLocation(\CUCM\StructType\UpdateLocationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSoftKeyTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateSoftKeyTemplateReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateSoftKeyTemplate(\CUCM\StructType\UpdateSoftKeyTemplateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateSoftKeyTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateTranscoder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateTranscoderReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateTranscoder(\CUCM\StructType\UpdateTranscoderReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateTranscoder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCommonDeviceConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateCommonDeviceConfigReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateCommonDeviceConfig(\CUCM\StructType\UpdateCommonDeviceConfigReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateCommonDeviceConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateResourcePriorityNamespace
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateResourcePriorityNamespaceReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateResourcePriorityNamespace(\CUCM\StructType\UpdateResourcePriorityNamespaceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateResourcePriorityNamespace($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateResourcePriorityNamespaceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateResourcePriorityNamespaceListReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateResourcePriorityNamespaceList(\CUCM\StructType\UpdateResourcePriorityNamespaceListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateResourcePriorityNamespaceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDeviceMobility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateDeviceMobilityReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateDeviceMobility(\CUCM\StructType\UpdateDeviceMobilityReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateDeviceMobility($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCmcInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateCmcInfoReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateCmcInfo(\CUCM\StructType\UpdateCmcInfoReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateCmcInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCredentialPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateCredentialPolicyReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateCredentialPolicy(\CUCM\StructType\UpdateCredentialPolicyReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateCredentialPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateFacInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateFacInfoReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateFacInfo(\CUCM\StructType\UpdateFacInfoReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateFacInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateHuntList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateHuntListReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateHuntList(\CUCM\StructType\UpdateHuntListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateHuntList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateIvrUserLocale
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateIvrUserLocaleReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateIvrUserLocale(\CUCM\StructType\UpdateIvrUserLocaleReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateIvrUserLocale($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLineGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateLineGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateLineGroup(\CUCM\StructType\UpdateLineGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateLineGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRecordingProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateRecordingProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateRecordingProfile(\CUCM\StructType\UpdateRecordingProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateRecordingProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRouteFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateRouteFilterReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateRouteFilter(\CUCM\StructType\UpdateRouteFilterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateRouteFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCallManagerGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateCallManagerGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateCallManagerGroup(\CUCM\StructType\UpdateCallManagerGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateCallManagerGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateUserGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateUserGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateUserGroup(\CUCM\StructType\UpdateUserGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateUserGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateProcessNodeService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateProcessNodeServiceReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateProcessNodeService(\CUCM\StructType\UpdateProcessNodeServiceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateProcessNodeService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMohAudioSource
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateMohAudioSourceReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateMohAudioSource(\CUCM\StructType\UpdateMohAudioSourceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateMohAudioSource($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDhcpServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateDhcpServerReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateDhcpServer(\CUCM\StructType\UpdateDhcpServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateDhcpServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDhcpSubnet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateDhcpSubnetReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateDhcpSubnet(\CUCM\StructType\UpdateDhcpSubnetReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateDhcpSubnet($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateCallParkReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateCallPark(\CUCM\StructType\UpdateCallParkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDirectedCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateDirectedCallParkReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateDirectedCallPark(\CUCM\StructType\UpdateDirectedCallParkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateDirectedCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMeetMe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateMeetMeReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateMeetMe(\CUCM\StructType\UpdateMeetMeReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateMeetMe($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMobileVoiceAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateMobileVoiceAccessReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateMobileVoiceAccess(\CUCM\StructType\UpdateMobileVoiceAccessReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateMobileVoiceAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRouteList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateRouteListReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateRouteList(\CUCM\StructType\UpdateRouteListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateRouteList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateUserReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateUser(\CUCM\StructType\UpdateUserReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLicenseCapabilities
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateLicenseCapabilitiesReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateLicenseCapabilities(\CUCM\StructType\UpdateLicenseCapabilitiesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateLicenseCapabilities($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAppUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateAppUserReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateAppUser(\CUCM\StructType\UpdateAppUserReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateAppUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSipRealm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateSipRealmReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateSipRealm(\CUCM\StructType\UpdateSipRealmReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateSipRealm($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePhoneNtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdatePhoneNtpReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updatePhoneNtp(\CUCM\StructType\UpdatePhoneNtpReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updatePhoneNtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDateTimeGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateDateTimeGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateDateTimeGroup(\CUCM\StructType\UpdateDateTimeGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateDateTimeGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePresenceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdatePresenceGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updatePresenceGroup(\CUCM\StructType\UpdatePresenceGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updatePresenceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateGeoLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateGeoLocationReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateGeoLocation(\CUCM\StructType\UpdateGeoLocationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateGeoLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSrst
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateSrstReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateSrst(\CUCM\StructType\UpdateSrstReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateSrst($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMlppDomain
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateMlppDomainReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateMlppDomain(\CUCM\StructType\UpdateMlppDomainReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateMlppDomain($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCumaServerSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateCumaServerSecurityProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateCumaServerSecurityProfile(\CUCM\StructType\UpdateCumaServerSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateCumaServerSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateApplicationServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateApplicationServerReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateApplicationServer(\CUCM\StructType\UpdateApplicationServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateApplicationServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateApplicationUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateApplicationUserCapfProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateApplicationUserCapfProfile(\CUCM\StructType\UpdateApplicationUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateApplicationUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateEndUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateEndUserCapfProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateEndUserCapfProfile(\CUCM\StructType\UpdateEndUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateEndUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateServiceParameter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateServiceParameterReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateServiceParameter(\CUCM\StructType\UpdateServiceParameterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateServiceParameter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateGeoLocationFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateGeoLocationFilterReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateGeoLocationFilter(\CUCM\StructType\UpdateGeoLocationFilterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateGeoLocationFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateVoiceMailProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateVoiceMailProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateVoiceMailProfile(\CUCM\StructType\UpdateVoiceMailProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateVoiceMailProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateVoiceMailPort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateVoiceMailPortReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateVoiceMailPort(\CUCM\StructType\UpdateVoiceMailPortReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateVoiceMailPort($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateGatekeeper
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateGatekeeperReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateGatekeeper(\CUCM\StructType\UpdateGatekeeperReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateGatekeeper($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePhoneButtonTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdatePhoneButtonTemplateReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updatePhoneButtonTemplate(\CUCM\StructType\UpdatePhoneButtonTemplateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updatePhoneButtonTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCommonPhoneConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateCommonPhoneConfigReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateCommonPhoneConfig(\CUCM\StructType\UpdateCommonPhoneConfigReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateCommonPhoneConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMessageWaiting
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateMessageWaitingReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateMessageWaiting(\CUCM\StructType\UpdateMessageWaitingReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateMessageWaiting($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateIpPhoneServices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateIpPhoneServicesReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateIpPhoneServices(\CUCM\StructType\UpdateIpPhoneServicesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateIpPhoneServices($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCtiRoutePoint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateCtiRoutePointReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateCtiRoutePoint(\CUCM\StructType\UpdateCtiRoutePointReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateCtiRoutePoint($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateTransPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateTransPatternReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateTransPattern(\CUCM\StructType\UpdateTransPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateTransPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateCallingPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateCallingPartyTransformationPatternReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateCallingPartyTransformationPattern(\CUCM\StructType\UpdateCallingPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateCallingPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSipRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateSipRoutePatternReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateSipRoutePattern(\CUCM\StructType\UpdateSipRoutePatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateSipRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateHuntPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateHuntPilotReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateHuntPilot(\CUCM\StructType\UpdateHuntPilotReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateHuntPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateRoutePatternReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateRoutePattern(\CUCM\StructType\UpdateRoutePatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateApplicationDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateApplicationDialRulesReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateApplicationDialRules(\CUCM\StructType\UpdateApplicationDialRulesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateApplicationDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDirectoryLookupDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateDirectoryLookupDialRulesReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateDirectoryLookupDialRules(\CUCM\StructType\UpdateDirectoryLookupDialRulesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateDirectoryLookupDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePhoneSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdatePhoneSecurityProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updatePhoneSecurityProfile(\CUCM\StructType\UpdatePhoneSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updatePhoneSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSipDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateSipDialRulesReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateSipDialRules(\CUCM\StructType\UpdateSipDialRulesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateSipDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateConferenceBridge
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateConferenceBridgeReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateConferenceBridge(\CUCM\StructType\UpdateConferenceBridgeReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateConferenceBridge($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAnnunciator
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateAnnunciatorReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateAnnunciator(\CUCM\StructType\UpdateAnnunciatorReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateAnnunciator($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateMtpReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateMtp(\CUCM\StructType\UpdateMtpReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateMtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateFixedMohAudioSource
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateFixedMohAudioSourceReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateFixedMohAudioSource(\CUCM\StructType\UpdateFixedMohAudioSourceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateFixedMohAudioSource($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAarGroupMatrix
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateAarGroupMatrixReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateAarGroupMatrix(\CUCM\StructType\UpdateAarGroupMatrixReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateAarGroupMatrix($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRemoteDestinationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateRemoteDestinationProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateRemoteDestinationProfile(\CUCM\StructType\UpdateRemoteDestinationProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateRemoteDestinationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateLineReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateLine(\CUCM\StructType\UpdateLineReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateLine($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDefaultDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateDefaultDeviceProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateDefaultDeviceProfile(\CUCM\StructType\UpdateDefaultDeviceProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateDefaultDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateH323Phone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateH323PhoneReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateH323Phone(\CUCM\StructType\UpdateH323PhoneReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateH323Phone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMohServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateMohServerReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateMohServer(\CUCM\StructType\UpdateMohServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateMohServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateH323Trunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateH323TrunkReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateH323Trunk(\CUCM\StructType\UpdateH323TrunkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateH323Trunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdatePhoneReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updatePhone(\CUCM\StructType\UpdatePhoneReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updatePhone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateH323Gateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateH323GatewayReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateH323Gateway(\CUCM\StructType\UpdateH323GatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateH323Gateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateDeviceProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateDeviceProfile(\CUCM\StructType\UpdateDeviceProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRemoteDestination
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateRemoteDestinationReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateRemoteDestination(\CUCM\StructType\UpdateRemoteDestinationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateRemoteDestination($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateGatewayReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateGateway(\CUCM\StructType\UpdateGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateGatewayEndpointAnalogAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateGatewayEndpointAnalogAccessReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateGatewayEndpointAnalogAccess(\CUCM\StructType\UpdateGatewayEndpointAnalogAccessReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateGatewayEndpointAnalogAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateGatewayEndpointDigitalAccessPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateGatewayEndpointDigitalAccessPriReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateGatewayEndpointDigitalAccessPri(\CUCM\StructType\UpdateGatewayEndpointDigitalAccessPriReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateGatewayEndpointDigitalAccessPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateGatewayEndpointDigitalAccessBri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateGatewayEndpointDigitalAccessBriReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateGatewayEndpointDigitalAccessBri(\CUCM\StructType\UpdateGatewayEndpointDigitalAccessBriReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateGatewayEndpointDigitalAccessBri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateGatewayEndpointDigitalAccessT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateGatewayEndpointDigitalAccessT1Req $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateGatewayEndpointDigitalAccessT1(\CUCM\StructType\UpdateGatewayEndpointDigitalAccessT1Req $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateGatewayEndpointDigitalAccessT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateVg224
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateVg224Req $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateVg224(\CUCM\StructType\UpdateVg224Req $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateVg224($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateCiscoCatalyst600024PortFXSGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateCiscoCatalyst600024PortFXSGatewayReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateCiscoCatalyst600024PortFXSGateway(\CUCM\StructType\UpdateCiscoCatalyst600024PortFXSGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateCiscoCatalyst600024PortFXSGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateCiscoCatalyst6000E1VoIPGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateCiscoCatalyst6000E1VoIPGatewayReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateCiscoCatalyst6000E1VoIPGateway(\CUCM\StructType\UpdateCiscoCatalyst6000E1VoIPGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateCiscoCatalyst6000E1VoIPGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateCiscoCatalyst6000T1VoIPGatewayPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateCiscoCatalyst6000T1VoIPGatewayPri(\CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateCiscoCatalyst6000T1VoIPGatewayPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateCiscoCatalyst6000T1VoIPGatewayT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateCiscoCatalyst6000T1VoIPGatewayT1(\CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateCiscoCatalyst6000T1VoIPGatewayT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCallPickupGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateCallPickupGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateCallPickupGroup(\CUCM\StructType\UpdateCallPickupGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateCallPickupGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateGeoLocationPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateGeoLocationPolicyReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateGeoLocationPolicy(\CUCM\StructType\UpdateGeoLocationPolicyReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateGeoLocationPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSipTrunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateSipTrunkReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateSipTrunk(\CUCM\StructType\UpdateSipTrunkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateSipTrunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRegionMatrix
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateRegionMatrixReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateRegionMatrix(\CUCM\StructType\UpdateRegionMatrixReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateRegionMatrix($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateCalledPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateCalledPartyTransformationPatternReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateCalledPartyTransformationPattern(\CUCM\StructType\UpdateCalledPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateCalledPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateExternalCallControlProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateExternalCallControlProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateExternalCallControlProfile(\CUCM\StructType\UpdateExternalCallControlProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateExternalCallControlProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSafSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateSafSecurityProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateSafSecurityProfile(\CUCM\StructType\UpdateSafSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateSafSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSafForwarder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateSafForwarderReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateSafForwarder(\CUCM\StructType\UpdateSafForwarderReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateSafForwarder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCcdHostedDN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateCcdHostedDNReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateCcdHostedDN(\CUCM\StructType\UpdateCcdHostedDNReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateCcdHostedDN($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCcdHostedDNGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateCcdHostedDNGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateCcdHostedDNGroup(\CUCM\StructType\UpdateCcdHostedDNGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateCcdHostedDNGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCcdRequestingService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateCcdRequestingServiceReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateCcdRequestingService(\CUCM\StructType\UpdateCcdRequestingServiceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateCcdRequestingService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateInterClusterServiceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateInterClusterServiceProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateInterClusterServiceProfile(\CUCM\StructType\UpdateInterClusterServiceProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateInterClusterServiceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRemoteCluster
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateRemoteClusterReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateRemoteCluster(\CUCM\StructType\UpdateRemoteClusterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateRemoteCluster($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCcdAdvertisingService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateCcdAdvertisingServiceReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateCcdAdvertisingService(\CUCM\StructType\UpdateCcdAdvertisingServiceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateCcdAdvertisingService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLdapDirectory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateLdapDirectoryReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateLdapDirectory(\CUCM\StructType\UpdateLdapDirectoryReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateLdapDirectory($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateEmccFeatureConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateEmccFeatureConfigReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateEmccFeatureConfig(\CUCM\StructType\UpdateEmccFeatureConfigReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateEmccFeatureConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateSafCcdPurgeBlockLearnedRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateSafCcdPurgeBlockLearnedRoutesReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateSafCcdPurgeBlockLearnedRoutes(\CUCM\StructType\UpdateSafCcdPurgeBlockLearnedRoutesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateSafCcdPurgeBlockLearnedRoutes($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateVpnGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateVpnGatewayReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateVpnGateway(\CUCM\StructType\UpdateVpnGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateVpnGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateVpnGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateVpnGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateVpnGroup(\CUCM\StructType\UpdateVpnGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateVpnGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateVpnProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateVpnProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateVpnProfile(\CUCM\StructType\UpdateVpnProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateVpnProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateImeServerReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateImeServer(\CUCM\StructType\UpdateImeServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateImeServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeRouteFilterGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateImeRouteFilterGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateImeRouteFilterGroup(\CUCM\StructType\UpdateImeRouteFilterGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateImeRouteFilterGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeRouteFilterElement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateImeRouteFilterElementReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateImeRouteFilterElement(\CUCM\StructType\UpdateImeRouteFilterElementReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateImeRouteFilterElement($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeClient
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateImeClientReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateImeClient(\CUCM\StructType\UpdateImeClientReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateImeClient($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeEnrolledPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateImeEnrolledPatternReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateImeEnrolledPattern(\CUCM\StructType\UpdateImeEnrolledPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateImeEnrolledPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeEnrolledPatternGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateImeEnrolledPatternGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateImeEnrolledPatternGroup(\CUCM\StructType\UpdateImeEnrolledPatternGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateImeEnrolledPatternGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeExclusionNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateImeExclusionNumberReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateImeExclusionNumber(\CUCM\StructType\UpdateImeExclusionNumberReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateImeExclusionNumber($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeExclusionNumberGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateImeExclusionNumberGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateImeExclusionNumberGroup(\CUCM\StructType\UpdateImeExclusionNumberGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateImeExclusionNumberGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeFirewall
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateImeFirewallReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateImeFirewall(\CUCM\StructType\UpdateImeFirewallReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateImeFirewall($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeE164Transformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateImeE164TransformationReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateImeE164Transformation(\CUCM\StructType\UpdateImeE164TransformationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateImeE164Transformation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateTransformationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateTransformationProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateTransformationProfile(\CUCM\StructType\UpdateTransformationProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateTransformationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateFallbackProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateFallbackProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateFallbackProfile(\CUCM\StructType\UpdateFallbackProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateFallbackProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLdapFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateLdapFilterReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateLdapFilter(\CUCM\StructType\UpdateLdapFilterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateLdapFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAppServerInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateAppServerInfoReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateAppServerInfo(\CUCM\StructType\UpdateAppServerInfoReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateAppServerInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateTvsCertificate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateTvsCertificateReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateTvsCertificate(\CUCM\StructType\UpdateTvsCertificateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateTvsCertificate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateFeatureControlPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateFeatureControlPolicyReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateFeatureControlPolicy(\CUCM\StructType\UpdateFeatureControlPolicyReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateFeatureControlPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMobilityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateMobilityProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateMobilityProfile(\CUCM\StructType\UpdateMobilityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateMobilityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateEnterpriseFeatureAccessConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateEnterpriseFeatureAccessConfigurationReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateEnterpriseFeatureAccessConfiguration(\CUCM\StructType\UpdateEnterpriseFeatureAccessConfigurationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateEnterpriseFeatureAccessConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateHandoffConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateHandoffConfigurationReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateHandoffConfiguration(\CUCM\StructType\UpdateHandoffConfigurationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateHandoffConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMobility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateMobilityReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateMobility(\CUCM\StructType\UpdateMobilityReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateMobility($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateEnterprisePhoneConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateEnterprisePhoneConfigReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateEnterprisePhoneConfig(\CUCM\StructType\UpdateEnterprisePhoneConfigReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateEnterprisePhoneConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLdapSystem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateLdapSystemReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateLdapSystem(\CUCM\StructType\UpdateLdapSystemReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateLdapSystem($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLdapAuthentication
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateLdapAuthenticationReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateLdapAuthentication(\CUCM\StructType\UpdateLdapAuthenticationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateLdapAuthentication($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeFeatureConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateImeFeatureConfigReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateImeFeatureConfig(\CUCM\StructType\UpdateImeFeatureConfigReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateImeFeatureConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateFallbackFeatureConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateFallbackFeatureConfigReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateFallbackFeatureConfig(\CUCM\StructType\UpdateFallbackFeatureConfigReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateFallbackFeatureConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeLearnedRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateImeLearnedRoutesReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateImeLearnedRoutes(\CUCM\StructType\UpdateImeLearnedRoutesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateImeLearnedRoutes($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSoftKeySet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\UpdateSoftKeySetReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function updateSoftKeySet(\CUCM\StructType\UpdateSoftKeySetReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->updateSoftKeySet($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CUCM\StructType\StandardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
