<?php

namespace CUCM\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getSipProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetSipProfileReq $axlParams
     * @return \CUCM\StructType\GetSipProfileRes|bool
     */
    public function getSipProfile(\CUCM\StructType\GetSipProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getSipProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSipTrunkSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetSipTrunkSecurityProfileReq $axlParams
     * @return \CUCM\StructType\GetSipTrunkSecurityProfileRes|bool
     */
    public function getSipTrunkSecurityProfile(\CUCM\StructType\GetSipTrunkSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getSipTrunkSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTimePeriod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetTimePeriodReq $axlParams
     * @return \CUCM\StructType\GetTimePeriodRes|bool
     */
    public function getTimePeriod(\CUCM\StructType\GetTimePeriodReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getTimePeriod($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTimeSchedule
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetTimeScheduleReq $axlParams
     * @return \CUCM\StructType\GetTimeScheduleRes|bool
     */
    public function getTimeSchedule(\CUCM\StructType\GetTimeScheduleReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getTimeSchedule($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTodAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetTodAccessReq $axlParams
     * @return \CUCM\StructType\GetTodAccessRes|bool
     */
    public function getTodAccess(\CUCM\StructType\GetTodAccessReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getTodAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVoiceMailPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetVoiceMailPilotReq $axlParams
     * @return \CUCM\StructType\GetVoiceMailPilotRes|bool
     */
    public function getVoiceMailPilot(\CUCM\StructType\GetVoiceMailPilotReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getVoiceMailPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProcessNode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetProcessNodeReq $axlParams
     * @return \CUCM\StructType\GetProcessNodeRes|bool
     */
    public function getProcessNode(\CUCM\StructType\GetProcessNodeReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getProcessNode($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCallerFilterList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetCallerFilterListReq $axlParams
     * @return \CUCM\StructType\GetCallerFilterListRes|bool
     */
    public function getCallerFilterList(\CUCM\StructType\GetCallerFilterListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getCallerFilterList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRoutePartition
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetRoutePartitionReq $axlParams
     * @return \CUCM\StructType\GetRoutePartitionRes|bool
     */
    public function getRoutePartition(\CUCM\StructType\GetRoutePartitionReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getRoutePartition($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetCssReq $axlParams
     * @return \CUCM\StructType\GetCssRes|bool
     */
    public function getCss(\CUCM\StructType\GetCssReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getCss($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCallManager
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetCallManagerReq $axlParams
     * @return \CUCM\StructType\GetCallManagerRes|bool
     */
    public function getCallManager(\CUCM\StructType\GetCallManagerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getCallManager($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMediaResourceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetMediaResourceGroupReq $axlParams
     * @return \CUCM\StructType\GetMediaResourceGroupRes|bool
     */
    public function getMediaResourceGroup(\CUCM\StructType\GetMediaResourceGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getMediaResourceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMediaResourceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetMediaResourceListReq $axlParams
     * @return \CUCM\StructType\GetMediaResourceListRes|bool
     */
    public function getMediaResourceList(\CUCM\StructType\GetMediaResourceListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getMediaResourceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRegion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetRegionReq $axlParams
     * @return \CUCM\StructType\GetRegionRes|bool
     */
    public function getRegion(\CUCM\StructType\GetRegionReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getRegion($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAarGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetAarGroupReq $axlParams
     * @return \CUCM\StructType\GetAarGroupRes|bool
     */
    public function getAarGroup(\CUCM\StructType\GetAarGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getAarGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPhysicalLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetPhysicalLocationReq $axlParams
     * @return \CUCM\StructType\GetPhysicalLocationRes|bool
     */
    public function getPhysicalLocation(\CUCM\StructType\GetPhysicalLocationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getPhysicalLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRouteGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetRouteGroupReq $axlParams
     * @return \CUCM\StructType\GetRouteGroupRes|bool
     */
    public function getRouteGroup(\CUCM\StructType\GetRouteGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getRouteGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDevicePool
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetDevicePoolReq $axlParams
     * @return \CUCM\StructType\GetDevicePoolRes|bool
     */
    public function getDevicePool(\CUCM\StructType\GetDevicePoolReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getDevicePool($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeviceMobilityGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetDeviceMobilityGroupReq $axlParams
     * @return \CUCM\StructType\GetDeviceMobilityGroupRes|bool
     */
    public function getDeviceMobilityGroup(\CUCM\StructType\GetDeviceMobilityGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getDeviceMobilityGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetLocationReq $axlParams
     * @return \CUCM\StructType\GetLocationRes|bool
     */
    public function getLocation(\CUCM\StructType\GetLocationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSoftKeyTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetSoftKeyTemplateReq $axlParams
     * @return \CUCM\StructType\GetSoftKeyTemplateRes|bool
     */
    public function getSoftKeyTemplate(\CUCM\StructType\GetSoftKeyTemplateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getSoftKeyTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTranscoder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetTranscoderReq $axlParams
     * @return \CUCM\StructType\GetTranscoderRes|bool
     */
    public function getTranscoder(\CUCM\StructType\GetTranscoderReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getTranscoder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCommonDeviceConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetCommonDeviceConfigReq $axlParams
     * @return \CUCM\StructType\GetCommonDeviceConfigRes|bool
     */
    public function getCommonDeviceConfig(\CUCM\StructType\GetCommonDeviceConfigReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getCommonDeviceConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getResourcePriorityNamespace
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetResourcePriorityNamespaceReq $axlParams
     * @return \CUCM\StructType\GetResourcePriorityNamespaceRes|bool
     */
    public function getResourcePriorityNamespace(\CUCM\StructType\GetResourcePriorityNamespaceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getResourcePriorityNamespace($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getResourcePriorityNamespaceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetResourcePriorityNamespaceListReq $axlParams
     * @return \CUCM\StructType\GetResourcePriorityNamespaceListRes|bool
     */
    public function getResourcePriorityNamespaceList(\CUCM\StructType\GetResourcePriorityNamespaceListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getResourcePriorityNamespaceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeviceMobility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetDeviceMobilityReq $axlParams
     * @return \CUCM\StructType\GetDeviceMobilityRes|bool
     */
    public function getDeviceMobility(\CUCM\StructType\GetDeviceMobilityReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getDeviceMobility($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCmcInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetCmcInfoReq $axlParams
     * @return \CUCM\StructType\GetCmcInfoRes|bool
     */
    public function getCmcInfo(\CUCM\StructType\GetCmcInfoReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getCmcInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCredentialPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetCredentialPolicyReq $axlParams
     * @return \CUCM\StructType\GetCredentialPolicyRes|bool
     */
    public function getCredentialPolicy(\CUCM\StructType\GetCredentialPolicyReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getCredentialPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFacInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetFacInfoReq $axlParams
     * @return \CUCM\StructType\GetFacInfoRes|bool
     */
    public function getFacInfo(\CUCM\StructType\GetFacInfoReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getFacInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHuntList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetHuntListReq $axlParams
     * @return \CUCM\StructType\GetHuntListRes|bool
     */
    public function getHuntList(\CUCM\StructType\GetHuntListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getHuntList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getIvrUserLocale
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetIvrUserLocaleReq $axlParams
     * @return \CUCM\StructType\GetIvrUserLocaleRes|bool
     */
    public function getIvrUserLocale(\CUCM\StructType\GetIvrUserLocaleReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getIvrUserLocale($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLineGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetLineGroupReq $axlParams
     * @return \CUCM\StructType\GetLineGroupRes|bool
     */
    public function getLineGroup(\CUCM\StructType\GetLineGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getLineGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRecordingProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetRecordingProfileReq $axlParams
     * @return \CUCM\StructType\GetRecordingProfileRes|bool
     */
    public function getRecordingProfile(\CUCM\StructType\GetRecordingProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getRecordingProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRouteFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetRouteFilterReq $axlParams
     * @return \CUCM\StructType\GetRouteFilterRes|bool
     */
    public function getRouteFilter(\CUCM\StructType\GetRouteFilterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getRouteFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCallManagerGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetCallManagerGroupReq $axlParams
     * @return \CUCM\StructType\GetCallManagerGroupRes|bool
     */
    public function getCallManagerGroup(\CUCM\StructType\GetCallManagerGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getCallManagerGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUserGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetUserGroupReq $axlParams
     * @return \CUCM\StructType\GetUserGroupRes|bool
     */
    public function getUserGroup(\CUCM\StructType\GetUserGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getUserGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDialPlan
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetDialPlanReq $axlParams
     * @return \CUCM\StructType\GetDialPlanRes|bool
     */
    public function getDialPlan(\CUCM\StructType\GetDialPlanReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getDialPlan($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDialPlanTag
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetDialPlanTagReq $axlParams
     * @return \CUCM\StructType\GetDialPlanTagRes|bool
     */
    public function getDialPlanTag(\CUCM\StructType\GetDialPlanTagReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getDialPlanTag($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDdi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetDdiReq $axlParams
     * @return \CUCM\StructType\GetDdiRes|bool
     */
    public function getDdi(\CUCM\StructType\GetDdiReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getDdi($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMobileSmartClientProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetMobileSmartClientProfileReq $axlParams
     * @return \CUCM\StructType\GetMobileSmartClientProfileRes|bool
     */
    public function getMobileSmartClientProfile(\CUCM\StructType\GetMobileSmartClientProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getMobileSmartClientProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProcessNodeService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetProcessNodeServiceReq $axlParams
     * @return \CUCM\StructType\GetProcessNodeServiceRes|bool
     */
    public function getProcessNodeService(\CUCM\StructType\GetProcessNodeServiceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getProcessNodeService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMohAudioSource
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetMohAudioSourceReq $axlParams
     * @return \CUCM\StructType\GetMohAudioSourceRes|bool
     */
    public function getMohAudioSource(\CUCM\StructType\GetMohAudioSourceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getMohAudioSource($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDhcpServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetDhcpServerReq $axlParams
     * @return \CUCM\StructType\GetDhcpServerRes|bool
     */
    public function getDhcpServer(\CUCM\StructType\GetDhcpServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getDhcpServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDhcpSubnet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetDhcpSubnetReq $axlParams
     * @return \CUCM\StructType\GetDhcpSubnetRes|bool
     */
    public function getDhcpSubnet(\CUCM\StructType\GetDhcpSubnetReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getDhcpSubnet($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetCallParkReq $axlParams
     * @return \CUCM\StructType\GetCallParkRes|bool
     */
    public function getCallPark(\CUCM\StructType\GetCallParkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDirectedCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetDirectedCallParkReq $axlParams
     * @return \CUCM\StructType\GetDirectedCallParkRes|bool
     */
    public function getDirectedCallPark(\CUCM\StructType\GetDirectedCallParkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getDirectedCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMeetMe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetMeetMeReq $axlParams
     * @return \CUCM\StructType\GetMeetMeRes|bool
     */
    public function getMeetMe(\CUCM\StructType\GetMeetMeReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getMeetMe($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMobileVoiceAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetMobileVoiceAccessReq $axlParams
     * @return \CUCM\StructType\GetMobileVoiceAccessRes|bool
     */
    public function getMobileVoiceAccess(\CUCM\StructType\GetMobileVoiceAccessReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getMobileVoiceAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRouteList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetRouteListReq $axlParams
     * @return \CUCM\StructType\GetRouteListRes|bool
     */
    public function getRouteList(\CUCM\StructType\GetRouteListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getRouteList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetUserReq $axlParams
     * @return \CUCM\StructType\GetUserRes|bool
     */
    public function getUser(\CUCM\StructType\GetUserReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLicenseCapabilities
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetLicenseCapabilitiesReq $axlParams
     * @return \CUCM\StructType\GetLicenseCapabilitiesRes|bool
     */
    public function getLicenseCapabilities(\CUCM\StructType\GetLicenseCapabilitiesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getLicenseCapabilities($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAppUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetAppUserReq $axlParams
     * @return \CUCM\StructType\GetAppUserRes|bool
     */
    public function getAppUser(\CUCM\StructType\GetAppUserReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getAppUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSipRealm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetSipRealmReq $axlParams
     * @return \CUCM\StructType\GetSipRealmRes|bool
     */
    public function getSipRealm(\CUCM\StructType\GetSipRealmReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getSipRealm($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPhoneNtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetPhoneNtpReq $axlParams
     * @return \CUCM\StructType\GetPhoneNtpRes|bool
     */
    public function getPhoneNtp(\CUCM\StructType\GetPhoneNtpReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getPhoneNtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDateTimeGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetDateTimeGroupReq $axlParams
     * @return \CUCM\StructType\GetDateTimeGroupRes|bool
     */
    public function getDateTimeGroup(\CUCM\StructType\GetDateTimeGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getDateTimeGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPresenceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetPresenceGroupReq $axlParams
     * @return \CUCM\StructType\GetPresenceGroupRes|bool
     */
    public function getPresenceGroup(\CUCM\StructType\GetPresenceGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getPresenceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGeoLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetGeoLocationReq $axlParams
     * @return \CUCM\StructType\GetGeoLocationRes|bool
     */
    public function getGeoLocation(\CUCM\StructType\GetGeoLocationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getGeoLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSrst
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetSrstReq $axlParams
     * @return \CUCM\StructType\GetSrstRes|bool
     */
    public function getSrst(\CUCM\StructType\GetSrstReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getSrst($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMlppDomain
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetMlppDomainReq $axlParams
     * @return \CUCM\StructType\GetMlppDomainRes|bool
     */
    public function getMlppDomain(\CUCM\StructType\GetMlppDomainReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getMlppDomain($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCumaServerSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetCumaServerSecurityProfileReq $axlParams
     * @return \CUCM\StructType\GetCumaServerSecurityProfileRes|bool
     */
    public function getCumaServerSecurityProfile(\CUCM\StructType\GetCumaServerSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getCumaServerSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getApplicationServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetApplicationServerReq $axlParams
     * @return \CUCM\StructType\GetApplicationServerRes|bool
     */
    public function getApplicationServer(\CUCM\StructType\GetApplicationServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getApplicationServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getApplicationUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetApplicationUserCapfProfileReq $axlParams
     * @return \CUCM\StructType\GetApplicationUserCapfProfileRes|bool
     */
    public function getApplicationUserCapfProfile(\CUCM\StructType\GetApplicationUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getApplicationUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEndUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetEndUserCapfProfileReq $axlParams
     * @return \CUCM\StructType\GetEndUserCapfProfileRes|bool
     */
    public function getEndUserCapfProfile(\CUCM\StructType\GetEndUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getEndUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getServiceParameter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetServiceParameterReq $axlParams
     * @return \CUCM\StructType\GetServiceParameterRes|bool
     */
    public function getServiceParameter(\CUCM\StructType\GetServiceParameterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getServiceParameter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGeoLocationFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetGeoLocationFilterReq $axlParams
     * @return \CUCM\StructType\GetGeoLocationFilterRes|bool
     */
    public function getGeoLocationFilter(\CUCM\StructType\GetGeoLocationFilterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getGeoLocationFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVoiceMailProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetVoiceMailProfileReq $axlParams
     * @return \CUCM\StructType\GetVoiceMailProfileRes|bool
     */
    public function getVoiceMailProfile(\CUCM\StructType\GetVoiceMailProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getVoiceMailProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVoiceMailPort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetVoiceMailPortReq $axlParams
     * @return \CUCM\StructType\GetVoiceMailPortRes|bool
     */
    public function getVoiceMailPort(\CUCM\StructType\GetVoiceMailPortReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getVoiceMailPort($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGatekeeper
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetGatekeeperReq $axlParams
     * @return \CUCM\StructType\GetGatekeeperRes|bool
     */
    public function getGatekeeper(\CUCM\StructType\GetGatekeeperReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getGatekeeper($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPhoneButtonTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetPhoneButtonTemplateReq $axlParams
     * @return \CUCM\StructType\GetPhoneButtonTemplateRes|bool
     */
    public function getPhoneButtonTemplate(\CUCM\StructType\GetPhoneButtonTemplateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getPhoneButtonTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCommonPhoneConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetCommonPhoneConfigReq $axlParams
     * @return \CUCM\StructType\GetCommonPhoneConfigRes|bool
     */
    public function getCommonPhoneConfig(\CUCM\StructType\GetCommonPhoneConfigReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getCommonPhoneConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMessageWaiting
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetMessageWaitingReq $axlParams
     * @return \CUCM\StructType\GetMessageWaitingRes|bool
     */
    public function getMessageWaiting(\CUCM\StructType\GetMessageWaitingReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getMessageWaiting($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getIpPhoneServices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetIpPhoneServicesReq $axlParams
     * @return \CUCM\StructType\GetIpPhoneServicesRes|bool
     */
    public function getIpPhoneServices(\CUCM\StructType\GetIpPhoneServicesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getIpPhoneServices($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCtiRoutePoint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetCtiRoutePointReq $axlParams
     * @return \CUCM\StructType\GetCtiRoutePointRes|bool
     */
    public function getCtiRoutePoint(\CUCM\StructType\GetCtiRoutePointReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getCtiRoutePoint($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTransPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetTransPatternReq $axlParams
     * @return \CUCM\StructType\GetTransPatternRes|bool
     */
    public function getTransPattern(\CUCM\StructType\GetTransPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getTransPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getCallingPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetCallingPartyTransformationPatternReq $axlParams
     * @return \CUCM\StructType\GetCallingPartyTransformationPatternRes|bool
     */
    public function getCallingPartyTransformationPattern(\CUCM\StructType\GetCallingPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getCallingPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSipRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetSipRoutePatternReq $axlParams
     * @return \CUCM\StructType\GetSipRoutePatternRes|bool
     */
    public function getSipRoutePattern(\CUCM\StructType\GetSipRoutePatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getSipRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHuntPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetHuntPilotReq $axlParams
     * @return \CUCM\StructType\GetHuntPilotRes|bool
     */
    public function getHuntPilot(\CUCM\StructType\GetHuntPilotReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getHuntPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetRoutePatternReq $axlParams
     * @return \CUCM\StructType\GetRoutePatternRes|bool
     */
    public function getRoutePattern(\CUCM\StructType\GetRoutePatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getApplicationDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetApplicationDialRulesReq $axlParams
     * @return \CUCM\StructType\GetApplicationDialRulesRes|bool
     */
    public function getApplicationDialRules(\CUCM\StructType\GetApplicationDialRulesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getApplicationDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDirectoryLookupDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetDirectoryLookupDialRulesReq $axlParams
     * @return \CUCM\StructType\GetDirectoryLookupDialRulesRes|bool
     */
    public function getDirectoryLookupDialRules(\CUCM\StructType\GetDirectoryLookupDialRulesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getDirectoryLookupDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPhoneSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetPhoneSecurityProfileReq $axlParams
     * @return \CUCM\StructType\GetPhoneSecurityProfileRes|bool
     */
    public function getPhoneSecurityProfile(\CUCM\StructType\GetPhoneSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getPhoneSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSipDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetSipDialRulesReq $axlParams
     * @return \CUCM\StructType\GetSipDialRulesRes|bool
     */
    public function getSipDialRules(\CUCM\StructType\GetSipDialRulesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getSipDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getConferenceBridge
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetConferenceBridgeReq $axlParams
     * @return \CUCM\StructType\GetConferenceBridgeRes|bool
     */
    public function getConferenceBridge(\CUCM\StructType\GetConferenceBridgeReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getConferenceBridge($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAnnunciator
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetAnnunciatorReq $axlParams
     * @return \CUCM\StructType\GetAnnunciatorRes|bool
     */
    public function getAnnunciator(\CUCM\StructType\GetAnnunciatorReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getAnnunciator($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetMtpReq $axlParams
     * @return \CUCM\StructType\GetMtpRes|bool
     */
    public function getMtp(\CUCM\StructType\GetMtpReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getMtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFixedMohAudioSource
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetFixedMohAudioSourceReq $axlParams
     * @return \CUCM\StructType\GetFixedMohAudioSourceRes|bool
     */
    public function getFixedMohAudioSource(\CUCM\StructType\GetFixedMohAudioSourceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getFixedMohAudioSource($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRemoteDestinationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetRemoteDestinationProfileReq $axlParams
     * @return \CUCM\StructType\GetRemoteDestinationProfileRes|bool
     */
    public function getRemoteDestinationProfile(\CUCM\StructType\GetRemoteDestinationProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getRemoteDestinationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetLineReq $axlParams
     * @return \CUCM\StructType\GetLineRes|bool
     */
    public function getLine(\CUCM\StructType\GetLineReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getLine($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDefaultDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetDefaultDeviceProfileReq $axlParams
     * @return \CUCM\StructType\GetDefaultDeviceProfileRes|bool
     */
    public function getDefaultDeviceProfile(\CUCM\StructType\GetDefaultDeviceProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getDefaultDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getH323Phone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetH323PhoneReq $axlParams
     * @return \CUCM\StructType\GetH323PhoneRes|bool
     */
    public function getH323Phone(\CUCM\StructType\GetH323PhoneReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getH323Phone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMohServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetMohServerReq $axlParams
     * @return \CUCM\StructType\GetMohServerRes|bool
     */
    public function getMohServer(\CUCM\StructType\GetMohServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getMohServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getH323Trunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetH323TrunkReq $axlParams
     * @return \CUCM\StructType\GetH323TrunkRes|bool
     */
    public function getH323Trunk(\CUCM\StructType\GetH323TrunkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getH323Trunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetPhoneReq $axlParams
     * @return \CUCM\StructType\GetPhoneRes|bool
     */
    public function getPhone(\CUCM\StructType\GetPhoneReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getPhone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getH323Gateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetH323GatewayReq $axlParams
     * @return \CUCM\StructType\GetH323GatewayRes|bool
     */
    public function getH323Gateway(\CUCM\StructType\GetH323GatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getH323Gateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetDeviceProfileReq $axlParams
     * @return \CUCM\StructType\GetDeviceProfileRes|bool
     */
    public function getDeviceProfile(\CUCM\StructType\GetDeviceProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRemoteDestination
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetRemoteDestinationReq $axlParams
     * @return \CUCM\StructType\GetRemoteDestinationRes|bool
     */
    public function getRemoteDestination(\CUCM\StructType\GetRemoteDestinationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getRemoteDestination($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetGatewayReq $axlParams
     * @return \CUCM\StructType\GetGatewayRes|bool
     */
    public function getGateway(\CUCM\StructType\GetGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGatewayEndpointAnalogAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetGatewayEndpointAnalogAccessReq $axlParams
     * @return \CUCM\StructType\GetGatewayEndpointAnalogAccessRes|bool
     */
    public function getGatewayEndpointAnalogAccess(\CUCM\StructType\GetGatewayEndpointAnalogAccessReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getGatewayEndpointAnalogAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGatewayEndpointDigitalAccessPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetGatewayEndpointDigitalAccessPriReq $axlParams
     * @return \CUCM\StructType\GetGatewayEndpointDigitalAccessPriRes|bool
     */
    public function getGatewayEndpointDigitalAccessPri(\CUCM\StructType\GetGatewayEndpointDigitalAccessPriReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getGatewayEndpointDigitalAccessPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGatewayEndpointDigitalAccessBri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetGatewayEndpointDigitalAccessBriReq $axlParams
     * @return \CUCM\StructType\GetGatewayEndpointDigitalAccessBriRes|bool
     */
    public function getGatewayEndpointDigitalAccessBri(\CUCM\StructType\GetGatewayEndpointDigitalAccessBriReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getGatewayEndpointDigitalAccessBri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGatewayEndpointDigitalAccessT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetGatewayEndpointDigitalAccessT1Req $axlParams
     * @return \CUCM\StructType\GetGatewayEndpointDigitalAccessT1Res|bool
     */
    public function getGatewayEndpointDigitalAccessT1(\CUCM\StructType\GetGatewayEndpointDigitalAccessT1Req $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getGatewayEndpointDigitalAccessT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVg224
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetVg224Req $axlParams
     * @return \CUCM\StructType\GetVg224Res|bool
     */
    public function getVg224(\CUCM\StructType\GetVg224Req $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getVg224($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getCiscoCatalyst600024PortFXSGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetCiscoCatalyst600024PortFXSGatewayReq $axlParams
     * @return \CUCM\StructType\GetCiscoCatalyst600024PortFXSGatewayRes|bool
     */
    public function getCiscoCatalyst600024PortFXSGateway(\CUCM\StructType\GetCiscoCatalyst600024PortFXSGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getCiscoCatalyst600024PortFXSGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCiscoCatalyst6000E1VoIPGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetCiscoCatalyst6000E1VoIPGatewayReq $axlParams
     * @return \CUCM\StructType\GetCiscoCatalyst6000E1VoIPGatewayRes|bool
     */
    public function getCiscoCatalyst6000E1VoIPGateway(\CUCM\StructType\GetCiscoCatalyst6000E1VoIPGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getCiscoCatalyst6000E1VoIPGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getCiscoCatalyst6000T1VoIPGatewayPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetCiscoCatalyst6000T1VoIPGatewayPriReq $axlParams
     * @return \CUCM\StructType\GetCiscoCatalyst6000T1VoIPGatewayPriRes|bool
     */
    public function getCiscoCatalyst6000T1VoIPGatewayPri(\CUCM\StructType\GetCiscoCatalyst6000T1VoIPGatewayPriReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getCiscoCatalyst6000T1VoIPGatewayPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getCiscoCatalyst6000T1VoIPGatewayT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetCiscoCatalyst6000T1VoIPGatewayT1Req $axlParams
     * @return \CUCM\StructType\GetCiscoCatalyst6000T1VoIPGatewayT1Res|bool
     */
    public function getCiscoCatalyst6000T1VoIPGatewayT1(\CUCM\StructType\GetCiscoCatalyst6000T1VoIPGatewayT1Req $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getCiscoCatalyst6000T1VoIPGatewayT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCallPickupGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetCallPickupGroupReq $axlParams
     * @return \CUCM\StructType\GetCallPickupGroupRes|bool
     */
    public function getCallPickupGroup(\CUCM\StructType\GetCallPickupGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getCallPickupGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGeoLocationPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetGeoLocationPolicyReq $axlParams
     * @return \CUCM\StructType\GetGeoLocationPolicyRes|bool
     */
    public function getGeoLocationPolicy(\CUCM\StructType\GetGeoLocationPolicyReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getGeoLocationPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSipTrunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetSipTrunkReq $axlParams
     * @return \CUCM\StructType\GetSipTrunkRes|bool
     */
    public function getSipTrunk(\CUCM\StructType\GetSipTrunkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getSipTrunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getCalledPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetCalledPartyTransformationPatternReq $axlParams
     * @return \CUCM\StructType\GetCalledPartyTransformationPatternRes|bool
     */
    public function getCalledPartyTransformationPattern(\CUCM\StructType\GetCalledPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getCalledPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getExternalCallControlProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetExternalCallControlProfileReq $axlParams
     * @return \CUCM\StructType\GetExternalCallControlProfileRes|bool
     */
    public function getExternalCallControlProfile(\CUCM\StructType\GetExternalCallControlProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getExternalCallControlProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSafSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetSafSecurityProfileReq $axlParams
     * @return \CUCM\StructType\GetSafSecurityProfileRes|bool
     */
    public function getSafSecurityProfile(\CUCM\StructType\GetSafSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getSafSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSafForwarder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetSafForwarderReq $axlParams
     * @return \CUCM\StructType\GetSafForwarderRes|bool
     */
    public function getSafForwarder(\CUCM\StructType\GetSafForwarderReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getSafForwarder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCcdHostedDN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetCcdHostedDNReq $axlParams
     * @return \CUCM\StructType\GetCcdHostedDNRes|bool
     */
    public function getCcdHostedDN(\CUCM\StructType\GetCcdHostedDNReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getCcdHostedDN($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCcdHostedDNGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetCcdHostedDNGroupReq $axlParams
     * @return \CUCM\StructType\GetCcdHostedDNGroupRes|bool
     */
    public function getCcdHostedDNGroup(\CUCM\StructType\GetCcdHostedDNGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getCcdHostedDNGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCcdRequestingService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetCcdRequestingServiceReq $axlParams
     * @return \CUCM\StructType\GetCcdRequestingServiceRes|bool
     */
    public function getCcdRequestingService(\CUCM\StructType\GetCcdRequestingServiceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getCcdRequestingService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInterClusterServiceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetInterClusterServiceProfileReq $axlParams
     * @return \CUCM\StructType\GetInterClusterServiceProfileRes|bool
     */
    public function getInterClusterServiceProfile(\CUCM\StructType\GetInterClusterServiceProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getInterClusterServiceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRemoteCluster
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetRemoteClusterReq $axlParams
     * @return \CUCM\StructType\GetRemoteClusterRes|bool
     */
    public function getRemoteCluster(\CUCM\StructType\GetRemoteClusterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getRemoteCluster($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCcdAdvertisingService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetCcdAdvertisingServiceReq $axlParams
     * @return \CUCM\StructType\GetCcdAdvertisingServiceRes|bool
     */
    public function getCcdAdvertisingService(\CUCM\StructType\GetCcdAdvertisingServiceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getCcdAdvertisingService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLdapDirectory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetLdapDirectoryReq $axlParams
     * @return \CUCM\StructType\GetLdapDirectoryRes|bool
     */
    public function getLdapDirectory(\CUCM\StructType\GetLdapDirectoryReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getLdapDirectory($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEmccFeatureConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetEmccFeatureConfigReq $axlParams
     * @return \CUCM\StructType\GetEmccFeatureConfigRes|bool
     */
    public function getEmccFeatureConfig(\CUCM\StructType\GetEmccFeatureConfigReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getEmccFeatureConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSafCcdPurgeBlockLearnedRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetSafCcdPurgeBlockLearnedRoutesReq $axlParams
     * @return \CUCM\StructType\GetSafCcdPurgeBlockLearnedRoutesRes|bool
     */
    public function getSafCcdPurgeBlockLearnedRoutes(\CUCM\StructType\GetSafCcdPurgeBlockLearnedRoutesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getSafCcdPurgeBlockLearnedRoutes($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVpnGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetVpnGatewayReq $axlParams
     * @return \CUCM\StructType\GetVpnGatewayRes|bool
     */
    public function getVpnGateway(\CUCM\StructType\GetVpnGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getVpnGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVpnGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetVpnGroupReq $axlParams
     * @return \CUCM\StructType\GetVpnGroupRes|bool
     */
    public function getVpnGroup(\CUCM\StructType\GetVpnGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getVpnGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVpnProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetVpnProfileReq $axlParams
     * @return \CUCM\StructType\GetVpnProfileRes|bool
     */
    public function getVpnProfile(\CUCM\StructType\GetVpnProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getVpnProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetImeServerReq $axlParams
     * @return \CUCM\StructType\GetImeServerRes|bool
     */
    public function getImeServer(\CUCM\StructType\GetImeServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getImeServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeRouteFilterGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetImeRouteFilterGroupReq $axlParams
     * @return \CUCM\StructType\GetImeRouteFilterGroupRes|bool
     */
    public function getImeRouteFilterGroup(\CUCM\StructType\GetImeRouteFilterGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getImeRouteFilterGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeRouteFilterElement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetImeRouteFilterElementReq $axlParams
     * @return \CUCM\StructType\GetImeRouteFilterElementRes|bool
     */
    public function getImeRouteFilterElement(\CUCM\StructType\GetImeRouteFilterElementReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getImeRouteFilterElement($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeClient
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetImeClientReq $axlParams
     * @return \CUCM\StructType\GetImeClientRes|bool
     */
    public function getImeClient(\CUCM\StructType\GetImeClientReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getImeClient($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeEnrolledPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetImeEnrolledPatternReq $axlParams
     * @return \CUCM\StructType\GetImeEnrolledPatternRes|bool
     */
    public function getImeEnrolledPattern(\CUCM\StructType\GetImeEnrolledPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getImeEnrolledPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeEnrolledPatternGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetImeEnrolledPatternGroupReq $axlParams
     * @return \CUCM\StructType\GetImeEnrolledPatternGroupRes|bool
     */
    public function getImeEnrolledPatternGroup(\CUCM\StructType\GetImeEnrolledPatternGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getImeEnrolledPatternGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeExclusionNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetImeExclusionNumberReq $axlParams
     * @return \CUCM\StructType\GetImeExclusionNumberRes|bool
     */
    public function getImeExclusionNumber(\CUCM\StructType\GetImeExclusionNumberReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getImeExclusionNumber($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeExclusionNumberGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetImeExclusionNumberGroupReq $axlParams
     * @return \CUCM\StructType\GetImeExclusionNumberGroupRes|bool
     */
    public function getImeExclusionNumberGroup(\CUCM\StructType\GetImeExclusionNumberGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getImeExclusionNumberGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeFirewall
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetImeFirewallReq $axlParams
     * @return \CUCM\StructType\GetImeFirewallRes|bool
     */
    public function getImeFirewall(\CUCM\StructType\GetImeFirewallReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getImeFirewall($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeE164Transformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetImeE164TransformationReq $axlParams
     * @return \CUCM\StructType\GetImeE164TransformationRes|bool
     */
    public function getImeE164Transformation(\CUCM\StructType\GetImeE164TransformationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getImeE164Transformation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTransformationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetTransformationProfileReq $axlParams
     * @return \CUCM\StructType\GetTransformationProfileRes|bool
     */
    public function getTransformationProfile(\CUCM\StructType\GetTransformationProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getTransformationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFallbackProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetFallbackProfileReq $axlParams
     * @return \CUCM\StructType\GetFallbackProfileRes|bool
     */
    public function getFallbackProfile(\CUCM\StructType\GetFallbackProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getFallbackProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLdapFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetLdapFilterReq $axlParams
     * @return \CUCM\StructType\GetLdapFilterRes|bool
     */
    public function getLdapFilter(\CUCM\StructType\GetLdapFilterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getLdapFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTvsCertificate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetTvsCertificateReq $axlParams
     * @return \CUCM\StructType\GetTvsCertificateRes|bool
     */
    public function getTvsCertificate(\CUCM\StructType\GetTvsCertificateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getTvsCertificate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFeatureControlPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetFeatureControlPolicyReq $axlParams
     * @return \CUCM\StructType\GetFeatureControlPolicyRes|bool
     */
    public function getFeatureControlPolicy(\CUCM\StructType\GetFeatureControlPolicyReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getFeatureControlPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMobilityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetMobilityProfileReq $axlParams
     * @return \CUCM\StructType\GetMobilityProfileRes|bool
     */
    public function getMobilityProfile(\CUCM\StructType\GetMobilityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getMobilityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getEnterpriseFeatureAccessConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetEnterpriseFeatureAccessConfigurationReq $axlParams
     * @return \CUCM\StructType\GetEnterpriseFeatureAccessConfigurationRes|bool
     */
    public function getEnterpriseFeatureAccessConfiguration(\CUCM\StructType\GetEnterpriseFeatureAccessConfigurationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getEnterpriseFeatureAccessConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHandoffConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetHandoffConfigurationReq $axlParams
     * @return \CUCM\StructType\GetHandoffConfigurationRes|bool
     */
    public function getHandoffConfiguration(\CUCM\StructType\GetHandoffConfigurationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getHandoffConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOSVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetOSVersionReq $axlParams
     * @return \CUCM\StructType\GetOSVersionRes|bool
     */
    public function getOSVersion(\CUCM\StructType\GetOSVersionReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getOSVersion($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNumDevices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetNumDevicesReq $axlParams
     * @return \CUCM\StructType\GetNumDevicesResponse|bool
     */
    public function getNumDevices(\CUCM\StructType\GetNumDevicesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getNumDevices($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMobility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetMobilityReq $axlParams
     * @return \CUCM\StructType\GetMobilityRes|bool
     */
    public function getMobility(\CUCM\StructType\GetMobilityReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getMobility($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEnterprisePhoneConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetEnterprisePhoneConfigReq $axlParams
     * @return \CUCM\StructType\GetEnterprisePhoneConfigRes|bool
     */
    public function getEnterprisePhoneConfig(\CUCM\StructType\GetEnterprisePhoneConfigReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getEnterprisePhoneConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLicenseUnitReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetLicenseUnitReportReq $axlParams
     * @return \CUCM\StructType\GetLicenseUnitReportRes|bool
     */
    public function getLicenseUnitReport(\CUCM\StructType\GetLicenseUnitReportReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getLicenseUnitReport($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLdapSystem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetLdapSystemReq $axlParams
     * @return \CUCM\StructType\GetLdapSystemRes|bool
     */
    public function getLdapSystem(\CUCM\StructType\GetLdapSystemReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getLdapSystem($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLdapAuthentication
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetLdapAuthenticationReq $axlParams
     * @return \CUCM\StructType\GetLdapAuthenticationRes|bool
     */
    public function getLdapAuthentication(\CUCM\StructType\GetLdapAuthenticationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getLdapAuthentication($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCCMVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetCCMVersionReq $axlParams
     * @return \CUCM\StructType\GetCCMVersionRes|bool
     */
    public function getCCMVersion(\CUCM\StructType\GetCCMVersionReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getCCMVersion($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeLearnedRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetImeLearnedRoutesReq $axlParams
     * @return \CUCM\StructType\GetImeLearnedRoutesRes|bool
     */
    public function getImeLearnedRoutes(\CUCM\StructType\GetImeLearnedRoutesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getImeLearnedRoutes($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeFeatureConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetImeFeatureConfigReq $axlParams
     * @return \CUCM\StructType\GetImeFeatureConfigRes|bool
     */
    public function getImeFeatureConfig(\CUCM\StructType\GetImeFeatureConfigReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getImeFeatureConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFallbackFeatureConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetFallbackFeatureConfigReq $axlParams
     * @return \CUCM\StructType\GetFallbackFeatureConfigRes|bool
     */
    public function getFallbackFeatureConfig(\CUCM\StructType\GetFallbackFeatureConfigReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getFallbackFeatureConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAppServerInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetAppServerInfoReq $axlParams
     * @return \CUCM\StructType\GetAppServerInfoRes|bool
     */
    public function getAppServerInfo(\CUCM\StructType\GetAppServerInfoReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getAppServerInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLdapSyncStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetLdapSyncStatusReq $axlParams
     * @return \CUCM\StructType\GetLdapSyncStatusRes|bool
     */
    public function getLdapSyncStatus(\CUCM\StructType\GetLdapSyncStatusReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getLdapSyncStatus($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSoftKeySet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\GetSoftKeySetReq $axlParams
     * @return \CUCM\StructType\GetSoftKeySetRes|bool
     */
    public function getSoftKeySet(\CUCM\StructType\GetSoftKeySetReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->getSoftKeySet($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CUCM\StructType\GetAarGroupRes|\CUCM\StructType\GetAnnunciatorRes|\CUCM\StructType\GetApplicationDialRulesRes|\CUCM\StructType\GetApplicationServerRes|\CUCM\StructType\GetApplicationUserCapfProfileRes|\CUCM\StructType\GetAppServerInfoRes|\CUCM\StructType\GetAppUserRes|\CUCM\StructType\GetCalledPartyTransformationPatternRes|\CUCM\StructType\GetCallerFilterListRes|\CUCM\StructType\GetCallingPartyTransformationPatternRes|\CUCM\StructType\GetCallManagerGroupRes|\CUCM\StructType\GetCallManagerRes|\CUCM\StructType\GetCallParkRes|\CUCM\StructType\GetCallPickupGroupRes|\CUCM\StructType\GetCcdAdvertisingServiceRes|\CUCM\StructType\GetCcdHostedDNGroupRes|\CUCM\StructType\GetCcdHostedDNRes|\CUCM\StructType\GetCcdRequestingServiceRes|\CUCM\StructType\GetCCMVersionRes|\CUCM\StructType\GetCiscoCatalyst6000E1VoIPGatewayRes|\CUCM\StructType\GetCiscoCatalyst6000T1VoIPGatewayPriRes|\CUCM\StructType\GetCiscoCatalyst6000T1VoIPGatewayT1Res|\CUCM\StructType\GetCiscoCatalyst600024PortFXSGatewayRes|\CUCM\StructType\GetCmcInfoRes|\CUCM\StructType\GetCommonDeviceConfigRes|\CUCM\StructType\GetCommonPhoneConfigRes|\CUCM\StructType\GetConferenceBridgeRes|\CUCM\StructType\GetCredentialPolicyRes|\CUCM\StructType\GetCssRes|\CUCM\StructType\GetCtiRoutePointRes|\CUCM\StructType\GetCumaServerSecurityProfileRes|\CUCM\StructType\GetDateTimeGroupRes|\CUCM\StructType\GetDdiRes|\CUCM\StructType\GetDefaultDeviceProfileRes|\CUCM\StructType\GetDeviceMobilityGroupRes|\CUCM\StructType\GetDeviceMobilityRes|\CUCM\StructType\GetDevicePoolRes|\CUCM\StructType\GetDeviceProfileRes|\CUCM\StructType\GetDhcpServerRes|\CUCM\StructType\GetDhcpSubnetRes|\CUCM\StructType\GetDialPlanRes|\CUCM\StructType\GetDialPlanTagRes|\CUCM\StructType\GetDirectedCallParkRes|\CUCM\StructType\GetDirectoryLookupDialRulesRes|\CUCM\StructType\GetEmccFeatureConfigRes|\CUCM\StructType\GetEndUserCapfProfileRes|\CUCM\StructType\GetEnterpriseFeatureAccessConfigurationRes|\CUCM\StructType\GetEnterprisePhoneConfigRes|\CUCM\StructType\GetExternalCallControlProfileRes|\CUCM\StructType\GetFacInfoRes|\CUCM\StructType\GetFallbackFeatureConfigRes|\CUCM\StructType\GetFallbackProfileRes|\CUCM\StructType\GetFeatureControlPolicyRes|\CUCM\StructType\GetFixedMohAudioSourceRes|\CUCM\StructType\GetGatekeeperRes|\CUCM\StructType\GetGatewayEndpointAnalogAccessRes|\CUCM\StructType\GetGatewayEndpointDigitalAccessBriRes|\CUCM\StructType\GetGatewayEndpointDigitalAccessPriRes|\CUCM\StructType\GetGatewayEndpointDigitalAccessT1Res|\CUCM\StructType\GetGatewayRes|\CUCM\StructType\GetGeoLocationFilterRes|\CUCM\StructType\GetGeoLocationPolicyRes|\CUCM\StructType\GetGeoLocationRes|\CUCM\StructType\GetH323GatewayRes|\CUCM\StructType\GetH323PhoneRes|\CUCM\StructType\GetH323TrunkRes|\CUCM\StructType\GetHandoffConfigurationRes|\CUCM\StructType\GetHuntListRes|\CUCM\StructType\GetHuntPilotRes|\CUCM\StructType\GetImeClientRes|\CUCM\StructType\GetImeE164TransformationRes|\CUCM\StructType\GetImeEnrolledPatternGroupRes|\CUCM\StructType\GetImeEnrolledPatternRes|\CUCM\StructType\GetImeExclusionNumberGroupRes|\CUCM\StructType\GetImeExclusionNumberRes|\CUCM\StructType\GetImeFeatureConfigRes|\CUCM\StructType\GetImeFirewallRes|\CUCM\StructType\GetImeLearnedRoutesRes|\CUCM\StructType\GetImeRouteFilterElementRes|\CUCM\StructType\GetImeRouteFilterGroupRes|\CUCM\StructType\GetImeServerRes|\CUCM\StructType\GetInterClusterServiceProfileRes|\CUCM\StructType\GetIpPhoneServicesRes|\CUCM\StructType\GetIvrUserLocaleRes|\CUCM\StructType\GetLdapAuthenticationRes|\CUCM\StructType\GetLdapDirectoryRes|\CUCM\StructType\GetLdapFilterRes|\CUCM\StructType\GetLdapSyncStatusRes|\CUCM\StructType\GetLdapSystemRes|\CUCM\StructType\GetLicenseCapabilitiesRes|\CUCM\StructType\GetLicenseUnitReportRes|\CUCM\StructType\GetLineGroupRes|\CUCM\StructType\GetLineRes|\CUCM\StructType\GetLocationRes|\CUCM\StructType\GetMediaResourceGroupRes|\CUCM\StructType\GetMediaResourceListRes|\CUCM\StructType\GetMeetMeRes|\CUCM\StructType\GetMessageWaitingRes|\CUCM\StructType\GetMlppDomainRes|\CUCM\StructType\GetMobileSmartClientProfileRes|\CUCM\StructType\GetMobileVoiceAccessRes|\CUCM\StructType\GetMobilityProfileRes|\CUCM\StructType\GetMobilityRes|\CUCM\StructType\GetMohAudioSourceRes|\CUCM\StructType\GetMohServerRes|\CUCM\StructType\GetMtpRes|\CUCM\StructType\GetNumDevicesResponse|\CUCM\StructType\GetOSVersionRes|\CUCM\StructType\GetPhoneButtonTemplateRes|\CUCM\StructType\GetPhoneNtpRes|\CUCM\StructType\GetPhoneRes|\CUCM\StructType\GetPhoneSecurityProfileRes|\CUCM\StructType\GetPhysicalLocationRes|\CUCM\StructType\GetPresenceGroupRes|\CUCM\StructType\GetProcessNodeRes|\CUCM\StructType\GetProcessNodeServiceRes|\CUCM\StructType\GetRecordingProfileRes|\CUCM\StructType\GetRegionRes|\CUCM\StructType\GetRemoteClusterRes|\CUCM\StructType\GetRemoteDestinationProfileRes|\CUCM\StructType\GetRemoteDestinationRes|\CUCM\StructType\GetResourcePriorityNamespaceListRes|\CUCM\StructType\GetResourcePriorityNamespaceRes|\CUCM\StructType\GetRouteFilterRes|\CUCM\StructType\GetRouteGroupRes|\CUCM\StructType\GetRouteListRes|\CUCM\StructType\GetRoutePartitionRes|\CUCM\StructType\GetRoutePatternRes|\CUCM\StructType\GetSafCcdPurgeBlockLearnedRoutesRes|\CUCM\StructType\GetSafForwarderRes|\CUCM\StructType\GetSafSecurityProfileRes|\CUCM\StructType\GetServiceParameterRes|\CUCM\StructType\GetSipDialRulesRes|\CUCM\StructType\GetSipProfileRes|\CUCM\StructType\GetSipRealmRes|\CUCM\StructType\GetSipRoutePatternRes|\CUCM\StructType\GetSipTrunkRes|\CUCM\StructType\GetSipTrunkSecurityProfileRes|\CUCM\StructType\GetSoftKeySetRes|\CUCM\StructType\GetSoftKeyTemplateRes|\CUCM\StructType\GetSrstRes|\CUCM\StructType\GetTimePeriodRes|\CUCM\StructType\GetTimeScheduleRes|\CUCM\StructType\GetTodAccessRes|\CUCM\StructType\GetTranscoderRes|\CUCM\StructType\GetTransformationProfileRes|\CUCM\StructType\GetTransPatternRes|\CUCM\StructType\GetTvsCertificateRes|\CUCM\StructType\GetUserGroupRes|\CUCM\StructType\GetUserRes|\CUCM\StructType\GetVg224Res|\CUCM\StructType\GetVoiceMailPilotRes|\CUCM\StructType\GetVoiceMailPortRes|\CUCM\StructType\GetVoiceMailProfileRes|\CUCM\StructType\GetVpnGatewayRes|\CUCM\StructType\GetVpnGroupRes|\CUCM\StructType\GetVpnProfileRes
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
