<?php

namespace CUCM\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Execute ServiceType
 * @subpackage Services
 */
class Execute extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named executeSQLQuery
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ExecuteSQLQueryReq $axlParams
     * @return \CUCM\StructType\ExecuteSQLQueryRes|bool
     */
    public function executeSQLQuery(\CUCM\StructType\ExecuteSQLQueryReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->executeSQLQuery($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named executeSQLUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\ExecuteSQLUpdateReq $axlParams
     * @return \CUCM\StructType\ExecuteSQLUpdateRes|bool
     */
    public function executeSQLUpdate(\CUCM\StructType\ExecuteSQLUpdateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->executeSQLUpdate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CUCM\StructType\ExecuteSQLQueryRes|\CUCM\StructType\ExecuteSQLUpdateRes
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
