<?php

namespace CUCM\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named addSipProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddSipProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addSipProfile(\CUCM\StructType\AddSipProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addSipProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSipTrunkSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddSipTrunkSecurityProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addSipTrunkSecurityProfile(\CUCM\StructType\AddSipTrunkSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addSipTrunkSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addTimePeriod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddTimePeriodReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addTimePeriod(\CUCM\StructType\AddTimePeriodReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addTimePeriod($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addTimeSchedule
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddTimeScheduleReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addTimeSchedule(\CUCM\StructType\AddTimeScheduleReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addTimeSchedule($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addTodAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddTodAccessReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addTodAccess(\CUCM\StructType\AddTodAccessReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addTodAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addVoiceMailPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddVoiceMailPilotReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addVoiceMailPilot(\CUCM\StructType\AddVoiceMailPilotReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addVoiceMailPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addProcessNode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddProcessNodeReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addProcessNode(\CUCM\StructType\AddProcessNodeReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addProcessNode($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCallerFilterList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddCallerFilterListReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addCallerFilterList(\CUCM\StructType\AddCallerFilterListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCallerFilterList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRoutePartition
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddRoutePartitionReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addRoutePartition(\CUCM\StructType\AddRoutePartitionReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addRoutePartition($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddCssReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addCss(\CUCM\StructType\AddCssReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCss($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMediaResourceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddMediaResourceGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addMediaResourceGroup(\CUCM\StructType\AddMediaResourceGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addMediaResourceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMediaResourceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddMediaResourceListReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addMediaResourceList(\CUCM\StructType\AddMediaResourceListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addMediaResourceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRegion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddRegionReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addRegion(\CUCM\StructType\AddRegionReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addRegion($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addAarGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddAarGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addAarGroup(\CUCM\StructType\AddAarGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addAarGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addPhysicalLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddPhysicalLocationReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addPhysicalLocation(\CUCM\StructType\AddPhysicalLocationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addPhysicalLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRouteGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddRouteGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addRouteGroup(\CUCM\StructType\AddRouteGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addRouteGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDevicePool
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddDevicePoolReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addDevicePool(\CUCM\StructType\AddDevicePoolReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addDevicePool($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDeviceMobilityGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddDeviceMobilityGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addDeviceMobilityGroup(\CUCM\StructType\AddDeviceMobilityGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addDeviceMobilityGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddLocationReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addLocation(\CUCM\StructType\AddLocationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSoftKeyTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddSoftKeyTemplateReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addSoftKeyTemplate(\CUCM\StructType\AddSoftKeyTemplateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addSoftKeyTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addTranscoder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddTranscoderReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addTranscoder(\CUCM\StructType\AddTranscoderReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addTranscoder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCommonDeviceConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddCommonDeviceConfigReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addCommonDeviceConfig(\CUCM\StructType\AddCommonDeviceConfigReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCommonDeviceConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addResourcePriorityNamespace
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddResourcePriorityNamespaceReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addResourcePriorityNamespace(\CUCM\StructType\AddResourcePriorityNamespaceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addResourcePriorityNamespace($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addResourcePriorityNamespaceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddResourcePriorityNamespaceListReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addResourcePriorityNamespaceList(\CUCM\StructType\AddResourcePriorityNamespaceListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addResourcePriorityNamespaceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDeviceMobility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddDeviceMobilityReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addDeviceMobility(\CUCM\StructType\AddDeviceMobilityReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addDeviceMobility($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCmcInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddCmcInfoReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addCmcInfo(\CUCM\StructType\AddCmcInfoReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCmcInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCredentialPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddCredentialPolicyReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addCredentialPolicy(\CUCM\StructType\AddCredentialPolicyReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCredentialPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addFacInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddFacInfoReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addFacInfo(\CUCM\StructType\AddFacInfoReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addFacInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addHuntList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddHuntListReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addHuntList(\CUCM\StructType\AddHuntListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addHuntList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addIvrUserLocale
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddIvrUserLocaleReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addIvrUserLocale(\CUCM\StructType\AddIvrUserLocaleReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addIvrUserLocale($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLineGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddLineGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addLineGroup(\CUCM\StructType\AddLineGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addLineGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRecordingProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddRecordingProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addRecordingProfile(\CUCM\StructType\AddRecordingProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addRecordingProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRouteFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddRouteFilterReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addRouteFilter(\CUCM\StructType\AddRouteFilterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addRouteFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCallManagerGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddCallManagerGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addCallManagerGroup(\CUCM\StructType\AddCallManagerGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCallManagerGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addUserGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddUserGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addUserGroup(\CUCM\StructType\AddUserGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addUserGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDhcpServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddDhcpServerReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addDhcpServer(\CUCM\StructType\AddDhcpServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addDhcpServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDhcpSubnet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddDhcpSubnetReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addDhcpSubnet(\CUCM\StructType\AddDhcpSubnetReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addDhcpSubnet($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddCallParkReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addCallPark(\CUCM\StructType\AddCallParkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDirectedCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddDirectedCallParkReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addDirectedCallPark(\CUCM\StructType\AddDirectedCallParkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addDirectedCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMeetMe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddMeetMeReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addMeetMe(\CUCM\StructType\AddMeetMeReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addMeetMe($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMobileVoiceAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddMobileVoiceAccessReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addMobileVoiceAccess(\CUCM\StructType\AddMobileVoiceAccessReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addMobileVoiceAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRouteList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddRouteListReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addRouteList(\CUCM\StructType\AddRouteListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addRouteList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddUserReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addUser(\CUCM\StructType\AddUserReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addAppUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddAppUserReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addAppUser(\CUCM\StructType\AddAppUserReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addAppUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSipRealm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddSipRealmReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addSipRealm(\CUCM\StructType\AddSipRealmReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addSipRealm($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addPhoneNtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddPhoneNtpReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addPhoneNtp(\CUCM\StructType\AddPhoneNtpReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addPhoneNtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDateTimeGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddDateTimeGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addDateTimeGroup(\CUCM\StructType\AddDateTimeGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addDateTimeGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addPresenceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddPresenceGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addPresenceGroup(\CUCM\StructType\AddPresenceGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addPresenceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGeoLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddGeoLocationReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addGeoLocation(\CUCM\StructType\AddGeoLocationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addGeoLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSrst
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddSrstReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addSrst(\CUCM\StructType\AddSrstReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addSrst($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMlppDomain
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddMlppDomainReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addMlppDomain(\CUCM\StructType\AddMlppDomainReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addMlppDomain($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCumaServerSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddCumaServerSecurityProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addCumaServerSecurityProfile(\CUCM\StructType\AddCumaServerSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCumaServerSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addApplicationServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddApplicationServerReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addApplicationServer(\CUCM\StructType\AddApplicationServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addApplicationServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addApplicationUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddApplicationUserCapfProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addApplicationUserCapfProfile(\CUCM\StructType\AddApplicationUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addApplicationUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addEndUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddEndUserCapfProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addEndUserCapfProfile(\CUCM\StructType\AddEndUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addEndUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addUserPhoneAssociation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddUserPhoneAssociationReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addUserPhoneAssociation(\CUCM\StructType\AddUserPhoneAssociationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addUserPhoneAssociation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGeoLocationFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddGeoLocationFilterReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addGeoLocationFilter(\CUCM\StructType\AddGeoLocationFilterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addGeoLocationFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addVoiceMailProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddVoiceMailProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addVoiceMailProfile(\CUCM\StructType\AddVoiceMailProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addVoiceMailProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addVoiceMailPort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddVoiceMailPortReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addVoiceMailPort(\CUCM\StructType\AddVoiceMailPortReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addVoiceMailPort($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGatekeeper
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddGatekeeperReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addGatekeeper(\CUCM\StructType\AddGatekeeperReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addGatekeeper($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addPhoneButtonTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddPhoneButtonTemplateReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addPhoneButtonTemplate(\CUCM\StructType\AddPhoneButtonTemplateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addPhoneButtonTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCommonPhoneConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddCommonPhoneConfigReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addCommonPhoneConfig(\CUCM\StructType\AddCommonPhoneConfigReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCommonPhoneConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMessageWaiting
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddMessageWaitingReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addMessageWaiting(\CUCM\StructType\AddMessageWaitingReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addMessageWaiting($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addIpPhoneServices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddIpPhoneServicesReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addIpPhoneServices(\CUCM\StructType\AddIpPhoneServicesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addIpPhoneServices($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCtiRoutePoint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddCtiRoutePointReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addCtiRoutePoint(\CUCM\StructType\AddCtiRoutePointReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCtiRoutePoint($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addTransPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddTransPatternReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addTransPattern(\CUCM\StructType\AddTransPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addTransPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * addCallingPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddCallingPartyTransformationPatternReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addCallingPartyTransformationPattern(\CUCM\StructType\AddCallingPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCallingPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSipRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddSipRoutePatternReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addSipRoutePattern(\CUCM\StructType\AddSipRoutePatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addSipRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addHuntPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddHuntPilotReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addHuntPilot(\CUCM\StructType\AddHuntPilotReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addHuntPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddRoutePatternReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addRoutePattern(\CUCM\StructType\AddRoutePatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addApplicationDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddApplicationDialRulesReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addApplicationDialRules(\CUCM\StructType\AddApplicationDialRulesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addApplicationDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDirectoryLookupDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddDirectoryLookupDialRulesReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addDirectoryLookupDialRules(\CUCM\StructType\AddDirectoryLookupDialRulesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addDirectoryLookupDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addPhoneSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddPhoneSecurityProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addPhoneSecurityProfile(\CUCM\StructType\AddPhoneSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addPhoneSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSipDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddSipDialRulesReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addSipDialRules(\CUCM\StructType\AddSipDialRulesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addSipDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addConferenceBridge
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddConferenceBridgeReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addConferenceBridge(\CUCM\StructType\AddConferenceBridgeReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addConferenceBridge($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddMtpReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addMtp(\CUCM\StructType\AddMtpReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addMtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRemoteDestinationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddRemoteDestinationProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addRemoteDestinationProfile(\CUCM\StructType\AddRemoteDestinationProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addRemoteDestinationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddLineReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addLine(\CUCM\StructType\AddLineReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addLine($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDefaultDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddDefaultDeviceProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addDefaultDeviceProfile(\CUCM\StructType\AddDefaultDeviceProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addDefaultDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addH323Phone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddH323PhoneReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addH323Phone(\CUCM\StructType\AddH323PhoneReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addH323Phone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addH323Trunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddH323TrunkReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addH323Trunk(\CUCM\StructType\AddH323TrunkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addH323Trunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addPhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddPhoneReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addPhone(\CUCM\StructType\AddPhoneReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addPhone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addH323Gateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddH323GatewayReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addH323Gateway(\CUCM\StructType\AddH323GatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addH323Gateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddDeviceProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addDeviceProfile(\CUCM\StructType\AddDeviceProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRemoteDestination
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddRemoteDestinationReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addRemoteDestination(\CUCM\StructType\AddRemoteDestinationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addRemoteDestination($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddGatewayReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addGateway(\CUCM\StructType\AddGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGatewayEndpointAnalogAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddGatewayEndpointAnalogAccessReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addGatewayEndpointAnalogAccess(\CUCM\StructType\AddGatewayEndpointAnalogAccessReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addGatewayEndpointAnalogAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGatewayEndpointDigitalAccessPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddGatewayEndpointDigitalAccessPriReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addGatewayEndpointDigitalAccessPri(\CUCM\StructType\AddGatewayEndpointDigitalAccessPriReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addGatewayEndpointDigitalAccessPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGatewayEndpointDigitalAccessBri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddGatewayEndpointDigitalAccessBriReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addGatewayEndpointDigitalAccessBri(\CUCM\StructType\AddGatewayEndpointDigitalAccessBriReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addGatewayEndpointDigitalAccessBri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGatewayEndpointDigitalAccessT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddGatewayEndpointDigitalAccessT1Req $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addGatewayEndpointDigitalAccessT1(\CUCM\StructType\AddGatewayEndpointDigitalAccessT1Req $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addGatewayEndpointDigitalAccessT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addVg224
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddVg224Req $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addVg224(\CUCM\StructType\AddVg224Req $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addVg224($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * addCiscoCatalyst600024PortFXSGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddCiscoCatalyst600024PortFXSGatewayReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addCiscoCatalyst600024PortFXSGateway(\CUCM\StructType\AddCiscoCatalyst600024PortFXSGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCiscoCatalyst600024PortFXSGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCiscoCatalyst6000E1VoIPGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddCiscoCatalyst6000E1VoIPGatewayReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addCiscoCatalyst6000E1VoIPGateway(\CUCM\StructType\AddCiscoCatalyst6000E1VoIPGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCiscoCatalyst6000E1VoIPGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * addCiscoCatalyst6000T1VoIPGatewayPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddCiscoCatalyst6000T1VoIPGatewayPriReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addCiscoCatalyst6000T1VoIPGatewayPri(\CUCM\StructType\AddCiscoCatalyst6000T1VoIPGatewayPriReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCiscoCatalyst6000T1VoIPGatewayPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * addCiscoCatalyst6000T1VoIPGatewayT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddCiscoCatalyst6000T1VoIPGatewayT1Req $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addCiscoCatalyst6000T1VoIPGatewayT1(\CUCM\StructType\AddCiscoCatalyst6000T1VoIPGatewayT1Req $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCiscoCatalyst6000T1VoIPGatewayT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCallPickupGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddCallPickupGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addCallPickupGroup(\CUCM\StructType\AddCallPickupGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCallPickupGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGeoLocationPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddGeoLocationPolicyReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addGeoLocationPolicy(\CUCM\StructType\AddGeoLocationPolicyReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addGeoLocationPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSipTrunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddSipTrunkReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addSipTrunk(\CUCM\StructType\AddSipTrunkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addSipTrunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * addCalledPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddCalledPartyTransformationPatternReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addCalledPartyTransformationPattern(\CUCM\StructType\AddCalledPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCalledPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addExternalCallControlProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddExternalCallControlProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addExternalCallControlProfile(\CUCM\StructType\AddExternalCallControlProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addExternalCallControlProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSafSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddSafSecurityProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addSafSecurityProfile(\CUCM\StructType\AddSafSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addSafSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSafForwarder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddSafForwarderReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addSafForwarder(\CUCM\StructType\AddSafForwarderReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addSafForwarder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCcdHostedDN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddCcdHostedDNReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addCcdHostedDN(\CUCM\StructType\AddCcdHostedDNReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCcdHostedDN($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCcdHostedDNGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddCcdHostedDNGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addCcdHostedDNGroup(\CUCM\StructType\AddCcdHostedDNGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCcdHostedDNGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCcdRequestingService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddCcdRequestingServiceReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addCcdRequestingService(\CUCM\StructType\AddCcdRequestingServiceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCcdRequestingService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRemoteCluster
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddRemoteClusterReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addRemoteCluster(\CUCM\StructType\AddRemoteClusterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addRemoteCluster($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCcdAdvertisingService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddCcdAdvertisingServiceReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addCcdAdvertisingService(\CUCM\StructType\AddCcdAdvertisingServiceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCcdAdvertisingService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addUnitsToGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddUnitsToGatewayReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addUnitsToGateway(\CUCM\StructType\AddUnitsToGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addUnitsToGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGatewaySubunits
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddGatewaySubunitsReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addGatewaySubunits(\CUCM\StructType\AddGatewaySubunitsReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addGatewaySubunits($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLdapDirectory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddLdapDirectoryReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addLdapDirectory(\CUCM\StructType\AddLdapDirectoryReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addLdapDirectory($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSafCcdPurgeBlockLearnedRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddSafCcdPurgeBlockLearnedRoutesReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addSafCcdPurgeBlockLearnedRoutes(\CUCM\StructType\AddSafCcdPurgeBlockLearnedRoutesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addSafCcdPurgeBlockLearnedRoutes($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addVpnGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddVpnGatewayReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addVpnGateway(\CUCM\StructType\AddVpnGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addVpnGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addVpnGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddVpnGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addVpnGroup(\CUCM\StructType\AddVpnGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addVpnGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addVpnProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddVpnProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addVpnProfile(\CUCM\StructType\AddVpnProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addVpnProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddImeServerReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addImeServer(\CUCM\StructType\AddImeServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addImeServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeRouteFilterGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddImeRouteFilterGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addImeRouteFilterGroup(\CUCM\StructType\AddImeRouteFilterGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addImeRouteFilterGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeRouteFilterElement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddImeRouteFilterElementReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addImeRouteFilterElement(\CUCM\StructType\AddImeRouteFilterElementReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addImeRouteFilterElement($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeClient
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddImeClientReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addImeClient(\CUCM\StructType\AddImeClientReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addImeClient($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeEnrolledPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddImeEnrolledPatternReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addImeEnrolledPattern(\CUCM\StructType\AddImeEnrolledPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addImeEnrolledPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeEnrolledPatternGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddImeEnrolledPatternGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addImeEnrolledPatternGroup(\CUCM\StructType\AddImeEnrolledPatternGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addImeEnrolledPatternGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeExclusionNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddImeExclusionNumberReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addImeExclusionNumber(\CUCM\StructType\AddImeExclusionNumberReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addImeExclusionNumber($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeExclusionNumberGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddImeExclusionNumberGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addImeExclusionNumberGroup(\CUCM\StructType\AddImeExclusionNumberGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addImeExclusionNumberGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeFirewall
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddImeFirewallReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addImeFirewall(\CUCM\StructType\AddImeFirewallReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addImeFirewall($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeE164Transformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddImeE164TransformationReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addImeE164Transformation(\CUCM\StructType\AddImeE164TransformationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addImeE164Transformation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addTransformationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddTransformationProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addTransformationProfile(\CUCM\StructType\AddTransformationProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addTransformationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addFallbackProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddFallbackProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addFallbackProfile(\CUCM\StructType\AddFallbackProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addFallbackProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLdapFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddLdapFilterReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addLdapFilter(\CUCM\StructType\AddLdapFilterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addLdapFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addAppServerInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddAppServerInfoReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addAppServerInfo(\CUCM\StructType\AddAppServerInfoReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addAppServerInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addFeatureControlPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddFeatureControlPolicyReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addFeatureControlPolicy(\CUCM\StructType\AddFeatureControlPolicyReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addFeatureControlPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMobilityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddMobilityProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addMobilityProfile(\CUCM\StructType\AddMobilityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addMobilityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * addEnterpriseFeatureAccessConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddEnterpriseFeatureAccessConfigurationReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addEnterpriseFeatureAccessConfiguration(\CUCM\StructType\AddEnterpriseFeatureAccessConfigurationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addEnterpriseFeatureAccessConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addHandoffConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddHandoffConfigurationReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addHandoffConfiguration(\CUCM\StructType\AddHandoffConfigurationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addHandoffConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMobility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddMobilityReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addMobility(\CUCM\StructType\AddMobilityReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addMobility($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addApplicationToSoftkeyTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\AddApplicationToSoftkeyTemplateReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function addApplicationToSoftkeyTemplate(\CUCM\StructType\AddApplicationToSoftkeyTemplateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addApplicationToSoftkeyTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CUCM\StructType\StandardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
