<?php

namespace CUCM\EnumType;

/**
 * This class stands for XZznetworkMediaType EnumType
 * @subpackage Enumerations
 */
class XZznetworkMediaType
{
    /**
     * Constant for value 'Auto'
     * @return string 'Auto'
     */
    const VALUE_AUTO = 'Auto';
    /**
     * Constant for value 'Full 100'
     * @return string 'Full 100'
     */
    const VALUE_FULL_100 = 'Full 100';
    /**
     * Constant for value 'Half 100'
     * @return string 'Half 100'
     */
    const VALUE_HALF_100 = 'Half 100';
    /**
     * Constant for value 'Full 10'
     * @return string 'Full 10'
     */
    const VALUE_FULL_10 = 'Full 10';
    /**
     * Constant for value 'Half 10'
     * @return string 'Half 10'
     */
    const VALUE_HALF_10 = 'Half 10';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AUTO
     * @uses self::VALUE_FULL_100
     * @uses self::VALUE_HALF_100
     * @uses self::VALUE_FULL_10
     * @uses self::VALUE_HALF_10
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AUTO,
            self::VALUE_FULL_100,
            self::VALUE_HALF_100,
            self::VALUE_FULL_10,
            self::VALUE_HALF_10,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
