<?php

namespace CUCM\EnumType;

/**
 * This class stands for XUserAssociation EnumType
 * @subpackage Enumerations
 */
class XUserAssociation
{
    /**
     * Constant for value 'Cti Control In'
     * @return string 'Cti Control In'
     */
    const VALUE_CTI_CONTROL_IN = 'Cti Control In';
    /**
     * Constant for value 'Cti Control Out'
     * @return string 'Cti Control Out'
     */
    const VALUE_CTI_CONTROL_OUT = 'Cti Control Out';
    /**
     * Constant for value 'Digest In'
     * @return string 'Digest In'
     */
    const VALUE_DIGEST_IN = 'Digest In';
    /**
     * Constant for value 'Digest Out'
     * @return string 'Digest Out'
     */
    const VALUE_DIGEST_OUT = 'Digest Out';
    /**
     * Constant for value 'Profile Available'
     * @return string 'Profile Available'
     */
    const VALUE_PROFILE_AVAILABLE = 'Profile Available';
    /**
     * Constant for value 'Mobility Primary Device'
     * @return string 'Mobility Primary Device'
     */
    const VALUE_MOBILITY_PRIMARY_DEVICE = 'Mobility Primary Device';
    /**
     * Constant for value 'Cti Control Profile In'
     * @return string 'Cti Control Profile In'
     */
    const VALUE_CTI_CONTROL_PROFILE_IN = 'Cti Control Profile In';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CTI_CONTROL_IN
     * @uses self::VALUE_CTI_CONTROL_OUT
     * @uses self::VALUE_DIGEST_IN
     * @uses self::VALUE_DIGEST_OUT
     * @uses self::VALUE_PROFILE_AVAILABLE
     * @uses self::VALUE_MOBILITY_PRIMARY_DEVICE
     * @uses self::VALUE_CTI_CONTROL_PROFILE_IN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CTI_CONTROL_IN,
            self::VALUE_CTI_CONTROL_OUT,
            self::VALUE_DIGEST_IN,
            self::VALUE_DIGEST_OUT,
            self::VALUE_PROFILE_AVAILABLE,
            self::VALUE_MOBILITY_PRIMARY_DEVICE,
            self::VALUE_CTI_CONTROL_PROFILE_IN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
